/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.bridj.BridJ;
import org.bridj.StructFieldDescription;
import org.bridj.ann.Alignment;
import org.bridj.ann.Array;
import org.bridj.ann.Bits;
import org.bridj.ann.CLong;
import org.bridj.ann.Field;
import org.bridj.ann.Ptr;
import org.bridj.ann.Union;
import org.bridj.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StructFieldDeclaration {
    final StructFieldDescription desc = new StructFieldDescription();
    Method setter;
    long index = -1L;
    long unionWith = -1L;
    Class<?> valueClass;
    Class<?> declaringClass;

    StructFieldDeclaration() {
    }

    public String toString() {
        return this.desc.name + " (index = " + this.index + (this.unionWith < 0L ? "" : ", unionWith = " + this.unionWith) + ", desc = " + this.desc + ")";
    }

    protected static boolean acceptFieldGetter(Member member, boolean getter2) {
        if (member instanceof Method && ((Method)member).getParameterTypes().length != (getter2 ? 0 : 1)) {
            return false;
        }
        if (((AnnotatedElement)((Object)member)).getAnnotation(Field.class) == null) {
            return false;
        }
        int modifiers = member.getModifiers();
        return !Modifier.isStatic(modifiers);
    }

    protected static List<StructFieldDeclaration> listFields(Class<?> structClass) {
        ArrayList<StructFieldDeclaration> list2 = new ArrayList<StructFieldDeclaration>();
        for (Method method : structClass.getMethods()) {
            if (!StructFieldDeclaration.acceptFieldGetter(method, true)) continue;
            StructFieldDeclaration io = StructFieldDeclaration.fromGetter(method);
            try {
                Method setter2 = structClass.getMethod(method.getName(), io.valueClass);
                if (StructFieldDeclaration.acceptFieldGetter(setter2, false)) {
                    io.setter = setter2;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (io == null) continue;
            list2.add(io);
        }
        int nFieldFields = 0;
        for (java.lang.reflect.Field field2 : structClass.getFields()) {
            StructFieldDeclaration io;
            if (!StructFieldDeclaration.acceptFieldGetter(field2, true) || (io = StructFieldDeclaration.fromField(field2)) == null) continue;
            list2.add(io);
            ++nFieldFields;
        }
        if (nFieldFields > 0 && BridJ.warnStructFields) {
            BridJ.warning("Struct " + structClass.getName() + " has " + nFieldFields + " struct fields implemented as Java fields, which won't give the best performance and might require counter-intuitive calls to BridJ.readFromNative / .writeToNative. Please consider using JNAerator to generate your struct instead, or use BRIDJ_WARN_STRUCT_FIELDS=0 or -Dbridj.warnStructFields=false to mute this warning.");
        }
        return list2;
    }

    protected static StructFieldDeclaration fromField(java.lang.reflect.Field getter2) {
        StructFieldDeclaration field2 = StructFieldDeclaration.fromMember(getter2);
        field2.desc.field = getter2;
        field2.desc.valueType = getter2.getGenericType();
        field2.valueClass = getter2.getType();
        return field2;
    }

    protected static StructFieldDeclaration fromGetter(Method getter2) {
        StructFieldDeclaration field2 = StructFieldDeclaration.fromMember(getter2);
        field2.desc.getter = getter2;
        field2.desc.valueType = getter2.getGenericReturnType();
        field2.valueClass = getter2.getReturnType();
        return field2;
    }

    private static StructFieldDeclaration fromMember(Member member) {
        StructFieldDeclaration field2 = new StructFieldDeclaration();
        field2.declaringClass = member.getDeclaringClass();
        String name = member.getName();
        if (name.matches("get[A-Z].*")) {
            name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        field2.desc.name = name;
        AnnotatedElement getter2 = (AnnotatedElement)((Object)member);
        Field fil = getter2.getAnnotation(Field.class);
        Bits bits = getter2.getAnnotation(Bits.class);
        Alignment alignment = getter2.getAnnotation(Alignment.class);
        Array arr = getter2.getAnnotation(Array.class);
        if (fil != null) {
            field2.index = fil.value();
            field2.unionWith = fil.unionWith();
        }
        if (field2.unionWith < 0L && field2.declaringClass.getAnnotation(Union.class) != null) {
            field2.unionWith = 0L;
        }
        if (bits != null) {
            field2.desc.bitLength = bits.value();
        }
        if (alignment != null) {
            field2.desc.alignment = alignment.value();
        }
        if (arr != null) {
            long length = 1L;
            for (long dim : arr.value()) {
                length *= dim;
            }
            field2.desc.arrayLength = length;
            field2.desc.isArray = true;
        }
        field2.desc.isCLong = AnnotationUtils.isAnnotationPresent(CLong.class, getter2, new Annotation[0]);
        field2.desc.isSizeT = AnnotationUtils.isAnnotationPresent(Ptr.class, getter2, new Annotation[0]);
        return field2;
    }
}

