/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jtransforms.dht.DoubleDHT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class DoubleDHT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private DoubleDHT_1D dhtSlices;
    private DoubleDHT_1D dhtRows;
    private DoubleDHT_1D dhtColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDHT_3D(long slices, long rows, long columns) {
        if (slices <= 1L || rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)slices;
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.slicesl = slices;
        this.rowsl = rows;
        this.columnsl = columns;
        this.sliceStride = (int)(rows * columns);
        this.rowStride = (int)columns;
        this.sliceStridel = rows * columns;
        this.rowStridel = columns;
        if (slices * rows * columns >= CommonUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(slices) && CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(slices * rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dhtSlices = new DoubleDHT_1D(slices);
        this.dhtRows = slices == rows ? this.dhtSlices : new DoubleDHT_1D(rows);
        this.dhtColumns = slices == columns ? this.dhtSlices : (rows == columns ? this.dhtRows : new DoubleDHT_1D(columns));
    }

    public void forward(final double[] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a2, true);
                this.ddxt3db_subth(-1, a2, true);
            } else {
                this.ddxt3da_sub(-1, a2, true);
                this.ddxt3db_sub(-1, a2, true);
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = l2 * p;
                    lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleDHT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.forward(a2, idx1 + r * DoubleDHT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = l3 * p;
                    lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleDHT_3D.this.sliceStride;
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c2;
                                        temp[r] = a2[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c2;
                                        a2[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final int startRow = l4 * p;
                    final int stopRow = l4 == nthreads - 1 ? this.rows : startRow + p;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = startRow; r < stopRow; ++r) {
                                int idx1 = r * DoubleDHT_3D.this.rowStride;
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int idx3;
                                    int s;
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleDHT_3D.this.sliceStride + idx1 + c2;
                                        temp[s] = a2[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(temp);
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleDHT_3D.this.sliceStride + idx1 + c2;
                                        a2[idx3] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx3;
                int c2;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a2, idx12 + r * this.rowStride);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c2;
                            temp[r] = a2[idx3];
                        }
                        this.dhtRows.forward(temp);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c2;
                            a2[idx3] = temp[r];
                        }
                    }
                }
                temp = new double[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c2;
                            temp[s] = a2[idx3];
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c2;
                            a2[idx3] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void forward(final DoubleLargeArray a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a2, true);
                this.ddxt3db_subth(-1, a2, true);
            } else {
                this.ddxt3da_sub(-1, a2, true);
                this.ddxt3db_sub(-1, a2, true);
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = (long)l2 * p;
                    lastSlice = l2 == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * (long)DoubleDHT_3D.this.sliceStride;
                                for (long r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.forward(a2, idx1 + r * (long)DoubleDHT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = (long)l3 * p;
                    lastSlice = l3 == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.rowsl, false);
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * (long)DoubleDHT_3D.this.sliceStride;
                                for (long c2 = 0L; c2 < DoubleDHT_3D.this.columnsl; ++c2) {
                                    long idx3;
                                    long r;
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * (long)DoubleDHT_3D.this.rowStride + c2;
                                        temp.setDouble(r, a2.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * (long)DoubleDHT_3D.this.rowStride + c2;
                                        a2.setDouble(idx3, temp.getDouble(r));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final long startRow = (long)l4 * p;
                    final long stopRow = l4 == nthreads - 1 ? this.rowsl : startRow + p;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.slicesl, false);
                            for (long r = startRow; r < stopRow; ++r) {
                                long idx1 = r * (long)DoubleDHT_3D.this.rowStride;
                                for (long c2 = 0L; c2 < DoubleDHT_3D.this.columnsl; ++c2) {
                                    long idx3;
                                    long s;
                                    for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                        idx3 = s * (long)DoubleDHT_3D.this.sliceStride + idx1 + c2;
                                        temp.setDouble(s, a2.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(temp);
                                    for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                        idx3 = s * (long)DoubleDHT_3D.this.sliceStride + idx1 + c2;
                                        a2.setDouble(idx3, temp.getDouble(s));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx3;
                long c2;
                long idx1;
                for (long s = 0L; s < this.slicesl; ++s) {
                    long idx12 = s * (long)this.sliceStride;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.dhtColumns.forward(a2, idx12 + r * (long)this.rowStride);
                    }
                }
                DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
                for (long s = 0L; s < this.slicesl; ++s) {
                    idx1 = s * (long)this.sliceStride;
                    for (c2 = 0L; c2 < this.columnsl; ++c2) {
                        long r;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * (long)this.rowStride + c2;
                            temp.setDouble(r, a2.getDouble(idx3));
                        }
                        this.dhtRows.forward(temp);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * (long)this.rowStride + c2;
                            a2.setDouble(idx3, temp.getDouble(r));
                        }
                    }
                }
                temp = new DoubleLargeArray(this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * (long)this.rowStride;
                    for (c2 = 0L; c2 < this.columnsl; ++c2) {
                        long s;
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * (long)this.sliceStride + idx1 + c2;
                            temp.setDouble(s, a2.getDouble(idx3));
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * (long)this.sliceStride + idx1 + c2;
                            a2.setDouble(idx3, temp.getDouble(s));
                        }
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void forward(final double[][][] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a2, true);
                this.ddxt3db_subth(-1, a2, true);
            } else {
                this.ddxt3da_sub(-1, a2, true);
                this.ddxt3db_sub(-1, a2, true);
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = l2 * p;
                    lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.forward(a2[s][r]);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = l3 * p;
                    lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        temp[r] = a2[s][r][c2];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        a2[s][r][c2] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final int firstRow = l4 * p;
                    final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int s;
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        temp[s] = a2[s][r][c2];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.forward(temp);
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        a2[s][r][c2] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int c2;
                int r;
                for (int s = 0; s < this.slices; ++s) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a2[s][r]);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a2[s][r2][c2];
                        }
                        this.dhtRows.forward(temp);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a2[s][r2][c2] = temp[r2];
                        }
                    }
                }
                temp = new double[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            temp[s] = a2[s][r][c2];
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0; s < this.slices; ++s) {
                            a2[s][r][c2] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void inverse(final double[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a2, scale);
                this.ddxt3db_subth(1, a2, scale);
            } else {
                this.ddxt3da_sub(1, a2, scale);
                this.ddxt3db_sub(1, a2, scale);
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = l2 * p;
                    lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleDHT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(a2, idx1 + r * DoubleDHT_3D.this.rowStride, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = l3 * p;
                    lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleDHT_3D.this.sliceStride;
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c2;
                                        temp[r] = a2[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStride + c2;
                                        a2[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final int firstRow = l4 * p;
                    final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * DoubleDHT_3D.this.rowStride;
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int idx3;
                                    int s;
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleDHT_3D.this.sliceStride + idx1 + c2;
                                        temp[s] = a2[idx3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleDHT_3D.this.sliceStride + idx1 + c2;
                                        a2[idx3] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int idx3;
                int c2;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a2, idx12 + r * this.rowStride, scale);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c2;
                            temp[r] = a2[idx3];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c2;
                            a2[idx3] = temp[r];
                        }
                    }
                }
                temp = new double[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c2;
                            temp[s] = a2[idx3];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c2;
                            a2[idx3] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void inverse(final DoubleLargeArray a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a2, scale);
                this.ddxt3db_subth(1, a2, scale);
            } else {
                this.ddxt3da_sub(1, a2, scale);
                this.ddxt3db_sub(1, a2, scale);
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.slicesl >= (long)nthreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                long lastSlice;
                long firstSlice;
                Future[] futures = new Future[nthreads];
                long p = this.slicesl / (long)nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = (long)l2 * p;
                    lastSlice = l2 == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * DoubleDHT_3D.this.sliceStridel;
                                for (long r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(a2, idx1 + r * DoubleDHT_3D.this.rowStridel, scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = (long)l3 * p;
                    lastSlice = l3 == nthreads - 1 ? this.slicesl : firstSlice + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.rowsl, false);
                            for (long s = firstSlice; s < lastSlice; ++s) {
                                long idx1 = s * DoubleDHT_3D.this.sliceStridel;
                                for (long c2 = 0L; c2 < DoubleDHT_3D.this.columnsl; ++c2) {
                                    long idx3;
                                    long r;
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStridel + c2;
                                        temp.setDouble(r, a2.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                        idx3 = idx1 + r * DoubleDHT_3D.this.rowStridel + c2;
                                        a2.setDouble(idx3, temp.getDouble(r));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rowsl / (long)nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final long firstRow = (long)l4 * p;
                    final long lastRow = l4 == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            DoubleLargeArray temp = new DoubleLargeArray(DoubleDHT_3D.this.slicesl, false);
                            for (long r = firstRow; r < lastRow; ++r) {
                                long idx1 = r * DoubleDHT_3D.this.rowStridel;
                                for (long c2 = 0L; c2 < DoubleDHT_3D.this.columnsl; ++c2) {
                                    long idx3;
                                    long s;
                                    for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                        idx3 = s * DoubleDHT_3D.this.sliceStridel + idx1 + c2;
                                        temp.setDouble(s, a2.getDouble(idx3));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                        idx3 = s * DoubleDHT_3D.this.sliceStridel + idx1 + c2;
                                        a2.setDouble(idx3, temp.getDouble(s));
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                long idx3;
                long c2;
                long idx1;
                for (long s = 0L; s < this.slicesl; ++s) {
                    long idx12 = s * this.sliceStridel;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        this.dhtColumns.inverse(a2, idx12 + r * this.rowStridel, scale);
                    }
                }
                DoubleLargeArray temp = new DoubleLargeArray(this.rowsl, false);
                for (long s = 0L; s < this.slicesl; ++s) {
                    idx1 = s * this.sliceStridel;
                    for (c2 = 0L; c2 < this.columnsl; ++c2) {
                        long r;
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * this.rowStridel + c2;
                            temp.setDouble(r, a2.getDouble(idx3));
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r = 0L; r < this.rowsl; ++r) {
                            idx3 = idx1 + r * this.rowStridel + c2;
                            a2.setDouble(idx3, temp.getDouble(r));
                        }
                    }
                }
                temp = new DoubleLargeArray(this.slicesl, false);
                for (long r = 0L; r < this.rowsl; ++r) {
                    idx1 = r * this.rowStridel;
                    for (c2 = 0L; c2 < this.columnsl; ++c2) {
                        long s;
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * this.sliceStridel + idx1 + c2;
                            temp.setDouble(s, a2.getDouble(idx3));
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx3 = s * this.sliceStridel + idx1 + c2;
                            a2.setDouble(idx3, temp.getDouble(s));
                        }
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void inverse(final double[][][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a2, scale);
                this.ddxt3db_subth(1, a2, scale);
            } else {
                this.ddxt3da_sub(1, a2, scale);
                this.ddxt3db_sub(1, a2, scale);
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    firstSlice = l2 * p;
                    lastSlice = l2 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                    DoubleDHT_3D.this.dhtColumns.inverse(a2[s][r], scale);
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    firstSlice = l3 * p;
                    lastSlice = l3 == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int r;
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        temp[r] = a2[s][r][c2];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                        a2[s][r][c2] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.rows / nthreads;
                for (int l4 = 0; l4 < nthreads; ++l4) {
                    final int firstRow = l4 * p;
                    final int lastRow = l4 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[DoubleDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; ++c2) {
                                    int s;
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        temp[s] = a2[s][r][c2];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        a2[s][r][c2] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                int c2;
                int r;
                for (int s = 0; s < this.slices; ++s) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a2[s][r], scale);
                    }
                }
                double[] temp = new double[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a2[s][r2][c2];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a2[s][r2][c2] = temp[r2];
                        }
                    }
                }
                temp = new double[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c2 = 0; c2 < this.columns; ++c2) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            temp[s] = a2[s][r][c2];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0; s < this.slices; ++s) {
                            a2[s][r][c2] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    private void ddxt3da_sub(int isgn, double[] a2, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        double[] t = new double[nt];
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a2, idx0 + r * this.rowStride);
                }
                if (this.columns > 2) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c2;
                            idx2 = this.rows + r2;
                            t[r2] = a2[idx1];
                            t[idx2] = a2[idx1 + 1];
                            t[idx2 + this.rows] = a2[idx1 + 2];
                            t[idx2 + 2 * this.rows] = a2[idx1 + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c2;
                            idx2 = this.rows + r2;
                            a2[idx1] = t[r2];
                            a2[idx1 + 1] = t[idx2];
                            a2[idx1 + 2] = t[idx2 + this.rows];
                            a2[idx1 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t[r] = a2[idx1];
                    t[this.rows + r] = a2[idx1 + 1];
                }
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a2[idx1] = t[r];
                    a2[idx1 + 1] = t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a2, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c3;
                            idx2 = this.rows + r3;
                            t[r3] = a2[idx1];
                            t[idx2] = a2[idx1 + 1];
                            t[idx2 + this.rows] = a2[idx1 + 2];
                            t[idx2 + 2 * this.rows] = a2[idx1 + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c3;
                            idx2 = this.rows + r3;
                            a2[idx1] = t[r3];
                            a2[idx1 + 1] = t[idx2];
                            a2[idx1 + 2] = t[idx2 + this.rows];
                            a2[idx1 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    t[r] = a2[idx1];
                    t[this.rows + r] = a2[idx1 + 1];
                }
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a2[idx1] = t[r];
                    a2[idx1 + 1] = t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, DoubleLargeArray a2, boolean scale) {
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        DoubleLargeArray t = new DoubleLargeArray(nt);
        if (isgn == -1) {
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx1;
                long r;
                long idx0 = s * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dhtColumns.forward(a2, idx0 + r * this.rowStridel);
                }
                if (this.columnsl > 2L) {
                    for (long c2 = 0L; c2 < this.columnsl; c2 += 4L) {
                        long idx2;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c2;
                            idx2 = this.rowsl + r2;
                            t.setDouble(r2, a2.getDouble(idx1));
                            t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                            t.setDouble(idx2 + this.rowsl, a2.getDouble(idx1 + 2L));
                            t.setDouble(idx2 + 2L * this.rowsl, a2.getDouble(idx1 + 3L));
                        }
                        this.dhtRows.forward(t, 0L);
                        this.dhtRows.forward(t, this.rowsl);
                        this.dhtRows.forward(t, 2L * this.rowsl);
                        this.dhtRows.forward(t, 3L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx1 = idx0 + r2 * this.rowStridel + c2;
                            idx2 = this.rowsl + r2;
                            a2.setDouble(idx1, t.getDouble(r2));
                            a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                            a2.setDouble(idx1 + 2L, t.getDouble(idx2 + this.rowsl));
                            a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t.setDouble(r, a2.getDouble(idx1));
                    t.setDouble(this.rowsl + r, a2.getDouble(idx1 + 1L));
                }
                this.dhtRows.forward(t, 0L);
                this.dhtRows.forward(t, this.rowsl);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a2.setDouble(idx1, t.getDouble(r));
                    a2.setDouble(idx1 + 1L, t.getDouble(this.rowsl + r));
                }
            }
        } else {
            for (long s = 0L; s < this.slicesl; ++s) {
                long idx1;
                long r;
                long idx0 = s * this.sliceStridel;
                for (r = 0L; r < this.rowsl; ++r) {
                    this.dhtColumns.inverse(a2, idx0 + r * this.rowStridel, scale);
                }
                if (this.columnsl > 2L) {
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 4L) {
                        long idx2;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c3;
                            idx2 = this.rowsl + r3;
                            t.setDouble(r3, a2.getDouble(idx1));
                            t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                            t.setDouble(idx2 + this.rowsl, a2.getDouble(idx1 + 2L));
                            t.setDouble(idx2 + 2L * this.rowsl, a2.getDouble(idx1 + 3L));
                        }
                        this.dhtRows.inverse(t, 0L, scale);
                        this.dhtRows.inverse(t, this.rowsl, scale);
                        this.dhtRows.inverse(t, 2L * this.rowsl, scale);
                        this.dhtRows.inverse(t, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx1 = idx0 + r3 * this.rowStridel + c3;
                            idx2 = this.rowsl + r3;
                            a2.setDouble(idx1, t.getDouble(r3));
                            a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                            a2.setDouble(idx1 + 2L, t.getDouble(idx2 + this.rowsl));
                            a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    t.setDouble(r, a2.getDouble(idx1));
                    t.setDouble(this.rowsl + r, a2.getDouble(idx1 + 1L));
                }
                this.dhtRows.inverse(t, 0L, scale);
                this.dhtRows.inverse(t, this.rowsl, scale);
                for (r = 0L; r < this.rowsl; ++r) {
                    idx1 = idx0 + r * this.rowStridel;
                    a2.setDouble(idx1, t.getDouble(r));
                    a2.setDouble(idx1 + 1L, t.getDouble(this.rowsl + r));
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[][][] a2, boolean scale) {
        int nt = 4 * this.rows;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        double[] t = new double[nt];
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a2[s][r]);
                }
                if (this.columns > 2) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t[r2] = a2[s][r2][c2];
                            t[idx2] = a2[s][r2][c2 + 1];
                            t[idx2 + this.rows] = a2[s][r2][c2 + 2];
                            t[idx2 + 2 * this.rows] = a2[s][r2][c2 + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a2[s][r2][c2] = t[r2];
                            a2[s][r2][c2 + 1] = t[idx2];
                            a2[s][r2][c2 + 2] = t[idx2 + this.rows];
                            a2[s][r2][c2 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t[r] = a2[s][r][0];
                    t[this.rows + r] = a2[s][r][1];
                }
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    a2[s][r][0] = t[r];
                    a2[s][r][1] = t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a2[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t[r3] = a2[s][r3][c3];
                            t[idx2] = a2[s][r3][c3 + 1];
                            t[idx2 + this.rows] = a2[s][r3][c3 + 2];
                            t[idx2 + 2 * this.rows] = a2[s][r3][c3 + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a2[s][r3][c3] = t[r3];
                            a2[s][r3][c3 + 1] = t[idx2];
                            a2[s][r3][c3 + 2] = t[idx2 + this.rows];
                            a2[s][r3][c3 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    t[r] = a2[s][r][0];
                    t[this.rows + r] = a2[s][r][1];
                }
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a2[s][r][0] = t[r];
                    a2[s][r][1] = t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[] a2, boolean scale) {
        block20: {
            double[] t;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c2 = 0; c2 < this.columns; c2 += 4) {
                            int idx2;
                            int idx1;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c2;
                                idx2 = this.slices + s;
                                t[s] = a2[idx1];
                                t[idx2] = a2[idx1 + 1];
                                t[idx2 + this.slices] = a2[idx1 + 2];
                                t[idx2 + 2 * this.slices] = a2[idx1 + 3];
                            }
                            this.dhtSlices.forward(t, 0);
                            this.dhtSlices.forward(t, this.slices);
                            this.dhtSlices.forward(t, 2 * this.slices);
                            this.dhtSlices.forward(t, 3 * this.slices);
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c2;
                                idx2 = this.slices + s;
                                a2[idx1] = t[s];
                                a2[idx1 + 1] = t[idx2];
                                a2[idx1 + 2] = t[idx2 + this.slices];
                                a2[idx1 + 3] = t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        t[s] = a2[idx1];
                        t[this.slices + s] = a2[idx1 + 1];
                    }
                    this.dhtSlices.forward(t, 0);
                    this.dhtSlices.forward(t, this.slices);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a2[idx1] = t[s];
                        a2[idx1 + 1] = t[this.slices + s];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int idx1;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c3;
                            idx2 = this.slices + s;
                            t[s] = a2[idx1];
                            t[idx2] = a2[idx1 + 1];
                            t[idx2 + this.slices] = a2[idx1 + 2];
                            t[idx2 + 2 * this.slices] = a2[idx1 + 3];
                        }
                        this.dhtSlices.inverse(t, 0, scale);
                        this.dhtSlices.inverse(t, this.slices, scale);
                        this.dhtSlices.inverse(t, 2 * this.slices, scale);
                        this.dhtSlices.inverse(t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c3;
                            idx2 = this.slices + s;
                            a2[idx1] = t[s];
                            a2[idx1 + 1] = t[idx2];
                            a2[idx1 + 2] = t[idx2 + this.slices];
                            a2[idx1 + 3] = t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        t[s] = a2[idx1];
                        t[this.slices + s] = a2[idx1 + 1];
                    }
                    this.dhtSlices.inverse(t, 0, scale);
                    this.dhtSlices.inverse(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a2[idx1] = t[s];
                        a2[idx1 + 1] = t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, DoubleLargeArray a2, boolean scale) {
        block20: {
            DoubleLargeArray t;
            block18: {
                block19: {
                    long nt = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        nt >>= 1;
                    }
                    t = new DoubleLargeArray(nt);
                    if (isgn != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long r = 0L; r < this.rowsl; ++r) {
                        long idx0 = r * this.rowStridel;
                        for (long c2 = 0L; c2 < this.columnsl; c2 += 4L) {
                            long idx2;
                            long idx1;
                            long s;
                            for (s = 0L; s < this.slicesl; ++s) {
                                idx1 = s * this.sliceStridel + idx0 + c2;
                                idx2 = this.slicesl + s;
                                t.setDouble(s, a2.getDouble(idx1));
                                t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                t.setDouble(idx2 + this.slicesl, a2.getDouble(idx1 + 2L));
                                t.setDouble(idx2 + 2L * this.slicesl, a2.getDouble(idx1 + 3L));
                            }
                            this.dhtSlices.forward(t, 0L);
                            this.dhtSlices.forward(t, this.slicesl);
                            this.dhtSlices.forward(t, 2L * this.slicesl);
                            this.dhtSlices.forward(t, 3L * this.slicesl);
                            for (s = 0L; s < this.slicesl; ++s) {
                                idx1 = s * this.sliceStridel + idx0 + c2;
                                idx2 = this.slicesl + s;
                                a2.setDouble(idx1, t.getDouble(s));
                                a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                                a2.setDouble(idx1 + 2L, t.getDouble(idx2 + this.slicesl));
                                a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s;
                    long idx0 = r * this.rowStridel;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        t.setDouble(s, a2.getDouble(idx1));
                        t.setDouble(this.slicesl + s, a2.getDouble(idx1 + 1L));
                    }
                    this.dhtSlices.forward(t, 0L);
                    this.dhtSlices.forward(t, this.slicesl);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        a2.setDouble(idx1, t.getDouble(s));
                        a2.setDouble(idx1 + 1L, t.getDouble(this.slicesl + s));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx0 = r * this.rowStridel;
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 4L) {
                        long idx2;
                        long idx1;
                        long s;
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx1 = s * this.sliceStridel + idx0 + c3;
                            idx2 = this.slicesl + s;
                            t.setDouble(s, a2.getDouble(idx1));
                            t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                            t.setDouble(idx2 + this.slicesl, a2.getDouble(idx1 + 2L));
                            t.setDouble(idx2 + 2L * this.slicesl, a2.getDouble(idx1 + 3L));
                        }
                        this.dhtSlices.inverse(t, 0L, scale);
                        this.dhtSlices.inverse(t, this.slicesl, scale);
                        this.dhtSlices.inverse(t, 2L * this.slicesl, scale);
                        this.dhtSlices.inverse(t, 3L * this.slicesl, scale);
                        for (s = 0L; s < this.slicesl; ++s) {
                            idx1 = s * this.sliceStridel + idx0 + c3;
                            idx2 = this.slicesl + s;
                            a2.setDouble(idx1, t.getDouble(s));
                            a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                            a2.setDouble(idx1 + 2L, t.getDouble(idx2 + this.slicesl));
                            a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long r = 0L; r < this.rowsl; ++r) {
                    long idx1;
                    long s;
                    long idx0 = r * this.rowStridel;
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        t.setDouble(s, a2.getDouble(idx1));
                        t.setDouble(this.slicesl + s, a2.getDouble(idx1 + 1L));
                    }
                    this.dhtSlices.inverse(t, 0L, scale);
                    this.dhtSlices.inverse(t, this.slicesl, scale);
                    for (s = 0L; s < this.slicesl; ++s) {
                        idx1 = s * this.sliceStridel + idx0;
                        a2.setDouble(idx1, t.getDouble(s));
                        a2.setDouble(idx1 + 1L, t.getDouble(this.slicesl + s));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[][][] a2, boolean scale) {
        block20: {
            double[] t;
            block18: {
                block19: {
                    int nt = 4 * this.slices;
                    if (this.columns == 2) {
                        nt >>= 1;
                    }
                    t = new double[nt];
                    if (isgn != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c2 = 0; c2 < this.columns; c2 += 4) {
                            int idx2;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                t[s] = a2[s][r][c2];
                                t[idx2] = a2[s][r][c2 + 1];
                                t[idx2 + this.slices] = a2[s][r][c2 + 2];
                                t[idx2 + 2 * this.slices] = a2[s][r][c2 + 3];
                            }
                            this.dhtSlices.forward(t, 0);
                            this.dhtSlices.forward(t, this.slices);
                            this.dhtSlices.forward(t, 2 * this.slices);
                            this.dhtSlices.forward(t, 3 * this.slices);
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                a2[s][r][c2] = t[s];
                                a2[s][r][c2 + 1] = t[idx2];
                                a2[s][r][c2 + 2] = t[idx2 + this.slices];
                                a2[s][r][c2 + 3] = t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        t[s] = a2[s][r][0];
                        t[this.slices + s] = a2[s][r][1];
                    }
                    this.dhtSlices.forward(t, 0);
                    this.dhtSlices.forward(t, this.slices);
                    for (s = 0; s < this.slices; ++s) {
                        a2[s][r][0] = t[s];
                        a2[s][r][1] = t[this.slices + s];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            t[s] = a2[s][r][c3];
                            t[idx2] = a2[s][r][c3 + 1];
                            t[idx2 + this.slices] = a2[s][r][c3 + 2];
                            t[idx2 + 2 * this.slices] = a2[s][r][c3 + 3];
                        }
                        this.dhtSlices.inverse(t, 0, scale);
                        this.dhtSlices.inverse(t, this.slices, scale);
                        this.dhtSlices.inverse(t, 2 * this.slices, scale);
                        this.dhtSlices.inverse(t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            a2[s][r][c3] = t[s];
                            a2[s][r][c3 + 1] = t[idx2];
                            a2[s][r][c3 + 2] = t[idx2 + this.slices];
                            a2[s][r][c3 + 3] = t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        t[s] = a2[s][r][0];
                        t[this.slices + s] = a2[s][r][1];
                    }
                    this.dhtSlices.inverse(t, 0, scale);
                    this.dhtSlices.inverse(t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a2[s][r][0] = t[s];
                        a2[s][r][1] = t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final double[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t = new double[ntf];
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleDHT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * DoubleDHT_3D.this.sliceStride;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.forward(a2, idx0 + r * DoubleDHT_3D.this.rowStride);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; c2 += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDHT_3D.this.rowStride + c2;
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        t[r2] = a2[idx1];
                                        t[idx2] = a2[idx1 + 1];
                                        t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[idx1 + 2];
                                        t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[idx1 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(t, 0);
                                    DoubleDHT_3D.this.dhtRows.forward(t, DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t, 2 * DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t, 3 * DoubleDHT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDHT_3D.this.rowStride + c2;
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        a2[idx1] = t[r2];
                                        a2[idx1 + 1] = t[idx2];
                                        a2[idx1 + 2] = t[idx2 + DoubleDHT_3D.this.rows];
                                        a2[idx1 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                t[r] = a2[idx1];
                                t[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a2[idx1 + 1];
                            }
                            DoubleDHT_3D.this.dhtRows.forward(t, 0);
                            DoubleDHT_3D.this.dhtRows.forward(t, DoubleDHT_3D.this.rows);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                a2[idx1] = t[r];
                                a2[idx1 + 1] = t[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleDHT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * DoubleDHT_3D.this.sliceStride;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.inverse(a2, idx0 + r * DoubleDHT_3D.this.rowStride, scale);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c3 = 0; c3 < DoubleDHT_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDHT_3D.this.rowStride + c3;
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        t[r3] = a2[idx1];
                                        t[idx2] = a2[idx1 + 1];
                                        t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[idx1 + 2];
                                        t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[idx1 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 0, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 2 * DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 3 * DoubleDHT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDHT_3D.this.rowStride + c3;
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        a2[idx1] = t[r3];
                                        a2[idx1 + 1] = t[idx2];
                                        a2[idx1 + 2] = t[idx2 + DoubleDHT_3D.this.rows];
                                        a2[idx1 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                t[r] = a2[idx1];
                                t[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a2[idx1 + 1];
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(t, 0, scale);
                            DoubleDHT_3D.this.dhtRows.inverse(t, DoubleDHT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDHT_3D.this.rowStride;
                                a2[idx1] = t[r];
                                a2[idx1 + 1] = t[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final DoubleLargeArray a2, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    DoubleLargeArray t = new DoubleLargeArray(ntf);
                    if (isgn == -1) {
                        for (long s = n0; s < DoubleDHT_3D.this.slicesl; s += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s * (long)DoubleDHT_3D.this.sliceStride;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                DoubleDHT_3D.this.dhtColumns.forward(a2, idx0 + r * (long)DoubleDHT_3D.this.rowStride);
                            }
                            if (DoubleDHT_3D.this.columnsl > 2L) {
                                for (long c2 = 0L; c2 < DoubleDHT_3D.this.columnsl; c2 += 4L) {
                                    long idx2;
                                    long r2;
                                    for (r2 = 0L; r2 < DoubleDHT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * (long)DoubleDHT_3D.this.rowStride + c2;
                                        idx2 = DoubleDHT_3D.this.rowsl + r2;
                                        t.setDouble(r2, a2.getDouble(idx1));
                                        t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                        t.setDouble(idx2 + DoubleDHT_3D.this.rowsl, a2.getDouble(idx1 + 2L));
                                        t.setDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl, a2.getDouble(idx1 + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(t, 0L);
                                    DoubleDHT_3D.this.dhtRows.forward(t, DoubleDHT_3D.this.rowsl);
                                    DoubleDHT_3D.this.dhtRows.forward(t, 2L * DoubleDHT_3D.this.rowsl);
                                    DoubleDHT_3D.this.dhtRows.forward(t, 3L * DoubleDHT_3D.this.rowsl);
                                    for (r2 = 0L; r2 < DoubleDHT_3D.this.rowsl; ++r2) {
                                        idx1 = idx0 + r2 * (long)DoubleDHT_3D.this.rowStride + c2;
                                        idx2 = DoubleDHT_3D.this.rowsl + r2;
                                        a2.setDouble(idx1, t.getDouble(r2));
                                        a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                                        a2.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDHT_3D.this.rowsl));
                                        a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                t.setDouble(r, a2.getDouble(idx1));
                                t.setDouble(DoubleDHT_3D.this.rowsl + r, a2.getDouble(idx1 + 1L));
                            }
                            DoubleDHT_3D.this.dhtRows.forward(t, 0L);
                            DoubleDHT_3D.this.dhtRows.forward(t, DoubleDHT_3D.this.rowsl);
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                a2.setDouble(idx1, t.getDouble(r));
                                a2.setDouble(idx1 + 1L, t.getDouble(DoubleDHT_3D.this.rowsl + r));
                            }
                        }
                    } else {
                        for (long s = n0; s < DoubleDHT_3D.this.slicesl; s += (long)nthreads) {
                            long idx1;
                            long r;
                            long idx0 = s * (long)DoubleDHT_3D.this.sliceStride;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                DoubleDHT_3D.this.dhtColumns.inverse(a2, idx0 + r * (long)DoubleDHT_3D.this.rowStride, scale);
                            }
                            if (DoubleDHT_3D.this.columnsl > 2L) {
                                for (long c3 = 0L; c3 < DoubleDHT_3D.this.columnsl; c3 += 4L) {
                                    long idx2;
                                    long r3;
                                    for (r3 = 0L; r3 < DoubleDHT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * (long)DoubleDHT_3D.this.rowStride + c3;
                                        idx2 = DoubleDHT_3D.this.rowsl + r3;
                                        t.setDouble(r3, a2.getDouble(idx1));
                                        t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                        t.setDouble(idx2 + DoubleDHT_3D.this.rowsl, a2.getDouble(idx1 + 2L));
                                        t.setDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl, a2.getDouble(idx1 + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 0L, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, DoubleDHT_3D.this.rowsl, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 2L * DoubleDHT_3D.this.rowsl, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 3L * DoubleDHT_3D.this.rowsl, scale);
                                    for (r3 = 0L; r3 < DoubleDHT_3D.this.rowsl; ++r3) {
                                        idx1 = idx0 + r3 * (long)DoubleDHT_3D.this.rowStride + c3;
                                        idx2 = DoubleDHT_3D.this.rowsl + r3;
                                        a2.setDouble(idx1, t.getDouble(r3));
                                        a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                                        a2.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDHT_3D.this.rowsl));
                                        a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDHT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) continue;
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                t.setDouble(r, a2.getDouble(idx1));
                                t.setDouble(DoubleDHT_3D.this.rowsl + r, a2.getDouble(idx1 + 1L));
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(t, 0L, scale);
                            DoubleDHT_3D.this.dhtRows.inverse(t, DoubleDHT_3D.this.rowsl, scale);
                            for (r = 0L; r < DoubleDHT_3D.this.rowsl; ++r) {
                                idx1 = idx0 + r * (long)DoubleDHT_3D.this.rowStride;
                                a2.setDouble(idx1, t.getDouble(r));
                                a2.setDouble(idx1 + 1L, t.getDouble(DoubleDHT_3D.this.rowsl + r));
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3da_subth(final int isgn, final double[][][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    double[] t = new double[ntf];
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleDHT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.forward(a2[s][r]);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; c2 += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        t[r2] = a2[s][r2][c2];
                                        t[idx2] = a2[s][r2][c2 + 1];
                                        t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[s][r2][c2 + 2];
                                        t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[s][r2][c2 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.forward(t, 0);
                                    DoubleDHT_3D.this.dhtRows.forward(t, DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t, 2 * DoubleDHT_3D.this.rows);
                                    DoubleDHT_3D.this.dhtRows.forward(t, 3 * DoubleDHT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleDHT_3D.this.rows; ++r2) {
                                        idx2 = DoubleDHT_3D.this.rows + r2;
                                        a2[s][r2][c2] = t[r2];
                                        a2[s][r2][c2 + 1] = t[idx2];
                                        a2[s][r2][c2 + 2] = t[idx2 + DoubleDHT_3D.this.rows];
                                        a2[s][r2][c2 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                t[r] = a2[s][r][0];
                                t[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a2[s][r][1];
                            }
                            DoubleDHT_3D.this.dhtRows.forward(t, 0);
                            DoubleDHT_3D.this.dhtRows.forward(t, DoubleDHT_3D.this.rows);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                a2[s][r][0] = t[r];
                                a2[s][r][1] = t[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleDHT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                DoubleDHT_3D.this.dhtColumns.inverse(a2[s][r], scale);
                            }
                            if (DoubleDHT_3D.this.columns > 2) {
                                for (int c3 = 0; c3 < DoubleDHT_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        t[r3] = a2[s][r3][c3];
                                        t[idx2] = a2[s][r3][c3 + 1];
                                        t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[s][r3][c3 + 2];
                                        t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).rows] = a2[s][r3][c3 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 0, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 2 * DoubleDHT_3D.this.rows, scale);
                                    DoubleDHT_3D.this.dhtRows.inverse(t, 3 * DoubleDHT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDHT_3D.this.rows; ++r3) {
                                        idx2 = DoubleDHT_3D.this.rows + r3;
                                        a2[s][r3][c3] = t[r3];
                                        a2[s][r3][c3 + 1] = t[idx2];
                                        a2[s][r3][c3 + 2] = t[idx2 + DoubleDHT_3D.this.rows];
                                        a2[s][r3][c3 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                t[r] = a2[s][r][0];
                                t[((DoubleDHT_3D)DoubleDHT_3D.this).rows + r] = a2[s][r][1];
                            }
                            DoubleDHT_3D.this.dhtRows.inverse(t, 0, scale);
                            DoubleDHT_3D.this.dhtRows.inverse(t, DoubleDHT_3D.this.rows, scale);
                            for (r = 0; r < DoubleDHT_3D.this.rows; ++r) {
                                a2[s][r][0] = t[r];
                                a2[s][r][1] = t[DoubleDHT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t;
                        block17: {
                            block18: {
                                t = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDHT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                    int idx0 = r * DoubleDHT_3D.this.rowStride;
                                    for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; c2 += 4) {
                                        int idx2;
                                        int idx1;
                                        int s;
                                        for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                            idx1 = s * DoubleDHT_3D.this.sliceStride + idx0 + c2;
                                            idx2 = DoubleDHT_3D.this.slices + s;
                                            t[s] = a2[idx1];
                                            t[idx2] = a2[idx1 + 1];
                                            t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[idx1 + 2];
                                            t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[idx1 + 3];
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 0);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 2 * DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 3 * DoubleDHT_3D.this.slices);
                                        for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                            idx1 = s * DoubleDHT_3D.this.sliceStride + idx0 + c2;
                                            idx2 = DoubleDHT_3D.this.slices + s;
                                            a2[idx1] = t[s];
                                            a2[idx1 + 1] = t[idx2];
                                            a2[idx1 + 2] = t[idx2 + DoubleDHT_3D.this.slices];
                                            a2[idx1 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * DoubleDHT_3D.this.rowStride;
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStride + idx0;
                                    t[s] = a2[idx1];
                                    t[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s] = a2[idx1 + 1];
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(t, 0);
                                DoubleDHT_3D.this.dhtSlices.forward(t, DoubleDHT_3D.this.slices);
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStride + idx0;
                                    a2[idx1] = t[s];
                                    a2[idx1 + 1] = t[DoubleDHT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int idx0 = r * DoubleDHT_3D.this.rowStride;
                                for (int c3 = 0; c3 < DoubleDHT_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int idx1;
                                    int s;
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleDHT_3D.this.sliceStride + idx0 + c3;
                                        idx2 = DoubleDHT_3D.this.slices + s;
                                        t[s] = a2[idx1];
                                        t[idx2] = a2[idx1 + 1];
                                        t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[idx1 + 2];
                                        t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[idx1 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 0, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 2 * DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 3 * DoubleDHT_3D.this.slices, scale);
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleDHT_3D.this.sliceStride + idx0 + c3;
                                        idx2 = DoubleDHT_3D.this.slices + s;
                                        a2[idx1] = t[s];
                                        a2[idx1 + 1] = t[idx2];
                                        a2[idx1 + 2] = t[idx2 + DoubleDHT_3D.this.slices];
                                        a2[idx1 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * DoubleDHT_3D.this.rowStride;
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStride + idx0;
                                    t[s] = a2[idx1];
                                    t[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s] = a2[idx1 + 1];
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(t, 0, scale);
                                DoubleDHT_3D.this.dhtSlices.inverse(t, DoubleDHT_3D.this.slices, scale);
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStride + idx0;
                                    a2[idx1] = t[s];
                                    a2[idx1 + 1] = t[DoubleDHT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final DoubleLargeArray a2, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        }
        final long ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        DoubleLargeArray t;
                        block17: {
                            block18: {
                                t = new DoubleLargeArray(ntf);
                                if (isgn != -1) break block17;
                                if (DoubleDHT_3D.this.columnsl <= 2L) break block18;
                                for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                    long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                    for (long c2 = 0L; c2 < DoubleDHT_3D.this.columnsl; c2 += 4L) {
                                        long idx2;
                                        long idx1;
                                        long s;
                                        for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                            idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0 + c2;
                                            idx2 = DoubleDHT_3D.this.slicesl + s;
                                            t.setDouble(s, a2.getDouble(idx1));
                                            t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                            t.setDouble(idx2 + DoubleDHT_3D.this.slicesl, a2.getDouble(idx1 + 2L));
                                            t.setDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl, a2.getDouble(idx1 + 3L));
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 0L);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, DoubleDHT_3D.this.slicesl);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 2L * DoubleDHT_3D.this.slicesl);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 3L * DoubleDHT_3D.this.slicesl);
                                        for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                            idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0 + c2;
                                            idx2 = DoubleDHT_3D.this.slicesl + s;
                                            a2.setDouble(idx1, t.getDouble(s));
                                            a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                                            a2.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDHT_3D.this.slicesl));
                                            a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columnsl != 2L) break block19;
                            for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s;
                                long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0;
                                    t.setDouble(s, a2.getDouble(idx1));
                                    t.setDouble(DoubleDHT_3D.this.slicesl + s, a2.getDouble(idx1 + 1L));
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(t, 0L);
                                DoubleDHT_3D.this.dhtSlices.forward(t, DoubleDHT_3D.this.slicesl);
                                for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0;
                                    a2.setDouble(idx1, t.getDouble(s));
                                    a2.setDouble(idx1 + 1L, t.getDouble(DoubleDHT_3D.this.slicesl + s));
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columnsl > 2L) {
                            for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                for (long c3 = 0L; c3 < DoubleDHT_3D.this.columnsl; c3 += 4L) {
                                    long idx2;
                                    long idx1;
                                    long s;
                                    for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                        idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0 + c3;
                                        idx2 = DoubleDHT_3D.this.slicesl + s;
                                        t.setDouble(s, a2.getDouble(idx1));
                                        t.setDouble(idx2, a2.getDouble(idx1 + 1L));
                                        t.setDouble(idx2 + DoubleDHT_3D.this.slicesl, a2.getDouble(idx1 + 2L));
                                        t.setDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl, a2.getDouble(idx1 + 3L));
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 0L, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, DoubleDHT_3D.this.slicesl, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 2L * DoubleDHT_3D.this.slicesl, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 3L * DoubleDHT_3D.this.slicesl, scale);
                                    for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                        idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0 + c3;
                                        idx2 = DoubleDHT_3D.this.slicesl + s;
                                        a2.setDouble(idx1, t.getDouble(s));
                                        a2.setDouble(idx1 + 1L, t.getDouble(idx2));
                                        a2.setDouble(idx1 + 2L, t.getDouble(idx2 + DoubleDHT_3D.this.slicesl));
                                        a2.setDouble(idx1 + 3L, t.getDouble(idx2 + 2L * DoubleDHT_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columnsl == 2L) {
                            for (long r = n0; r < DoubleDHT_3D.this.rowsl; r += (long)nthreads) {
                                long idx1;
                                long s;
                                long idx0 = r * DoubleDHT_3D.this.rowStridel;
                                for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0;
                                    t.setDouble(s, a2.getDouble(idx1));
                                    t.setDouble(DoubleDHT_3D.this.slicesl + s, a2.getDouble(idx1 + 1L));
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(t, 0L, scale);
                                DoubleDHT_3D.this.dhtSlices.inverse(t, DoubleDHT_3D.this.slicesl, scale);
                                for (s = 0L; s < DoubleDHT_3D.this.slicesl; ++s) {
                                    idx1 = s * DoubleDHT_3D.this.sliceStridel + idx0;
                                    a2.setDouble(idx1, t.getDouble(s));
                                    a2.setDouble(idx1 + 1L, t.getDouble(DoubleDHT_3D.this.slicesl + s));
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt3db_subth(final int isgn, final double[][][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        final int ntf = nt;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        double[] t;
                        block17: {
                            block18: {
                                t = new double[ntf];
                                if (isgn != -1) break block17;
                                if (DoubleDHT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                    for (int c2 = 0; c2 < DoubleDHT_3D.this.columns; c2 += 4) {
                                        int idx2;
                                        int s;
                                        for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                            idx2 = DoubleDHT_3D.this.slices + s;
                                            t[s] = a2[s][r][c2];
                                            t[idx2] = a2[s][r][c2 + 1];
                                            t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[s][r][c2 + 2];
                                            t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[s][r][c2 + 3];
                                        }
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 0);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 2 * DoubleDHT_3D.this.slices);
                                        DoubleDHT_3D.this.dhtSlices.forward(t, 3 * DoubleDHT_3D.this.slices);
                                        for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                            idx2 = DoubleDHT_3D.this.slices + s;
                                            a2[s][r][c2] = t[s];
                                            a2[s][r][c2 + 1] = t[idx2];
                                            a2[s][r][c2 + 2] = t[idx2 + DoubleDHT_3D.this.slices];
                                            a2[s][r][c2 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDHT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    t[s] = a2[s][r][0];
                                    t[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s] = a2[s][r][1];
                                }
                                DoubleDHT_3D.this.dhtSlices.forward(t, 0);
                                DoubleDHT_3D.this.dhtSlices.forward(t, DoubleDHT_3D.this.slices);
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    a2[s][r][0] = t[s];
                                    a2[s][r][1] = t[DoubleDHT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDHT_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                for (int c3 = 0; c3 < DoubleDHT_3D.this.columns; c3 += 4) {
                                    int idx2;
                                    int s;
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx2 = DoubleDHT_3D.this.slices + s;
                                        t[s] = a2[s][r][c3];
                                        t[idx2] = a2[s][r][c3 + 1];
                                        t[idx2 + ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[s][r][c3 + 2];
                                        t[idx2 + 2 * ((DoubleDHT_3D)DoubleDHT_3D.this).slices] = a2[s][r][c3 + 3];
                                    }
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 0, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 2 * DoubleDHT_3D.this.slices, scale);
                                    DoubleDHT_3D.this.dhtSlices.inverse(t, 3 * DoubleDHT_3D.this.slices, scale);
                                    for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                        idx2 = DoubleDHT_3D.this.slices + s;
                                        a2[s][r][c3] = t[s];
                                        a2[s][r][c3 + 1] = t[idx2];
                                        a2[s][r][c3 + 2] = t[idx2 + DoubleDHT_3D.this.slices];
                                        a2[s][r][c3 + 3] = t[idx2 + 2 * DoubleDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDHT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDHT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    t[s] = a2[s][r][0];
                                    t[((DoubleDHT_3D)DoubleDHT_3D.this).slices + s] = a2[s][r][1];
                                }
                                DoubleDHT_3D.this.dhtSlices.inverse(t, 0, scale);
                                DoubleDHT_3D.this.dhtSlices.inverse(t, DoubleDHT_3D.this.slices, scale);
                                for (s = 0; s < DoubleDHT_3D.this.slices; ++s) {
                                    a2[s][r][0] = t[s];
                                    a2[s][r][1] = t[DoubleDHT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(DoubleDHT_3D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void yTransform(double[] a2) {
        for (int s = 0; s <= this.slices / 2; ++s) {
            int sC = (this.slices - s) % this.slices;
            int idx9 = s * this.sliceStride;
            int idx10 = sC * this.sliceStride;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                int idx11 = r * this.rowStride;
                int idx12 = rC * this.rowStride;
                for (int c2 = 0; c2 <= this.columns / 2; ++c2) {
                    int cC = (this.columns - c2) % this.columns;
                    int idx1 = idx9 + idx12 + c2;
                    int idx2 = idx9 + idx11 + cC;
                    int idx3 = idx10 + idx11 + c2;
                    int idx4 = idx10 + idx12 + cC;
                    int idx5 = idx10 + idx12 + c2;
                    int idx6 = idx10 + idx11 + cC;
                    int idx7 = idx9 + idx11 + c2;
                    int idx8 = idx9 + idx12 + cC;
                    double A = a2[idx1];
                    double B = a2[idx2];
                    double C = a2[idx3];
                    double D = a2[idx4];
                    double E = a2[idx5];
                    double F = a2[idx6];
                    double G = a2[idx7];
                    double H = a2[idx8];
                    a2[idx7] = (A + B + C - D) / 2.0;
                    a2[idx3] = (E + F + G - H) / 2.0;
                    a2[idx1] = (G + H + E - F) / 2.0;
                    a2[idx5] = (C + D + A - B) / 2.0;
                    a2[idx2] = (H + G + F - E) / 2.0;
                    a2[idx6] = (D + C + B - A) / 2.0;
                    a2[idx8] = (B + A + D - C) / 2.0;
                    a2[idx4] = (F + E + H - G) / 2.0;
                }
            }
        }
    }

    private void yTransform(DoubleLargeArray a2) {
        for (long s = 0L; s <= this.slicesl / 2L; ++s) {
            long sC = (this.slicesl - s) % this.slicesl;
            long idx9 = s * this.sliceStridel;
            long idx10 = sC * this.sliceStridel;
            for (long r = 0L; r <= this.rowsl / 2L; ++r) {
                long rC = (this.rowsl - r) % this.rowsl;
                long idx11 = r * this.rowStridel;
                long idx12 = rC * this.rowStridel;
                for (long c2 = 0L; c2 <= this.columnsl / 2L; ++c2) {
                    long cC = (this.columnsl - c2) % this.columnsl;
                    long idx1 = idx9 + idx12 + c2;
                    long idx2 = idx9 + idx11 + cC;
                    long idx3 = idx10 + idx11 + c2;
                    long idx4 = idx10 + idx12 + cC;
                    long idx5 = idx10 + idx12 + c2;
                    long idx6 = idx10 + idx11 + cC;
                    long idx7 = idx9 + idx11 + c2;
                    long idx8 = idx9 + idx12 + cC;
                    double A = a2.getDouble(idx1);
                    double B = a2.getDouble(idx2);
                    double C = a2.getDouble(idx3);
                    double D = a2.getDouble(idx4);
                    double E = a2.getDouble(idx5);
                    double F = a2.getDouble(idx6);
                    double G = a2.getDouble(idx7);
                    double H = a2.getDouble(idx8);
                    a2.setDouble(idx7, (A + B + C - D) / 2.0);
                    a2.setDouble(idx3, (E + F + G - H) / 2.0);
                    a2.setDouble(idx1, (G + H + E - F) / 2.0);
                    a2.setDouble(idx5, (C + D + A - B) / 2.0);
                    a2.setDouble(idx2, (H + G + F - E) / 2.0);
                    a2.setDouble(idx6, (D + C + B - A) / 2.0);
                    a2.setDouble(idx8, (B + A + D - C) / 2.0);
                    a2.setDouble(idx4, (F + E + H - G) / 2.0);
                }
            }
        }
    }

    private void yTransform(double[][][] a2) {
        for (int s = 0; s <= this.slices / 2; ++s) {
            int sC = (this.slices - s) % this.slices;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                for (int c2 = 0; c2 <= this.columns / 2; ++c2) {
                    int cC = (this.columns - c2) % this.columns;
                    double A = a2[s][rC][c2];
                    double B = a2[s][r][cC];
                    double C = a2[sC][r][c2];
                    double D = a2[sC][rC][cC];
                    double E = a2[sC][rC][c2];
                    double F = a2[sC][r][cC];
                    double G = a2[s][r][c2];
                    double H = a2[s][rC][cC];
                    a2[s][r][c2] = (A + B + C - D) / 2.0;
                    a2[sC][r][c2] = (E + F + G - H) / 2.0;
                    a2[s][rC][c2] = (G + H + E - F) / 2.0;
                    a2[sC][rC][c2] = (C + D + A - B) / 2.0;
                    a2[s][r][cC] = (H + G + F - E) / 2.0;
                    a2[sC][r][cC] = (D + C + B - A) / 2.0;
                    a2[s][rC][cC] = (B + A + D - C) / 2.0;
                    a2[sC][rC][cC] = (F + E + H - G) / 2.0;
                }
            }
        }
    }
}

