/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dht;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.dht.FloatDHT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class FloatDHT_2D {
    private int rows;
    private int columns;
    private long rowsl;
    private long columnsl;
    private FloatDHT_1D dhtColumns;
    private FloatDHT_1D dhtRows;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDHT_2D(long rows, long columns) {
        if (rows <= 1L || columns <= 1L) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = (int)rows;
        this.columns = (int)columns;
        this.rowsl = rows;
        this.columnsl = columns;
        if (rows * columns >= CommonUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (CommonUtils.isPowerOf2(rows) && CommonUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
        }
        CommonUtils.setUseLargeArrays(rows * columns > (long)LargeArray.getMaxSizeOf32bitArray());
        this.dhtRows = new FloatDHT_1D(rows);
        this.dhtColumns = rows == columns ? this.dhtRows : new FloatDHT_1D(columns);
    }

    public void forward(final float[] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a2, true);
                this.ddxt2d0_subth(-1, a2, true);
            } else {
                this.ddxt2d_sub(-1, a2, true);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dhtColumns.forward(a2, i2 * this.columns);
                }
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final int firstRow = l2 * p;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i2 = firstRow; i2 < lastRow; ++i2) {
                                FloatDHT_2D.this.dhtColumns.forward(a2, i2 * FloatDHT_2D.this.columns);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final int firstColumn = l3 * p;
                    final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a2[r * FloatDHT_2D.this.columns + c2];
                                }
                                FloatDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a2[r * ((FloatDHT_2D)FloatDHT_2D.this).columns + c2] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i3 = 0; i3 < this.rows; ++i3) {
                    this.dhtColumns.forward(a2, i3 * this.columns);
                }
                float[] temp = new float[this.rows];
                for (int c2 = 0; c2 < this.columns; ++c2) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a2[r * this.columns + c2];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a2[r * this.columns + c2] = temp[r];
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void forward(final FloatLargeArray a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a2, true);
                this.ddxt2d0_subth(-1, a2, true);
            } else {
                this.ddxt2d_sub(-1, a2, true);
                for (long i2 = 0L; i2 < this.rowsl; ++i2) {
                    this.dhtColumns.forward(a2, i2 * this.columnsl);
                }
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                Future[] futures = new Future[nthreads];
                long p = this.rowsl / (long)nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final long firstRow = (long)l2 * p;
                    final long lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i2 = firstRow; i2 < lastRow; ++i2) {
                                FloatDHT_2D.this.dhtColumns.forward(a2, i2 * FloatDHT_2D.this.columnsl);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columnsl / (long)nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final long firstColumn = (long)l3 * p;
                    final long lastColumn = l3 == nthreads - 1 ? this.columnsl : firstColumn + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(FloatDHT_2D.this.rowsl, false);
                            for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                                long r;
                                for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                    temp.setFloat(r, a2.getFloat(r * FloatDHT_2D.this.columnsl + c2));
                                }
                                FloatDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                    a2.setFloat(r * FloatDHT_2D.this.columnsl + c2, temp.getFloat(r));
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i3 = 0L; i3 < this.rowsl; ++i3) {
                    this.dhtColumns.forward(a2, i3 * this.columnsl);
                }
                FloatLargeArray temp = new FloatLargeArray(this.rowsl, false);
                for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        temp.setFloat(r, a2.getFloat(r * this.columnsl + c2));
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0L; r < this.rowsl; ++r) {
                        a2.setFloat(r * this.columnsl + c2, temp.getFloat(r));
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void forward(final float[][] a2) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a2, true);
                this.ddxt2d0_subth(-1, a2, true);
            } else {
                this.ddxt2d_sub(-1, a2, true);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dhtColumns.forward(a2[i2]);
                }
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final int firstRow = l2 * p;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i2 = firstRow; i2 < lastRow; ++i2) {
                                FloatDHT_2D.this.dhtColumns.forward(a2[i2]);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final int firstColumn = l3 * p;
                    final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a2[r][c2];
                                }
                                FloatDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a2[r][c2] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i3 = 0; i3 < this.rows; ++i3) {
                    this.dhtColumns.forward(a2[i3]);
                }
                float[] temp = new float[this.rows];
                for (int c2 = 0; c2 < this.columns; ++c2) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a2[r][c2];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a2[r][c2] = temp[r];
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void inverse(final float[] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a2, scale);
                this.ddxt2d0_subth(1, a2, scale);
            } else {
                this.ddxt2d_sub(1, a2, scale);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dhtColumns.inverse(a2, i2 * this.columns, scale);
                }
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final int firstRow = l2 * p;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i2 = firstRow; i2 < lastRow; ++i2) {
                                FloatDHT_2D.this.dhtColumns.inverse(a2, i2 * FloatDHT_2D.this.columns, scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final int firstColumn = l3 * p;
                    final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a2[r * FloatDHT_2D.this.columns + c2];
                                }
                                FloatDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a2[r * ((FloatDHT_2D)FloatDHT_2D.this).columns + c2] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i3 = 0; i3 < this.rows; ++i3) {
                    this.dhtColumns.inverse(a2, i3 * this.columns, scale);
                }
                float[] temp = new float[this.rows];
                for (int c2 = 0; c2 < this.columns; ++c2) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a2[r * this.columns + c2];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a2[r * this.columns + c2] = temp[r];
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void inverse(final FloatLargeArray a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a2, scale);
                this.ddxt2d0_subth(1, a2, scale);
            } else {
                this.ddxt2d_sub(1, a2, scale);
                for (long i2 = 0L; i2 < this.rowsl; ++i2) {
                    this.dhtColumns.inverse(a2, i2 * this.columnsl, scale);
                }
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.rowsl >= (long)nthreads && this.columnsl >= (long)nthreads) {
                Future[] futures = new Future[nthreads];
                long p = this.rowsl / (long)nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final long firstRow = (long)l2 * p;
                    final long lastRow = l2 == nthreads - 1 ? this.rowsl : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i2 = firstRow; i2 < lastRow; ++i2) {
                                FloatDHT_2D.this.dhtColumns.inverse(a2, i2 * FloatDHT_2D.this.columnsl, scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columnsl / (long)nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final long firstColumn = (long)l3 * p;
                    final long lastColumn = l3 == nthreads - 1 ? this.columnsl : firstColumn + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            FloatLargeArray temp = new FloatLargeArray(FloatDHT_2D.this.rowsl, false);
                            for (long c2 = firstColumn; c2 < lastColumn; ++c2) {
                                long r;
                                for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                    temp.setFloat(r, a2.getFloat(r * FloatDHT_2D.this.columnsl + c2));
                                }
                                FloatDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                    a2.setFloat(r * FloatDHT_2D.this.columnsl + c2, temp.getFloat(r));
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i3 = 0L; i3 < this.rowsl; ++i3) {
                    this.dhtColumns.inverse(a2, i3 * this.columnsl, scale);
                }
                FloatLargeArray temp = new FloatLargeArray(this.rowsl, false);
                for (long c2 = 0L; c2 < this.columnsl; ++c2) {
                    long r;
                    for (r = 0L; r < this.rowsl; ++r) {
                        temp.setFloat(r, a2.getFloat(r * this.columnsl + c2));
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0L; r < this.rowsl; ++r) {
                        a2.setFloat(r * this.columnsl + c2, temp.getFloat(r));
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    public void inverse(final float[][] a2, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a2, scale);
                this.ddxt2d0_subth(1, a2, scale);
            } else {
                this.ddxt2d_sub(1, a2, scale);
                for (int i2 = 0; i2 < this.rows; ++i2) {
                    this.dhtColumns.inverse(a2[i2], scale);
                }
            }
            this.yTransform(a2);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (int l2 = 0; l2 < nthreads; ++l2) {
                    final int firstRow = l2 * p;
                    final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i2 = firstRow; i2 < lastRow; ++i2) {
                                FloatDHT_2D.this.dhtColumns.inverse(a2[i2], scale);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                p = this.columns / nthreads;
                for (int l3 = 0; l3 < nthreads; ++l3) {
                    final int firstColumn = l3 * p;
                    final int lastColumn = l3 == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c2 = firstColumn; c2 < lastColumn; ++c2) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a2[r][c2];
                                }
                                FloatDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a2[r][c2] = temp[r];
                                }
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i3 = 0; i3 < this.rows; ++i3) {
                    this.dhtColumns.inverse(a2[i3], scale);
                }
                float[] temp = new float[this.rows];
                for (int c2 = 0; c2 < this.columns; ++c2) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a2[r][c2];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a2[r][c2] = temp[r];
                    }
                }
            }
            this.yTransform(a2);
        }
    }

    private void ddxt2d_subth(final int isgn, final float[] a2, final boolean scale) {
        int nthread = FastMath.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int idx1;
                        float[] t;
                        block12: {
                            t = new float[ntf];
                            if (FloatDHT_2D.this.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c2 = 4 * n0; c2 < FloatDHT_2D.this.columns; c2 += 4 * nthreads) {
                                    int idx22;
                                    int idx12;
                                    int r;
                                    for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                        idx12 = r * FloatDHT_2D.this.columns + c2;
                                        idx22 = FloatDHT_2D.this.rows + r;
                                        t[r] = a2[idx12];
                                        t[idx22] = a2[idx12 + 1];
                                        t[idx22 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[idx12 + 2];
                                        t[idx22 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[idx12 + 3];
                                    }
                                    FloatDHT_2D.this.dhtRows.forward(t, 0);
                                    FloatDHT_2D.this.dhtRows.forward(t, FloatDHT_2D.this.rows);
                                    FloatDHT_2D.this.dhtRows.forward(t, 2 * FloatDHT_2D.this.rows);
                                    FloatDHT_2D.this.dhtRows.forward(t, 3 * FloatDHT_2D.this.rows);
                                    for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                        idx12 = r * FloatDHT_2D.this.columns + c2;
                                        idx22 = FloatDHT_2D.this.rows + r;
                                        a2[idx12] = t[r];
                                        a2[idx12 + 1] = t[idx22];
                                        a2[idx12 + 2] = t[idx22 + FloatDHT_2D.this.rows];
                                        a2[idx12 + 3] = t[idx22 + 2 * FloatDHT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int c3 = 4 * n0; c3 < FloatDHT_2D.this.columns; c3 += 4 * nthreads) {
                                    int idx23;
                                    int idx13;
                                    int r;
                                    for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                        idx13 = r * FloatDHT_2D.this.columns + c3;
                                        idx23 = FloatDHT_2D.this.rows + r;
                                        t[r] = a2[idx13];
                                        t[idx23] = a2[idx13 + 1];
                                        t[idx23 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[idx13 + 2];
                                        t[idx23 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[idx13 + 3];
                                    }
                                    FloatDHT_2D.this.dhtRows.inverse(t, 0, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, FloatDHT_2D.this.rows, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, 2 * FloatDHT_2D.this.rows, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, 3 * FloatDHT_2D.this.rows, scale);
                                    for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                        idx13 = r * FloatDHT_2D.this.columns + c3;
                                        idx23 = FloatDHT_2D.this.rows + r;
                                        a2[idx13] = t[r];
                                        a2[idx13 + 1] = t[idx23];
                                        a2[idx13 + 2] = t[idx23 + FloatDHT_2D.this.rows];
                                        a2[idx13 + 3] = t[idx23 + 2 * FloatDHT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (FloatDHT_2D.this.columns != 2) break block13;
                        int r = 0;
                        while (r < FloatDHT_2D.this.rows) {
                            idx1 = r * FloatDHT_2D.this.columns + 2 * n0;
                            idx2 = r++;
                            t[idx2] = a2[idx1];
                            t[idx2 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[idx1 + 1];
                        }
                        if (isgn == -1) {
                            FloatDHT_2D.this.dhtRows.forward(t, 0);
                            FloatDHT_2D.this.dhtRows.forward(t, FloatDHT_2D.this.rows);
                        } else {
                            FloatDHT_2D.this.dhtRows.inverse(t, 0, scale);
                            FloatDHT_2D.this.dhtRows.inverse(t, FloatDHT_2D.this.rows, scale);
                        }
                        r = 0;
                        while (r < FloatDHT_2D.this.rows) {
                            idx1 = r * FloatDHT_2D.this.columns + 2 * n0;
                            idx2 = r++;
                            a2[idx1] = t[idx2];
                            a2[idx1 + 1] = t[idx2 + FloatDHT_2D.this.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final FloatLargeArray a2, final boolean scale) {
        int nthread = (int)FastMath.min(this.columnsl, (long)ConcurrencyUtils.getNumberOfThreads());
        long nt = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            nt >>= 1;
        } else if (this.columnsl < 2L) {
            nt >>= 2;
        }
        final long ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        long idx2;
                        long idx1;
                        FloatLargeArray t;
                        block12: {
                            t = new FloatLargeArray(ntf);
                            if (FloatDHT_2D.this.columnsl <= 2L) break block12;
                            if (isgn == -1) {
                                for (long c2 = 4L * n0; c2 < FloatDHT_2D.this.columnsl; c2 += (long)(4 * nthreads)) {
                                    long idx22;
                                    long idx12;
                                    long r;
                                    for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                        idx12 = r * FloatDHT_2D.this.columnsl + c2;
                                        idx22 = FloatDHT_2D.this.rowsl + r;
                                        t.setFloat(r, a2.getFloat(idx12));
                                        t.setFloat(idx22, a2.getFloat(idx12 + 1L));
                                        t.setFloat(idx22 + FloatDHT_2D.this.rowsl, a2.getFloat(idx12 + 2L));
                                        t.setFloat(idx22 + 2L * FloatDHT_2D.this.rowsl, a2.getFloat(idx12 + 3L));
                                    }
                                    FloatDHT_2D.this.dhtRows.forward(t, 0L);
                                    FloatDHT_2D.this.dhtRows.forward(t, FloatDHT_2D.this.rowsl);
                                    FloatDHT_2D.this.dhtRows.forward(t, 2L * FloatDHT_2D.this.rowsl);
                                    FloatDHT_2D.this.dhtRows.forward(t, 3L * FloatDHT_2D.this.rowsl);
                                    for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                        idx12 = r * FloatDHT_2D.this.columnsl + c2;
                                        idx22 = FloatDHT_2D.this.rowsl + r;
                                        a2.setFloat(idx12, t.getFloat(r));
                                        a2.setFloat(idx12 + 1L, t.getFloat(idx22));
                                        a2.setFloat(idx12 + 2L, t.getFloat(idx22 + FloatDHT_2D.this.rowsl));
                                        a2.setFloat(idx12 + 3L, t.getFloat(idx22 + 2L * FloatDHT_2D.this.rowsl));
                                    }
                                }
                            } else {
                                for (long c3 = 4L * n0; c3 < FloatDHT_2D.this.columnsl; c3 += (long)(4 * nthreads)) {
                                    long idx23;
                                    long idx13;
                                    long r;
                                    for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                        idx13 = r * FloatDHT_2D.this.columnsl + c3;
                                        idx23 = FloatDHT_2D.this.rowsl + r;
                                        t.setFloat(r, a2.getFloat(idx13));
                                        t.setFloat(idx23, a2.getFloat(idx13 + 1L));
                                        t.setFloat(idx23 + FloatDHT_2D.this.rowsl, a2.getFloat(idx13 + 2L));
                                        t.setFloat(idx23 + 2L * FloatDHT_2D.this.rowsl, a2.getFloat(idx13 + 3L));
                                    }
                                    FloatDHT_2D.this.dhtRows.inverse(t, 0L, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, FloatDHT_2D.this.rowsl, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, 2L * FloatDHT_2D.this.rowsl, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, 3L * FloatDHT_2D.this.rowsl, scale);
                                    for (r = 0L; r < FloatDHT_2D.this.rowsl; ++r) {
                                        idx13 = r * FloatDHT_2D.this.columnsl + c3;
                                        idx23 = FloatDHT_2D.this.rowsl + r;
                                        a2.setFloat(idx13, t.getFloat(r));
                                        a2.setFloat(idx13 + 1L, t.getFloat(idx23));
                                        a2.setFloat(idx13 + 2L, t.getFloat(idx23 + FloatDHT_2D.this.rowsl));
                                        a2.setFloat(idx13 + 3L, t.getFloat(idx23 + 2L * FloatDHT_2D.this.rowsl));
                                    }
                                }
                            }
                            break block13;
                        }
                        if (FloatDHT_2D.this.columnsl != 2L) break block13;
                        long r = 0L;
                        while (r < FloatDHT_2D.this.rowsl) {
                            idx1 = r * FloatDHT_2D.this.columnsl + 2L * n0;
                            idx2 = r++;
                            t.setFloat(idx2, a2.getFloat(idx1));
                            t.setFloat(idx2 + FloatDHT_2D.this.rowsl, a2.getFloat(idx1 + 1L));
                        }
                        if (isgn == -1) {
                            FloatDHT_2D.this.dhtRows.forward(t, 0L);
                            FloatDHT_2D.this.dhtRows.forward(t, FloatDHT_2D.this.rowsl);
                        } else {
                            FloatDHT_2D.this.dhtRows.inverse(t, 0L, scale);
                            FloatDHT_2D.this.dhtRows.inverse(t, FloatDHT_2D.this.rowsl, scale);
                        }
                        r = 0L;
                        while (r < FloatDHT_2D.this.rowsl) {
                            idx1 = r * FloatDHT_2D.this.columnsl + 2L * n0;
                            idx2 = r++;
                            a2.setFloat(idx1, t.getFloat(idx2));
                            a2.setFloat(idx1 + 1L, t.getFloat(idx2 + FloatDHT_2D.this.rowsl));
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_subth(final int isgn, final float[][] a2, final boolean scale) {
        int nthread = FastMath.min(this.columns, ConcurrencyUtils.getNumberOfThreads());
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        } else if (this.columns < 2) {
            nt >>= 2;
        }
        final int ntf = nt;
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block13: {
                        int idx2;
                        int r;
                        float[] t;
                        block12: {
                            t = new float[ntf];
                            if (FloatDHT_2D.this.columns <= 2) break block12;
                            if (isgn == -1) {
                                for (int c2 = 4 * n0; c2 < FloatDHT_2D.this.columns; c2 += 4 * nthreads) {
                                    int idx22;
                                    int r2;
                                    for (r2 = 0; r2 < FloatDHT_2D.this.rows; ++r2) {
                                        idx22 = FloatDHT_2D.this.rows + r2;
                                        t[r2] = a2[r2][c2];
                                        t[idx22] = a2[r2][c2 + 1];
                                        t[idx22 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[r2][c2 + 2];
                                        t[idx22 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[r2][c2 + 3];
                                    }
                                    FloatDHT_2D.this.dhtRows.forward(t, 0);
                                    FloatDHT_2D.this.dhtRows.forward(t, FloatDHT_2D.this.rows);
                                    FloatDHT_2D.this.dhtRows.forward(t, 2 * FloatDHT_2D.this.rows);
                                    FloatDHT_2D.this.dhtRows.forward(t, 3 * FloatDHT_2D.this.rows);
                                    for (r2 = 0; r2 < FloatDHT_2D.this.rows; ++r2) {
                                        idx22 = FloatDHT_2D.this.rows + r2;
                                        a2[r2][c2] = t[r2];
                                        a2[r2][c2 + 1] = t[idx22];
                                        a2[r2][c2 + 2] = t[idx22 + FloatDHT_2D.this.rows];
                                        a2[r2][c2 + 3] = t[idx22 + 2 * FloatDHT_2D.this.rows];
                                    }
                                }
                            } else {
                                for (int c3 = 4 * n0; c3 < FloatDHT_2D.this.columns; c3 += 4 * nthreads) {
                                    int idx23;
                                    int r3;
                                    for (r3 = 0; r3 < FloatDHT_2D.this.rows; ++r3) {
                                        idx23 = FloatDHT_2D.this.rows + r3;
                                        t[r3] = a2[r3][c3];
                                        t[idx23] = a2[r3][c3 + 1];
                                        t[idx23 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[r3][c3 + 2];
                                        t[idx23 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[r3][c3 + 3];
                                    }
                                    FloatDHT_2D.this.dhtRows.inverse(t, 0, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, FloatDHT_2D.this.rows, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, 2 * FloatDHT_2D.this.rows, scale);
                                    FloatDHT_2D.this.dhtRows.inverse(t, 3 * FloatDHT_2D.this.rows, scale);
                                    for (r3 = 0; r3 < FloatDHT_2D.this.rows; ++r3) {
                                        idx23 = FloatDHT_2D.this.rows + r3;
                                        a2[r3][c3] = t[r3];
                                        a2[r3][c3 + 1] = t[idx23];
                                        a2[r3][c3 + 2] = t[idx23 + FloatDHT_2D.this.rows];
                                        a2[r3][c3 + 3] = t[idx23 + 2 * FloatDHT_2D.this.rows];
                                    }
                                }
                            }
                            break block13;
                        }
                        if (FloatDHT_2D.this.columns != 2) break block13;
                        for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                            idx2 = r;
                            t[idx2] = a2[r][2 * n0];
                            t[idx2 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a2[r][2 * n0 + 1];
                        }
                        if (isgn == -1) {
                            FloatDHT_2D.this.dhtRows.forward(t, 0);
                            FloatDHT_2D.this.dhtRows.forward(t, FloatDHT_2D.this.rows);
                        } else {
                            FloatDHT_2D.this.dhtRows.inverse(t, 0, scale);
                            FloatDHT_2D.this.dhtRows.inverse(t, FloatDHT_2D.this.rows, scale);
                        }
                        for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                            idx2 = r;
                            a2[r][2 * n0] = t[idx2];
                            a2[r][2 * n0 + 1] = t[idx2 + FloatDHT_2D.this.rows];
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final float[] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.forward(a2, r * FloatDHT_2D.this.columns);
                        }
                    } else {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.inverse(a2, r * FloatDHT_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final FloatLargeArray a2, final boolean scale) {
        final int nthreads = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final long n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (long r = n0; r < FloatDHT_2D.this.rowsl; r += (long)nthreads) {
                            FloatDHT_2D.this.dhtColumns.forward(a2, r * FloatDHT_2D.this.columnsl);
                        }
                    } else {
                        for (long r = n0; r < FloatDHT_2D.this.rowsl; r += (long)nthreads) {
                            FloatDHT_2D.this.dhtColumns.inverse(a2, r * FloatDHT_2D.this.columnsl, scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d0_subth(final int isgn, final float[][] a2, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i2 = 0; i2 < nthreads; ++i2) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.forward(a2[r]);
                        }
                    } else {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.inverse(a2[r], scale);
                        }
                    }
                }
            });
        }
        try {
            ConcurrencyUtils.waitForCompletion(futures);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(FloatDHT_2D.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void ddxt2d_sub(int isgn, float[] a2, boolean scale) {
        block16: {
            int idx1;
            int r;
            float[] t;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t = new float[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int idx12;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c2;
                            idx2 = this.rows + r2;
                            t[r2] = a2[idx12];
                            t[idx2] = a2[idx12 + 1];
                            t[idx2 + this.rows] = a2[idx12 + 2];
                            t[idx2 + 2 * this.rows] = a2[idx12 + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c2;
                            idx2 = this.rows + r2;
                            a2[idx12] = t[r2];
                            a2[idx12 + 1] = t[idx2];
                            a2[idx12 + 2] = t[idx2 + this.rows];
                            a2[idx12 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int idx13;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c3;
                            idx2 = this.rows + r3;
                            t[r3] = a2[idx13];
                            t[idx2] = a2[idx13 + 1];
                            t[idx2 + this.rows] = a2[idx13 + 2];
                            t[idx2 + 2 * this.rows] = a2[idx13 + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c3;
                            idx2 = this.rows + r3;
                            a2[idx13] = t[r3];
                            a2[idx13 + 1] = t[idx2];
                            a2[idx13 + 2] = t[idx2 + this.rows];
                            a2[idx13 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                t[r] = a2[idx1];
                t[this.rows + r] = a2[idx1 + 1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
            } else {
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                a2[idx1] = t[r];
                a2[idx1 + 1] = t[this.rows + r];
            }
        }
    }

    private void ddxt2d_sub(int isgn, FloatLargeArray a2, boolean scale) {
        block16: {
            long idx1;
            long r;
            FloatLargeArray t;
            block15: {
                long nt = 4L * this.rowsl;
                if (this.columnsl == 2L) {
                    nt >>= 1;
                } else if (this.columnsl < 2L) {
                    nt >>= 2;
                }
                t = new FloatLargeArray(nt);
                if (this.columnsl <= 2L) break block15;
                if (isgn == -1) {
                    for (long c2 = 0L; c2 < this.columnsl; c2 += 4L) {
                        long idx2;
                        long idx12;
                        long r2;
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx12 = r2 * this.columnsl + c2;
                            idx2 = this.rowsl + r2;
                            t.setFloat(r2, a2.getFloat(idx12));
                            t.setFloat(idx2, a2.getFloat(idx12 + 1L));
                            t.setFloat(idx2 + this.rowsl, a2.getFloat(idx12 + 2L));
                            t.setFloat(idx2 + 2L * this.rowsl, a2.getFloat(idx12 + 3L));
                        }
                        this.dhtRows.forward(t, 0L);
                        this.dhtRows.forward(t, this.rowsl);
                        this.dhtRows.forward(t, 2L * this.rowsl);
                        this.dhtRows.forward(t, 3L * this.rowsl);
                        for (r2 = 0L; r2 < this.rowsl; ++r2) {
                            idx12 = r2 * this.columnsl + c2;
                            idx2 = this.rowsl + r2;
                            a2.setFloat(idx12, t.getFloat(r2));
                            a2.setFloat(idx12 + 1L, t.getFloat(idx2));
                            a2.setFloat(idx12 + 2L, t.getFloat(idx2 + this.rowsl));
                            a2.setFloat(idx12 + 3L, t.getFloat(idx2 + 2L * this.rowsl));
                        }
                    }
                } else {
                    for (long c3 = 0L; c3 < this.columnsl; c3 += 4L) {
                        long idx2;
                        long idx13;
                        long r3;
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx13 = r3 * this.columnsl + c3;
                            idx2 = this.rowsl + r3;
                            t.setFloat(r3, a2.getFloat(idx13));
                            t.setFloat(idx2, a2.getFloat(idx13 + 1L));
                            t.setFloat(idx2 + this.rowsl, a2.getFloat(idx13 + 2L));
                            t.setFloat(idx2 + 2L * this.rowsl, a2.getFloat(idx13 + 3L));
                        }
                        this.dhtRows.inverse(t, 0L, scale);
                        this.dhtRows.inverse(t, this.rowsl, scale);
                        this.dhtRows.inverse(t, 2L * this.rowsl, scale);
                        this.dhtRows.inverse(t, 3L * this.rowsl, scale);
                        for (r3 = 0L; r3 < this.rowsl; ++r3) {
                            idx13 = r3 * this.columnsl + c3;
                            idx2 = this.rowsl + r3;
                            a2.setFloat(idx13, t.getFloat(r3));
                            a2.setFloat(idx13 + 1L, t.getFloat(idx2));
                            a2.setFloat(idx13 + 2L, t.getFloat(idx2 + this.rowsl));
                            a2.setFloat(idx13 + 3L, t.getFloat(idx2 + 2L * this.rowsl));
                        }
                    }
                }
                break block16;
            }
            if (this.columnsl != 2L) break block16;
            for (r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.columnsl;
                t.setFloat(r, a2.getFloat(idx1));
                t.setFloat(this.rowsl + r, a2.getFloat(idx1 + 1L));
            }
            if (isgn == -1) {
                this.dhtRows.forward(t, 0L);
                this.dhtRows.forward(t, this.rowsl);
            } else {
                this.dhtRows.inverse(t, 0L, scale);
                this.dhtRows.inverse(t, this.rowsl, scale);
            }
            for (r = 0L; r < this.rowsl; ++r) {
                idx1 = r * this.columnsl;
                a2.setFloat(idx1, t.getFloat(r));
                a2.setFloat(idx1 + 1L, t.getFloat(this.rowsl + r));
            }
        }
    }

    private void ddxt2d_sub(int isgn, float[][] a2, boolean scale) {
        block16: {
            int r;
            float[] t;
            block15: {
                int nt = 4 * this.rows;
                if (this.columns == 2) {
                    nt >>= 1;
                } else if (this.columns < 2) {
                    nt >>= 2;
                }
                t = new float[nt];
                if (this.columns <= 2) break block15;
                if (isgn == -1) {
                    for (int c2 = 0; c2 < this.columns; c2 += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            t[r2] = a2[r2][c2];
                            t[idx2] = a2[r2][c2 + 1];
                            t[idx2 + this.rows] = a2[r2][c2 + 2];
                            t[idx2 + 2 * this.rows] = a2[r2][c2 + 3];
                        }
                        this.dhtRows.forward(t, 0);
                        this.dhtRows.forward(t, this.rows);
                        this.dhtRows.forward(t, 2 * this.rows);
                        this.dhtRows.forward(t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a2[r2][c2] = t[r2];
                            a2[r2][c2 + 1] = t[idx2];
                            a2[r2][c2 + 2] = t[idx2 + this.rows];
                            a2[r2][c2 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c3 = 0; c3 < this.columns; c3 += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            t[r3] = a2[r3][c3];
                            t[idx2] = a2[r3][c3 + 1];
                            t[idx2 + this.rows] = a2[r3][c3 + 2];
                            t[idx2 + 2 * this.rows] = a2[r3][c3 + 3];
                        }
                        this.dhtRows.inverse(t, 0, scale);
                        this.dhtRows.inverse(t, this.rows, scale);
                        this.dhtRows.inverse(t, 2 * this.rows, scale);
                        this.dhtRows.inverse(t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a2[r3][c3] = t[r3];
                            a2[r3][c3 + 1] = t[idx2];
                            a2[r3][c3 + 2] = t[idx2 + this.rows];
                            a2[r3][c3 + 3] = t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block16;
            }
            if (this.columns != 2) break block16;
            for (r = 0; r < this.rows; ++r) {
                t[r] = a2[r][0];
                t[this.rows + r] = a2[r][1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(t, 0);
                this.dhtRows.forward(t, this.rows);
            } else {
                this.dhtRows.inverse(t, 0, scale);
                this.dhtRows.inverse(t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                a2[r][0] = t[r];
                a2[r][1] = t[this.rows + r];
            }
        }
    }

    private void yTransform(float[] a2) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            int idx1 = r * this.columns;
            int idx2 = mRow * this.columns;
            for (int c2 = 0; c2 <= this.columns / 2; ++c2) {
                int mCol = (this.columns - c2) % this.columns;
                float A = a2[idx1 + c2];
                float B = a2[idx2 + c2];
                float C = a2[idx1 + mCol];
                float D = a2[idx2 + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                a2[idx1 + c2] = A - E;
                a2[idx2 + c2] = B + E;
                a2[idx1 + mCol] = C + E;
                a2[idx2 + mCol] = D - E;
            }
        }
    }

    private void yTransform(FloatLargeArray a2) {
        for (long r = 0L; r <= this.rowsl / 2L; ++r) {
            long mRow = (this.rowsl - r) % this.rowsl;
            long idx1 = r * this.columnsl;
            long idx2 = mRow * this.columnsl;
            for (long c2 = 0L; c2 <= this.columnsl / 2L; ++c2) {
                long mCol = (this.columnsl - c2) % this.columnsl;
                float A = a2.getFloat(idx1 + c2);
                float B = a2.getFloat(idx2 + c2);
                float C = a2.getFloat(idx1 + mCol);
                float D = a2.getFloat(idx2 + mCol);
                float E = (A + D - (B + C)) / 2.0f;
                a2.setFloat(idx1 + c2, A - E);
                a2.setFloat(idx2 + c2, B + E);
                a2.setFloat(idx1 + mCol, C + E);
                a2.setFloat(idx2 + mCol, D - E);
            }
        }
    }

    private void yTransform(float[][] a2) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            for (int c2 = 0; c2 <= this.columns / 2; ++c2) {
                int mCol = (this.columns - c2) % this.columns;
                float A = a2[r][c2];
                float B = a2[mRow][c2];
                float C = a2[r][mCol];
                float D = a2[mRow][mCol];
                float E = (A + D - (B + C)) / 2.0f;
                a2[r][c2] = A - E;
                a2[mRow][c2] = B + E;
                a2[r][mCol] = C + E;
                a2[mRow][mCol] = D - E;
            }
        }
    }
}

