/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.MemoryCounter;
import sun.misc.Cleaner;

public class FloatLargeArray
extends LargeArray {
    private static final long serialVersionUID = -8342458159338079576L;
    private float[] data;

    public FloatLargeArray(long length) {
        this(length, true);
    }

    public FloatLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.FLOAT;
        this.sizeof = 4L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        if (length > (long)FloatLargeArray.getMaxSizeOf32bitArray()) {
            this.ptr = LargeArrayUtils.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (zeroNativeMemory) {
                this.zeroNativeMemory(length);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new float[(int)length];
        }
    }

    public FloatLargeArray(long length, float constantValue) {
        this.type = LargeArrayType.FLOAT;
        this.sizeof = 4L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.isConstant = true;
        this.data = new float[]{constantValue};
    }

    public FloatLargeArray(float[] data) {
        this.type = LargeArrayType.FLOAT;
        this.sizeof = 4L;
        this.length = data.length;
        this.data = data;
    }

    @Override
    public FloatLargeArray clone() {
        if (this.isConstant) {
            return new FloatLargeArray(this.length, this.getFloat(0L));
        }
        FloatLargeArray v = new FloatLargeArray(this.length, false);
        LargeArrayUtils.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o2) {
        if (super.equals(o2)) {
            FloatLargeArray la = (FloatLargeArray)o2;
            return this.data == la.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 29 * super.hashCode() + (this.data != null ? this.data.hashCode() : 0);
    }

    @Override
    public final Float get(long i2) {
        return Float.valueOf(this.getFloat(i2));
    }

    @Override
    public final Float getFromNative(long i2) {
        return Float.valueOf(LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2));
    }

    @Override
    public final boolean getBoolean(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2) != 0.0f;
        }
        if (this.isConstant) {
            return this.data[0] != 0.0f;
        }
        return this.data[(int)i2] != 0.0f;
    }

    @Override
    public final byte getByte(long i2) {
        if (this.ptr != 0L) {
            return (byte)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
        }
        if (this.isConstant) {
            return (byte)this.data[0];
        }
        return (byte)this.data[(int)i2];
    }

    @Override
    public final short getUnsignedByte(long i2) {
        if (this.ptr != 0L) {
            return (short)(0xFF & (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2));
        }
        if (this.isConstant) {
            return (short)(0xFF & (int)this.data[0]);
        }
        return (short)(0xFF & (int)this.data[(int)i2]);
    }

    @Override
    public final short getShort(long i2) {
        if (this.ptr != 0L) {
            return (short)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
        }
        if (this.isConstant) {
            return (short)this.data[0];
        }
        return (short)this.data[(int)i2];
    }

    @Override
    public final int getInt(long i2) {
        if (this.ptr != 0L) {
            return (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
        }
        if (this.isConstant) {
            return (int)this.data[0];
        }
        return (int)this.data[(int)i2];
    }

    @Override
    public final long getLong(long i2) {
        if (this.ptr != 0L) {
            return (long)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
        }
        if (this.isConstant) {
            return (long)this.data[0];
        }
        return (long)this.data[(int)i2];
    }

    @Override
    public final float getFloat(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    @Override
    public final double getDouble(long i2) {
        if (this.ptr != 0L) {
            return LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
        }
        if (this.isConstant) {
            return this.data[0];
        }
        return this.data[(int)i2];
    }

    public final float[] getData() {
        return this.data;
    }

    @Override
    public final boolean[] getBooleanData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        boolean[] out = new boolean[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                float v = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * (long)i2);
                out[i2] = v != 0.0f;
                ++i2;
            }
        } else if (this.isConstant) {
            boolean elem = this.data[0] != 0.0f;
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4] != 0.0f;
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final boolean[] getBooleanData(boolean[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        boolean[] out = a2 != null && (long)a2.length >= len2 ? a2 : new boolean[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                float v = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
                out[idx++] = v != 0.0f;
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0] != 0.0f;
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                float v = this.data[(int)i4];
                out[idx++] = v != 0.0f;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        byte[] out = new byte[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = (byte)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = (byte)elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = (byte)this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final byte[] getByteData(byte[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        byte[] out = a2 != null && (long)a2.length >= len2 ? a2 : new byte[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = (byte)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = (byte)this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = (byte)this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        short[] out = new short[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = (short)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = (short)elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = (short)this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final short[] getShortData(short[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        short[] out = a2 != null && (long)a2.length >= len2 ? a2 : new short[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = (short)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = (short)this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = (short)this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        int[] out = new int[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = (int)elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = (int)this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final int[] getIntData(int[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        int[] out = a2 != null && (long)a2.length >= len2 ? a2 : new int[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = (int)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = (int)this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = (int)this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        long[] out = new long[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = (long)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = (long)elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = (long)this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final long[] getLongData(long[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        long[] out = a2 != null && (long)a2.length >= len2 ? a2 : new long[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = (long)LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = (long)this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = (long)this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final float[] getFloatData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        float[] out = new float[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            float elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            System.arraycopy(this.data, 0, out, 0, (int)this.length);
        }
        return out;
    }

    @Override
    public final float[] getFloatData(float[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        float[] out = a2 != null && (long)a2.length >= len2 ? a2 : new float[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData() {
        if (this.length > 0x40000000L) {
            return null;
        }
        double[] out = new double[(int)this.length];
        if (this.ptr != 0L) {
            int i2 = 0;
            while ((long)i2 < this.length) {
                out[i2] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * (long)i2);
                ++i2;
            }
        } else if (this.isConstant) {
            double elem = this.data[0];
            int i3 = 0;
            while ((long)i3 < this.length) {
                out[i3] = elem;
                ++i3;
            }
        } else {
            int i4 = 0;
            while ((long)i4 < this.length) {
                out[i4] = this.data[i4];
                ++i4;
            }
        }
        return out;
    }

    @Override
    public final double[] getDoubleData(double[] a2, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len2 = (long)FastMath.ceil((double)(endPos - startPos) / (double)step);
        if (len2 > 0x40000000L) {
            return null;
        }
        double[] out = a2 != null && (long)a2.length >= len2 ? a2 : new double[(int)len2];
        int idx = 0;
        if (this.ptr != 0L) {
            for (long i2 = startPos; i2 < endPos; i2 += step) {
                out[idx++] = LargeArrayUtils.UNSAFE.getFloat(this.ptr + this.sizeof * i2);
            }
        } else if (this.isConstant) {
            for (long i3 = startPos; i3 < endPos; i3 += step) {
                out[idx++] = this.data[0];
            }
        } else {
            for (long i4 = startPos; i4 < endPos; i4 += step) {
                out[idx++] = this.data[(int)i4];
            }
        }
        return out;
    }

    @Override
    public final void setToNative(long i2, Object value) {
        LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, ((Float)value).floatValue());
    }

    @Override
    public final void setBoolean(long i2, boolean value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, value ? 1.0f : 0.0f);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value ? 1.0f : 0.0f;
        }
    }

    @Override
    public final void setByte(long i2, byte value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value;
        }
    }

    @Override
    public final void setUnsignedByte(long i2, short value) {
        this.setShort(i2, value);
    }

    @Override
    public final void setShort(long i2, short value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value;
        }
    }

    @Override
    public final void setInt(long i2, int value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value;
        }
    }

    @Override
    public final void setLong(long i2, long value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value;
        }
    }

    @Override
    public final void setFloat(long i2, float value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = value;
        }
    }

    @Override
    public final void setDouble(long i2, double value) {
        if (this.ptr != 0L) {
            LargeArrayUtils.UNSAFE.putFloat(this.ptr + this.sizeof * i2, (float)value);
        } else {
            if (this.isConstant) {
                throw new IllegalAccessError("Constant arrays cannot be modified.");
            }
            this.data[(int)i2] = (float)value;
        }
    }
}

