/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.ModuleSerializationProxy;

public final class BigDecimal$
implements Serializable {
    public static final BigDecimal$ MODULE$ = new BigDecimal$();
    private static BigDecimal[] cache;
    private static final int minCached;
    private static final int maxCached;
    private static final MathContext defaultMathContext;
    private static volatile boolean bitmap$0;

    static {
        minCached = -512;
        maxCached = 512;
        defaultMathContext = MathContext.DECIMAL128;
    }

    private final int maximumHashScale() {
        return 4934;
    }

    private final int hashCodeNotComputed() {
        return 1565550863;
    }

    private final double deci2binary() {
        return 3.3219280948873626;
    }

    public MathContext defaultMathContext() {
        return defaultMathContext;
    }

    private BigDecimal[] cache$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                cache = new BigDecimal[maxCached - minCached + 1];
                bitmap$0 = true;
            }
        }
        return cache;
    }

    private BigDecimal[] cache() {
        if (!bitmap$0) {
            return this.cache$lzycompute();
        }
        return cache;
    }

    public BigDecimal decimal(double d2, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(Double.toString(d2), mc), mc);
    }

    public BigDecimal decimal(double d2) {
        return this.decimal(d2, this.defaultMathContext());
    }

    public BigDecimal decimal(float f2, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(Float.toString(f2), mc), mc);
    }

    public BigDecimal decimal(float f2) {
        return this.decimal(f2, this.defaultMathContext());
    }

    public BigDecimal decimal(long l2, MathContext mc) {
        return this.apply(l2, mc);
    }

    public BigDecimal decimal(long l2) {
        return this.apply(l2);
    }

    public BigDecimal decimal(java.math.BigDecimal bd, MathContext mc) {
        return new BigDecimal(bd.round(mc), mc);
    }

    public BigDecimal binary(double d2, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(d2, mc), mc);
    }

    public BigDecimal binary(double d2) {
        return this.binary(d2, this.defaultMathContext());
    }

    public BigDecimal exact(java.math.BigDecimal repr) {
        MathContext mc = repr.precision() <= this.defaultMathContext().getPrecision() ? this.defaultMathContext() : new MathContext(repr.precision(), RoundingMode.HALF_EVEN);
        return new BigDecimal(repr, mc);
    }

    public BigDecimal exact(double d2) {
        return this.exact(new java.math.BigDecimal(d2));
    }

    public BigDecimal exact(BigInt bi) {
        return this.exact(new java.math.BigDecimal(bi.bigInteger()));
    }

    public BigDecimal exact(long l2) {
        return this.apply(l2);
    }

    public BigDecimal exact(String s) {
        return this.exact(new java.math.BigDecimal(s));
    }

    public BigDecimal exact(char[] cs) {
        return this.exact(new java.math.BigDecimal(cs));
    }

    public BigDecimal valueOf(double d2) {
        return this.apply(java.math.BigDecimal.valueOf(d2));
    }

    public BigDecimal valueOf(long x) {
        return this.apply(x);
    }

    public BigDecimal apply(int i2) {
        return this.apply(i2, this.defaultMathContext());
    }

    public BigDecimal apply(int i2, MathContext mc) {
        MathContext mathContext = mc;
        MathContext mathContext2 = this.defaultMathContext();
        if (!(mathContext != null ? !((Object)mathContext).equals(mathContext2) : mathContext2 != null)) {
            if (minCached <= i2 && i2 <= maxCached) {
                int offset = i2 - minCached;
                BigDecimal n2 = this.cache()[offset];
                if (n2 == null) {
                    this.cache()[offset] = n2 = new BigDecimal(java.math.BigDecimal.valueOf(i2), mc);
                }
                return n2;
            }
        }
        return this.apply((long)i2, mc);
    }

    public BigDecimal apply(long l2) {
        if ((long)minCached <= l2 && l2 <= (long)maxCached) {
            return this.apply((int)l2);
        }
        return new BigDecimal(java.math.BigDecimal.valueOf(l2), this.defaultMathContext());
    }

    public BigDecimal apply(long l2, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(l2, mc), mc);
    }

    public BigDecimal apply(long unscaledVal, int scale) {
        return this.apply(BigInt$.MODULE$.apply(unscaledVal), scale);
    }

    public BigDecimal apply(long unscaledVal, int scale, MathContext mc) {
        return this.apply(BigInt$.MODULE$.apply(unscaledVal), scale, mc);
    }

    public BigDecimal apply(double d2) {
        return this.decimal(d2, this.defaultMathContext());
    }

    public BigDecimal apply(double d2, MathContext mc) {
        return this.decimal(d2, mc);
    }

    public BigDecimal apply(char[] x) {
        return this.exact(x);
    }

    public BigDecimal apply(char[] x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x, mc), mc);
    }

    public BigDecimal apply(String x) {
        return this.exact(x);
    }

    public BigDecimal apply(String x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x, mc), mc);
    }

    public BigDecimal apply(BigInt x) {
        return this.exact(x);
    }

    public BigDecimal apply(BigInt x, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(x.bigInteger(), mc), mc);
    }

    public BigDecimal apply(BigInt unscaledVal, int scale) {
        return this.exact(new java.math.BigDecimal(unscaledVal.bigInteger(), scale));
    }

    public BigDecimal apply(BigInt unscaledVal, int scale, MathContext mc) {
        return new BigDecimal(new java.math.BigDecimal(unscaledVal.bigInteger(), scale, mc), mc);
    }

    public BigDecimal apply(java.math.BigDecimal bd) {
        return new BigDecimal(bd, this.defaultMathContext());
    }

    public BigDecimal int2bigDecimal(int i2) {
        return this.apply(i2);
    }

    public BigDecimal long2bigDecimal(long l2) {
        return this.apply(l2);
    }

    public BigDecimal double2bigDecimal(double d2) {
        return this.decimal(d2);
    }

    public BigDecimal javaBigDecimal2bigDecimal(java.math.BigDecimal x) {
        if (x == null) {
            return null;
        }
        return this.apply(x);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BigDecimal$.class);
    }

    private BigDecimal$() {
    }
}

