/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.machine.luac;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.IdentityHashMap;
import li.cil.repack.com.naef.jnlua.LuaGcMetamethodException;
import li.cil.repack.com.naef.jnlua.LuaMemoryAllocationException;
import li.cil.repack.com.naef.jnlua.LuaRuntimeException;
import li.cil.repack.com.naef.jnlua.LuaState;
import li.cil.repack.com.naef.jnlua.LuaType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.mutable.Stack;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import totoro.ocelot.brain.Ocelot$;
import totoro.ocelot.brain.Settings$;
import totoro.ocelot.brain.entity.machine.Architecture;
import totoro.ocelot.brain.entity.machine.ExecutionResult;
import totoro.ocelot.brain.entity.machine.ExtendedLuaState;
import totoro.ocelot.brain.entity.machine.ExtendedLuaState$;
import totoro.ocelot.brain.entity.machine.LimitReachedException;
import totoro.ocelot.brain.entity.machine.Machine;
import totoro.ocelot.brain.entity.machine.MachineAPI;
import totoro.ocelot.brain.entity.machine.MachineAPI$State$;
import totoro.ocelot.brain.entity.machine.luac.ComponentAPI;
import totoro.ocelot.brain.entity.machine.luac.ComputerAPI;
import totoro.ocelot.brain.entity.machine.luac.LuaStateFactory;
import totoro.ocelot.brain.entity.machine.luac.NativeLuaAPI;
import totoro.ocelot.brain.entity.machine.luac.OSAPI;
import totoro.ocelot.brain.entity.machine.luac.PersistenceAPI;
import totoro.ocelot.brain.entity.machine.luac.SystemAPI;
import totoro.ocelot.brain.entity.machine.luac.UnicodeAPI;
import totoro.ocelot.brain.entity.machine.luac.UserdataAPI;
import totoro.ocelot.brain.entity.traits.Entity;
import totoro.ocelot.brain.entity.traits.Memory;
import totoro.ocelot.brain.nbt.NBTTagCompound;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h!\u0002\u0012$\u0003\u0003\u0001\u0004\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011A\u001e\t\u0011}\u0002!\u0011!Q\u0001\nqBQ\u0001\u0011\u0001\u0005\u0002\u0005CQ!\u0012\u0001\u0007\u0012\u0019C!B\u0013\u0001A\u0002\u0003\u0007I\u0011A\u0013L\u0011)a\u0006\u00011AA\u0002\u0013\u0005Q%\u0018\u0005\nG\u0002\u0001\r\u0011!Q!\n1C\u0001\u0002\u001a\u0001A\u0002\u0013\u0005Q%\u001a\u0005\tS\u0002\u0001\r\u0011\"\u0001&U\"1A\u000e\u0001Q!\n\u0019D\u0001\"\u001c\u0001A\u0002\u0013\u0005QE\u001c\u0005\te\u0002\u0001\r\u0011\"\u0001&g\"1Q\u000f\u0001Q!\n=DqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004|\u0001\u0001\u0006I\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\tI\u0001\u0001Q\u0001\nyD\u0001\"a\u0003\u0001\t\u0003)\u0013Q\u0002\u0005\t\u00037\u0001A\u0011A\u0013\u0002\u001e!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003S\u0002A\u0011BA6\u0011\u0019\ty\u0007\u0001C!K\"1\u0011\u0011\u000f\u0001\u0005B\u0015Dq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002v!9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAF\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u001b\u0003A\u0011IA;\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!!4\u0001\t\u0003\ny\rC\u0004\u0002`\u0002!\t%!9\u0003+9\u000bG/\u001b<f\u0019V\f\u0017I]2iSR,7\r^;sK*\u0011A%J\u0001\u0005YV\f7M\u0003\u0002'O\u00059Q.Y2iS:,'B\u0001\u0015*\u0003\u0019)g\u000e^5us*\u0011!fK\u0001\u0006EJ\f\u0017N\u001c\u0006\u0003Y5\naa\\2fY>$(\"\u0001\u0018\u0002\rQ|Go\u001c:p\u0007\u0001\u00192\u0001A\u00198!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fMB\u0011\u0001(O\u0007\u0002K%\u0011!(\n\u0002\r\u0003J\u001c\u0007.\u001b;fGR,(/Z\u000b\u0002yA\u0011\u0001(P\u0005\u0003}\u0015\u0012q!T1dQ&tW-\u0001\u0005nC\u000eD\u0017N\\3!\u0003\u0019a\u0014N\\5u}Q\u0011!\t\u0012\t\u0003\u0007\u0002i\u0011a\t\u0005\u0006M\r\u0001\r\u0001P\u0001\bM\u0006\u001cGo\u001c:z+\u00059\u0005CA\"I\u0013\tI5EA\bMk\u0006\u001cF/\u0019;f\r\u0006\u001cGo\u001c:z\u0003\raW/Y\u000b\u0002\u0019B\u0011QJW\u0007\u0002\u001d*\u0011q\nU\u0001\u0006U:dW/\u0019\u0006\u0003#J\u000bAA\\1fM*\u00111\u000bV\u0001\u0004G>l'BA+W\u0003\u0019\u0011X\r]1dW*\u0011q\u000bW\u0001\u0004G&d'\"A-\u0002\u00051L\u0017BA.O\u0005!aU/Y*uCR,\u0017a\u00027vC~#S-\u001d\u000b\u0003=\u0006\u0004\"AM0\n\u0005\u0001\u001c$\u0001B+oSRDqA\u0019\u0004\u0002\u0002\u0003\u0007A*A\u0002yIE\nA\u0001\\;bA\u0005a1.\u001a:oK2lU-\\8ssV\ta\r\u0005\u00023O&\u0011\u0001n\r\u0002\u0004\u0013:$\u0018\u0001E6fe:,G.T3n_JLx\fJ3r)\tq6\u000eC\u0004c\u0013\u0005\u0005\t\u0019\u00014\u0002\u001b-,'O\\3m\u001b\u0016lwN]=!\u0003!\u0011\u0018-\\*dC2,W#A8\u0011\u0005I\u0002\u0018BA94\u0005\u0019!u.\u001e2mK\u0006a!/Y7TG\u0006dWm\u0018\u0013fcR\u0011a\f\u001e\u0005\bE2\t\t\u00111\u0001p\u0003%\u0011\u0018-\\*dC2,\u0007%A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,W#\u0001=\u0011\u0005\rK\u0018B\u0001>$\u00059\u0001VM]:jgR,gnY3B!&\u000bA\u0002]3sg&\u001cH/\u001a8dK\u0002\nA!\u00199jgV\ta\u0010\u0005\u00033\u007f\u0006\r\u0011bAA\u0001g\t)\u0011I\u001d:bsB\u00191)!\u0002\n\u0007\u0005\u001d1E\u0001\u0007OCRLg/\u001a'vC\u0006\u0003\u0016*A\u0003ba&\u001c\b%\u0001\u0004j]Z|7.\u001a\u000b\u0004M\u0006=\u0001bBA\t%\u0001\u0007\u00111C\u0001\u0002MB)!'!\u0006\u0002\u001a%\u0019\u0011qC\u001a\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u0001\u001a\u0000c\u0005iAm\\2v[\u0016tG/\u0019;j_:$2AZA\u0010\u0011\u001d\t\tb\u0005a\u0001\u0003C\u0001RAMA\u000b\u0003G\u0001B!!\n\u000249!\u0011qEA\u0018!\r\tIcM\u0007\u0003\u0003WQ1!!\f0\u0003\u0019a$o\\8u}%\u0019\u0011\u0011G\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\rM#(/\u001b8h\u0015\r\t\tdM\u0001\u000eSNLe.\u001b;jC2L'0\u001a3\u0016\u0005\u0005u\u0002c\u0001\u001a\u0002@%\u0019\u0011\u0011I\u001a\u0003\u000f\t{w\u000e\\3b]\u0006y!/Z2p[B,H/Z'f[>\u0014\u0018\u0010\u0006\u0003\u0002>\u0005\u001d\u0003bBA%+\u0001\u0007\u00111J\u0001\u000bG>l\u0007o\u001c8f]R\u001c\bCBA'\u0003/\niF\u0004\u0003\u0002P\u0005Mc\u0002BA\u0015\u0003#J\u0011\u0001N\u0005\u0004\u0003+\u001a\u0014a\u00029bG.\fw-Z\u0005\u0005\u00033\nYF\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\t)f\r\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111M\u0014\u0002\rQ\u0014\u0018-\u001b;t\u0013\u0011\t9'!\u0019\u0003\r\u0015sG/\u001b;z\u00035iW-\\8ss&s')\u001f;fgR\u0019a-!\u001c\t\u000f\u0005%c\u00031\u0001\u0002L\u0005QaM]3f\u001b\u0016lwN]=\u0002\u0017Q|G/\u00197NK6|'/_\u0001\u0010eVt7+\u001f8dQJ|g.\u001b>fIR\ta,A\u0006sk:$\u0006N]3bI\u0016$G\u0003BA>\u0003\u0003\u00032\u0001OA?\u0013\r\ty(\n\u0002\u0010\u000bb,7-\u001e;j_:\u0014Vm];mi\"9\u00111\u0011\u000eA\u0002\u0005u\u0012\u0001F5t'ft7\r\u001b:p]&TX\r\u001a*fiV\u0014h.\u0001\u0005p]NKwM\\1m\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0003\u0003{\t\u0011b\u001c8D_:tWm\u0019;\u0002\u000b\rdwn]3\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005M\u0005CBAK\u0003?\u000b\u0019+\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\u001diW\u000f^1cY\u0016T1!!(4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003C\u000b9JA\u0003Ti\u0006\u001c7\u000e\u0005\u0003\u0002&\u0006Mf\u0002BAT\u0003[s1\u0001OAU\u0013\r\tY+J\u0001\u000b\u001b\u0006\u001c\u0007.\u001b8f\u0003BK\u0015\u0002BAX\u0003c\u000bQa\u0015;bi\u0016T1!a+&\u0013\u0011\t),a.\u0003\u000bY\u000bG.^3\n\u0007\u0005e6GA\u0006F]VlWM]1uS>t\u0007fA\u0010\u0002>B!\u0011qXAe\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u0015\u0017\u0001\u00027b]\u001eT!!a2\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\f\tM\u0001\u0006EKB\u0014XmY1uK\u0012\fA\u0001\\8bIR\u0019a,!5\t\u000f\u0005M\u0007\u00051\u0001\u0002V\u0006\u0019aN\u0019;\u0011\t\u0005]\u00171\\\u0007\u0003\u00033T1!a5*\u0013\u0011\ti.!7\u0003\u001d9\u0013E\u000bV1h\u0007>l\u0007o\\;oI\u0006!1/\u0019<f)\rq\u00161\u001d\u0005\b\u0003'\f\u0003\u0019AAk\u0001")
public abstract class NativeLuaArchitecture
implements Architecture {
    private final Machine machine;
    private LuaState lua;
    private int kernelMemory;
    private double ramScale;
    private final PersistenceAPI persistence;
    private final NativeLuaAPI[] apis;

    public Machine machine() {
        return this.machine;
    }

    public abstract LuaStateFactory factory();

    public LuaState lua() {
        return this.lua;
    }

    public void lua_$eq(LuaState x$1) {
        this.lua = x$1;
    }

    public int kernelMemory() {
        return this.kernelMemory;
    }

    public void kernelMemory_$eq(int x$1) {
        this.kernelMemory = x$1;
    }

    public double ramScale() {
        return this.ramScale;
    }

    public void ramScale_$eq(double x$1) {
        this.ramScale = x$1;
    }

    private PersistenceAPI persistence() {
        return this.persistence;
    }

    private NativeLuaAPI[] apis() {
        return this.apis;
    }

    public int invoke(Function0<Object[]> f2) {
        int n2;
        try {
            Object[] objectArray = f2.apply();
            if (objectArray != null) {
                Object[] objectArray2 = objectArray;
                this.lua().pushBoolean(true);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectArray2), (Function1<Object, Object> & Serializable)result2 -> {
                    NativeLuaArchitecture.$anonfun$invoke$1(this, result2);
                    return BoxedUnit.UNIT;
                });
                n2 = 1 + objectArray2.length;
            } else {
                this.lua().pushBoolean(true);
                n2 = 1;
            }
        }
        catch (Throwable e2) {
            Throwable throwable;
            if (Settings$.MODULE$.get().logLuaCallbackErrors() && !(e2 instanceof LimitReachedException)) {
                Ocelot$.MODULE$.log().warn("Exception in Lua callback.", e2);
            }
            boolean bl = false;
            IllegalArgumentException illegalArgumentException = null;
            Throwable throwable2 = e2;
            if (throwable2 instanceof LimitReachedException) {
                n2 = 0;
            }
            if (throwable2 instanceof IllegalArgumentException) {
                bl = true;
                illegalArgumentException = (IllegalArgumentException)throwable2;
                if (illegalArgumentException.getMessage() != null) {
                    this.lua().pushBoolean(false);
                    this.lua().pushString(illegalArgumentException.getMessage());
                    n2 = 2;
                }
            }
            if (throwable2 != null && (throwable = throwable2).getMessage() != null) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString(throwable.getMessage());
                if (Settings$.MODULE$.get().logLuaCallbackErrors()) {
                    this.lua().pushString(Predef$.MODULE$.wrapRefArray((Object[])throwable.getStackTrace()).mkString("", "\n", "\n"));
                    n2 = 4;
                } else {
                    n2 = 3;
                }
            }
            if (throwable2 instanceof IndexOutOfBoundsException) {
                this.lua().pushBoolean(false);
                this.lua().pushString("index out of bounds");
                n2 = 2;
            }
            if (bl) {
                this.lua().pushBoolean(false);
                this.lua().pushString("bad argument");
                n2 = 2;
            }
            if (throwable2 instanceof NoSuchMethodException) {
                this.lua().pushBoolean(false);
                this.lua().pushString("no such method");
                n2 = 2;
            }
            if (throwable2 instanceof FileNotFoundException) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString("file not found");
                n2 = 3;
            }
            if (throwable2 instanceof SecurityException) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString("access denied");
                n2 = 3;
            }
            if (throwable2 instanceof IOException) {
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString("i/o error");
                n2 = 3;
            }
            if (throwable2 instanceof UnsupportedOperationException) {
                this.lua().pushBoolean(false);
                this.lua().pushString("unsupported operation");
                n2 = 2;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                Ocelot$.MODULE$.log().warn("Unexpected error in Lua callback.", throwable3);
                this.lua().pushBoolean(true);
                this.lua().pushNil();
                this.lua().pushString("unknown error");
                n2 = 3;
            }
            throw new MatchError((Object)throwable2);
        }
        return n2;
    }

    public int documentation(Function0<String> f2) {
        int n2;
        try {
            String doc = f2.apply();
            if (Strings.isNullOrEmpty(doc)) {
                this.lua().pushNil();
            } else {
                this.lua().pushString(doc);
            }
            n2 = 1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.lua().pushNil();
            this.lua().pushString("no such method");
            n2 = 2;
        }
        catch (Throwable t) {
            this.lua().pushNil();
            this.lua().pushString(t.getMessage() != null ? t.getMessage() : t.toString());
            n2 = 2;
        }
        return n2;
    }

    @Override
    public boolean isInitialized() {
        return this.kernelMemory() > 0;
    }

    @Override
    public boolean recomputeMemory(Iterable<Entity> components) {
        int memoryBytes;
        block2: {
            memoryBytes = this.memoryInBytes(components);
            Option<LuaState> option = Option$.MODULE$.apply(this.lua());
            if (!(option instanceof Some)) break block2;
            Some some = (Some)option;
            LuaState l2 = (LuaState)some.value();
            if (Settings$.MODULE$.get().limitMemory()) {
                l2.setTotalMemory(Integer.MAX_VALUE);
                if (this.kernelMemory() > 0) {
                    l2.setTotalMemory(this.kernelMemory() + (int)package$.MODULE$.ceil((double)memoryBytes * this.ramScale()));
                }
            }
        }
        return memoryBytes > 0;
    }

    private int memoryInBytes(Iterable<Entity> components) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)BoxesRunTime.unboxToDouble(components.foldLeft(BoxesRunTime.boxToDouble(0.0), (Function2<Object, Entity, Object> & Serializable)(acc, entity) -> BoxesRunTime.boxToDouble(NativeLuaArchitecture.$anonfun$memoryInBytes$1(BoxesRunTime.unboxToDouble(acc), entity))))), 0)), Settings$.MODULE$.get().maxTotalRam());
    }

    @Override
    public int freeMemory() {
        return (int)((double)RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.lua().getFreeMemory()), this.lua().getTotalMemory() - this.kernelMemory()) / this.ramScale());
    }

    @Override
    public int totalMemory() {
        return (int)((double)(this.lua().getTotalMemory() - this.kernelMemory()) / this.ramScale());
    }

    @Override
    public void runSynchronized() {
        Predef$.MODULE$.assert(this.lua().getTop() == 2);
        Predef$.MODULE$.assert(this.lua().isThread(1));
        Predef$.MODULE$.assert(this.lua().isFunction(2));
        try {
            this.lua().call(0, 1);
            this.lua().checkType(2, LuaType.TABLE);
        }
        catch (LuaMemoryAllocationException luaMemoryAllocationException) {
            throw new OutOfMemoryError("not enough memory");
        }
    }

    @Override
    public ExecutionResult runThreaded(boolean isSynchronizedReturn) {
        ExecutionResult executionResult;
        try {
            int results;
            int n2;
            Predef$.MODULE$.assert(this.lua().isThread(1));
            if (isSynchronizedReturn) {
                Predef$.MODULE$.assert(this.lua().getTop() == 2);
                Predef$.MODULE$.assert(this.lua().isTable(2));
                n2 = this.lua().resume(1, 1);
            } else if (this.kernelMemory() == 0) {
                if (this.lua().resume(1, 0) > 0) {
                    n2 = 0;
                } else {
                    this.lua().gc(LuaState.GcAction.COLLECT, 0);
                    this.kernelMemory_$eq(package$.MODULE$.max(this.lua().getTotalMemory() - this.lua().getFreeMemory(), 1));
                    this.recomputeMemory(this.machine().host().inventory().entities());
                    this.lua().pushInteger(0L);
                    n2 = 1;
                }
            } else {
                MachineAPI.Signal signal = this.machine().popSignal();
                if (signal != null) {
                    this.lua().pushString(signal.name());
                    ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(signal.args()), (Function1<Object, Object> & Serializable)arg -> {
                        NativeLuaArchitecture.$anonfun$runThreaded$1(this, arg);
                        return BoxedUnit.UNIT;
                    });
                    n2 = this.lua().resume(1, 1 + signal.args().length);
                } else {
                    n2 = results = this.lua().resume(1, 0);
                }
            }
            if (this.lua().status(1) == 1) {
                if (results == 1 && this.lua().isFunction(2)) {
                    executionResult = new ExecutionResult.SynchronizedCall();
                } else if (results == 1 && this.lua().isBoolean(2)) {
                    executionResult = new ExecutionResult.Shutdown(this.lua().toBoolean(2));
                } else {
                    int ticks = results == 1 && this.lua().isNumber(2) ? (int)(this.lua().toNumber(2) * (double)20) : Integer.MAX_VALUE;
                    this.lua().pop(results);
                    executionResult = new ExecutionResult.Sleep(ticks);
                }
            } else {
                Predef$.MODULE$.assert(this.lua().isThread(1));
                if (!this.lua().isBoolean(2) || !this.lua().isString(3) && !this.lua().isNoneOrNil(3)) {
                    Ocelot$.MODULE$.log().warn("Kernel returned unexpected results.");
                }
                if (this.lua().toBoolean(2)) {
                    Ocelot$.MODULE$.log().warn("Kernel stopped unexpectedly.");
                    executionResult = new ExecutionResult.Shutdown(false);
                } else {
                    String error2;
                    if (Settings$.MODULE$.get().limitMemory()) {
                        this.lua().setTotalMemory(Integer.MAX_VALUE);
                    }
                    String string = error2 = this.lua().isJavaObjectRaw(3) ? this.lua().toJavaObjectRaw(3).toString() : this.lua().toString(3);
                    executionResult = error2 != null ? new ExecutionResult.Error(error2) : new ExecutionResult.Error("unknown error");
                }
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof LuaRuntimeException) {
                LuaRuntimeException luaRuntimeException = (LuaRuntimeException)throwable2;
                Ocelot$.MODULE$.log().warn(new StringBuilder(35).append("Kernel crashed. This is a bug!\n").append(luaRuntimeException.toString()).append("\tat ").append(Predef$.MODULE$.wrapRefArray((Object[])luaRuntimeException.getLuaStackTrace()).mkString("\n\tat ")).toString());
                executionResult = new ExecutionResult.Error("kernel panic: this is a bug, check your log file and report it");
            }
            if (throwable2 instanceof LuaGcMetamethodException) {
                LuaGcMetamethodException luaGcMetamethodException = (LuaGcMetamethodException)throwable2;
                executionResult = luaGcMetamethodException.getMessage() != null ? new ExecutionResult.Error(new StringBuilder(14).append("kernel panic:\n").append(luaGcMetamethodException.getMessage()).toString()) : new ExecutionResult.Error("kernel panic:\nerror in garbage collection metamethod");
            }
            if (throwable2 instanceof LuaMemoryAllocationException) {
                executionResult = new ExecutionResult.Error("not enough memory");
            }
            if (throwable2 instanceof Error) {
                Error error3 = (Error)throwable2;
                String string = error3.getMessage();
                String string2 = "not enough memory";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    executionResult = new ExecutionResult.Error("not enough memory");
                }
            }
            throw throwable;
        }
        return executionResult;
    }

    @Override
    public void onSignal() {
    }

    @Override
    public boolean initialize() {
        Option<LuaState> option = this.factory().createState();
        if (None$.MODULE$.equals(option)) {
            this.lua_$eq(null);
            this.machine().crash("native libraries not available");
            return false;
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        LuaState value = (LuaState)some.value();
        this.lua_$eq(value);
        this.ramScale_$eq(this.lua().getPointerWidth() >= 8 ? Settings$.MODULE$.get().ramScaleFor64Bit() : 1.0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.apis()), (Function1<NativeLuaAPI, Object> & Serializable)x$2 -> {
            x$2.initialize();
            return BoxedUnit.UNIT;
        });
        this.lua().load(Machine.class.getResourceAsStream(new StringBuilder(11).append(Settings$.MODULE$.scriptPath()).append("machine.lua").toString()), "=machine", "t");
        this.lua().newThread();
        return true;
    }

    @Override
    public void onConnect() {
    }

    @Override
    public void close() {
        if (this.lua() != null) {
            if (Settings$.MODULE$.get().limitMemory()) {
                this.lua().setTotalMemory(Integer.MAX_VALUE);
            }
            this.lua().close();
        }
        this.lua_$eq(null);
        this.kernelMemory_$eq(0);
    }

    @Deprecated
    private Stack<Enumeration.Value> state() {
        return this.machine().state();
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (!this.machine().isRunning()) {
            return;
        }
        if (Settings$.MODULE$.get().limitMemory()) {
            this.lua().setTotalMemory(Integer.MAX_VALUE);
        }
        try {
            Constable constable;
            this.lua().setTop(0);
            this.persistence().unpersist(nbt.getByteArray(new StringBuilder(7).append(this.machine().node().address()).append("_kernel").toString()));
            if (!this.lua().isThread(1)) {
                throw new LuaRuntimeException("Invalid kernel.");
            }
            if (this.state().contains(MachineAPI$State$.MODULE$.SynchronizedCall()) || this.state().contains(MachineAPI$State$.MODULE$.SynchronizedReturn())) {
                this.persistence().unpersist(nbt.getByteArray(new StringBuilder(6).append(this.machine().node().address()).append("_stack").toString()));
                if (this.state().contains(MachineAPI$State$.MODULE$.SynchronizedCall()) ? !this.lua().isFunction(2) : !this.lua().isTable(2)) {
                    throw new LuaRuntimeException("Invalid stack.");
                }
            }
            this.kernelMemory_$eq((int)((double)nbt.getInteger("kernelMemory") * this.ramScale()));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.apis()), (Function1<NativeLuaAPI, Object> & Serializable)api2 -> {
                api2.load(nbt);
                return BoxedUnit.UNIT;
            });
            try {
                constable = BoxesRunTime.boxToInteger(this.lua().gc(LuaState.GcAction.COLLECT, 0));
            }
            catch (Throwable throwable) {
                Ocelot$.MODULE$.log().warn("Error cleaning up loaded computer. This either means the server is badly overloaded or a user created an evil __gc method, accidentally or not.");
                constable = BoxesRunTime.boxToBoolean(this.machine().crash("error in garbage collector, most likely __gc method timed out"));
            }
        }
        catch (LuaRuntimeException e2) {
            throw new Exception(new StringBuilder(0).append(e2.toString()).append((Object)(ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(e2.getLuaStackTrace())) ? "" : new StringBuilder(4).append("\tat ").append(Predef$.MODULE$.wrapRefArray((Object[])e2.getLuaStackTrace()).mkString("\n\tat ")).toString())).toString(), e2);
        }
        this.recomputeMemory(this.machine().host().inventory().entities());
    }

    @Override
    public void save(NBTTagCompound nbt) {
        Serializable serializable;
        if (Settings$.MODULE$.get().limitMemory()) {
            this.lua().setTotalMemory(Integer.MAX_VALUE);
        }
        try {
            Predef$.MODULE$.assert(this.lua().isThread(1));
            nbt.setByteArray(new StringBuilder(7).append(this.machine().node().address()).append("_kernel").toString(), this.persistence().persist(1));
            if (this.state().contains(MachineAPI$State$.MODULE$.SynchronizedCall()) || this.state().contains(MachineAPI$State$.MODULE$.SynchronizedReturn())) {
                Predef$.MODULE$.assert(this.state().contains(MachineAPI$State$.MODULE$.SynchronizedCall()) ? this.lua().isFunction(2) : this.lua().isTable(2));
                nbt.setByteArray(new StringBuilder(6).append(this.machine().node().address()).append("_stack").toString(), this.persistence().persist(2));
            }
            nbt.setInteger("kernelMemory", (int)package$.MODULE$.ceil((double)this.kernelMemory() / this.ramScale()));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(this.apis()), (Function1<NativeLuaAPI, Object> & Serializable)api2 -> {
                api2.save(nbt);
                return BoxedUnit.UNIT;
            });
            try {
                serializable = BoxesRunTime.boxToInteger(this.lua().gc(LuaState.GcAction.COLLECT, 0));
            }
            catch (Throwable throwable) {
                Ocelot$.MODULE$.log().warn("Error cleaning up loaded computer. This either means the server is badly overloaded or a user created an evil __gc method, accidentally or not.");
                serializable = BoxesRunTime.boxToBoolean(this.machine().crash("error in garbage collector, most likely __gc method timed out"));
            }
        }
        catch (LuaRuntimeException e2) {
            Ocelot$.MODULE$.log().warn(new StringBuilder(28).append("Could not persist computer.\n").append(e2.toString()).append((Object)(ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(e2.getLuaStackTrace())) ? "" : new StringBuilder(4).append("\tat ").append(Predef$.MODULE$.wrapRefArray((Object[])e2.getLuaStackTrace()).mkString("\n\tat ")).toString())).toString());
            nbt.removeTag("state");
            serializable = BoxedUnit.UNIT;
        }
        catch (LuaGcMetamethodException e3) {
            Ocelot$.MODULE$.log().warn(new StringBuilder(28).append("Could not persist computer.\n").append(e3.toString()).toString());
            nbt.removeTag("state");
            serializable = BoxedUnit.UNIT;
        }
        this.recomputeMemory(this.machine().host().inventory().entities());
    }

    public static final /* synthetic */ void $anonfun$invoke$1(NativeLuaArchitecture $this, Object result2) {
        ExtendedLuaState.ExtendedLuaState qual$1 = ExtendedLuaState$.MODULE$.extendLuaState($this.lua());
        Object x$1 = result2;
        IdentityHashMap<Object, Object> x$2 = qual$1.pushValue$default$2();
        qual$1.pushValue(x$1, x$2);
    }

    public static final /* synthetic */ double $anonfun$memoryInBytes$1(double acc, Entity entity) {
        double d2;
        Entity entity2 = entity;
        if (entity2 instanceof Memory) {
            Entity entity3 = entity2;
            d2 = ((Memory)((Object)entity3)).amount() * (double)1024;
        } else {
            d2 = 0.0;
        }
        return acc + d2;
    }

    public static final /* synthetic */ void $anonfun$runThreaded$1(NativeLuaArchitecture $this, Object arg) {
        ExtendedLuaState.ExtendedLuaState qual$1 = ExtendedLuaState$.MODULE$.extendLuaState($this.lua());
        Object x$1 = arg;
        IdentityHashMap<Object, Object> x$2 = qual$1.pushValue$default$2();
        qual$1.pushValue(x$1, x$2);
    }

    public NativeLuaArchitecture(Machine machine) {
        this.machine = machine;
        this.kernelMemory = 0;
        this.ramScale = 1.0;
        this.persistence = new PersistenceAPI(this);
        this.apis = (NativeLuaAPI[])((Object[])new NativeLuaAPI[]{new ComponentAPI(this), new ComputerAPI(this), new OSAPI(this), new SystemAPI(this), new UnicodeAPI(this), new UserdataAPI(this), this.persistence()});
    }
}

