/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.entity.tape;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import totoro.ocelot.brain.Ocelot$;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001B\u0012%\u0001=B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005{!A\u0011\n\u0001B\u0001J\u0003%!\n\u0003\u0005V\u0001\t\u0005\r\u0011\"\u0003W\u0011!Q\u0006A!a\u0001\n\u0013Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0015B,\t\u0011\t\u0004!\u00111A\u0005\nYC\u0001b\u0019\u0001\u0003\u0002\u0004%I\u0001\u001a\u0005\tM\u0002\u0011\t\u0011)Q\u0005/\")q\r\u0001C\u0001Q\"9q\u000e\u0001a\u0001\n\u0013\u0001\bbB<\u0001\u0001\u0004%I\u0001\u001f\u0005\u0007u\u0002\u0001\u000b\u0015B9\t\u000fm\u0004\u0001\u0019!C\u0005y\"I\u0011\u0011\u0001\u0001A\u0002\u0013%\u00111\u0001\u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003~\u0011\u0019\tI\u0001\u0001C!y!1\u00111\u0002\u0001\u0005BYCa!!\u0004\u0001\t\u00032\u0006bBA\b\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\ty\u0002\u0001C!\u0003CAq!a\n\u0001\t\u0003\nI\u0003C\u0004\u0002(\u0001!\t!a\f\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002<!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA\"\u0001\u0011\u0005\u00131\n\u0005\b\u0003#\u0002A\u0011BA*\u0011%\tI\nAI\u0001\n\u0013\tY\nC\u0004\u00022\u0002!I!a-\t\u0013\u0005\r\u0007!%A\u0005\n\u0005m\u0005bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003+\u0004A\u0011IAd\u0011\u001d\t9\u000e\u0001C!\u0003\u000f\u00141\u0002V1qKN#xN]1hK*\u0011QEJ\u0001\u0005i\u0006\u0004XM\u0003\u0002(Q\u00051QM\u001c;jifT!!\u000b\u0016\u0002\u000b\t\u0014\u0018-\u001b8\u000b\u0005-b\u0013AB8dK2|GOC\u0001.\u0003\u0019!x\u000e^8s_\u000e\u00011c\u0001\u00011mA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t1\u0011I\\=SK\u001a\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0013\u0002\rQ\u0014\u0018-\u001b;t\u0013\t\u0019\u0003(\u0001\u0005v]&\fX/Z%e+\u0005i\u0004C\u0001 F\u001d\ty4\t\u0005\u0002Ae5\t\u0011I\u0003\u0002C]\u00051AH]8pizJ!\u0001\u0012\u001a\u0002\rA\u0013X\rZ3g\u0013\t1uI\u0001\u0004TiJLgn\u001a\u0006\u0003\tJ\n\u0011\"\u001e8jcV,\u0017\n\u001a\u0011\u0002\t\u0019LG.\u001a\t\u0004c-k\u0015B\u0001'3\u0005!a$-\u001f8b[\u0016t\u0004C\u0001(T\u001b\u0005y%B\u0001)R\u0003\tIwNC\u0001S\u0003\u0011Q\u0017M^1\n\u0005Q{%\u0001\u0002$jY\u0016\fQaX:ju\u0016,\u0012a\u0016\t\u0003caK!!\u0017\u001a\u0003\u0007%sG/A\u0005`g&TXm\u0018\u0013fcR\u0011Al\u0018\t\u0003cuK!A\u0018\u001a\u0003\tUs\u0017\u000e\u001e\u0005\bA\u0016\t\t\u00111\u0001X\u0003\rAH%M\u0001\u0007?NL'0\u001a\u0011\u0002\u0013}\u0003xn]5uS>t\u0017!D0q_NLG/[8o?\u0012*\u0017\u000f\u0006\u0002]K\"9\u0001\rCA\u0001\u0002\u00049\u0016AC0q_NLG/[8oA\u00051A(\u001b8jiz\"R![6m[:\u0004\"A\u001b\u0001\u000e\u0003\u0011BQa\u000f\u0006A\u0002uBa!\u0013\u0006\u0005\u0002\u0004Q\u0005\"B+\u000b\u0001\u00049\u0006\"\u00022\u000b\u0001\u00049\u0016\u0001\u00023bi\u0006,\u0012!\u001d\t\u0004cI$\u0018BA:3\u0005\u0015\t%O]1z!\t\tT/\u0003\u0002we\t!!)\u001f;f\u0003!!\u0017\r^1`I\u0015\fHC\u0001/z\u0011\u001d\u0001G\"!AA\u0002E\fQ\u0001Z1uC\u0002\n\u0001\"\\8eS\u001aLW\rZ\u000b\u0002{B\u0011\u0011G`\u0005\u0003\u007fJ\u0012qAQ8pY\u0016\fg.\u0001\u0007n_\u0012Lg-[3e?\u0012*\u0017\u000fF\u0002]\u0003\u000bAq\u0001Y\b\u0002\u0002\u0003\u0007Q0A\u0005n_\u0012Lg-[3eA\u0005!a.Y7f\u0003!\u0001xn]5uS>t\u0017\u0001B:ju\u0016\f1b]3u!>\u001c\u0018\u000e^5p]R\u0019q+a\u0005\t\r\u0005UA\u00031\u0001X\u0003-qWm\u001e)pg&$\u0018n\u001c8\u0002\u000fQ\u0014\u0018pU3fWR\u0019q+a\u0007\t\r\u0005uQ\u00031\u0001X\u0003\r!\u0017N]\u0001\u0005g\u0016,7\u000eF\u0002X\u0003GAa!!\n\u0017\u0001\u00049\u0016AB1n_VtG/\u0001\u0003sK\u0006$GcA,\u0002,!1\u0011QF\fA\u0002u\f\u0001b]5nk2\fG/\u001a\u000b\b/\u0006E\u0012QGA\u001d\u0011\u0019\t\u0019\u0004\u0007a\u0001c\u0006\ta\u000f\u0003\u0004\u00028a\u0001\raV\u0001\u0007_\u001a47/\u001a;\t\r\u00055\u0002\u00041\u0001~)\u00159\u0016QHA!\u0011\u0019\ty$\u0007a\u0001c\u0006I\u0011N\u001c;p\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003[I\u0002\u0019A?\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007q\u000b9\u0005\u0003\u0004\u0002Ji\u0001\r\u0001^\u0001\u0002ER\u0019q+!\u0014\t\r\u0005=3\u00041\u0001r\u0003\u0015\t'O]1z\u0003!\u0011X-\u00193GS2,Gc\u0001/\u0002V!9\u0011\n\bI\u0001\u0002\u0004i\u0005&\u0002\u000f\u0002Z\u0005\u0015\u0004#B\u0019\u0002\\\u0005}\u0013bAA/e\t1A\u000f\u001b:poN\u00042ATA1\u0013\r\t\u0019g\u0014\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0004\u001f{\u0005\u001d\u0014qS\u0019\nG\u0005%\u0014qNAG\u0003c*2\u0001PA6\t\u001d\tiG\fb\u0001\u0003o\u0012\u0011\u0001V\u0005\u0005\u0003c\n\u0019(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0004\u0003k\u0012\u0014A\u0002;ie><8/\u0005\u0003\u0002z\u0005}\u0004cA\u0019\u0002|%\u0019\u0011Q\u0010\u001a\u0003\u000f9{G\u000f[5oOB!\u0011\u0011QAD\u001d\r\t\u00141Q\u0005\u0004\u0003\u000b\u0013\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\u000bYIA\u0005UQJ|w/\u00192mK*\u0019\u0011Q\u0011\u001a2\u0013\r\ny)!%\u0002\u0014\u0006UdbA\u0019\u0002\u0012&\u0019\u0011Q\u000f\u001a2\u000b\t\n$'!&\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\ny&\u0001\nsK\u0006$g)\u001b7fI\u0011,g-Y;mi\u0012\nTCAAOU\ri\u0015qT\u0016\u0003\u0003C\u0003B!a)\u0002.6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0016\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00020\u0006\u0015&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006IqO]5uK\u001aKG.\u001a\u000b\u00049\u0006U\u0006bB%\u001f!\u0003\u0005\r!\u0014\u0015\u0006=\u0005e\u0013\u0011X\u0019\u0007=u\nY,!12\u0013\r\nI'a\u001c\u0002>\u0006E\u0014'C\u0012\u0002\u0010\u0006E\u0015qXA;c\u0015\u0011\u0013GMAKc\r1\u0013qL\u0001\u0014oJLG/\u001a$jY\u0016$C-\u001a4bk2$H%M\u0001\u0014oJLG/\u001a$jY\u0016Le-T8eS\u001aLW\r\u001a\u000b\u00029\"*\u0001%!\u0017\u0002LF2a$PAg\u0003'\f\u0014bIA5\u0003_\ny-!\u001d2\u0013\r\ny)!%\u0002R\u0006U\u0014'\u0002\u00122e\u0005U\u0015g\u0001\u0014\u0002`\u0005!1/\u0019<f\u0003=ygn\u0015;pe\u0006<W-\u00168m_\u0006$\u0007")
public class TapeStorage
implements totoro.ocelot.brain.entity.tape.traits.TapeStorage {
    private final String uniqueId;
    private final Function0<File> file;
    private int _size;
    private int _position;
    private byte[] data;
    private boolean modified;

    @Override
    public String uniqueId() {
        return this.uniqueId;
    }

    private int _size() {
        return this._size;
    }

    private void _size_$eq(int x$1) {
        this._size = x$1;
    }

    private int _position() {
        return this._position;
    }

    private void _position_$eq(int x$1) {
        this._position = x$1;
    }

    private byte[] data() {
        return this.data;
    }

    private void data_$eq(byte[] x$1) {
        this.data = x$1;
    }

    private boolean modified() {
        return this.modified;
    }

    private void modified_$eq(boolean x$1) {
        this.modified = x$1;
    }

    @Override
    public String name() {
        return "Tape";
    }

    @Override
    public int position() {
        return this._position();
    }

    @Override
    public int size() {
        return this._size();
    }

    @Override
    public int setPosition(int newPosition) {
        this._position_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(newPosition), 0)), this.size() - 1));
        return this._position();
    }

    private int trySeek(int dir) {
        int oldPosition = this._position();
        int newPosition = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this._position() + dir), 0)), this.size() - 1);
        return newPosition - oldPosition;
    }

    @Override
    public int seek(int amount) {
        int seek = this.trySeek(amount);
        this._position_$eq(this._position() + seek);
        this.modified_$eq(true);
        return seek;
    }

    @Override
    public int read(boolean simulate) {
        if (this.position() >= this.size()) {
            return 0;
        }
        if (simulate) {
            return this.data()[this.position()] & 0xFF;
        }
        this.modified_$eq(true);
        byte result2 = this.data()[this.position()];
        this._position_$eq(this._position() + 1);
        return result2 & 0xFF;
    }

    public int read(byte[] v, int offset, boolean simulate) {
        int len2;
        block0: {
            len2 = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(v.length), this.size() - (this.position() + offset) - 1);
            Array$.MODULE$.copy(this.data(), this.position() + offset, v, 0, len2);
            if (simulate) break block0;
            this._position_$eq(this._position() + len2);
            this.modified_$eq(true);
        }
        return len2;
    }

    @Override
    public int read(byte[] intoArray, boolean simulate) {
        return this.read(intoArray, 0, simulate);
    }

    @Override
    public void write(byte b2) {
        if (this.position() >= this.size()) {
            return;
        }
        this.modified_$eq(true);
        this.data()[this.position()] = b2;
        this._position_$eq(this._position() + 1);
    }

    @Override
    public int write(byte[] array) {
        int len2 = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(array.length), this.size() - this.position() - 1);
        if (len2 == 0) {
            return 0;
        }
        Array$.MODULE$.copy(array, 0, this.data(), this.position(), len2);
        this._position_$eq(this._position() + len2);
        this.modified_$eq(true);
        return len2;
    }

    private void readFile(File file) throws IOException {
        Using$.MODULE$.resource(new FileInputStream(file), (Function1<FileInputStream, Object> & Serializable)fileStream -> {
            Using$.MODULE$.resource(new GZIPInputStream(fileStream), (Function1<GZIPInputStream, Object> & Serializable)stream -> {
                TapeStorage.$anonfun$readFile$2($this, stream);
                return BoxedUnit.UNIT;
            }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private File readFile$default$1() {
        return this.file.apply();
    }

    private void writeFile(File file) throws IOException {
        Using$.MODULE$.resource(new FileOutputStream(file), (Function1<FileOutputStream, Object> & Serializable)fileStream -> {
            Using$.MODULE$.resource(new GZIPOutputStream(fileStream), (Function1<GZIPOutputStream, Object> & Serializable)stream -> {
                TapeStorage.$anonfun$writeFile$2($this, stream);
                return BoxedUnit.UNIT;
            }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
        this.modified_$eq(true);
    }

    private File writeFile$default$1() {
        return this.file.apply();
    }

    private void writeFileIfModified() throws IOException {
        if (this.modified()) {
            this.writeFile(this.writeFile$default$1());
            return;
        }
    }

    @Override
    public void save() {
        try {
            this.writeFileIfModified();
        }
        catch (Exception e2) {
            Ocelot$.MODULE$.log().error(new StringBuilder(23).append("Tape ID ").append(this.uniqueId()).append(" was NOT saved!").toString(), (Throwable)e2);
        }
    }

    @Override
    public void onStorageUnload() {
        this.save();
    }

    public static final /* synthetic */ void $anonfun$readFile$2(TapeStorage $this, GZIPInputStream stream) {
        int version = stream.read();
        if (version >= 1) {
            int b1 = stream.read() & 0xFF;
            int b2 = stream.read() & 0xFF;
            int b3 = stream.read() & 0xFF;
            int b4 = stream.read() & 0xFF;
            $this._position_$eq(b1 | b2 << 8 | b3 << 16 | b4 << 24);
        }
        $this.data_$eq((byte[])Array$.MODULE$.ofDim($this.size(), ClassTag$.MODULE$.Byte()));
        for (int position = 0; position < $this.data().length; position += stream.read($this.data(), position, $this.data().length - position)) {
        }
    }

    public static final /* synthetic */ void $anonfun$writeFile$2(TapeStorage $this, GZIPOutputStream stream) {
        stream.write(1);
        stream.write($this.position() & 0xFF);
        stream.write($this.position() >>> 8 & 0xFF);
        stream.write($this.position() >>> 16 & 0xFF);
        stream.write($this.position() >>> 24 & 0xFF);
        stream.write($this.data());
        stream.finish();
        stream.flush();
    }

    public TapeStorage(String uniqueId, Function0<File> file, int _size, int _position) {
        this.uniqueId = uniqueId;
        this.file = file;
        this._size = _size;
        this._position = _position;
        this.data = (byte[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Byte());
        this.modified = false;
        File f2 = file.apply();
        if (!f2.exists()) {
            try {
                f2.createNewFile();
                this.writeFile(f2);
            }
            catch (Exception e2) {
                Ocelot$.MODULE$.log().error(new StringBuilder(30).append("Could not create tape storage ").append(f2).toString(), (Throwable)e2);
            }
        } else {
            try {
                this.readFile(f2);
            }
            catch (Exception e3) {
                Ocelot$.MODULE$.log().error(new StringBuilder(28).append("Could not read tape storage ").append(f2).toString(), (Throwable)e3);
            }
        }
    }
}

