/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTReadLimiter;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.NBTTagEnd;

public class CompressedStreamTools {
    public static NBTTagCompound readCompressed(InputStream inputStream) throws IOException {
        NBTTagCompound nBTTagCompound;
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(inputStream)));){
            nBTTagCompound = CompressedStreamTools.read(dataInputStream, NBTReadLimiter.INFINITE);
        }
        return nBTTagCompound;
    }

    public static void writeCompressed(NBTTagCompound nBTTagCompound, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            CompressedStreamTools.write(nBTTagCompound, dataOutputStream);
        }
    }

    public static NBTTagCompound read(byte[] byArray, NBTReadLimiter nBTReadLimiter) throws IOException {
        NBTTagCompound nBTTagCompound;
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(byArray))));){
            nBTTagCompound = CompressedStreamTools.read(dataInputStream, nBTReadLimiter);
        }
        return nBTTagCompound;
    }

    public static byte[] write(NBTTagCompound nBTTagCompound) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(byteArrayOutputStream));){
            CompressedStreamTools.write(nBTTagCompound, dataOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static NBTTagCompound read(DataInputStream dataInputStream) throws IOException {
        return CompressedStreamTools.read(dataInputStream, NBTReadLimiter.INFINITE);
    }

    public static NBTTagCompound read(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
        NBTBase nBTBase = CompressedStreamTools.read(dataInput, 0, nBTReadLimiter);
        if (nBTBase instanceof NBTTagCompound) {
            return (NBTTagCompound)nBTBase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(NBTTagCompound nBTTagCompound, DataOutput dataOutput) throws IOException {
        CompressedStreamTools.writeTag(nBTTagCompound, dataOutput);
    }

    private static void writeTag(NBTBase nBTBase, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(nBTBase.getId());
        if (nBTBase.getId() != 0) {
            dataOutput.writeUTF("");
            nBTBase.write(dataOutput);
        }
    }

    private static NBTBase read(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        byte by = dataInput.readByte();
        if (by == 0) {
            return new NBTTagEnd();
        }
        dataInput.readUTF();
        NBTBase nBTBase = NBTBase.createTag(by);
        if (nBTBase != null) {
            nBTBase.load(dataInput, n2, nBTReadLimiter);
        }
        return nBTBase;
    }
}

