/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTNumber;
import totoro.ocelot.brain.nbt.NBTReadLimiter;
import totoro.ocelot.brain.nbt.NBTTagByte;
import totoro.ocelot.brain.nbt.NBTTagByteArray;
import totoro.ocelot.brain.nbt.NBTTagDouble;
import totoro.ocelot.brain.nbt.NBTTagFloat;
import totoro.ocelot.brain.nbt.NBTTagInt;
import totoro.ocelot.brain.nbt.NBTTagIntArray;
import totoro.ocelot.brain.nbt.NBTTagList;
import totoro.ocelot.brain.nbt.NBTTagLong;
import totoro.ocelot.brain.nbt.NBTTagShort;
import totoro.ocelot.brain.nbt.NBTTagString;

public class NBTTagCompound
extends NBTBase {
    private final Map<String, NBTBase> map = new HashMap<String, NBTBase>();

    @Override
    void write(DataOutput dataOutput) throws IOException {
        for (String string : this.map.keySet()) {
            NBTBase nBTBase = this.map.get(string);
            NBTTagCompound.a(string, nBTBase, dataOutput);
        }
        dataOutput.writeByte(0);
    }

    @Override
    void load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        byte by;
        if (n2 > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.map.clear();
        while ((by = NBTTagCompound.a(dataInput, nBTReadLimiter)) != 0) {
            String string = NBTTagCompound.getTagType(dataInput, nBTReadLimiter);
            nBTReadLimiter.a(16L * (long)string.length());
            NBTBase nBTBase = NBTTagCompound.a(by, string, dataInput, n2 + 1, nBTReadLimiter);
            this.map.put(string, nBTBase);
        }
    }

    public Set<String> getKeySet() {
        return this.map.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public void setTag(String string, NBTBase nBTBase) {
        this.map.put(string, nBTBase);
    }

    public void setByte(String string, byte by) {
        this.map.put(string, new NBTTagByte(by));
    }

    public void setShort(String string, short s) {
        this.map.put(string, new NBTTagShort(s));
    }

    public void setInteger(String string, int n2) {
        this.map.put(string, new NBTTagInt(n2));
    }

    public void setLong(String string, long l2) {
        this.map.put(string, new NBTTagLong(l2));
    }

    public void setFloat(String string, float f2) {
        this.map.put(string, new NBTTagFloat(f2));
    }

    public void setDouble(String string, double d2) {
        this.map.put(string, new NBTTagDouble(d2));
    }

    public void setString(String string, String string2) {
        this.map.put(string, new NBTTagString(string2));
    }

    public void setByteArray(String string, byte[] byArray) {
        this.map.put(string, new NBTTagByteArray(byArray));
    }

    public void setIntArray(String string, int[] nArray) {
        this.map.put(string, new NBTTagIntArray(nArray));
    }

    public void setBoolean(String string, boolean bl) {
        this.setByte(string, (byte)(bl ? 1 : 0));
    }

    public void setTagList(String string, List<NBTBase> list2) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.appendAll(list2);
        this.map.put(string, nBTTagList);
    }

    public NBTBase getTag(String string) {
        return this.map.get(string);
    }

    public byte getTagType(String string) {
        NBTBase nBTBase = this.map.get(string);
        return nBTBase != null ? nBTBase.getId() : (byte)0;
    }

    public boolean hasKey(String string) {
        return this.map.containsKey(string);
    }

    public boolean hasKeyOfType(String string, int n2) {
        byte by = this.getTagType(string);
        return by == n2 || n2 == 99 && (by == 1 || by == 2 || by == 3 || by == 4 || by == 5 || by == 6);
    }

    public byte getByte(String string) {
        try {
            return !this.map.containsKey(string) ? (byte)0 : ((NBTNumber)this.map.get(string)).getByte();
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    public short getShort(String string) {
        try {
            return !this.map.containsKey(string) ? (short)0 : ((NBTNumber)this.map.get(string)).getShort();
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    public int getInteger(String string) {
        try {
            return !this.map.containsKey(string) ? 0 : ((NBTNumber)this.map.get(string)).getInt();
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    public long getLong(String string) {
        try {
            return !this.map.containsKey(string) ? 0L : ((NBTNumber)this.map.get(string)).getLong();
        }
        catch (ClassCastException classCastException) {
            return 0L;
        }
    }

    public float getFloat(String string) {
        try {
            return !this.map.containsKey(string) ? 0.0f : ((NBTNumber)this.map.get(string)).getFloat();
        }
        catch (ClassCastException classCastException) {
            return 0.0f;
        }
    }

    public double getDouble(String string) {
        try {
            return !this.map.containsKey(string) ? 0.0 : ((NBTNumber)this.map.get(string)).getDouble();
        }
        catch (ClassCastException classCastException) {
            return 0.0;
        }
    }

    public String getString(String string) {
        try {
            return !this.map.containsKey(string) ? "" : this.map.get(string).getString();
        }
        catch (ClassCastException classCastException) {
            return "";
        }
    }

    public byte[] getByteArray(String string) {
        return !this.map.containsKey(string) ? new byte[]{} : ((NBTTagByteArray)this.map.get(string)).getByteArray();
    }

    public int[] getIntArray(String string) {
        return !this.map.containsKey(string) ? new int[]{} : ((NBTTagIntArray)this.map.get(string)).getIntArray();
    }

    public NBTTagCompound getCompoundTag(String string) {
        return !this.map.containsKey(string) ? new NBTTagCompound() : (NBTTagCompound)this.map.get(string);
    }

    public NBTTagList getTagList(String string, int n2) {
        if (this.getTagType(string) != 9) {
            return new NBTTagList();
        }
        NBTTagList nBTTagList = (NBTTagList)this.map.get(string);
        return nBTTagList.tagCount() > 0 && nBTTagList.getType() != n2 ? new NBTTagList() : nBTTagList;
    }

    public boolean getBoolean(String string) {
        return this.getByte(string) != 0;
    }

    public void removeTag(String string) {
        this.map.remove(string);
    }

    @Override
    public String toString() {
        String string = "{";
        for (String string2 : this.map.keySet()) {
            string = string + string2 + ':' + this.map.get(string2) + ',';
        }
        return string + "}";
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean hasNoTags() {
        return this.isEmpty();
    }

    @Override
    public NBTBase clone() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (String string : this.map.keySet()) {
            nBTTagCompound.setTag(string, this.map.get(string).clone());
        }
        return nBTTagCompound;
    }

    public NBTTagCompound copy() {
        return (NBTTagCompound)this.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)object;
            return this.map.entrySet().equals(nBTTagCompound.map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.map.hashCode();
    }

    private static void a(String string, NBTBase nBTBase, DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(nBTBase.getId());
        if (nBTBase.getId() != 0) {
            dataOutput.writeUTF(string);
            nBTBase.write(dataOutput);
        }
    }

    private static byte a(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
        return dataInput.readByte();
    }

    private static String getTagType(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
        return dataInput.readUTF();
    }

    static NBTBase a(byte by, String string, DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        NBTBase nBTBase = NBTBase.createTag(by);
        if (nBTBase != null) {
            nBTBase.load(dataInput, n2, nBTReadLimiter);
        }
        return nBTBase;
    }

    static Map<String, NBTBase> a(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.map;
    }
}

