/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTNumber;
import totoro.ocelot.brain.nbt.NBTReadLimiter;

public class NBTTagDouble
extends NBTNumber {
    private double data;

    NBTTagDouble() {
    }

    public NBTTagDouble(double d2) {
        this.data = d2;
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.data);
    }

    @Override
    void load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        nBTReadLimiter.a(64L);
        this.data = dataInput.readDouble();
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String toString() {
        return "" + this.data + "d";
    }

    @Override
    public NBTBase clone() {
        return new NBTTagDouble(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagDouble nBTTagDouble = (NBTTagDouble)object;
            return this.data == nBTTagDouble.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.data);
        return super.hashCode() ^ (int)(l2 ^ l2 >>> 32);
    }

    @Override
    public long getLong() {
        return (long)Math.floor(this.data);
    }

    @Override
    public int getInt() {
        return (int)Math.floor(this.data);
    }

    @Override
    public short getShort() {
        return (short)(this.getInt() & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(this.getInt() & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return (float)this.data;
    }
}

