/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTReadLimiter;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.NBTTagDouble;
import totoro.ocelot.brain.nbt.NBTTagFloat;
import totoro.ocelot.brain.nbt.NBTTagIntArray;

public class NBTTagList
extends NBTBase {
    private List<NBTBase> list = new ArrayList<NBTBase>();
    private byte type = 0;

    @Override
    void write(DataOutput dataOutput) throws IOException {
        this.type = !this.list.isEmpty() ? this.list.get(0).getId() : (byte)0;
        dataOutput.writeByte(this.type);
        dataOutput.writeInt(this.list.size());
        for (NBTBase nBTBase : this.list) {
            nBTBase.write(dataOutput);
        }
    }

    @Override
    void load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        if (n2 > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        nBTReadLimiter.a(8L);
        this.type = dataInput.readByte();
        int n3 = dataInput.readInt();
        this.list = new ArrayList<NBTBase>();
        for (int i2 = 0; i2 < n3; ++i2) {
            NBTBase nBTBase = NBTBase.createTag(this.type);
            if (nBTBase != null) {
                nBTBase.load(dataInput, n2 + 1, nBTReadLimiter);
            }
            this.list.add(nBTBase);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        int n2 = 0;
        for (NBTBase nBTBase : this.list) {
            stringBuilder.append(n2).append(':').append(nBTBase).append(',');
            ++n2;
        }
        return stringBuilder + "]";
    }

    public void appendTag(NBTBase nBTBase) {
        if (this.type == 0) {
            this.type = nBTBase.getId();
        } else if (this.type != nBTBase.getId()) {
            System.err.println("WARNING: Adding mismatching tag types to tag list");
            return;
        }
        this.list.add(nBTBase);
    }

    public NBTBase removeTag(int n2) {
        return this.list.remove(n2);
    }

    public void appendAll(List<NBTBase> list2) {
        for (NBTBase nBTBase : list2) {
            this.appendTag(nBTBase);
        }
    }

    public void set(int n2, NBTBase nBTBase) {
        if (n2 >= 0 && n2 < this.list.size()) {
            if (this.type == 0) {
                this.type = nBTBase.getId();
            } else if (this.type != nBTBase.getId()) {
                return;
            }
            this.list.set(n2, nBTBase);
        }
    }

    public NBTTagCompound getCompoundTagAt(int n2) {
        if (n2 >= 0 && n2 < this.list.size()) {
            NBTBase nBTBase = this.list.get(n2);
            return nBTBase.getId() == 10 ? (NBTTagCompound)nBTBase : new NBTTagCompound();
        }
        return new NBTTagCompound();
    }

    public int[] getIntegerAt(int n2) {
        if (n2 >= 0 && n2 < this.list.size()) {
            NBTBase nBTBase = this.list.get(n2);
            return nBTBase.getId() == 11 ? ((NBTTagIntArray)nBTBase).getIntArray() : new int[]{};
        }
        return new int[0];
    }

    public double getDoubleAt(int n2) {
        if (n2 >= 0 && n2 < this.list.size()) {
            NBTBase nBTBase = this.list.get(n2);
            return nBTBase.getId() == 6 ? ((NBTTagDouble)nBTBase).getDouble() : 0.0;
        }
        return 0.0;
    }

    public float getFloatAt(int n2) {
        if (n2 >= 0 && n2 < this.list.size()) {
            NBTBase nBTBase = this.list.get(n2);
            return nBTBase.getId() == 5 ? ((NBTTagFloat)nBTBase).getFloat() : 0.0f;
        }
        return 0.0f;
    }

    public String getStringTagAt(int n2) {
        if (n2 >= 0 && n2 < this.list.size()) {
            NBTBase nBTBase = this.list.get(n2);
            return nBTBase.getId() == 8 ? nBTBase.getString() : nBTBase.toString();
        }
        return "";
    }

    public int tagCount() {
        return this.list.size();
    }

    @Override
    public NBTBase clone() {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.type = this.type;
        for (NBTBase nBTBase : this.list) {
            nBTTagList.list.add(nBTBase.clone());
        }
        return nBTTagList;
    }

    public NBTTagList copy() {
        return (NBTTagList)this.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagList nBTTagList = (NBTTagList)object;
            if (this.type == nBTTagList.type) {
                return this.list.equals(nBTTagList.list);
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.list.hashCode();
    }

    public int getType() {
        return this.type;
    }
}

