/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTNumber;
import totoro.ocelot.brain.nbt.NBTReadLimiter;

public class NBTTagLong
extends NBTNumber {
    private long data;

    NBTTagLong() {
    }

    public NBTTagLong(long l2) {
        this.data = l2;
    }

    @Override
    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.data);
    }

    @Override
    void load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
        nBTReadLimiter.a(64L);
        this.data = dataInput.readLong();
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    public String toString() {
        return "" + this.data + "L";
    }

    @Override
    public NBTBase clone() {
        return new NBTTagLong(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NBTTagLong nBTTagLong = (NBTTagLong)object;
            return this.data == nBTTagLong.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)(this.data ^ this.data >>> 32);
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public int getInt() {
        return (int)this.data;
    }

    @Override
    public short getShort() {
        return (short)(this.data & 0xFFFFL);
    }

    @Override
    public byte getByte() {
        return (byte)(this.data & 0xFFL);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }
}

