/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.nbt.persistence;

import java.lang.reflect.Constructor;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import totoro.ocelot.brain.Ocelot$;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.persistence.NBTPersistence;
import totoro.ocelot.brain.util.Persistable;
import totoro.ocelot.brain.workspace.Workspace;

public final class NBTPersistence$ {
    public static final NBTPersistence$ MODULE$ = new NBTPersistence$();
    private static final String TypeTag = "type";
    private static final String DataTag = "data";
    private static final HashMap<String, NBTPersistence.InstanceConstructor> constructors = HashMap$.MODULE$.empty();

    public String TypeTag() {
        return TypeTag;
    }

    public String DataTag() {
        return DataTag;
    }

    private HashMap<String, NBTPersistence.InstanceConstructor> constructors() {
        return constructors;
    }

    public void registerConstructor(String className, NBTPersistence.InstanceConstructor constructor) {
        this.constructors().update(className, constructor);
    }

    public void unregisterConstructor(String className) {
        this.constructors().remove(className);
    }

    public void save(Persistable persistable, NBTTagCompound nbt) {
        nbt.setString(this.TypeTag(), persistable.getClass().getName());
        NBTTagCompound data = new NBTTagCompound();
        persistable.save(data);
        nbt.setTag(this.DataTag(), data);
    }

    public NBTTagCompound save(Persistable persistable) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.save(persistable, nbt);
        return nbt;
    }

    public Persistable load(NBTTagCompound nbt, Workspace workspace) {
        Persistable persistable;
        String className = nbt.getString(this.TypeTag());
        try {
            if (this.constructors().contains(className)) {
                persistable = this.constructors().apply(className).construct(nbt, className, workspace);
            } else {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                persistable = (Persistable)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception exc) {
            Ocelot$.MODULE$.log().atError().withThrowable(exc).log(new StringBuilder(47).append("Could not deserialize a Persistable (").append(className).append(") from NBT").toString());
            throw exc;
        }
        Persistable persistable2 = persistable;
        return this.load(nbt, persistable2, workspace);
    }

    public Persistable load(NBTTagCompound nbt, Persistable persistable, Workspace workspace) {
        persistable.load(nbt.getCompoundTag(this.DataTag()), workspace);
        return persistable;
    }

    private NBTPersistence$() {
    }
}

