/*
 * Decompiled with CFR 0.152.
 */
package totoro.ocelot.brain.workspace;

import java.io.Serializable;
import java.nio.file.Path;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random;
import totoro.ocelot.brain.entity.tape.StorageManager;
import totoro.ocelot.brain.entity.traits.Entity;
import totoro.ocelot.brain.entity.traits.Environment;
import totoro.ocelot.brain.entity.traits.SidedEnvironment;
import totoro.ocelot.brain.entity.traits.WorkspaceAware;
import totoro.ocelot.brain.nbt.ExtendedNBT$;
import totoro.ocelot.brain.nbt.NBTBase;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.persistence.NBTPersistence$;
import totoro.ocelot.brain.network.Node;
import totoro.ocelot.brain.util.Direction$;
import totoro.ocelot.brain.util.Persistable;

@ScalaSignature(bytes="\u0006\u0005\t]a\u0001\u0002\u00192\u0001iB\u0001\"\u0011\u0001\u0003\u0002\u0004%\tA\u0011\u0005\t\u001b\u0002\u0011\t\u0019!C\u0001\u001d\"AA\u000b\u0001B\u0001B\u0003&1\tC\u0003V\u0001\u0011\u0005a\u000bC\u0004[\u0001\t\u0007I\u0011B.\t\r\t\u0004\u0001\u0015!\u0003]\u0011\u0015\u0019\u0007\u0001\"\u0001\\\u0011\u001d!\u0007A1A\u0005\u0002\u0015DaA\u001c\u0001!\u0002\u00131\u0007bB8\u0001\u0001\u0004%I\u0001\u001d\u0005\bi\u0002\u0001\r\u0011\"\u0003v\u0011\u00199\b\u0001)Q\u0005c\"9\u0001\u0010\u0001a\u0001\n\u0013I\bbB?\u0001\u0001\u0004%IA \u0005\b\u0003\u0003\u0001\u0001\u0015)\u0003{\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010!A\u00111\u0003\u0001!B\u0013\t9\u0001\u0003\u0004\u0002\u0016\u0001!\t\u0001\u001d\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\ty\u0002\u0001C\u0001\u0003\u000bAa!!\t\u0001\t\u0003I\bbBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\n\u0003W\u0001!\u0019!C\u0005\u0003[A\u0001\"a\u0013\u0001A\u0003%\u0011q\u0006\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u000e\u0002!\t!a$\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006\"CAb\u0001\t\u0007I\u0011BAc\u0011!\t\t\u000e\u0001Q\u0001\n\u0005\u001d\u0007\"CAj\u0001\t\u0007I\u0011BAc\u0011!\t)\u000e\u0001Q\u0001\n\u0005\u001d\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003_\u0004A\u0011BAy\u0011%\tY\u0010\u0001b\u0001\n\u0013\t)\r\u0003\u0005\u0002~\u0002\u0001\u000b\u0011BAd\u0011%\ty\u0010\u0001b\u0001\n\u0013\t)\r\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0011BAd\u0011%\u0011\u0019\u0001\u0001b\u0001\n\u0013\t)\r\u0003\u0005\u0003\u0006\u0001\u0001\u000b\u0011BAd\u0011%\u00119\u0001\u0001b\u0001\n\u0013\t)\r\u0003\u0005\u0003\n\u0001\u0001\u000b\u0011BAd\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005\u001bAqA!\u0005\u0001\t\u0003\u0011\u0019BA\u0005X_J\\7\u000f]1dK*\u0011!gM\u0001\no>\u00148n\u001d9bG\u0016T!\u0001N\u001b\u0002\u000b\t\u0014\u0018-\u001b8\u000b\u0005Y:\u0014AB8dK2|GOC\u00019\u0003\u0019!x\u000e^8s_\u000e\u00011C\u0001\u0001<!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fM\u0006!\u0001/\u0019;i+\u0005\u0019\u0005C\u0001#L\u001b\u0005)%B\u0001$H\u0003\u00111\u0017\u000e\\3\u000b\u0005!K\u0015a\u00018j_*\t!*\u0001\u0003kCZ\f\u0017B\u0001'F\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0011A\fG\u000f[0%KF$\"a\u0014*\u0011\u0005q\u0002\u0016BA)>\u0005\u0011)f.\u001b;\t\u000fM\u0013\u0011\u0011!a\u0001\u0007\u0006\u0019\u0001\u0010J\u0019\u0002\u000bA\fG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\t9\u0016\f\u0005\u0002Y\u00015\t\u0011\u0007C\u0003B\t\u0001\u00071)\u0001\u0004sC:$w.\\\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011q,P\u0001\u0005kRLG.\u0003\u0002b=\n1!+\u00198e_6\fqA]1oI>l\u0007%\u0001\u0003sC:$\u0017a\u0003;ba\u0016\u001cFo\u001c:bO\u0016,\u0012A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA\u0001^1qK*\u00111nM\u0001\u0007K:$\u0018\u000e^=\n\u00055D'AD*u_J\fw-Z'b]\u0006<WM]\u0001\ri\u0006\u0004Xm\u0015;pe\u0006<W\rI\u0001\u000bS:<\u0017-\\3US6,W#A9\u0011\u0005q\u0012\u0018BA:>\u0005\rIe\u000e^\u0001\u000fS:<\u0017-\\3US6,w\fJ3r)\tye\u000fC\u0004T\u0017\u0005\u0005\t\u0019A9\u0002\u0017%tw-Y7f)&lW\rI\u0001\u0011S:<\u0017-\\3US6,\u0007+Y;tK\u0012,\u0012A\u001f\t\u0003ymL!\u0001`\u001f\u0003\u000f\t{w\u000e\\3b]\u0006!\u0012N\\4b[\u0016$\u0016.\\3QCV\u001cX\rZ0%KF$\"aT@\t\u000fMs\u0011\u0011!a\u0001u\u0006\t\u0012N\\4b[\u0016$\u0016.\\3QCV\u001cX\r\u001a\u0011\u0002!1\f7\u000f\u001e+jG.t\u0015M\\8US6,WCAA\u0004!\ra\u0014\u0011B\u0005\u0004\u0003\u0017i$\u0001\u0002'p]\u001e\fA\u0003\\1tiRK7m\u001b(b]>$\u0016.\\3`I\u0015\fHcA(\u0002\u0012!A1+EA\u0001\u0002\u0004\t9!A\tmCN$H+[2l\u001d\u0006tw\u000eV5nK\u0002\nQbZ3u\u0013:<\u0017-\\3US6,\u0017!D:fi&sw-Y7f)&lW\rF\u0002P\u00037Aa!!\b\u0015\u0001\u0004\t\u0018!\u0002;jG.\u001c\u0018aE4fi2\u000b7\u000f\u001e+jG.t\u0015M\\8US6,\u0017AE5t\u0013:<\u0017-\\3US6,\u0007+Y;tK\u0012\f1c]3u\u0013:<\u0017-\\3US6,\u0007+Y;tK\u0012$2aTA\u0014\u0011\u0019\tIc\u0006a\u0001u\u00061\u0001/Y;tK\u0012\f\u0001\"\u001a8uSRLWm]\u000b\u0003\u0003_\u0001b!!\r\u0002<\u0005}RBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011H\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002>\u0005M\"A\u0003'jgR\u0014UO\u001a4feB!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002F)\fa\u0001\u001e:bSR\u001c\u0018\u0002BA%\u0003\u0007\u0012a!\u00128uSRL\u0018!C3oi&$\u0018.Z:!\u0003\r\tG\rZ\u000b\u0005\u0003#\n9\u0006\u0006\u0003\u0002T\u0005\r\u0004\u0003BA+\u0003/b\u0001\u0001B\u0004\u0002Zi\u0011\r!a\u0017\u0003\u0003Q\u000bB!!\u0018\u0002@A\u0019A(a\u0018\n\u0007\u0005\u0005THA\u0004O_RD\u0017N\\4\t\r-T\u0002\u0019AA*\u0003=9W\r^#oi&$\u0018.Z:Ji\u0016\u0014XCAA5!\u0019\tY'a\u001f\u0002@9!\u0011QNA<\u001d\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:s\u00051AH]8pizJ\u0011AP\u0005\u0004\u0003sj\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tI(P\u0001\u0007e\u0016lwN^3\u0016\t\u0005\u0015\u0015\u0011\u0012\u000b\u0005\u0003\u000f\u000bY\t\u0005\u0003\u0002V\u0005%EaBA-9\t\u0007\u00111\f\u0005\u0007Wr\u0001\r!a\"\u0002\rU\u0004H-\u0019;f)\u0005y\u0015aD3oi&$\u0018PQ=BI\u0012\u0014Xm]:\u0015\t\u0005U\u00151\u0014\t\u0006y\u0005]\u0015qH\u0005\u0004\u00033k$AB(qi&|g\u000eC\u0004\u0002\u001ez\u0001\r!a(\u0002\u000f\u0005$GM]3tgB!\u0011\u0011UAU\u001d\u0011\t\u0019+!*\u0011\u0007\u0005=T(C\u0002\u0002(v\na\u0001\u0015:fI\u00164\u0017\u0002BAV\u0003[\u0013aa\u0015;sS:<'bAAT{\u0005ian\u001c3f\u0005f\fE\r\u001a:fgN$B!a-\u0002BB)A(a&\u00026B!\u0011qWA_\u001b\t\tILC\u0002\u0002<N\nqA\\3uo>\u00148.\u0003\u0003\u0002@\u0006e&\u0001\u0002(pI\u0016Dq!!( \u0001\u0004\ty*A\u0004MK\u001a$H+Y4\u0016\u0005\u0005\u001d\u0007\u0003BAe\u0003\u001fl!!a3\u000b\u0007\u00055\u0017*\u0001\u0003mC:<\u0017\u0002BAV\u0003\u0017\f\u0001\u0002T3giR\u000bw\rI\u0001\t%&<\u0007\u000e\u001e+bO\u0006I!+[4iiR\u000bw\rI\u0001\rEVLG\u000eZ#eO\u0016t%\r\u001e\u000b\u0007\u00037\f9/a;\u0011\t\u0005u\u00171]\u0007\u0003\u0003?T1!!94\u0003\rq'\r^\u0005\u0005\u0003K\fyN\u0001\bO\u0005R#\u0016mZ\"p[B|WO\u001c3\t\u000f\u0005%H\u00051\u0001\u0002 \u0006A\u0011\r\u001a3sKN\u001c\u0018\u0007C\u0004\u0002n\u0012\u0002\r!a(\u0002\u0011\u0005$GM]3tgJ\nAbY8mY\u0016\u001cG/\u00123hKN$\"!a=\u0011\r\u0005E\u00121HA{!\u0011\ti.a>\n\t\u0005e\u0018q\u001c\u0002\b\u001d\n#&)Y:f\u0003\u001d!\u0016.\\3UC\u001e\f\u0001\u0002V5nKR\u000bw\rI\u0001\u000e)&lW\rU1vg\u0016$G+Y4\u0002\u001dQKW.\u001a)bkN,G\rV1hA\u0005AQ\tZ4fgR\u000bw-A\u0005FI\u001e,7\u000fV1hA\u0005YQI\u001c;ji&,7\u000fV1h\u00031)e\u000e^5uS\u0016\u001cH+Y4!\u0003\u0011\u0019\u0018M^3\u0015\u0007=\u0013y\u0001C\u0004\u0002b:\u0002\r!a7\u0002\t1|\u0017\r\u001a\u000b\u0004\u001f\nU\u0001bBAq_\u0001\u0007\u00111\u001c")
public class Workspace {
    private Path path;
    private final Random random;
    private final StorageManager tapeStorage;
    private int ingameTime;
    private boolean ingameTimePaused;
    private long lastTickNanoTime;
    private final ListBuffer<Entity> entities;
    private final String LeftTag;
    private final String RightTag;
    private final String TimeTag;
    private final String TimePausedTag;
    private final String EdgesTag;
    private final String EntitiesTag;

    public Path path() {
        return this.path;
    }

    public void path_$eq(Path x$1) {
        this.path = x$1;
    }

    private Random random() {
        return this.random;
    }

    public Random rand() {
        return this.random();
    }

    public StorageManager tapeStorage() {
        return this.tapeStorage;
    }

    private int ingameTime() {
        return this.ingameTime;
    }

    private void ingameTime_$eq(int x$1) {
        this.ingameTime = x$1;
    }

    private boolean ingameTimePaused() {
        return this.ingameTimePaused;
    }

    private void ingameTimePaused_$eq(boolean x$1) {
        this.ingameTimePaused = x$1;
    }

    private long lastTickNanoTime() {
        return this.lastTickNanoTime;
    }

    private void lastTickNanoTime_$eq(long x$1) {
        this.lastTickNanoTime = x$1;
    }

    public int getIngameTime() {
        return this.ingameTime();
    }

    public void setIngameTime(int ticks) {
        this.ingameTime_$eq(ticks);
        this.lastTickNanoTime_$eq(System.nanoTime());
    }

    public long getLastTickNanoTime() {
        return this.lastTickNanoTime();
    }

    public boolean isIngameTimePaused() {
        return this.ingameTimePaused();
    }

    public void setIngameTimePaused(boolean paused) {
        this.ingameTimePaused_$eq(paused);
    }

    private ListBuffer<Entity> entities() {
        return this.entities;
    }

    public <T extends Entity> T add(T entity) {
        block0: {
            this.entities().$plus$eq(entity);
            entity.initialize();
            T t = entity;
            if (!(t instanceof WorkspaceAware)) break block0;
            T t2 = t;
            ((WorkspaceAware)((Object)t2)).workspace_$eq(this);
        }
        return entity;
    }

    public Iterator<Entity> getEntitiesIter() {
        return this.entities().iterator();
    }

    public <T extends Entity> T remove(T entity) {
        block1: {
            entity.dispose();
            this.entities().$minus$eq(entity);
            T t = entity;
            if (!(t instanceof WorkspaceAware)) break block1;
            T t2 = t;
            Workspace workspace = ((WorkspaceAware)((Object)t2)).workspace();
            Workspace workspace2 = this;
            if (!(workspace != null ? !workspace.equals(workspace2) : workspace2 != null)) {
                ((WorkspaceAware)((Object)t2)).workspace_$eq(null);
            }
        }
        return entity;
    }

    public void update() {
        this.entities().withFilter((Function1<Entity, Object> & Serializable)entity -> BoxesRunTime.boxToBoolean(entity.needUpdate())).foreach((Function1<Entity, Object> & Serializable)entity -> {
            entity.update();
            return BoxedUnit.UNIT;
        });
        if (!this.ingameTimePaused()) {
            this.ingameTime_$eq(this.ingameTime() + 1);
            this.lastTickNanoTime_$eq(System.nanoTime());
            return;
        }
    }

    public Option<Entity> entityByAddress(String address) {
        return this.entities().find((Function1<Entity, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(Workspace.$anonfun$entityByAddress$1(address, x0$1)));
    }

    public Option<Node> nodeByAddress(String address) {
        Option option;
        Object object = new Object();
        try {
            this.entities().foreach((Function1<Entity, Object> & Serializable)entity -> {
                Workspace.$anonfun$nodeByAddress$1(address, object, entity);
                return BoxedUnit.UNIT;
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private String LeftTag() {
        return this.LeftTag;
    }

    private String RightTag() {
        return this.RightTag;
    }

    private NBTTagCompound buildEdgeNbt(String address1, String address2) {
        NBTTagCompound edgeNbt = new NBTTagCompound();
        edgeNbt.setString(this.LeftTag(), address1);
        edgeNbt.setString(this.RightTag(), address2);
        return edgeNbt;
    }

    private ListBuffer<NBTBase> collectEdges() {
        return (ListBuffer)this.entities().flatMap((Function1<Entity, IterableOnce> & Serializable)x0$1 -> {
            Entity entity = x0$1;
            if (entity instanceof SidedEnvironment) {
                Entity entity2 = entity;
                return (IterableOnce)Direction$.MODULE$.values().unsorted().flatMap((Function1<Enumeration.Value, IterableOnce> & Serializable)d2 -> {
                    Node node = ((SidedEnvironment)((Object)entity2)).sidedNode((Enumeration.Value)d2);
                    if (node != null) {
                        return (IterableOnce)node.neighbors().map((Function1<Node, NBTTagCompound> & Serializable)n2 -> this.buildEdgeNbt(node.address(), n2.address()));
                    }
                    return package$.MODULE$.Seq().empty();
                });
            }
            if (entity instanceof Environment) {
                Entity entity3 = entity;
                return (IterableOnce)((Environment)((Object)entity3)).node().neighbors().map((Function1<Node, NBTTagCompound> & Serializable)n2 -> this.buildEdgeNbt(((Environment)((Object)entity3)).node().address(), n2.address()));
            }
            throw new MatchError(entity);
        });
    }

    private String TimeTag() {
        return this.TimeTag;
    }

    private String TimePausedTag() {
        return this.TimePausedTag;
    }

    private String EdgesTag() {
        return this.EdgesTag;
    }

    private String EntitiesTag() {
        return this.EntitiesTag;
    }

    public void save(NBTTagCompound nbt) {
        nbt.setInteger(this.TimeTag(), this.ingameTime());
        nbt.setBoolean(this.TimePausedTag(), this.ingameTimePaused());
        this.lastTickNanoTime_$eq(System.nanoTime());
        ListBuffer nbtEntities = (ListBuffer)this.entities().map((Function1<Entity, NBTTagCompound> & Serializable)entity -> NBTPersistence$.MODULE$.save((Persistable)entity));
        nbt.setTagList(this.EntitiesTag(), CollectionConverters$.MODULE$.BufferHasAsJava(nbtEntities).asJava());
        ListBuffer<NBTBase> nbtEdges = this.collectEdges();
        nbt.setTagList(this.EdgesTag(), CollectionConverters$.MODULE$.BufferHasAsJava(nbtEdges).asJava());
    }

    public void load(NBTTagCompound nbt2) {
        this.ingameTime_$eq(nbt2.getInteger(this.TimeTag()));
        this.ingameTimePaused_$eq(nbt2.getBoolean(this.TimePausedTag()));
        this.entities().foreach((Function1<Entity, Object> & Serializable)x$1 -> {
            x$1.dispose();
            return BoxedUnit.UNIT;
        });
        this.entities().clear();
        ExtendedNBT$.MODULE$.extendNBTTagList(nbt2.getTagList(this.EntitiesTag(), 10)).foreach((Function1<NBTTagCompound, Object> & Serializable)nbt -> {
            Workspace.$anonfun$load$2(this, nbt);
            return BoxedUnit.UNIT;
        });
        ExtendedNBT$.MODULE$.extendNBTTagList(nbt2.getTagList(this.EdgesTag(), 10)).map((Function1<NBTTagCompound, Object> & Serializable)nbt -> {
            Workspace.$anonfun$load$3(this, nbt);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$entityByAddress$2(Entity x2$1, String address$1, Enumeration.Value dir) {
        if (((SidedEnvironment)((Object)x2$1)).sidedNode(dir) == null) return false;
        String string = ((SidedEnvironment)((Object)x2$1)).sidedNode(dir).address();
        String string2 = address$1;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$entityByAddress$1(String address$1, Entity x0$1) {
        Entity entity = x0$1;
        if (entity instanceof SidedEnvironment) {
            Entity entity2 = entity;
            return Direction$.MODULE$.values().unsorted().exists((Function1<Enumeration.Value, Object> & Serializable)dir -> BoxesRunTime.boxToBoolean(Workspace.$anonfun$entityByAddress$2(entity2, address$1, dir)));
        }
        if (entity instanceof Environment) {
            Entity entity3 = entity;
            String string = ((Environment)((Object)entity3)).node().address();
            String string2 = address$1;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        throw new MatchError(entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$nodeByAddress$2(Entity x2$2, String address$2, Enumeration.Value dir) {
        if (((SidedEnvironment)((Object)x2$2)).sidedNode(dir) == null) return false;
        String string = ((SidedEnvironment)((Object)x2$2)).sidedNode(dir).address();
        String string2 = address$2;
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$nodeByAddress$1(String address$2, Object nonLocalReturnKey1$1, Entity entity) {
        Entity entity2 = entity;
        if (entity2 instanceof SidedEnvironment) {
            Entity entity3 = entity2;
            Option result2 = Direction$.MODULE$.values().unsorted().find((Function1<Enumeration.Value, Object> & Serializable)dir -> BoxesRunTime.boxToBoolean(Workspace.$anonfun$nodeByAddress$2(entity3, address$2, dir))).map((Function1<Enumeration.Value, Node> & Serializable)dir -> ((SidedEnvironment)((Object)entity3)).sidedNode((Enumeration.Value)dir));
            if (result2.nonEmpty()) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, result2);
            }
            return;
        }
        if (entity2 instanceof Environment) {
            Entity entity4 = entity2;
            String string = ((Environment)((Object)entity4)).node().address();
            String string2 = address$2;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new NonLocalReturnControl<Some<Node>>(nonLocalReturnKey1$1, new Some<Node>(((Environment)((Object)entity4)).node()));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$load$2(Workspace $this, NBTTagCompound nbt) {
        Entity entity = (Entity)NBTPersistence$.MODULE$.load(nbt, $this);
        $this.add(entity);
    }

    public static final /* synthetic */ void $anonfun$load$3(Workspace $this, NBTTagCompound nbt) {
        Option<Node> left = $this.nodeByAddress(nbt.getString($this.LeftTag()));
        Option<Node> right = $this.nodeByAddress(nbt.getString($this.RightTag()));
        if (left.isDefined() && right.isDefined()) {
            if (!left.get().isNeighborOf(right.get())) {
                left.get().connect(right.get());
                return;
            }
            return;
        }
    }

    public Workspace(Path path) {
        this.path = path;
        this.random = new Random(System.currentTimeMillis());
        this.tapeStorage = new StorageManager(this);
        this.ingameTime = 0;
        this.ingameTimePaused = false;
        this.lastTickNanoTime = System.nanoTime();
        this.entities = ListBuffer$.MODULE$.empty();
        this.LeftTag = "left";
        this.RightTag = "right";
        this.TimeTag = "time";
        this.TimePausedTag = "time_paused";
        this.EdgesTag = "edges";
        this.EntitiesTag = "entities";
    }
}

