/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

public class GsmEncoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    protected static final int ORDER = 8;
    protected static final int BLOCKSIZE = 160;
    protected static final int SBLOCKSIZE = 40;
    protected static final int SBLOCKS = 4;
    protected static final int SUBSAMPBLOCKS = 4;
    protected static final int SUBSAMPSIZE = 13;
    protected static final int nPARAMETERS = 77;
    private static final int INTERPLAR = 4;
    public static final boolean USE_VAD = true;
    public static final boolean NO_VAD = false;
    public static final boolean GSM_FULL = true;
    public static final boolean GSM_LIGHT = false;
    protected int sidUpdateRate = 0;
    public static final int GSM_SPEECH_FRAME = 0;
    public static final int GSM_SID_FRAME = 1;
    public static final int GSM_SILENCE_FRAME = 2;
    protected int frameType = 0;
    protected boolean vadSupportFlag;
    protected float data_buffer;
    protected float data_scaledSample;
    protected int data_blockNumber;
    protected float[] aux_correlations = new float[121];
    protected int[] data_Nc = new int[4];
    protected float[] data_LAR = new float[8];
    protected float[] data_currentxmax = new float[4];
    protected int[] data_Parameters = new int[77];
    protected int data_pParams;
    protected float[] data_wt = new float[50];
    protected float[] data_u = new float[9];
    protected float[] data_prevLARpp = new float[9];
    protected boolean data_complexity_mode;
    protected boolean data_vad_mode;
    protected float[] data_residual = new float[280];
    protected int data_residual_Index;
    protected float[] data_input = new float[160];
    protected float[] data_first_res = new float[160];
    protected float[] data_acf = new float[9];
    protected float[] data_r = new float[9];
    protected float[] data_LARpp = new float[9];
    protected float[] aux_decimated_subsegment = new float[20];
    protected float[] aux_decimated_q_frstbase = new float[60];
    protected float[] aux_decimated_correlations = new float[41];
    protected float[] aux_KK = new float[9];
    protected float[] aux_P = new float[9];
    protected float[] encode_outsegment = new float[40];
    protected int[] encode_pitchArray = new int[1];
    protected float[] aux_rp = new float[9];
    protected static float[] lut_A = new float[]{0.0f, 20.0f, 20.0f, 20.0f, 20.0f, 13.637f, 15.0f, 8.334f, 8.824f};
    protected static float[] lut_INVA = new float[]{0.0f, 0.05f, 0.05f, 0.05f, 0.05f, 0.07332991f, 0.06666667f, 0.11999041f, 0.11332729f};
    protected static float[] lut_MIC = new float[]{0.0f, -32.0f, -32.0f, -16.0f, -16.0f, -8.0f, -8.0f, -4.0f, -4.0f};
    protected static float[] lut_MAC = new float[]{0.0f, 31.0f, 31.0f, 15.0f, 15.0f, 7.0f, 7.0f, 3.0f, 3.0f};
    protected static float[] lut_B = new float[]{0.0f, 0.0f, 0.0f, 4.0f, -5.0f, 0.184f, -3.5f, -0.666f, -2.235f};
    protected static int[] lut_k_start = new int[]{0, 13, 27, 40, 160};
    protected static int[] lut_lg2s = new int[32];
    private static final int GSM_MAGIC = 13;

    public boolean isVADsupported() {
        return this.vadSupportFlag;
    }

    public void setVAD(boolean newVAD) {
        this.data_vad_mode = this.vadSupportFlag ? newVAD : false;
    }

    public boolean getVAD() {
        return this.data_vad_mode;
    }

    public void setSIDupdateRate(int newSIDupdateRate) {
        this.sidUpdateRate = newSIDupdateRate;
    }

    public void setComplexity(boolean newcomplexity) {
        this.data_complexity_mode = newcomplexity;
    }

    public boolean getComplexity() {
        return this.data_complexity_mode;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void gsm_encoder_close() {
    }

    public void gsm_encoder_reset() {
        this.data_buffer = 0.0f;
        this.data_scaledSample = 0.0f;
        int i2 = 0;
        while (i2 < this.data_first_res.length) {
            this.data_first_res[i2] = 0.0f;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.data_residual.length) {
            this.data_residual[i2] = 0.0f;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.data_u.length) {
            this.data_u[i2] = 0.0f;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.data_prevLARpp.length) {
            this.data_prevLARpp[i2] = 0.0f;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.data_wt.length) {
            this.data_wt[i2] = 0.0f;
            ++i2;
        }
        this.data_complexity_mode = true;
        this.data_vad_mode = false;
        this.data_Parameters[76] = 0;
        this.vadSupportFlag = false;
    }

    public void gsm_encode_frame(byte[] input_samples, int input_offset, byte[] output_bits, int output_offset) {
        float[] outsegment = this.encode_outsegment;
        float[] input = this.data_input;
        float[] first_res = this.data_first_res;
        float[] acf = this.data_acf;
        float[] r = this.data_r;
        float[] LARpp = this.data_LARpp;
        int[] pitchArray = this.encode_pitchArray;
        int i2 = 0;
        while (i2 < 160) {
            int temp = input_samples[2 * i2 + input_offset] & 0xFF | input_samples[2 * i2 + input_offset + 1] << 8;
            input[i2] = (float)temp * 3.0517578E-5f;
            ++i2;
        }
        this.PreProcessing(input, first_res);
        this.Autocorrelations(first_res, acf);
        this.schurRecursion(acf, r);
        this.rToLAR(r, LARpp);
        this.latticeFilter(LARpp, first_res);
        this.data_residual_Index = 120;
        int blocknumber = 0;
        while (blocknumber < 4) {
            this.data_blockNumber = blocknumber;
            float max_corr = this.data_complexity_mode ? this.calculatePitch(first_res, blocknumber * 40, pitchArray) : this.calculatePitch_Light(first_res, blocknumber * 40, pitchArray);
            int pitch = pitchArray[0];
            float gain = this.calculatePitchGain(max_corr, pitch);
            int offset = this.analizeSecondResidual(gain, pitch, first_res, blocknumber * 40, outsegment);
            this.quantizeSecondResidual(offset, outsegment);
            this.data_residual_Index += 40;
            ++blocknumber;
        }
        if (this.data_vad_mode) {
            this.doVAD();
        } else {
            this.frameType = 0;
        }
        this.packBitStream(output_bits, output_offset);
        System.arraycopy(this.data_residual, 160, this.data_residual, 0, 120);
    }

    protected void doVAD() {
    }

    void PreProcessing(float[] input, float[] output) {
        float buffer = this.data_buffer;
        float scaledSample = this.data_scaledSample;
        int i2 = 0;
        while (i2 < 160) {
            float temp = scaledSample;
            scaledSample = input[i2] * 0.5f;
            output[i2] = buffer * -0.85998535f;
            buffer = scaledSample - temp + 0.9989929f * buffer;
            int n2 = i2++;
            output[n2] = output[n2] + (buffer + 1.0E-15f);
        }
        this.data_buffer = buffer;
        this.data_scaledSample = scaledSample;
    }

    void Autocorrelations(float[] firstResidual, float[] AutoCorrelations) {
        int correlNumber = 0;
        while (correlNumber <= 8) {
            float result2 = 0.0f;
            int i2 = correlNumber;
            while (i2 < 160) {
                result2 += firstResidual[i2] * firstResidual[i2 - correlNumber];
                ++i2;
            }
            AutoCorrelations[correlNumber] = result2;
            ++correlNumber;
        }
    }

    void schurRecursion(float[] AutoCorrelations, float[] reflectionCoef) {
        float[] KK = this.aux_KK;
        float[] P2 = this.aux_P;
        if (AutoCorrelations[0] == 0.0f) {
            int i2 = 1;
            while (i2 <= 8) {
                reflectionCoef[i2] = 0.0f;
                ++i2;
            }
            return;
        }
        P2[0] = AutoCorrelations[0];
        int i2 = 1;
        while (i2 <= 8) {
            float f2 = AutoCorrelations[i2];
            KK[9 - i2] = f2;
            P2[i2] = f2;
            ++i2;
        }
        i2 = 1;
        while (i2 <= 8) {
            int k2;
            float temp;
            float f3 = temp = P2[1] > 0.0f ? P2[1] : -P2[1];
            if (P2[0] < temp) {
                k2 = i2;
                while (k2 <= 8) {
                    reflectionCoef[k2] = 0.0f;
                    ++k2;
                }
                return;
            }
            reflectionCoef[i2] = temp / P2[0];
            if ((double)P2[1] > 0.0) {
                reflectionCoef[i2] = -reflectionCoef[i2];
            }
            if (i2 == 8) {
                return;
            }
            P2[0] = P2[0] + P2[1] * reflectionCoef[i2];
            k2 = 1;
            while (k2 <= 8 - i2) {
                P2[k2] = P2[k2 + 1] + KK[9 - k2] * reflectionCoef[i2];
                KK[9 - k2] = KK[9 - k2] + P2[k2 + 1] * reflectionCoef[i2];
                ++k2;
            }
            ++i2;
        }
    }

    void rToLAR(float[] r, float[] LARpp) {
        float[] MIC = lut_MIC;
        float[] MAC = lut_MAC;
        float[] A = lut_A;
        float[] B = lut_B;
        float[] INVA = lut_INVA;
        int[] Parameters2 = this.data_Parameters;
        int pParams = 0;
        float[] LAR = this.data_LAR;
        int i2 = 1;
        while (i2 <= 8) {
            float temp;
            if ((double)r[i2] >= 1.0) {
                temp = MAC[i2];
                LAR[i2 - 1] = 1.625f;
            } else if ((double)r[i2] <= -1.0) {
                temp = MIC[i2];
                LAR[i2 - 1] = -1.625f;
            } else {
                float sgnReflectionCoef;
                float absReflectionCoef;
                float reflectionCoef = r[i2];
                if (reflectionCoef > 0.0f) {
                    absReflectionCoef = reflectionCoef;
                    sgnReflectionCoef = 1.0f;
                } else {
                    absReflectionCoef = -reflectionCoef;
                    sgnReflectionCoef = -1.0f;
                }
                float lar = absReflectionCoef < 0.675f ? reflectionCoef : (absReflectionCoef < 0.95f ? sgnReflectionCoef * (2.0f * absReflectionCoef - 0.675f) : sgnReflectionCoef * (8.0f * absReflectionCoef - 6.375f));
                LAR[i2 - 1] = lar;
                temp = A[i2] * lar + B[i2];
                temp = temp >= 0.0f ? (float)((double)temp + 0.5) : (float)((double)temp - 0.5);
                temp = (int)temp;
                if (temp > MAC[i2]) {
                    temp = MAC[i2];
                }
                if (temp < MIC[i2]) {
                    temp = MIC[i2];
                }
            }
            Parameters2[pParams++] = (int)(temp -= MIC[i2]);
            LARpp[i2] = (temp + MIC[i2] - B[i2]) * INVA[i2];
            ++i2;
        }
        this.data_pParams = pParams;
    }

    void latticeFilter(float[] LARpp, float[] first_res) {
        float[] rp = this.aux_rp;
        float[] u = this.data_u;
        float[] prevLARpp = this.data_prevLARpp;
        int[] k_start = lut_k_start;
        int j2 = 0;
        while (j2 < 4) {
            float PrevCoef = 0.75f - (float)j2 * 0.25f;
            float PresentCoef = 1.0f - PrevCoef;
            int i2 = 1;
            while (i2 <= 8) {
                float sgnLar;
                float absLar;
                float lar = prevLARpp[i2] * PrevCoef + LARpp[i2] * PresentCoef;
                if (lar > 0.0f) {
                    absLar = lar;
                    sgnLar = 1.0f;
                } else {
                    absLar = -lar;
                    sgnLar = -1.0f;
                }
                float reflectionCoef = absLar < 0.675f ? lar : (absLar < 1.225f ? sgnLar * (0.5f * absLar + 0.3375f) : sgnLar * (0.125f * absLar + 0.796875f));
                rp[i2] = reflectionCoef;
                ++i2;
            }
            float u0 = u[0];
            float u1 = u[1];
            float u2 = u[2];
            float u3 = u[3];
            float u4 = u[4];
            float u5 = u[5];
            float u6 = u[6];
            float u7 = u[7];
            float rp1 = rp[1];
            float rp2 = rp[2];
            float rp3 = rp[3];
            float rp4 = rp[4];
            float rp5 = rp[5];
            float rp6 = rp[6];
            float rp7 = rp[7];
            float rp8 = rp[8];
            int k_end = k_start[j2 + 1];
            int k2 = k_start[j2];
            while (k2 < k_end) {
                float di;
                float temp2 = di = first_res[k2];
                float temp = u0 + rp1 * di;
                u0 = temp2;
                temp2 = temp;
                temp = u1 + rp2 * (di += rp1 * u0);
                u1 = temp2;
                temp2 = temp;
                temp = u2 + rp3 * (di += rp2 * u1);
                u2 = temp2;
                temp2 = temp;
                temp = u3 + rp4 * (di += rp3 * u2);
                u3 = temp2;
                temp2 = temp;
                temp = u4 + rp5 * (di += rp4 * u3);
                u4 = temp2;
                temp2 = temp;
                temp = u5 + rp6 * (di += rp5 * u4);
                u5 = temp2;
                temp2 = temp;
                temp = u6 + rp7 * (di += rp6 * u5);
                u6 = temp2;
                temp2 = temp;
                temp = u7 + rp8 * (di += rp7 * u6);
                u7 = temp2;
                temp2 = temp;
                first_res[k2] = di += rp8 * u7;
                ++k2;
            }
            u[0] = u0;
            u[1] = u1;
            u[2] = u2;
            u[3] = u3;
            u[4] = u4;
            u[5] = u5;
            u[6] = u6;
            u[7] = u7;
            rp[1] = rp1;
            rp[2] = rp2;
            rp[3] = rp3;
            rp[4] = rp4;
            rp[5] = rp5;
            rp[6] = rp6;
            rp[7] = rp7;
            rp[8] = rp8;
            ++j2;
        }
        System.arraycopy(LARpp, 1, prevLARpp, 1, 8);
    }

    private float calculatePitch(float[] subsegment, int seg_offset, int[] pitch) {
        int jj;
        float max_corr = 0.0f;
        float[] correlations = this.aux_correlations;
        int[] Nc = this.data_Nc;
        int blocknumber = this.data_blockNumber;
        int residual_Index = this.data_residual_Index;
        float[] residual = this.data_residual;
        int pParams = this.data_pParams;
        int[] Parameters2 = this.data_Parameters;
        pitch[0] = 40;
        int ii = 40;
        while (ii <= 120) {
            float result1 = 0.0f;
            float result2 = 0.0f;
            float result3 = 0.0f;
            float residual_p1 = residual[residual_Index - 1 - ii];
            float residual_p0 = residual[residual_Index - 2 - ii];
            jj = 0;
            while (jj < 40) {
                float subsegment_temp0 = subsegment[seg_offset + jj];
                float subsegment_temp1 = subsegment[seg_offset + jj + 1];
                int temp_index = residual_Index + jj - ii;
                float residual_n1 = residual_p1;
                float residual_n2 = residual_p0;
                residual_p1 = residual[temp_index + 1];
                residual_p0 = residual[temp_index];
                result1 += subsegment_temp0 * residual_p0 + subsegment_temp1 * residual_p1;
                result2 += subsegment_temp0 * residual_n1 + subsegment_temp1 * residual_p0;
                result3 += subsegment_temp0 * residual_n2 + subsegment_temp1 * residual_n1;
                jj += 2;
            }
            correlations[ii] = result1;
            correlations[ii + 1] = result2;
            correlations[ii + 2] = result3;
            ii += 3;
        }
        jj = 40;
        while (jj <= 120) {
            if (max_corr < correlations[jj]) {
                max_corr = correlations[jj];
                pitch[0] = jj;
            }
            ++jj;
        }
        int n2 = pParams++;
        int n3 = pitch[0];
        Parameters2[n2] = n3;
        Nc[blocknumber] = n3;
        this.data_pParams = pParams;
        return max_corr;
    }

    private float calculatePitch_Light(float[] subsegment, int seg_offset, int[] pitch) {
        float result2;
        float result1;
        float max_corr = 0.0f;
        float[] correlations = this.aux_correlations;
        int[] Nc = this.data_Nc;
        int blocknumber = this.data_blockNumber;
        int residual_Index = this.data_residual_Index;
        float[] residual = this.data_residual;
        int pParams = this.data_pParams;
        int[] Parameters2 = this.data_Parameters;
        float[] decimated_subsegment = this.aux_decimated_subsegment;
        float[] decimated_q_frstbase = this.aux_decimated_q_frstbase;
        float[] decimated_correlations = this.aux_decimated_correlations;
        decimated_subsegment[0] = 0.5f * (subsegment[seg_offset + 0] + subsegment[seg_offset + 1]);
        int ii = 1;
        int jj = 2;
        while (ii <= 19) {
            decimated_subsegment[ii] = 0.25f * (subsegment[seg_offset + jj - 1] + subsegment[seg_offset + jj + 1]) + 0.5f * subsegment[seg_offset + jj];
            ++ii;
            jj += 2;
        }
        decimated_q_frstbase[0] = 0.5f * (residual[residual_Index - 120] + residual[residual_Index - 119]);
        ii = 1;
        jj = -118;
        while (ii <= 59) {
            int index = residual_Index + jj;
            decimated_q_frstbase[ii] = 0.25f * (residual[index - 1] + residual[index + 1]) + 0.5f * residual[index];
            ++ii;
            jj += 2;
        }
        int decimated_q_frstbase_index = 60;
        ii = 20;
        while (ii < 60) {
            result1 = 0.0f;
            result2 = 0.0f;
            jj = 0;
            while (jj < 20) {
                float decimatedSubsegmentSample0 = decimated_subsegment[jj];
                float decimatedSubsegmentSample1 = decimated_subsegment[jj + 1];
                int index = decimated_q_frstbase_index + jj - ii;
                result1 += decimatedSubsegmentSample0 * decimated_q_frstbase[index] + decimatedSubsegmentSample1 * decimated_q_frstbase[index + 1];
                result2 += decimatedSubsegmentSample0 * decimated_q_frstbase[index - 1] + decimatedSubsegmentSample1 * decimated_q_frstbase[index];
                jj += 2;
            }
            decimated_correlations[ii - 20] = result1;
            decimated_correlations[ii + 1 - 20] = result2;
            ii += 2;
        }
        result1 = 0.0f;
        jj = 0;
        while (jj < 20) {
            result1 += decimated_subsegment[jj] * decimated_q_frstbase[decimated_q_frstbase_index + jj - ii];
            ++jj;
        }
        decimated_correlations[ii - 20] = result1;
        int decimated_pitch = 20;
        max_corr = 0.0f;
        jj = 20;
        while (jj <= 60) {
            if (max_corr < decimated_correlations[jj - 20]) {
                max_corr = decimated_correlations[jj - 20];
                decimated_pitch = jj;
            }
            ++jj;
        }
        ii = 2 * decimated_pitch - 1;
        if (ii == 39) {
            ii = 40;
        }
        if (ii == 119) {
            ii = 118;
        }
        result1 = 0.0f;
        result2 = 0.0f;
        float result3 = 0.0f;
        jj = 0;
        while (jj <= 39) {
            int index = residual_Index + jj - ii;
            float subsegmentSample = subsegment[seg_offset + jj];
            result1 += subsegmentSample * residual[index];
            result2 += subsegmentSample * residual[index - 1];
            result3 += subsegmentSample * residual[index - 2];
            ++jj;
        }
        correlations[ii] = result1;
        correlations[ii + 1] = result2;
        correlations[ii + 2] = result3;
        pitch[0] = 40;
        max_corr = 0.0f;
        jj = ii;
        while (jj <= ii + 2) {
            if (max_corr < correlations[jj]) {
                max_corr = correlations[jj];
                pitch[0] = jj;
            }
            ++jj;
        }
        int n2 = pParams++;
        int n3 = pitch[0];
        Parameters2[n2] = n3;
        Nc[blocknumber] = n3;
        this.data_pParams = pParams;
        return max_corr;
    }

    private final float calculatePitchGain(float max_corr, int pitch) {
        float gain;
        float[] residual = this.data_residual;
        int residual_Index = this.data_residual_Index;
        int pParams = this.data_pParams;
        int[] Parameters2 = this.data_Parameters;
        float power = 0.0f;
        int index = residual_Index - pitch;
        int i2 = 0;
        while (i2 < 40) {
            float sample = residual[index++];
            power += sample * sample;
            ++i2;
        }
        if ((double)max_corr <= 0.2 * (double)power) {
            Parameters2[pParams++] = 0;
            gain = 0.1f;
        } else if ((double)max_corr <= 0.5 * (double)power) {
            Parameters2[pParams++] = 1;
            gain = 0.35f;
        } else if ((double)max_corr <= 0.8 * (double)power) {
            Parameters2[pParams++] = 2;
            gain = 0.65f;
        } else {
            Parameters2[pParams++] = 3;
            gain = 1.0f;
        }
        this.data_pParams = pParams;
        return gain;
    }

    private final int analizeSecondResidual(float gain, int pitch, float[] subsegment, int subseg_ofs, float[] outsegment) {
        int Mc = 0;
        float EM = 0.0f;
        float[] wt = this.data_wt;
        int residual_Index = this.data_residual_Index;
        float[] residual = this.data_residual;
        int pParams = this.data_pParams;
        int[] Parameters2 = this.data_Parameters;
        int residual_index = residual_Index;
        int i2 = 0;
        while (i2 < 40) {
            float pitchPredictSample;
            residual[residual_index] = pitchPredictSample = gain * residual[residual_index - pitch];
            wt[5 + i2] = subsegment[subseg_ofs + i2] - pitchPredictSample;
            ++residual_index;
            ++i2;
        }
        int i3 = 0;
        while (i3 < 40) {
            outsegment[i3] = -0.016357422f * (wt[i3] + wt[i3 + 10]) + -0.045654297f * (wt[i3 + 1] + wt[i3 + 9]) + 0.25073242f * (wt[i3 + 3] + wt[i3 + 7]) + 0.70080566f * (wt[i3 + 4] + wt[i3 + 6]) + wt[i3 + 5];
            ++i3;
        }
        int j2 = 0;
        while (j2 <= 3) {
            float temp = 0.0f;
            int index = j2;
            int i4 = 0;
            while (i4 <= 12) {
                float sample = outsegment[index];
                index += 3;
                temp += sample * sample;
                ++i4;
            }
            if (EM < temp) {
                Mc = j2;
                EM = temp;
            }
            ++j2;
        }
        Parameters2[pParams++] = Mc;
        this.data_pParams = pParams;
        return Mc;
    }

    private final void quantizeSecondResidual(int Mc, float[] outsegment) {
        int xmaxc;
        float xmaxp;
        int tempint;
        int blocknumber = this.data_blockNumber;
        float[] currentxmax = this.data_currentxmax;
        float[] residual = this.data_residual;
        int residual_Index = this.data_residual_Index;
        int[] lg2s = lut_lg2s;
        int pParams = this.data_pParams;
        int[] Parameters2 = this.data_Parameters;
        float xmax = 0.0f;
        int i2 = 0;
        while (i2 < 13) {
            float temp = outsegment[Mc + i2 * 3];
            if (temp > xmax) {
                xmax = temp;
            } else if (-temp > xmax) {
                xmax = -temp;
            }
            ++i2;
        }
        currentxmax[blocknumber] = xmax;
        if (xmax < 0.015625f) {
            tempint = (int)(xmax * 1024.0f);
            Parameters2[pParams++] = tempint;
            xmaxp = 31 + tempint * 32;
            xmaxc = (int)(xmax * 1024.0f);
        } else {
            tempint = (int)(32768.0f * xmax);
            if ((tempint >>= 10) < 31) {
                i2 = lg2s[tempint];
                xmaxc = (int)((float)(i2 << 3) + xmax * (float)(1024 >> i2));
                Parameters2[pParams++] = xmaxc;
                xmaxp = (256 << i2) + (32 << i2) - 1 + (xmaxc - 8 - 8 * i2) * (32 << i2);
            } else {
                Parameters2[pParams++] = 63;
                xmaxc = 63;
                xmaxp = 32767.0f;
            }
        }
        float div_xmaxp = 1.0f / xmaxp;
        i2 = 0;
        while (i2 < 13) {
            tempint = (int)(outsegment[Mc + i2 * 3] * div_xmaxp * 262144.0f);
            if (tempint > 7) {
                tempint = 7;
            } else if (tempint < -7) {
                tempint = -7;
            }
            tempint = tempint + 7 >> 1;
            Parameters2[pParams++] = tempint;
            int n2 = residual_Index + Mc + i2 * 3;
            residual[n2] = residual[n2] + (0.25f * (float)tempint - 0.875f) * 3.0517578E-5f * xmaxp;
            ++i2;
        }
        this.data_pParams = pParams;
    }

    protected void packBitStream(byte[] outputBits, int output_offset) {
        int[] Params2 = this.data_Parameters;
        int outPtr = output_offset;
        outputBits[outPtr++] = (byte)(0xD0 | Params2[0] >> 2 & 0xF);
        outputBits[outPtr++] = (byte)((Params2[0] & 3) << 6 | Params2[1] & 0x3F);
        outputBits[outPtr++] = (byte)((Params2[2] & 0x1F) << 3 | Params2[3] >> 2 & 7);
        outputBits[outPtr++] = (byte)((Params2[3] & 3) << 6 | (Params2[4] & 0xF) << 2 | Params2[5] >> 2 & 3);
        outputBits[outPtr++] = (byte)((Params2[5] & 3) << 6 | (Params2[6] & 7) << 3 | Params2[7] & 7);
        int paramPtr = 8;
        int blocknum = 0;
        while (blocknum < 4) {
            outputBits[outPtr++] = (byte)((Params2[paramPtr++] & 0x7F) << 1 | Params2[paramPtr] >> 1 & 1);
            outputBits[outPtr++] = (byte)((Params2[paramPtr++] & 1) << 7 | (Params2[paramPtr++] & 3) << 5 | Params2[paramPtr] >> 1 & 0x1F);
            outputBits[outPtr++] = (byte)((Params2[paramPtr++] & 1) << 7 | (Params2[paramPtr++] & 7) << 4 | (Params2[paramPtr++] & 7) << 1 | Params2[paramPtr] >> 2 & 1);
            outputBits[outPtr++] = (byte)((Params2[paramPtr++] & 3) << 6 | (Params2[paramPtr++] & 7) << 3 | Params2[paramPtr++] & 7);
            outputBits[outPtr++] = (byte)((Params2[paramPtr++] & 7) << 5 | (Params2[paramPtr++] & 7) << 2 | Params2[paramPtr] >> 1 & 3);
            outputBits[outPtr++] = (byte)((Params2[paramPtr++] & 1) << 7 | (Params2[paramPtr++] & 7) << 4 | (Params2[paramPtr++] & 7) << 1 | Params2[paramPtr] >> 2 & 1);
            outputBits[outPtr++] = (byte)((Params2[paramPtr++] & 3) << 6 | (Params2[paramPtr++] & 7) << 3 | Params2[paramPtr++] & 7);
            ++blocknum;
        }
    }

    static {
        int temp_index = 0;
        GsmEncoder.lut_lg2s[temp_index++] = 1;
        GsmEncoder.lut_lg2s[temp_index++] = 2;
        int ii = 3;
        while (ii <= 6) {
            int jj = 1;
            while (jj <= 1 << ii - 2) {
                GsmEncoder.lut_lg2s[temp_index++] = ii;
                ++jj;
            }
            ++ii;
        }
    }
}

