/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicInputConnector;
import com.sun.media.BasicSinkModule;
import com.sun.media.Connector;
import com.sun.media.InputConnector;
import com.sun.media.Log;
import com.sun.media.PlaybackEngine;
import com.sun.media.util.ElapseTime;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.Prefetchable;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;

public class BasicMuxModule
extends BasicSinkModule {
    protected Multiplexer multiplexer;
    protected Format[] inputs;
    protected InputConnector[] ics;
    protected boolean[] prefetchMarkers;
    protected boolean[] endMarkers;
    protected boolean[] resettedMarkers;
    protected boolean[] stopAtTimeMarkers;
    protected boolean[] paused;
    protected boolean[] prerollTrack;
    private Object[] pauseSync;
    protected ElapseTime[] elapseTime;
    protected boolean prefetching = false;
    protected boolean started = false;
    private boolean closed = false;
    private boolean failed = false;
    private Object prefetchSync = new Object();
    private float frameRate = 30.0f;
    private float lastFramesBehind = -1.0f;
    private int framesPlayed = 0;
    private VideoFormat rtpVideoFormat = null;
    private VideoFormat firstVideoFormat = null;
    public static String ConnectorNamePrefix = "input";
    private long bitsWritten = 0L;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");

    protected BasicMuxModule(Multiplexer m2, Format[] inputs) {
        this.multiplexer = m2;
        if (inputs != null) {
            this.ics = new InputConnector[inputs.length];
            int i2 = 0;
            while (i2 < inputs.length) {
                MyInputConnector ic = new MyInputConnector();
                ic.setSize(1);
                ic.setModule(this);
                this.registerInputConnector(ConnectorNamePrefix + i2, ic);
                this.ics[i2] = ic;
                if (inputs[i2] instanceof VideoFormat && this.firstVideoFormat == null) {
                    this.firstVideoFormat = (VideoFormat)inputs[i2];
                    String encoding = inputs[i2].getEncoding().toUpperCase();
                    if (encoding.endsWith("RTP")) {
                        this.rtpVideoFormat = this.firstVideoFormat;
                    }
                }
                ++i2;
            }
            this.inputs = inputs;
        }
        if (this.multiplexer != null && this.multiplexer instanceof Clock) {
            this.setClock((Clock)((Object)this.multiplexer));
        }
        this.setProtocol(0);
    }

    public boolean isThreaded() {
        return false;
    }

    public boolean doRealize() {
        if (this.multiplexer == null || this.inputs == null) {
            return false;
        }
        try {
            this.multiplexer.open();
        }
        catch (ResourceUnavailableException e2) {
            return false;
        }
        this.prefetchMarkers = new boolean[this.ics.length];
        this.endMarkers = new boolean[this.ics.length];
        this.resettedMarkers = new boolean[this.ics.length];
        this.stopAtTimeMarkers = new boolean[this.ics.length];
        this.paused = new boolean[this.ics.length];
        this.prerollTrack = new boolean[this.ics.length];
        this.pauseSync = new Object[this.ics.length];
        this.elapseTime = new ElapseTime[this.ics.length];
        int i2 = 0;
        while (i2 < this.ics.length) {
            this.prerollTrack[i2] = false;
            this.pauseSync[i2] = new Object();
            this.elapseTime[i2] = new ElapseTime();
            ++i2;
        }
        this.pause();
        return true;
    }

    public boolean doPrefetch() {
        if (!((PlaybackEngine)this.controller).prefetchEnabled) {
            return true;
        }
        this.resetPrefetchMarkers();
        this.prefetching = true;
        this.resume();
        return true;
    }

    public void doFailedPrefetch() {
        this.prefetching = false;
    }

    public void abortPrefetch() {
        this.prefetching = false;
    }

    public void setPreroll(long wanted, long actual) {
        super.setPreroll(wanted, actual);
        int i2 = 0;
        while (i2 < this.elapseTime.length) {
            this.elapseTime[i2].setValue(actual);
            this.prerollTrack[i2] = !(this.inputs[i2] instanceof AudioFormat) || !mpegAudio.matches(this.inputs[i2]);
            ++i2;
        }
    }

    public void doStart() {
        super.doStart();
        this.resetEndMarkers();
        this.resetStopAtTimeMarkers();
        this.started = true;
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            this.resume();
        }
    }

    public void doStop() {
        super.doStop();
        this.started = false;
        this.resetPrefetchMarkers();
        this.prefetching = true;
    }

    public void doDealloc() {
    }

    public void doClose() {
        this.multiplexer.close();
        this.closed = true;
        int i2 = 0;
        while (i2 < this.pauseSync.length) {
            Object object = this.pauseSync[i2];
            synchronized (object) {
                this.pauseSync[i2].notifyAll();
            }
            ++i2;
        }
    }

    void pause() {
        int i2 = 0;
        while (i2 < this.paused.length) {
            this.paused[i2] = true;
            ++i2;
        }
    }

    void resume() {
        int i2 = 0;
        while (i2 < this.pauseSync.length) {
            Object object = this.pauseSync[i2];
            synchronized (object) {
                this.paused[i2] = false;
                this.pauseSync[i2].notifyAll();
            }
            ++i2;
        }
    }

    public void connectorPushed(InputConnector ic) {
        int idx = -1;
        if (this.ics[0] == ic) {
            idx = 0;
        } else if (this.ics[1] == ic) {
            idx = 1;
        } else {
            int i2 = 2;
            while (i2 < this.ics.length) {
                if (this.ics[i2] == ic) {
                    idx = i2;
                    break;
                }
                ++i2;
            }
            if (idx == -1) {
                throw new RuntimeException("BasicMuxModule: unmatched input connector!");
            }
        }
        while (true) {
            if (this.paused[idx]) {
                Object i2 = this.pauseSync[idx];
                synchronized (i2) {
                    try {
                        while (this.paused[idx] && !this.closed) {
                            this.pauseSync[idx].wait();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            if (this.stopTime <= -1L || this.elapseTime[idx].value < this.stopTime) break;
            this.paused[idx] = true;
            if (!this.checkStopAtTime(idx)) continue;
            if (this.multiplexer instanceof Drainable) {
                ((Drainable)((Object)this.multiplexer)).drain();
            }
            this.doStop();
            if (this.moduleListener == null) continue;
            this.moduleListener.stopAtTime(this);
        }
        Buffer buffer = ic.getValidBuffer();
        int flags = buffer.getFlags();
        int rc = 0;
        if (this.resetted) {
            if ((flags & 0x200) != 0 && this.checkResetted(idx)) {
                this.resetted = false;
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.resetted(this);
                }
            }
            ic.readReport();
            return;
        }
        if (this.failed || this.closed || buffer.isDiscard()) {
            ic.readReport();
            return;
        }
        if (PlaybackEngine.DEBUG) {
            this.jmd.moduleIn(this, 0, buffer, true);
        }
        if ((flags & 0x400) != 0 && this.moduleListener != null) {
            this.moduleListener.markedDataArrived(this, buffer);
            buffer.setFlags(flags &= 0xFFFFFBFF);
        }
        boolean dataPrerolled = false;
        Format format2 = buffer.getFormat();
        if (format2 == null) {
            format2 = ic.getFormat();
            buffer.setFormat(format2);
        }
        if (this.elapseTime[idx].update(buffer.getLength(), buffer.getTimeStamp(), format2)) {
            if (this.prerollTrack[idx]) {
                long target = this.getMediaNanoseconds();
                if (this.elapseTime[idx].value > target) {
                    if (format2 instanceof AudioFormat && "LINEAR".equals(format2.getEncoding())) {
                        int remain = (int)ElapseTime.audioTimeToLen(this.elapseTime[idx].value - target, (AudioFormat)format2);
                        int offset = buffer.getOffset() + buffer.getLength() - remain;
                        if (offset >= 0) {
                            buffer.setOffset(offset);
                            buffer.setLength(remain);
                        }
                    }
                    this.prerollTrack[idx] = false;
                    this.elapseTime[idx].setValue(target);
                } else {
                    dataPrerolled = true;
                }
            }
            if (this.stopTime > -1L && this.elapseTime[idx].value > this.stopTime && format2 instanceof AudioFormat) {
                long exceeded = this.elapseTime[idx].value - this.stopTime;
                int exceededLen = (int)ElapseTime.audioTimeToLen(exceeded, (AudioFormat)format2);
                if (buffer.getLength() > exceededLen) {
                    buffer.setLength(buffer.getLength() - exceededLen);
                }
            }
        }
        if (this.moduleListener != null && format2 instanceof VideoFormat) {
            long mt = this.getMediaNanoseconds();
            long lateBy = mt / 1000000L - buffer.getTimeStamp() / 1000000L - this.getLatency() / 1000000L;
            float fb = (float)lateBy * this.frameRate / 1000.0f;
            if (fb < 0.0f) {
                fb = 0.0f;
            }
            if (this.lastFramesBehind != fb && (flags & 0x20) == 0) {
                this.moduleListener.framesBehind(this, fb, ic);
                this.lastFramesBehind = fb;
            }
        }
        do {
            if (!dataPrerolled) {
                block55: {
                    try {
                        rc = this.multiplexer.process(buffer, idx);
                    }
                    catch (Throwable e3) {
                        Log.dumpStack(e3);
                        if (this.moduleListener == null) break block55;
                        this.moduleListener.internalErrorOccurred(this);
                    }
                }
                if (rc == 0 && format2 == this.firstVideoFormat) {
                    if (format2 == this.rtpVideoFormat) {
                        if ((flags & 0x800) > 0) {
                            ++this.framesPlayed;
                        }
                    } else {
                        ++this.framesPlayed;
                    }
                }
            } else {
                rc = 0;
            }
            if ((rc & 8) != 0) {
                this.failed = true;
                if (this.moduleListener != null) {
                    this.moduleListener.pluginTerminated(this);
                }
                ic.readReport();
                return;
            }
            if (!this.prefetching || this.multiplexer instanceof Prefetchable && !((Prefetchable)((Object)this.multiplexer)).isPrefetched()) continue;
            Object object = this.prefetchSync;
            synchronized (object) {
                if (!this.started && this.prefetching && !this.resetted) {
                    this.paused[idx] = true;
                }
                if (this.checkPrefetch(idx)) {
                    this.prefetching = false;
                }
            }
            if (this.prefetching || this.moduleListener == null) continue;
            this.moduleListener.bufferPrefetched(this);
        } while (!this.resetted && rc == 2);
        this.bitsWritten += (long)buffer.getLength();
        if (buffer.isEOM()) {
            if (!this.resetted) {
                this.paused[idx] = true;
            }
            if (this.checkEnd(idx)) {
                this.doStop();
                if (this.moduleListener != null) {
                    this.moduleListener.mediaEnded(this);
                }
            }
        }
        ic.readReport();
        if (PlaybackEngine.DEBUG) {
            this.jmd.moduleIn(this, 0, buffer, false);
        }
    }

    void resetPrefetchMarkers() {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (blArray) {
            int i2 = 0;
            while (i2 < this.prefetchMarkers.length) {
                this.prefetchMarkers[i2] = false;
                ++i2;
            }
        }
    }

    boolean checkPrefetch(int idx) {
        boolean[] blArray = this.prefetchMarkers;
        synchronized (blArray) {
            this.prefetchMarkers[idx] = true;
            int i2 = 0;
            while (i2 < this.prefetchMarkers.length) {
                if (!this.prefetchMarkers[i2]) {
                    boolean bl = false;
                    return bl;
                }
                ++i2;
            }
            boolean bl = true;
            return bl;
        }
    }

    void resetEndMarkers() {
        boolean[] blArray = this.endMarkers;
        synchronized (blArray) {
            int i2 = 0;
            while (i2 < this.endMarkers.length) {
                this.endMarkers[i2] = false;
                ++i2;
            }
        }
    }

    boolean checkEnd(int idx) {
        boolean[] blArray = this.endMarkers;
        synchronized (blArray) {
            this.endMarkers[idx] = true;
            int i2 = 0;
            while (i2 < this.endMarkers.length) {
                if (!this.endMarkers[i2]) {
                    boolean bl = false;
                    return bl;
                }
                ++i2;
            }
            boolean bl = true;
            return bl;
        }
    }

    void resetResettedMarkers() {
        boolean[] blArray = this.resettedMarkers;
        synchronized (blArray) {
            int i2 = 0;
            while (i2 < this.resettedMarkers.length) {
                this.resettedMarkers[i2] = false;
                ++i2;
            }
        }
    }

    boolean checkResetted(int idx) {
        boolean[] blArray = this.resettedMarkers;
        synchronized (blArray) {
            this.resettedMarkers[idx] = true;
            int i2 = 0;
            while (i2 < this.resettedMarkers.length) {
                if (!this.resettedMarkers[i2]) {
                    boolean bl = false;
                    return bl;
                }
                ++i2;
            }
            boolean bl = true;
            return bl;
        }
    }

    void resetStopAtTimeMarkers() {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (blArray) {
            int i2 = 0;
            while (i2 < this.stopAtTimeMarkers.length) {
                this.stopAtTimeMarkers[i2] = false;
                ++i2;
            }
        }
    }

    boolean checkStopAtTime(int idx) {
        boolean[] blArray = this.stopAtTimeMarkers;
        synchronized (blArray) {
            this.stopAtTimeMarkers[idx] = true;
            int i2 = 0;
            while (i2 < this.stopAtTimeMarkers.length) {
                if (!this.stopAtTimeMarkers[i2]) {
                    boolean bl = false;
                    return bl;
                }
                ++i2;
            }
            boolean bl = true;
            return bl;
        }
    }

    protected void process() {
    }

    public void reset() {
        super.reset();
        this.resetResettedMarkers();
        this.prefetching = false;
    }

    public void triggerReset() {
        this.multiplexer.reset();
        Object object = this.prefetchSync;
        synchronized (object) {
            this.prefetching = false;
            if (this.resetted) {
                this.resume();
            }
        }
    }

    public DataSource getDataOutput() {
        return this.multiplexer.getDataOutput();
    }

    public Multiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public Object[] getControls() {
        return this.multiplexer.getControls();
    }

    public Object getControl(String s) {
        return this.multiplexer.getControl(s);
    }

    public void setFormat(Connector connector, Format format2) {
        float fr;
        if (format2 instanceof VideoFormat && (fr = ((VideoFormat)format2).getFrameRate()) != -1.0f) {
            this.frameRate = fr;
        }
    }

    public int getFramesPlayed() {
        return this.framesPlayed;
    }

    public void resetFramesPlayed() {
        this.framesPlayed = 0;
    }

    public long getBitsWritten() {
        return this.bitsWritten;
    }

    public void resetBitsWritten() {
        this.bitsWritten = 0L;
    }

    class MyInputConnector
    extends BasicInputConnector {
        public String toString() {
            return super.toString() + ": " + this.getFormat();
        }
    }
}

