/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepak;

import com.sun.media.codec.video.cinepak.CineStore;
import com.sun.media.codec.video.cinepak.CodeEntry;
import com.sun.media.codec.video.cinepak.CpStrip;
import javax.media.Buffer;
import javax.media.format.VideoFormat;

public class CPChunk {
    int fChunkType;
    int fChunkLen;
    int[] lookup;
    static int[] fBounding24;
    static int firstFlag;

    public CPChunk() {
        firstFlag = 1;
    }

    public CPChunk(int[] l2) {
        this.lookup = l2;
        firstFlag = 1;
    }

    public void setLookup(int[] l2) {
        this.lookup = l2;
    }

    public void processChunk(byte[] inData, CineStore myStor, int whichStrip, int ChunkStart, Buffer outBuffer) {
        fBounding24 = CineStore.BOUNDING24;
        this.fChunkType = (inData[ChunkStart] & 0xFF) * 256 + (inData[ChunkStart + 1] & 0xFF);
        this.fChunkLen = (inData[ChunkStart + 2] & 0xFF) * 256 + (inData[ChunkStart + 3] & 0xFF);
        switch (this.fChunkType) {
            case 8192: {
                this.doCFUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Detail);
                break;
            }
            case 8704: {
                this.doCFUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Smooth);
                break;
            }
            case 8448: {
                this.doCPUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Detail);
                break;
            }
            case 8960: {
                this.doCPUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Smooth);
                break;
            }
            case 12288: {
                this.doFKUpdate(inData, ChunkStart + 4, myStor, whichStrip, outBuffer);
                break;
            }
            case 12800: {
                this.doFSKUpdate(inData, ChunkStart + 4, myStor, whichStrip, outBuffer);
                break;
            }
            case 12544: {
                this.doIUpdate(inData, ChunkStart + 4, myStor, whichStrip, outBuffer);
                break;
            }
            case 9216: {
                this.doGFUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Detail);
                break;
            }
            case 9728: {
                this.doGFUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Smooth);
                break;
            }
            case 9472: {
                this.doGPUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Detail);
                break;
            }
            case 9984: {
                this.doGPUpdate(inData, ChunkStart + 4, myStor.StripVec[whichStrip].Smooth);
                break;
            }
        }
    }

    public String getChunkType() {
        switch (this.fChunkType) {
            case 8704: {
                return "color full    smooth codebook update";
            }
            case 8192: {
                return "color full    detail codebook update";
            }
            case 8960: {
                return "color partial smooth codebook update";
            }
            case 8448: {
                return "color partial detail codebook update";
            }
            case 12288: {
                return "full key frame update";
            }
            case 12800: {
                return "full smooth key frame update";
            }
            case 12544: {
                return "interframe update";
            }
            case 9216: {
                return "greyscale full smooth codebook update";
            }
            case 9728: {
                return "greyscale full detail codebook update";
            }
            case 9472: {
                return "greyscale partial smooth codebook update";
            }
            case 9984: {
                return "greyscale partial detail codebook update";
            }
        }
        return "WARNING******* unknown atom chunk type...*******";
    }

    public int getChunkLength() {
        return this.fChunkLen;
    }

    private void doCFUpdate(byte[] ChunkArray, int ChunkDataStart, CodeEntry[] codebook) {
        int numberOfCodes = ((ChunkArray[ChunkDataStart - 2] & 0xFF) * 256 + (ChunkArray[ChunkDataStart - 1] & 0xFF) - 4) / 6;
        int i2 = 0;
        while (i2 < numberOfCodes) {
            int Y0 = ChunkArray[ChunkDataStart + i2 * 6] & 0xFF;
            int Y1 = ChunkArray[ChunkDataStart + i2 * 6 + 1] & 0xFF;
            int Y2 = ChunkArray[ChunkDataStart + i2 * 6 + 2] & 0xFF;
            int Y3 = ChunkArray[ChunkDataStart + i2 * 6 + 3] & 0xFF;
            byte U2 = ChunkArray[ChunkDataStart + i2 * 6 + 4];
            byte V = ChunkArray[ChunkDataStart + i2 * 6 + 5];
            int delR = 2 * U2 + 128;
            int delB = 2 * V + 128;
            int delG = -(U2 / 2) - V + 128;
            codebook[i2].aRGB0 = (fBounding24[Y0 + delR] << 16) + (fBounding24[Y0 + delG] << 8) + fBounding24[Y0 + delB];
            codebook[i2].aRGB1 = (fBounding24[Y1 + delR] << 16) + (fBounding24[Y1 + delG] << 8) + fBounding24[Y1 + delB];
            codebook[i2].aRGB2 = (fBounding24[Y2 + delR] << 16) + (fBounding24[Y2 + delG] << 8) + fBounding24[Y2 + delB];
            codebook[i2].aRGB3 = (fBounding24[Y3 + delR] << 16) + (fBounding24[Y3 + delG] << 8) + fBounding24[Y3 + delB];
            ++i2;
        }
    }

    private void doCPUpdate(byte[] ChunkArray, int ChunkDataStart, CodeEntry[] codebook) {
        int ByteCounter = ChunkDataStart;
        int CodeCount = 0;
        int len2 = (ChunkArray[ChunkDataStart - 2] & 0xFF) * 256 + (ChunkArray[ChunkDataStart - 1] & 0xFF) - 4 + ByteCounter;
        while (ByteCounter < len2 && CodeCount < 256) {
            int Map5 = ChunkArray[ByteCounter++] & 0xFF;
            Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
            Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
            Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
            int Mask = Integer.MIN_VALUE;
            int i2 = 0;
            while (i2 < 32 && ByteCounter < len2 && CodeCount < 256) {
                if ((Mask & Map5) != 0) {
                    int Y0 = ChunkArray[ByteCounter++] & 0xFF;
                    int Y1 = ChunkArray[ByteCounter++] & 0xFF;
                    int Y2 = ChunkArray[ByteCounter++] & 0xFF;
                    int Y3 = ChunkArray[ByteCounter++] & 0xFF;
                    byte U2 = ChunkArray[ByteCounter++];
                    byte V = ChunkArray[ByteCounter++];
                    int delR = 2 * U2 + 128;
                    int delB = 2 * V + 128;
                    int delG = -(U2 / 2) - V + 128;
                    codebook[CodeCount].aRGB0 = (fBounding24[Y0 + delR] << 16) + (fBounding24[Y0 + delG] << 8) + fBounding24[Y0 + delB];
                    codebook[CodeCount].aRGB1 = (fBounding24[Y1 + delR] << 16) + (fBounding24[Y1 + delG] << 8) + fBounding24[Y1 + delB];
                    codebook[CodeCount].aRGB2 = (fBounding24[Y2 + delR] << 16) + (fBounding24[Y2 + delG] << 8) + fBounding24[Y2 + delB];
                    codebook[CodeCount].aRGB3 = (fBounding24[Y3 + delR] << 16) + (fBounding24[Y3 + delG] << 8) + fBounding24[Y3 + delB];
                }
                Mask >>>= 1;
                ++CodeCount;
                ++i2;
            }
        }
    }

    private void doFKUpdate(byte[] ChunkArray, int ChunkDataStart, CineStore myStor, int thisStrip, Buffer outBuffer) {
        int[] outData = (int[])outBuffer.getData();
        VideoFormat outFmt = (VideoFormat)outBuffer.getFormat();
        int outWidth = outFmt.getSize().width;
        CpStrip theStrip = myStor.StripVec[thisStrip];
        CodeEntry[] detailBook = theStrip.Detail;
        CodeEntry[] smoothBook = theStrip.Smooth;
        int len2 = (ChunkArray[ChunkDataStart - 2] & 0xFF) * 256 + (ChunkArray[ChunkDataStart - 1] & 0xFF) - 4 + ChunkDataStart;
        int xdraw = myStor.ImagePosX + myStor.StripPosX;
        int ydraw = myStor.ImagePosY + myStor.StripPosY;
        int ByteCounter = ChunkDataStart;
        int CodeCount = 0;
        while (ByteCounter < len2 && ydraw < myStor.ImagePosY + myStor.ImageSizeY) {
            int Map5 = ChunkArray[ByteCounter++] & 0xFF;
            Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
            Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
            Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
            int Mask = Integer.MIN_VALUE;
            int i2 = 0;
            while (i2 < 32 && ByteCounter < len2 && ydraw < myStor.ImagePosY + myStor.ImageSizeY) {
                int location;
                int startLocation;
                int color;
                CodeEntry thisCode;
                if ((Mask & Map5) != 0) {
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    color = thisCode.aRGB0;
                    location = startLocation = xdraw + outWidth * ydraw;
                    outData[location] = color;
                    color = thisCode.aRGB1;
                    location = startLocation + 1;
                    outData[location] = color;
                    color = thisCode.aRGB2;
                    location = startLocation + outWidth;
                    outData[location] = color;
                    color = thisCode.aRGB3;
                    outData[++location] = color;
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    color = thisCode.aRGB0;
                    location = startLocation = xdraw + 2 + outWidth * ydraw;
                    outData[location] = color;
                    color = thisCode.aRGB1;
                    location = startLocation + 1;
                    outData[location] = color;
                    color = thisCode.aRGB2;
                    location = startLocation + outWidth;
                    outData[location] = color;
                    color = thisCode.aRGB3;
                    outData[++location] = color;
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    color = thisCode.aRGB0;
                    location = startLocation = xdraw + outWidth * (ydraw + 2);
                    outData[location] = color;
                    color = thisCode.aRGB1;
                    location = startLocation + 1;
                    outData[location] = color;
                    color = thisCode.aRGB2;
                    location = startLocation + outWidth;
                    outData[location] = color;
                    color = thisCode.aRGB3;
                    outData[++location] = color;
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    color = thisCode.aRGB0;
                    location = startLocation = xdraw + 2 + outWidth * (ydraw + 2);
                    outData[location] = color;
                    color = thisCode.aRGB1;
                    location = startLocation + 1;
                    outData[location] = color;
                    color = thisCode.aRGB2;
                    location = startLocation + outWidth;
                    outData[location] = color;
                    outData[location + 1] = color = thisCode.aRGB3;
                } else {
                    thisCode = smoothBook[ChunkArray[ByteCounter++] & 0xFF];
                    color = thisCode.aRGB0;
                    location = startLocation = xdraw + outWidth * ydraw;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                    color = thisCode.aRGB1;
                    location = startLocation + 2;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                    color = thisCode.aRGB2;
                    location = startLocation += outWidth * 2;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                    color = thisCode.aRGB3;
                    location = startLocation + 2;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                }
                Mask >>>= 1;
                ++CodeCount;
                if ((xdraw += 4) > myStor.ImageSizeX - 4) {
                    xdraw = myStor.ImagePosX + myStor.StripPosX;
                    ydraw += 4;
                }
                ++i2;
            }
        }
    }

    private void doFSKUpdate(byte[] ChunkArray, int ChunkDataStart, CineStore myStor, int thisStrip, Buffer outBuffer) {
        int[] outData = (int[])outBuffer.getData();
        VideoFormat outFmt = (VideoFormat)outBuffer.getFormat();
        int outWidth = outFmt.getSize().width;
        CpStrip theStrip = myStor.StripVec[thisStrip];
        CodeEntry[] detailBook = theStrip.Detail;
        CodeEntry[] smoothBook = theStrip.Smooth;
        int len2 = (ChunkArray[ChunkDataStart - 2] & 0xFF) * 256 + (ChunkArray[ChunkDataStart - 1] & 0xFF) - 4 + ChunkDataStart;
        int xdraw = myStor.ImagePosX + myStor.StripPosX;
        int ydraw = myStor.ImagePosY + myStor.StripPosY;
        int ByteCounter = ChunkDataStart;
        while (ByteCounter < len2) {
            CodeEntry thisCode = smoothBook[ChunkArray[ByteCounter++] & 0xFF];
            int color = thisCode.aRGB0;
            int startLocation = xdraw + outWidth * ydraw;
            if (startLocation >= outData.length) break;
            int location = startLocation;
            outData[location] = color;
            outData[location + 1] = color;
            outData[location += outWidth] = color;
            outData[location + 1] = color;
            color = thisCode.aRGB1;
            location = startLocation + 2;
            outData[location] = color;
            outData[location + 1] = color;
            outData[location += outWidth] = color;
            outData[location + 1] = color;
            color = thisCode.aRGB2;
            location = startLocation += outWidth * 2;
            outData[location] = color;
            outData[location + 1] = color;
            outData[location += outWidth] = color;
            outData[location + 1] = color;
            color = thisCode.aRGB3;
            location = startLocation + 2;
            outData[location] = color;
            outData[location + 1] = color;
            outData[location += outWidth] = color;
            outData[location + 1] = color;
            if ((xdraw += 4) <= myStor.ImageSizeX - 4) continue;
            xdraw = myStor.ImagePosX + myStor.StripPosX;
            ydraw += 4;
        }
    }

    private void doIUpdate(byte[] ChunkArray, int ChunkDataStart, CineStore myStor, int thisStrip, Buffer outBuffer) {
        int[] outData = (int[])outBuffer.getData();
        VideoFormat outFmt = (VideoFormat)outBuffer.getFormat();
        int outWidth = outFmt.getSize().width;
        CodeEntry[] detailBook = myStor.StripVec[thisStrip].Detail;
        CodeEntry[] smoothBook = myStor.StripVec[thisStrip].Smooth;
        int len2 = (ChunkArray[ChunkDataStart - 2] & 0xFF) * 256 + (ChunkArray[ChunkDataStart - 1] & 0xFF) - 4 + ChunkDataStart;
        int xdraw = myStor.ImagePosX + myStor.StripPosX;
        int ydraw = myStor.ImagePosY + myStor.StripPosY;
        int ByteCounter = ChunkDataStart;
        int Map5 = 0;
        int Mask = 0;
        int FinishY = myStor.ImagePosY + myStor.StripPosY + myStor.StripPosY1;
        while (ByteCounter < len2 && ydraw < FinishY) {
            if ((Mask >>>= 1) == 0) {
                Map5 = ChunkArray[ByteCounter++] & 0xFF;
                Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
                Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
                Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
                Mask = Integer.MIN_VALUE;
            }
            if ((Mask & Map5) != 0 && ByteCounter < len2) {
                CodeEntry thisCode;
                int startLocation;
                if ((Mask >>>= 1) == 0) {
                    Map5 = ChunkArray[ByteCounter++] & 0xFF;
                    Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
                    Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
                    Map5 = Map5 * 256 + (ChunkArray[ByteCounter++] & 0xFF);
                    Mask = Integer.MIN_VALUE;
                }
                if ((Mask & Map5) != 0) {
                    startLocation = xdraw + outWidth * ydraw;
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    outData[startLocation] = thisCode.aRGB0;
                    outData[startLocation + 1] = thisCode.aRGB1;
                    outData[startLocation + outWidth] = thisCode.aRGB2;
                    outData[startLocation + outWidth + 1] = thisCode.aRGB3;
                    startLocation = xdraw + 2 + outWidth * ydraw;
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    outData[startLocation] = thisCode.aRGB0;
                    outData[startLocation + 1] = thisCode.aRGB1;
                    outData[startLocation + outWidth] = thisCode.aRGB2;
                    outData[startLocation + outWidth + 1] = thisCode.aRGB3;
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    startLocation = xdraw + outWidth * (ydraw + 2);
                    outData[startLocation] = thisCode.aRGB0;
                    outData[startLocation + 1] = thisCode.aRGB1;
                    outData[startLocation + outWidth] = thisCode.aRGB2;
                    outData[startLocation + outWidth + 1] = thisCode.aRGB3;
                    thisCode = detailBook[ChunkArray[ByteCounter++] & 0xFF];
                    startLocation = xdraw + 2 + outWidth * (ydraw + 2);
                    outData[startLocation] = thisCode.aRGB0;
                    outData[startLocation + 1] = thisCode.aRGB1;
                    outData[startLocation + outWidth] = thisCode.aRGB2;
                    outData[startLocation + outWidth + 1] = thisCode.aRGB3;
                } else {
                    thisCode = smoothBook[ChunkArray[ByteCounter++] & 0xFF];
                    int color = thisCode.aRGB0;
                    int location = startLocation = xdraw + outWidth * ydraw;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                    color = thisCode.aRGB1;
                    location = startLocation + 2;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                    color = thisCode.aRGB2;
                    location = startLocation += outWidth * 2;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                    color = thisCode.aRGB3;
                    location = startLocation + 2;
                    outData[location] = color;
                    outData[location + 1] = color;
                    outData[location += outWidth] = color;
                    outData[location + 1] = color;
                }
            }
            if ((xdraw += 4) <= myStor.ImageSizeX - 4) continue;
            xdraw = myStor.ImagePosX + myStor.StripPosX;
            ydraw += 4;
        }
    }

    private void doGFUpdate(byte[] ChunkArray, int ChunkDataStart, CodeEntry[] codebook) {
        int ByteCounter = ChunkDataStart;
        int numberOfCodes = ((ChunkArray[ChunkDataStart - 2] & 0xFF) * 256 + (ChunkArray[ChunkDataStart - 1] & 0xFF) - 4) / 4;
        if (this.lookup == null) {
            int i2 = 0;
            while (i2 < numberOfCodes) {
                int anInt;
                if (firstFlag == 1) {
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB0 = (anInt << 16) + (anInt << 8) + anInt;
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB1 = (anInt << 16) + (anInt << 8) + anInt;
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB2 = (anInt << 16) + (anInt << 8) + anInt;
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB3 = (anInt << 16) + (anInt << 8) + anInt;
                } else {
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB0 = anInt << 16 | anInt << 8 | anInt;
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB1 = anInt << 16 | anInt << 8 | anInt;
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB2 = anInt << 16 | anInt << 8 | anInt;
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB3 = anInt << 16 | anInt << 8 | anInt;
                }
                ++i2;
            }
        } else {
            int i2 = 0;
            while (i2 < numberOfCodes) {
                int anInt;
                if (firstFlag == 1) {
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB0 = this.lookup[anInt];
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB1 = this.lookup[anInt];
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB2 = this.lookup[anInt];
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB3 = this.lookup[anInt];
                } else {
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB0 = this.lookup[anInt];
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB1 = this.lookup[anInt];
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB2 = this.lookup[anInt];
                    anInt = ChunkArray[ByteCounter++] & 0xFF;
                    codebook[i2].aRGB3 = this.lookup[anInt];
                }
                ++i2;
            }
        }
        firstFlag = 0;
    }

    /*
     * Unable to fully structure code
     */
    private void doGPUpdate(byte[] ChunkArray, int ChunkDataStart, CodeEntry[] codebook) {
        block6: {
            ByteCounter = ChunkDataStart;
            CodeCount = 0;
            len = (ChunkArray[ChunkDataStart - 2] & 255) * 256 + (ChunkArray[ChunkDataStart - 1] & 255) - 4 + ChunkDataStart;
            if (this.lookup != null) ** GOTO lbl48
            while (ByteCounter < len && CodeCount < 256) {
                Map = ChunkArray[ByteCounter++] & 255;
                Map = Map * 256 + (ChunkArray[ByteCounter++] & 255);
                Map = Map * 256 + (ChunkArray[ByteCounter++] & 255);
                Map = Map * 256 + (ChunkArray[ByteCounter++] & 255);
                Mask = -2147483648;
                i = 0;
                while (i < 32 && ByteCounter < len && CodeCount < 256) {
                    if ((Mask & Map) != 0) {
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB0 = anInt << 16 | anInt << 8 | anInt;
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB1 = anInt << 16 | anInt << 8 | anInt;
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB2 = anInt << 16 | anInt << 8 | anInt;
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB3 = anInt << 16 | anInt << 8 | anInt;
                    }
                    Mask >>>= 1;
                    ++CodeCount;
                    ++i;
                }
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                Map = ChunkArray[ByteCounter++] & 255;
                Map = Map * 256 + (ChunkArray[ByteCounter++] & 255);
                Map = Map * 256 + (ChunkArray[ByteCounter++] & 255);
                Map = Map * 256 + (ChunkArray[ByteCounter++] & 255);
                Mask = -2147483648;
                i = 0;
                while (i < 32 && ByteCounter < len && CodeCount < 256) {
                    if ((Mask & Map) != 0) {
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB0 = this.lookup[anInt];
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB1 = this.lookup[anInt];
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB2 = this.lookup[anInt];
                        anInt = ChunkArray[ByteCounter++] & 255;
                        codebook[CodeCount].aRGB3 = this.lookup[anInt];
                    }
                    Mask >>>= 1;
                    ++CodeCount;
                    ++i;
                }
lbl48:
                // 2 sources

                ** while (ByteCounter < len && CodeCount < 256)
            }
        }
    }
}

