/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class AIFFMux
extends BasicMux {
    private Format format;
    private AudioFormat audioFormat;
    private int sampleSizeInBits;
    private double sampleRate;
    private int channels;
    private int blockAlign = 1;
    private int dataSizeOffset;
    private int maxFrames = 0;
    private int maxFramesOffset = 0;
    private String formType;
    private String aiffEncoding;
    private int headerSize = 0;
    private int dataSize = 0;
    private static int AIFCVersion1 = -1568648896;
    private static final String FormID = "FORM";
    private static final String FormatVersionID = "FVER";
    private static final String CommonID = "COMM";
    private static final String SoundDataID = "SSND";
    private static final int CommonIDSize = 18;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, 1);

    public AIFFMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("audio.x_aiff");
    }

    public String getName() {
        return "AIFF Audio Multiplexer";
    }

    public int setNumTracks(int nTracks) {
        if (nTracks != 1) {
            return 1;
        }
        return super.setNumTracks(nTracks);
    }

    protected void writeHeader() {
        this.bufClear();
        this.bufWriteBytes(FormID);
        this.bufWriteInt(0);
        this.bufWriteBytes(this.formType);
        if (this.formType.equals("AIFC")) {
            this.bufWriteBytes(FormatVersionID);
            this.bufWriteInt(4);
            this.bufWriteInt(AIFCVersion1);
        }
        this.bufWriteBytes(CommonID);
        int commonIDSize = 18;
        if (this.formType.equals("AIFC")) {
            commonIDSize += 8;
        }
        this.bufWriteInt(commonIDSize);
        this.bufWriteShort((short)this.channels);
        this.maxFramesOffset = this.filePointer;
        this.bufWriteInt(this.maxFrames);
        this.bufWriteShort((short)this.sampleSizeInBits);
        int exponent = 16398;
        double highMantissa = this.sampleRate;
        while (highMantissa < 44000.0) {
            highMantissa *= 2.0;
            --exponent;
        }
        this.bufWriteShort((short)exponent);
        this.bufWriteInt((int)highMantissa << 16);
        this.bufWriteInt(0);
        if (this.formType.equals("AIFC")) {
            this.bufWriteBytes(this.aiffEncoding);
            this.bufWriteBytes(this.aiffEncoding);
        }
        this.bufWriteBytes(SoundDataID);
        this.dataSizeOffset = this.filePointer;
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufFlush();
        this.headerSize = this.filePointer;
    }

    public Format setInputFormat(Format format2, int trackID) {
        String reason = null;
        if (!(format2 instanceof AudioFormat)) {
            return null;
        }
        this.audioFormat = (AudioFormat)format2;
        String encodingString = this.audioFormat.getEncoding();
        this.sampleSizeInBits = this.audioFormat.getSampleSizeInBits();
        this.sampleRate = this.audioFormat.getSampleRate();
        this.channels = this.audioFormat.getChannels();
        this.blockAlign = this.channels * this.sampleSizeInBits / 8;
        if (encodingString.equalsIgnoreCase("LINEAR")) {
            if (this.sampleSizeInBits > 8 && this.audioFormat.getEndian() == 0) {
                return null;
            }
            if (this.audioFormat.getSigned() == 0) {
                return null;
            }
            if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                format2 = this.audioFormat.intersects(this.bigEndian);
            }
            this.formType = "AIFF";
            this.aiffEncoding = "NONE";
        } else {
            this.formType = "AIFC";
            if (encodingString.equalsIgnoreCase("ULAW")) {
                this.aiffEncoding = "ulaw";
            } else if (encodingString.equalsIgnoreCase("alaw")) {
                this.aiffEncoding = "alaw";
            } else if (encodingString.equalsIgnoreCase("ima4")) {
                this.aiffEncoding = "ima4";
                this.blockAlign = 34 * this.channels;
            } else if (encodingString.equalsIgnoreCase("MAC3")) {
                this.aiffEncoding = encodingString;
                this.blockAlign = 2;
            } else if (encodingString.equalsIgnoreCase("MAC6")) {
                this.aiffEncoding = encodingString;
                this.blockAlign = 1;
            } else {
                reason = "Cannot handle encoding " + encodingString;
            }
        }
        if (reason == null) {
            this.inputs[0] = format2;
            return format2;
        }
        return null;
    }

    protected void writeFooter() {
        byte[] dummy = new byte[]{0};
        this.dataSize = this.filePointer - this.headerSize;
        if ((this.filePointer & 1) != 0) {
            this.write(dummy, 0, 1);
        }
        this.bufClear();
        this.seek(4);
        this.bufWriteInt(this.fileSize);
        this.bufFlush();
        this.bufClear();
        this.seek(this.maxFramesOffset);
        this.maxFrames = this.dataSize / this.blockAlign;
        this.bufWriteInt(this.maxFrames);
        this.bufFlush();
        this.bufClear();
        this.seek(this.dataSizeOffset);
        this.bufWriteInt(this.dataSize + 8);
        this.bufFlush();
    }
}

