/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.renderer.video.Blitter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.format.RGBFormat;

public class Java2DRenderer
implements Blitter {
    private transient AffineTransformOp savedATO = null;
    private transient DirectColorModel dcm = null;
    private transient Image destImage = null;

    public Java2DRenderer() {
        try {
            Class.forName("java.awt.Graphics2D");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("No Java2D");
        }
    }

    public synchronized void draw(Graphics graphics, Component component, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (image == null || n4 < 1 || n5 < 1) {
            return;
        }
        if (this.savedATO == null) {
            AffineTransformOp affineTransformOp;
            AffineTransform affineTransform = new AffineTransform((float)n4 / (float)n8, 0.0f, 0.0f, (float)n5 / (float)n9, 0.0f, 0.0f);
            this.savedATO = affineTransformOp = new AffineTransformOp(affineTransform, null);
            this.destImage = affineTransformOp.createCompatibleDestImage((BufferedImage)image, this.dcm);
        }
        this.savedATO.filter((BufferedImage)image, (BufferedImage)this.destImage);
        if (graphics != null && image != null && graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).drawImage(this.destImage, 0, 0, component);
        }
    }

    public int newData(Buffer buffer, Vector vector2, Vector vector3, Vector vector4) {
        Object object = buffer.getData();
        if (!(object instanceof int[])) {
            return -1;
        }
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        int n2 = rGBFormat.getRedMask();
        int n3 = rGBFormat.getGreenMask();
        int n4 = rGBFormat.getBlueMask();
        int[] nArray = new int[]{n2, n3, n4};
        DataBufferInt dataBufferInt = new DataBufferInt((int[])object, rGBFormat.getLineStride() * rGBFormat.getSize().height);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(3, rGBFormat.getLineStride(), rGBFormat.getSize().height, nArray);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferInt, new Point(0, 0));
        this.dcm = new DirectColorModel(24, n2, n3, n4);
        BufferedImage bufferedImage = new BufferedImage(this.dcm, writableRaster, true, null);
        vector4.addElement(object);
        vector2.addElement(bufferedImage);
        vector3.addElement(bufferedImage);
        Java2DRenderer java2DRenderer = this;
        synchronized (java2DRenderer) {
            this.savedATO = null;
        }
        return vector2.size() - 1;
    }

    public Image process(Buffer buffer, Object object, Object object2, Dimension dimension) {
        return (Image)object;
    }

    public void resized(Component component) {
        this.savedATO = null;
    }
}

