/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.Log;
import com.sun.media.rtp.util.RTPTimeReporter;
import java.util.Vector;
import javax.media.Time;
import javax.media.TimeBase;

public class RTPTimeBase
implements TimeBase {
    static Vector timeBases = new Vector();
    static int SSRC_UNDEFINED = 0;
    String cname;
    RTPTimeReporter master = null;
    Vector reporters = new Vector();
    long origin = 0L;
    long offset = 0L;
    boolean offsetUpdatable = true;

    public static RTPTimeBase find(RTPTimeReporter r, String cname) {
        Vector vector2 = timeBases;
        synchronized (vector2) {
            RTPTimeBase result2 = null;
            int i2 = 0;
            while (i2 < timeBases.size()) {
                RTPTimeBase tb = (RTPTimeBase)timeBases.elementAt(i2);
                if (tb.cname.equals(cname)) {
                    result2 = tb;
                    break;
                }
                ++i2;
            }
            if (result2 == null) {
                Log.comment("Created RTP time base for session: " + cname + "\n");
                result2 = new RTPTimeBase(cname);
                timeBases.addElement(result2);
            }
            if (r != null) {
                if (result2.getMaster() == null) {
                    result2.setMaster(r);
                }
                result2.reporters.addElement(r);
            }
            RTPTimeBase rTPTimeBase = result2;
            return rTPTimeBase;
        }
    }

    public static void remove(RTPTimeReporter r, String cname) {
        Vector vector2 = timeBases;
        synchronized (vector2) {
            int i2 = 0;
            while (i2 < timeBases.size()) {
                RTPTimeBase tb = (RTPTimeBase)timeBases.elementAt(i2);
                if (tb.cname.equals(cname)) {
                    tb.reporters.removeElement(r);
                    if (tb.reporters.size() == 0) {
                        tb.master = null;
                        timeBases.removeElement(tb);
                        break;
                    }
                    RTPTimeBase rTPTimeBase = tb;
                    synchronized (rTPTimeBase) {
                        if (tb.master == r) {
                            tb.setMaster((RTPTimeReporter)tb.reporters.elementAt(0));
                        }
                        break;
                    }
                }
                ++i2;
            }
        }
    }

    public static RTPTimeBase getMapper(String cname) {
        Vector vector2 = timeBases;
        synchronized (vector2) {
            RTPTimeBase rTPTimeBase = RTPTimeBase.find(null, cname);
            return rTPTimeBase;
        }
    }

    public static RTPTimeBase getMapperUpdatable(String cname) {
        Vector vector2 = timeBases;
        synchronized (vector2) {
            RTPTimeBase tb = RTPTimeBase.find(null, cname);
            if (tb.offsetUpdatable) {
                tb.offsetUpdatable = false;
                RTPTimeBase rTPTimeBase = tb;
                return rTPTimeBase;
            }
            RTPTimeBase rTPTimeBase = null;
            return rTPTimeBase;
        }
    }

    public static void returnMapperUpdatable(RTPTimeBase tb) {
        Vector vector2 = timeBases;
        synchronized (vector2) {
            tb.offsetUpdatable = true;
        }
    }

    RTPTimeBase(String cname) {
        this.cname = cname;
    }

    public Time getTime() {
        return new Time(this.getNanoseconds());
    }

    public synchronized long getNanoseconds() {
        return this.master != null ? this.master.getRTPTime() : 0L;
    }

    public synchronized void setMaster(RTPTimeReporter r) {
        this.master = r;
    }

    public synchronized RTPTimeReporter getMaster() {
        return this.master;
    }

    public synchronized void setOrigin(long orig) {
        this.origin = orig;
    }

    public long getOrigin() {
        return this.origin;
    }

    public synchronized void setOffset(long off) {
        this.offset = off;
    }

    public long getOffset() {
        return this.offset;
    }
}

