/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp;

import com.sun.media.Log;
import com.sun.media.rtsp.Connection;
import com.sun.media.rtsp.RtspListener;
import com.sun.media.rtsp.Server;
import com.sun.media.rtsp.protocol.Message;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class RtspManager {
    private Vector listeners = new Vector();
    private int connectionCounter;
    private Vector connections = new Vector();
    private String address;
    private int port;

    public RtspManager() {
        Server server = new Server(this);
        server.start();
    }

    public RtspManager(boolean server_socket) {
        if (server_socket) {
            Server server = new Server(this);
            server.start();
        }
    }

    public boolean sendMessage(int connectionId, String message) {
        Log.comment("outgoing msg:");
        Log.comment(message);
        Connection connection = this.getConnection(connectionId);
        boolean success = connection == null ? false : connection.sendData(message.getBytes());
        return success;
    }

    public void dataIndication(int connectionId, Message message) {
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            RtspListener listener = (RtspListener)this.listeners.elementAt(i2);
            listener.rtspMessageIndication(connectionId, message);
            ++i2;
        }
    }

    public void addListener(RtspListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeListener(RtspListener listener) {
        this.listeners.removeElement(listener);
    }

    public int createConnection(String address, int port) {
        this.address = address;
        this.port = port;
        int connectionId = -1;
        try {
            Connection connection = new Connection(this, this.connectionCounter + 1, address.getBytes(), port);
            this.connections.addElement(connection);
            connectionId = connection.connectionId;
            ++this.connectionCounter;
        }
        catch (UnknownHostException e2) {
            Log.error("[EXCEPTION]: Unknown host.");
            connectionId = -2;
        }
        catch (ConnectException e3) {
            Log.error("[EXCEPTION]: Can't connect to server.");
            connectionId = -3;
        }
        return connectionId;
    }

    public void addConnection(Socket socket) {
        ++this.connectionCounter;
        Connection connection = new Connection(this, this.connectionCounter, socket);
        this.connections.addElement(connection);
    }

    public void removeConnection(int connectionId) {
        Connection connection = this.getConnection(connectionId);
        this.connections.removeElement(connection);
        int i2 = 0;
        while (i2 < this.listeners.size()) {
            RtspListener listener = (RtspListener)this.listeners.elementAt(i2);
            listener.rtspConnectionTerminated(connectionId);
            ++i2;
        }
    }

    public void closeConnection(int connectionId) {
        Connection connection = this.getConnection(connectionId);
        if (connection != null) {
            connection.close();
            this.connections.removeElement(connection);
        } else {
            System.out.println("connection not found!");
        }
    }

    public Connection getConnection(int connectionId) {
        Connection connection = null;
        int i2 = 0;
        while (i2 < this.connections.size()) {
            Connection tmpConnection = (Connection)this.connections.elementAt(i2);
            if (tmpConnection.connectionId == connectionId) {
                connection = tmpConnection;
                break;
            }
            ++i2;
        }
        return connection;
    }
}

