/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import com.sun.media.ui.Scroll;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SliderComp
extends BasicComp
implements ActionListener {
    float value;
    float minValue;
    float maxValue;
    float initialValue;
    Scroll scroll;
    TextField tfIndicator;
    private static final int MIN = 0;
    private static final int MAX = 1000;
    private static final int PAGESIZE = 100;

    public SliderComp(String label, float min2, float max2, float initial) {
        super(label);
        this.minValue = min2;
        this.maxValue = max2;
        this.initialValue = initial;
        this.value = initial;
        this.setLayout(new BorderLayout());
        Label lab = new Label(label, 0);
        this.add("West", lab);
        this.scroll = new Scroll();
        this.add("Center", this.scroll);
        this.scroll.setActionListener(this);
        this.scroll.setValue(this.toRatio(this.value));
    }

    public void setValue(int value) {
        this.value = value;
        this.scroll.setValue(this.toRatio(value));
    }

    public void setValue(float value) {
        this.value = value;
        this.scroll.setValue(this.toRatio(value));
    }

    public int getIntValue() {
        return (int)this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public void actionPerformed(ActionEvent ae) {
        float scrollValue = this.scroll.getValue();
        this.value = this.fromRatio(scrollValue);
        this.informListener();
    }

    private float toRatio(float value) {
        float diff = this.maxValue - this.minValue;
        return (value - this.minValue) / diff;
    }

    private float fromRatio(float value) {
        return value * (this.maxValue - this.minValue) + this.minValue;
    }
}

