/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.Properties;
import de.jarnbjo.flac.StreamInfo;
import de.jarnbjo.flac.Subframe;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;

public class Frame {
    private int blockSize;
    private int sampleRate;
    private int bitsPerSample;
    private final int channelAssignment;
    private final int channels;
    private final long frameNumber;
    private static final int[] SAMPLE_RATES = new int[]{0, -1, -1, -1, 8000, 16000, 22050, 24000, 32000, 44100, 48000, 96000, 0, 0, 0, -1};
    private static final int[] SAMPLE_SIZES = new int[]{0, 8, 12, -1, 16, 20, 24, -1};
    private static final String[] CHANNEL_ASSIGNMENTS = new String[]{"INDEPENDENT", "INDEPENDENT", "INDEPENDENT", "INDEPENDENT", "INDEPENDENT", "INDEPENDENT", "INDEPENDENT", "INDEPENDENT", "LEFT_SIDE", "RIGHT_SIDE", "MID_SIDE"};
    private final StreamInfo streamInfo;
    private final Subframe[] subframes;
    private final int[][] pcm;

    public Frame(BitInputStream source, StreamInfo streamInfo) throws IOException {
        block34: {
            int i2;
            block36: {
                block35: {
                    block33: {
                        if (source.getInt(16) != 65528) {
                            throw new FlacFormatException("Audio frame header mismatch");
                        }
                        this.streamInfo = streamInfo;
                        int bs = source.getInt(4);
                        int sr = source.getInt(4);
                        this.channelAssignment = source.getInt(4);
                        int ss = source.getInt(3);
                        source.getBit();
                        if (bs == 0) {
                            this.blockSize = 0;
                        } else if (bs == 1) {
                            this.blockSize = 192;
                        } else if (bs >= 2 && bs <= 5) {
                            this.blockSize = 576 * (1 << bs - 2);
                        } else if (bs >= 8) {
                            this.blockSize = 256 * (1 << bs - 8);
                        }
                        this.sampleRate = SAMPLE_RATES[sr];
                        if (this.sampleRate == -1) {
                            throw new FlacFormatException("Invalid sample rate in frame");
                        }
                        this.bitsPerSample = SAMPLE_SIZES[ss];
                        if (this.sampleRate == -1) {
                            throw new FlacFormatException("Invalid sample rate in frame");
                        }
                        this.frameNumber = Frame.readUtf8Int(source);
                        switch (bs) {
                            case 0: {
                                this.blockSize = streamInfo.getMaximumBlockSize();
                                break;
                            }
                            case 6: {
                                this.blockSize = source.getInt(8) + 1;
                                break;
                            }
                            case 7: {
                                this.blockSize = source.getInt(16) + 1;
                                break;
                            }
                        }
                        switch (sr) {
                            case 0: {
                                this.sampleRate = streamInfo.getSampleRate();
                                break;
                            }
                            case 12: {
                                this.sampleRate = source.getInt(8) * 1000;
                                break;
                            }
                            case 13: {
                                this.sampleRate = source.getInt(16);
                                break;
                            }
                            case 14: {
                                this.sampleRate = source.getInt(16) * 10;
                                break;
                            }
                        }
                        if (ss == 0) {
                            this.bitsPerSample = streamInfo.getBitsPerSample();
                        }
                        if (this.channelAssignment < 8) {
                            this.channels = this.channelAssignment + 1;
                        } else if (this.channelAssignment < 11) {
                            this.channels = 2;
                        } else {
                            throw new FlacFormatException("Unsupported channel assignment in frame");
                        }
                        int crc = source.getInt(8);
                        if (Properties.analyze()) {
                            System.out.print("frame=" + this.frameNumber + "\t");
                            System.out.print("blocksize=" + this.blockSize + "\t");
                            System.out.print("sample_rate=" + this.sampleRate + "\t");
                            System.out.print("channels=" + this.channels + "\t");
                            System.out.println("channel_assignment" + CHANNEL_ASSIGNMENTS[this.channelAssignment]);
                        }
                        this.subframes = new Subframe[this.channels];
                        for (i2 = 0; i2 < this.channels; ++i2) {
                            boolean sideChannel = this.channelAssignment == 8 && i2 == 1 || this.channelAssignment == 9 && i2 == 0 || this.channelAssignment == 10 && i2 == 1;
                            this.subframes[i2] = Subframe.createInstance(source, this, streamInfo, sideChannel);
                        }
                        this.pcm = new int[this.channels][];
                        if (this.channelAssignment >= 8) break block33;
                        for (i2 = 0; i2 < this.channels; ++i2) {
                            this.pcm[i2] = this.subframes[i2].getPcm();
                        }
                        break block34;
                    }
                    if (this.channelAssignment != 8) break block35;
                    this.pcm[0] = this.subframes[0].getPcm();
                    this.pcm[1] = this.subframes[1].getPcm();
                    for (i2 = 0; i2 < this.pcm[0].length; ++i2) {
                        this.pcm[1][i2] = this.pcm[0][i2] - this.pcm[1][i2];
                    }
                    break block34;
                }
                if (this.channelAssignment != 9) break block36;
                this.pcm[0] = this.subframes[0].getPcm();
                this.pcm[1] = this.subframes[1].getPcm();
                for (i2 = 0; i2 < this.pcm[0].length; ++i2) {
                    int[] nArray = this.pcm[0];
                    int n2 = i2;
                    nArray[n2] = nArray[n2] + this.pcm[1][i2];
                }
                break block34;
            }
            if (this.channelAssignment != 10) break block34;
            this.pcm[0] = this.subframes[0].getPcm();
            this.pcm[1] = this.subframes[1].getPcm();
            for (i2 = 0; i2 < this.pcm[0].length; ++i2) {
                int mid = this.pcm[0][i2];
                int side = this.pcm[1][i2];
                mid <<= 1;
                if ((side & 1) == 1) {
                    ++mid;
                }
                this.pcm[0][i2] = mid + side >> 1;
                this.pcm[1][i2] = mid - side >> 1;
            }
        }
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    private static long readUtf8Int(BitInputStream source) throws IOException {
        long v = 0L;
        int x = 0;
        int i2 = 0;
        x = source.getInt(8);
        if ((x & 0x80) == 0) {
            v = x;
            i2 = 0;
        } else if ((x & 0xE0) == 192) {
            v = x & 0x1F;
            i2 = 1;
        } else if ((x & 0xF0) == 224) {
            v = x & 0xF;
            i2 = 2;
        } else if ((x & 0xF8) == 240) {
            v = x & 7;
            i2 = 3;
        } else if ((x & 0xFC) == 248) {
            v = x & 3;
            i2 = 4;
        } else if ((x & 0xFE) == 252) {
            v = x & 1;
            i2 = 5;
        } else if (x == 254) {
            v = 0L;
            i2 = 6;
        } else {
            return Long.MIN_VALUE;
        }
        while (i2 > 0) {
            x = source.getInt(8);
            if ((x & 0xC0) != 128) {
                return Long.MIN_VALUE;
            }
            v <<= 6;
            v |= (long)(x & 0x3F);
            --i2;
        }
        return v;
    }

    public Subframe[] getSubframes() {
        return this.subframes;
    }

    public int[][] getPcm() {
        return this.pcm;
    }
}

