/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.Frame;
import de.jarnbjo.flac.Properties;
import de.jarnbjo.flac.StreamInfo;
import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class Subframe {
    public static Subframe createInstance(BitInputStream source, Frame frame, StreamInfo streamInfo, boolean sideChannel) throws IOException {
        if (source.getBit()) {
            throw new FlacFormatException("Sync error when trying to read subframe");
        }
        int type2 = source.getInt(6);
        int wastedBits = 0;
        if (source.getBit()) {
            do {
                ++wastedBits;
            } while (!source.getBit());
        }
        if (type2 == 0) {
            return new Constant(source, frame, streamInfo);
        }
        if (type2 == 1) {
            return new Verbatim(source, frame, streamInfo);
        }
        if ((type2 & 0x38) == 8 && (type2 & 7) <= 4) {
            int order = type2 & 7;
            return new Fixed(source, frame, streamInfo, wastedBits, order, sideChannel);
        }
        if ((type2 & 0x20) == 32) {
            int order = (type2 & 0x1F) + 1;
            return new Lpc(source, frame, streamInfo, wastedBits, order, sideChannel);
        }
        throw new FlacFormatException("Unknown or unsupported subframe type");
    }

    public abstract int[] getPcm();

    public static class Constant
    extends Subframe {
        int[] pcm;

        public Constant(BitInputStream source, Frame frame, StreamInfo streamInfo) throws IOException {
            int c2 = source.getSignedInt(frame.getBitsPerSample());
            this.pcm = new int[frame.getBlockSize()];
            Arrays.fill(this.pcm, c2);
        }

        @Override
        public int[] getPcm() {
            return this.pcm;
        }
    }

    public static class Verbatim
    extends Subframe {
        int[] pcm;

        public Verbatim(BitInputStream source, Frame frame, StreamInfo streamInfo) throws IOException {
            int bps = frame.getBitsPerSample();
            int blockSize = frame.getBlockSize();
            this.pcm = new int[blockSize];
            for (int i2 = 0; i2 < blockSize; ++i2) {
                this.pcm[i2] = source.getSignedInt(bps);
            }
        }

        @Override
        public int[] getPcm() {
            return this.pcm;
        }
    }

    public static class Fixed
    extends Subframe {
        int[] pcm;
        int[] warmup;
        int[] residue;

        public Fixed(BitInputStream source, Frame frame, StreamInfo streamInfo, int wastedBits, int order, boolean sideChannel) throws IOException {
            int i2;
            int partitionSamples;
            int bitsPerSample = frame.getBitsPerSample();
            if (sideChannel) {
                ++bitsPerSample;
            }
            this.warmup = new int[order];
            for (int i3 = 0; i3 < order; ++i3) {
                this.warmup[i3] = source.getSignedInt(bitsPerSample - wastedBits);
            }
            int codingMethod = source.getInt(2);
            if (codingMethod != 0) {
                throw new FlacFormatException("SUBFRAME_FIXED: residual coding method " + codingMethod + " not supported");
            }
            int partitionOrder = source.getInt(4);
            int partitions = 1 << partitionOrder;
            int n2 = partitionSamples = partitionOrder > 0 ? frame.getBlockSize() >> partitionOrder : frame.getBlockSize() - order;
            if (Properties.analyze()) {
                System.out.print("\tsubframe=?\twasted_bits=" + wastedBits + "\t");
                System.out.print("type=FIXED\t");
                System.out.print("order=" + order + "\t");
                System.out.println("partition_order=" + partitionOrder);
            }
            this.pcm = new int[frame.getBlockSize()];
            this.residue = new int[frame.getBlockSize()];
            int sample = 0;
            for (int partition = 0; partition < partitions; ++partition) {
                int u;
                int riceParameter = source.getInt(4);
                if (riceParameter < 15) {
                    u = partitionOrder == 0 || partition > 0 ? partitionSamples : partitionSamples - order;
                    source.readSignedRice(riceParameter, this.residue, sample, u);
                    sample += u;
                    continue;
                }
                riceParameter = source.getInt(5);
                int n3 = u = partitionOrder == 0 || partition > 0 ? 0 : order;
                while (u < partitionSamples) {
                    this.residue[sample] = source.getSignedInt(riceParameter);
                    ++u;
                    ++sample;
                }
            }
            for (i2 = 0; i2 < order; ++i2) {
                this.pcm[i2] = this.warmup[i2];
                if (!Properties.analyze()) continue;
                System.out.println("\t\twarmup[" + i2 + "]=" + this.warmup[i2]);
            }
            int len2 = frame.getBlockSize() - order;
            switch (order) {
                case 0: {
                    for (i2 = 0; i2 < len2; ++i2) {
                        this.pcm[i2] = this.residue[i2];
                    }
                    break;
                }
                case 1: {
                    for (i2 = 0; i2 < len2; ++i2) {
                        this.pcm[i2 + 1] = this.residue[i2] + this.pcm[i2];
                    }
                    break;
                }
                case 2: {
                    for (i2 = 0; i2 < len2; ++i2) {
                        this.pcm[i2 + 2] = this.residue[i2] + (this.pcm[i2 + 1] << 1) - this.pcm[i2];
                    }
                    break;
                }
                case 3: {
                    for (i2 = 0; i2 < len2; ++i2) {
                        this.pcm[i2 + 3] = this.residue[i2] + ((this.pcm[i2 + 2] - this.pcm[i2 + 1] << 1) + (this.pcm[i2 + 2] - this.pcm[i2 + 1])) + this.pcm[i2];
                    }
                    break;
                }
                case 4: {
                    for (i2 = 0; i2 < len2; ++i2) {
                        this.pcm[i2 + 4] = this.residue[i2] + (this.pcm[i2 + 3] + this.pcm[i2 + 1] << 2) - ((this.pcm[i2 + 2] << 2) + (this.pcm[i2 + 2] << 1)) - this.pcm[i2];
                    }
                    break;
                }
                default: {
                    throw new FlacFormatException("Illegal SUBFRAME_FIXED order");
                }
            }
            if (wastedBits > 0) {
                i2 = 0;
                while (i2 < this.pcm.length) {
                    int n4 = i2++;
                    this.pcm[n4] = this.pcm[n4] << wastedBits;
                }
            }
        }

        @Override
        public int[] getPcm() {
            return this.pcm;
        }
    }

    public static class Lpc
    extends Subframe {
        int[] pcm;
        int[] warmup;
        int[] residue;
        int[] coeffs;

        public Lpc(BitInputStream source, Frame frame, StreamInfo streamInfo, int wastedBits, int order, boolean sideChannel) throws IOException {
            int i2;
            int bitsPerSample = frame.getBitsPerSample();
            if (sideChannel) {
                ++bitsPerSample;
            }
            this.warmup = new int[order];
            for (int i3 = 0; i3 < order; ++i3) {
                this.warmup[i3] = source.getSignedInt(bitsPerSample - wastedBits);
            }
            int coeffPrecision = source.getInt(4) + 1;
            if (coeffPrecision == 16) {
                throw new FlacFormatException("Illegal linear predictor coefficients' precision in SUBFRAME_LPC");
            }
            int quantizationLevel = source.getSignedInt(5);
            this.coeffs = new int[order];
            for (int i4 = 0; i4 < order; ++i4) {
                this.coeffs[i4] = source.getSignedInt(coeffPrecision);
            }
            int codingMethod = source.getInt(2);
            if (codingMethod != 0) {
                throw new FlacFormatException("SUBFRAME_FIXED: residual coding method " + codingMethod + " not supported", (ByteArrayBitInputStream)source);
            }
            int partitionOrder = source.getInt(4);
            int partitions = 1 << partitionOrder;
            int partitionSamples = partitionOrder > 0 ? frame.getBlockSize() >> partitionOrder : frame.getBlockSize() - order;
            this.pcm = new int[frame.getBlockSize()];
            this.residue = new int[frame.getBlockSize()];
            int sample = 0;
            for (int partition = 0; partition < partitions; ++partition) {
                int u;
                int riceParameter = source.getInt(4);
                if (riceParameter < 15) {
                    u = partitionOrder == 0 || partition > 0 ? partitionSamples : partitionSamples - order;
                    source.readSignedRice(riceParameter, this.residue, sample, u);
                    sample += u;
                    continue;
                }
                riceParameter = source.getInt(5);
                int n2 = u = partitionOrder == 0 || partition > 0 ? 0 : order;
                while (u < partitionSamples) {
                    this.residue[sample] = source.getSignedInt(riceParameter);
                    ++u;
                    ++sample;
                }
            }
            if (Properties.analyze()) {
                System.out.print("\tsubframe=?\twasted_bits=" + wastedBits + "\t");
                System.out.print("type=LPC\t");
                System.out.print("order=" + order + "\t");
                System.out.print("partition_order=" + partitionOrder + "\t");
                System.out.print("qlp_coeff_precision=" + coeffPrecision + "\t");
                System.out.println("quantization_level=" + quantizationLevel);
            }
            for (i2 = 0; i2 < order; ++i2) {
                this.pcm[i2] = this.warmup[i2];
                if (!Properties.analyze()) continue;
                System.out.println("\t\twarmup[" + i2 + "]=" + this.warmup[i2]);
            }
            for (i2 = 0; i2 < frame.getBlockSize() - order; ++i2) {
                long sum = 0L;
                int history = i2 + order;
                for (int j2 = 0; j2 < order; ++j2) {
                    sum += (long)this.coeffs[j2] * (long)this.pcm[--history];
                }
                this.pcm[i2 + order] = quantizationLevel >= 0 ? this.residue[i2] + (int)(sum >> quantizationLevel) : this.residue[i2] + (int)(sum << -quantizationLevel);
            }
            if (wastedBits > 0) {
                i2 = 0;
                while (i2 < this.pcm.length) {
                    int n3 = i2++;
                    this.pcm[n3] = this.pcm[n3] << wastedBits;
                }
            }
        }

        @Override
        public int[] getPcm() {
            return this.pcm;
        }
    }
}

