/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.flac.MetadataBlock;
import de.jarnbjo.flac.StreamInfo;
import de.jarnbjo.jmf.OggTrack;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.io.IOException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.format.AudioFormat;

public class FlacTrack
extends OggTrack {
    private final LogicalOggStream oggStream;
    private final StreamInfo streamInfo;
    private final AudioFormat format;

    public FlacTrack(LogicalOggStream source, byte[] siHeaderData) throws IOException {
        super(source);
        this.oggStream = source;
        ByteArrayBitInputStream bd = new ByteArrayBitInputStream(siHeaderData, 1);
        this.streamInfo = (StreamInfo)MetadataBlock.createInstance(bd);
        this.format = new AudioFormat("audio/x-flac", this.streamInfo.getSampleRate(), 16, this.streamInfo.getChannels(), -1, -1, -1, -1.0, Format.byteArray);
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public Time getDuration() {
        long nos = this.oggStream.getMaximumGranulePosition();
        return nos == -1L ? Duration.DURATION_UNKNOWN : new Time(nos * 1000000000L / (long)this.streamInfo.getSampleRate());
    }

    protected int getSampleRate() {
        return this.streamInfo.getSampleRate();
    }
}

