/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.theora;

import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.theora.CodingMode;
import de.jarnbjo.theora.Constants;
import de.jarnbjo.theora.Coordinate;
import de.jarnbjo.theora.Header;
import de.jarnbjo.theora.PbInstance;
import de.jarnbjo.theora.PostProcess;
import de.jarnbjo.theora.TheoraFormatException;
import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import de.jarnbjo.vorbis.Util;
import java.io.IOException;
import java.util.Arrays;

public class TheoraStream {
    private LogicalOggStream oggStream;
    private Header header;
    private PbInstance pbInstance;
    private long granulePos = -1L;

    public TheoraStream() {
    }

    public TheoraStream(LogicalOggStream oggStream) throws IOException {
        this.oggStream = oggStream;
        this.header = new Header(new ByteArrayBitInputStream(oggStream.getNextOggPacket(), 1));
        this.pbInstance = new PbInstance(this.header);
        this.pbInstance.initFrameDetails();
        this.pbInstance.keyframeGranuleShift = Util.ilog(this.header.getKeyframeFrequencyForce() - 1);
        this.pbInstance.lastFrameQualityValue = 0;
        this.pbInstance.decoderErrorCode = 0;
        Arrays.fill(this.pbInstance.skippedDisplayFragments, (byte)0);
        this.pbInstance.initQTables();
        this.pbInstance.initHuffmanSet();
    }

    public Header getHeader() {
        return this.header;
    }

    public PbInstance getPbi() {
        return this.pbInstance;
    }

    public byte[] decodePacket(byte[] packet) throws IOException {
        if (this.header == null) {
            this.header = new Header(new ByteArrayBitInputStream(packet, 1));
            System.out.println("-- header --");
            System.out.println(this.header.getWidth() + " " + this.header.getHeight());
            this.pbInstance = new PbInstance(this.header);
            this.pbInstance.initFrameDetails();
            this.pbInstance.keyframeGranuleShift = Util.ilog(this.header.getKeyframeFrequencyForce() - 1);
            this.pbInstance.lastFrameQualityValue = 0;
            this.pbInstance.decoderErrorCode = 0;
            Arrays.fill(this.pbInstance.skippedDisplayFragments, (byte)0);
            this.pbInstance.initQTables();
            this.pbInstance.initHuffmanSet();
            return null;
        }
        ByteArrayBitInputStream source = new ByteArrayBitInputStream(packet);
        this.pbInstance.decoderErrorCode = 0;
        if (source.getBit()) {
            throw new TheoraFormatException("Not a video frame");
        }
        this.loadAndDecode(source);
        if (this.pbInstance.postProcessingLevel != 0) {
            PostProcess.postProcess(this.pbInstance);
        }
        this.granulePos = 0L;
        if (this.granulePos == -1L) {
            this.granulePos = 0L;
        } else if (this.pbInstance.frameType == 0) {
            long frames = this.granulePos & (long)((1 << this.pbInstance.keyframeGranuleShift) - 1);
            this.granulePos >>= this.pbInstance.keyframeGranuleShift;
            this.granulePos += frames + 1L;
            this.granulePos <<= this.pbInstance.keyframeGranuleShift;
        } else {
            ++this.granulePos;
        }
        Arrays.fill(this.pbInstance.postProcessBuffer, (byte)68);
        return this.pbInstance.postProcessBuffer;
    }

    void loadAndDecode(BitInputStream source) throws IOException {
        this.pbInstance.invLastIntraDC = 0;
        this.pbInstance.invLastInterDC = 0;
        this.loadFrame(source);
        if (this.pbInstance.thisFrameQualityValue != this.pbInstance.lastFrameQualityValue) {
            this.pbInstance.updateQ(this.pbInstance.thisFrameQualityValue);
            this.pbInstance.lastFrameQualityValue = this.pbInstance.thisFrameQualityValue;
        }
        this.decodeData(source);
    }

    void loadFrame(BitInputStream source) throws IOException {
        this.loadFrameHeader(source);
        this.quadDecodeDisplayFragments(source);
    }

    void loadFrameHeader(BitInputStream source) throws IOException {
        this.pbInstance.frameType = (byte)source.getInt(1);
        int dctQMask = source.getInt(6);
        if (this.pbInstance.frameType == 0) {
            this.pbInstance.keyFrameType = (byte)source.getInt(1);
            int n2 = source.getInt(2);
        }
        this.pbInstance.thisFrameQualityValue = this.pbInstance.qThreshTable[dctQMask];
    }

    void quadDecodeDisplayFragments(BitInputStream source) throws IOException {
        int sb;
        int mbIndex = 0;
        this.pbInstance.codedBlockIndex = 0;
        Arrays.fill(this.pbInstance.displayFragments, (byte)0);
        if (this.pbInstance.frameType == 0) {
            Arrays.fill(this.pbInstance.sbFullyFlags, (byte)1);
            Arrays.fill(this.pbInstance.sbCodedFlags, (byte)1);
            Arrays.fill(this.pbInstance.mbCodedFlags, (byte)1);
        } else {
            Arrays.fill(this.pbInstance.sbCodedFlags, (byte)1);
            Arrays.fill(this.pbInstance.mbCodedFlags, (byte)1);
            this.pbInstance.getNextSbInit(source);
            for (sb = 0; sb < this.pbInstance.superBlocks; ++sb) {
                this.pbInstance.sbCodedFlags[sb] = this.pbInstance.getNextSbBit(source);
            }
            boolean dataToDecode = false;
            for (sb = 0; sb < this.pbInstance.superBlocks; ++sb) {
                if (this.pbInstance.sbCodedFlags[sb] != 0) continue;
                dataToDecode = true;
                break;
            }
            if (dataToDecode) {
                this.pbInstance.getNextSbInit(source);
                for (sb = 0; sb < this.pbInstance.superBlocks; ++sb) {
                    while (sb < this.pbInstance.superBlocks && this.pbInstance.sbCodedFlags[sb] != 0) {
                        ++sb;
                    }
                    if (sb >= this.pbInstance.superBlocks) continue;
                    this.pbInstance.sbFullyFlags[sb] = this.pbInstance.getNextSbBit(source);
                    if (this.pbInstance.sbFullyFlags[sb] == 0) continue;
                    this.pbInstance.sbCodedFlags[sb] = 1;
                }
            }
            for (sb = 0; sb < this.pbInstance.superBlocks; ++sb) {
                if (this.pbInstance.sbCodedFlags[sb] == 0 || this.pbInstance.sbFullyFlags[sb] != 0) continue;
                this.pbInstance.getNextBInit(source);
                break;
            }
        }
        for (sb = 0; sb < this.pbInstance.superBlocks; ++sb) {
            for (int mb = 0; mb < 4; ++mb) {
                if (TheoraStream.quadMapToMBTopLeft(this.pbInstance.blockMap, sb, mb) < 0) continue;
                if (this.pbInstance.sbCodedFlags[sb] != 0) {
                    for (int b2 = 0; b2 < 4; ++b2) {
                        int dfIndex = TheoraStream.quadMapToIndex1(this.pbInstance.blockMap, sb, mb, b2);
                        if (dfIndex < 0) continue;
                        this.pbInstance.displayFragments[dfIndex] = this.pbInstance.sbFullyFlags[sb] != 0 ? (byte)1 : this.pbInstance.getNextBBit(source);
                        if (this.pbInstance.displayFragments[dfIndex] == 0) continue;
                        this.pbInstance.mbCodedFlags[mbIndex] = 1;
                        this.pbInstance.codedBlockList[this.pbInstance.codedBlockIndex] = dfIndex;
                        ++this.pbInstance.codedBlockIndex;
                    }
                }
                ++mbIndex;
            }
        }
    }

    void decodeData(BitInputStream source) throws IOException {
        if (this.pbInstance.decoderErrorCode != 0) {
            return;
        }
        for (int i2 = 0; i2 < this.pbInstance.unitFragments; ++i2) {
            this.pbInstance.fragCodingMethod[i2] = CodingMode.CODE_INTER_NO_MV;
            this.pbInstance.fragMVect[i2] = new Coordinate();
            this.pbInstance.fragMVect[i2].x = 0;
            this.pbInstance.fragMVect[i2].y = 0;
        }
        this.pbInstance.eobRun = 0;
        this.pbInstance.codedBlocksThisFrame = this.pbInstance.codedBlockIndex;
        this.decodeModes(source, this.pbInstance.ysbRows, this.pbInstance.ysbCols);
    }

    void decodeModes(BitInputStream source, int sbRows, int sbCols) throws IOException {
        int sb = 0;
        int mbListIndex = 0;
        if (this.pbInstance.frameType == 0) {
            for (int i2 = 0; i2 < this.pbInstance.unitFragments; ++i2) {
                this.pbInstance.fragCodingMethod[i2] = CodingMode.CODE_INTRA;
            }
        } else {
            int codingScheme = source.getInt(3);
            if (codingScheme == 0) {
                for (int i3 = 0; i3 < 8; ++i3) {
                    Constants.modeAlphabet[0][source.getInt((int)3)] = CodingMode.MODES[i3];
                }
            }
            for (int sbRow = 0; sbRow < sbRows; ++sbRow) {
                for (int sbCol = 0; sbCol < sbCols; ++sbCol) {
                    for (int mb = 0; mb < 4; ++mb) {
                        CodingMode codingMethod;
                        if (TheoraStream.quadMapToMBTopLeft(this.pbInstance.blockMap, sb, mb) < 0 || this.pbInstance.mbCodedFlags[mbListIndex++] == 0) continue;
                        int fragIndex = TheoraStream.quadMapToMBTopLeft(this.pbInstance.blockMap, sb, mb);
                        if (codingScheme == 7) {
                            codingMethod = CodingMode.MODES[source.getInt(3)];
                        } else {
                            int modeEntry = this.pbInstance.frArrayUnpackMode(source).getValue();
                            codingMethod = Constants.modeAlphabet[codingScheme][modeEntry];
                        }
                        this.pbInstance.fragCodingMethod[fragIndex] = codingMethod;
                        this.pbInstance.fragCodingMethod[fragIndex + 1] = codingMethod;
                        this.pbInstance.fragCodingMethod[fragIndex + this.pbInstance.hFragments] = codingMethod;
                        this.pbInstance.fragCodingMethod[fragIndex + this.pbInstance.hFragments + 1] = codingMethod;
                        int uvRow = fragIndex / (this.pbInstance.hFragments * 2);
                        int uvColumn = fragIndex % this.pbInstance.hFragments / 2;
                        int uvFragOffset = uvRow * (this.pbInstance.hFragments / 2) + uvColumn;
                        this.pbInstance.fragCodingMethod[this.pbInstance.yPlaneFragments + uvFragOffset] = codingMethod;
                        this.pbInstance.fragCodingMethod[this.pbInstance.yPlaneFragments + this.pbInstance.uvPlaneFragments + uvFragOffset] = codingMethod;
                    }
                    ++sb;
                }
            }
        }
    }

    private static int quadMapToIndex1(int[][][] blockMap, int sb, int mb, int b2) {
        return blockMap[sb][Constants.mbOrderMap[mb]][Constants.blockOrderMap1[mb][b2]];
    }

    private static int quadMapToMBTopLeft(int[][][] blockMap, int sb, int mb) {
        return blockMap[sb][Constants.mbOrderMap[mb]][0];
    }
}

