/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Floor;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

class Floor1
extends Floor
implements Cloneable {
    private int[] partitionClassList;
    private int maximumClass;
    private int multiplier;
    private int rangeBits;
    private int[] classDimensions;
    private int[] classSubclasses;
    private int[] classMasterbooks;
    private int[][] subclassBooks;
    private int[] xList;
    private int[] yList;
    private int[] lowNeighbours;
    private int[] highNeighbours;
    private static final int[] RANGES = new int[]{256, 128, 86, 64};

    private Floor1() {
    }

    protected Floor1(BitInputStream source, SetupHeader header) throws IOException {
        int i2;
        this.maximumClass = -1;
        int partitions = source.getInt(5);
        this.partitionClassList = new int[partitions];
        for (int i3 = 0; i3 < this.partitionClassList.length; ++i3) {
            this.partitionClassList[i3] = source.getInt(4);
            if (this.partitionClassList[i3] <= this.maximumClass) continue;
            this.maximumClass = this.partitionClassList[i3];
        }
        this.classDimensions = new int[this.maximumClass + 1];
        this.classSubclasses = new int[this.maximumClass + 1];
        this.classMasterbooks = new int[this.maximumClass + 1];
        this.subclassBooks = new int[this.maximumClass + 1][];
        int xListLength = 2;
        for (int i4 = 0; i4 <= this.maximumClass; ++i4) {
            this.classDimensions[i4] = source.getInt(3) + 1;
            xListLength += this.classDimensions[i4];
            this.classSubclasses[i4] = source.getInt(2);
            if (this.classDimensions[i4] > header.getCodeBooks().length || this.classSubclasses[i4] > header.getCodeBooks().length) {
                throw new VorbisFormatException("There is a class dimension or class subclasses entry higher than the number of codebooks in the setup header.");
            }
            if (this.classSubclasses[i4] != 0) {
                this.classMasterbooks[i4] = source.getInt(8);
            }
            this.subclassBooks[i4] = new int[1 << this.classSubclasses[i4]];
            for (int j2 = 0; j2 < this.subclassBooks[i4].length; ++j2) {
                this.subclassBooks[i4][j2] = source.getInt(8) - 1;
            }
        }
        this.multiplier = source.getInt(2) + 1;
        this.rangeBits = source.getInt(4);
        boolean floorValues = false;
        ArrayList<Integer> alXList = new ArrayList<Integer>();
        alXList.add(0);
        alXList.add(1 << this.rangeBits);
        for (int i5 = 0; i5 < partitions; ++i5) {
            for (int j3 = 0; j3 < this.classDimensions[this.partitionClassList[i5]]; ++j3) {
                alXList.add(source.getInt(this.rangeBits));
            }
        }
        this.xList = new int[alXList.size()];
        this.lowNeighbours = new int[this.xList.length];
        this.highNeighbours = new int[this.xList.length];
        Iterator iter = alXList.iterator();
        for (i2 = 0; i2 < this.xList.length; ++i2) {
            this.xList[i2] = (Integer)iter.next();
        }
        for (i2 = 0; i2 < this.xList.length; ++i2) {
            this.lowNeighbours[i2] = Util.lowNeighbour(this.xList, i2);
            this.highNeighbours[i2] = Util.highNeighbour(this.xList, i2);
        }
    }

    @Override
    protected int getType() {
        return 1;
    }

    @Override
    protected Floor decodeFloor(VorbisStream vorbis, BitInputStream source) throws IOException {
        if (!source.getBit()) {
            return null;
        }
        Floor1 clone = (Floor1)this.clone();
        clone.yList = new int[this.xList.length];
        int range = RANGES[this.multiplier - 1];
        clone.yList[0] = source.getInt(Util.ilog(range - 1));
        clone.yList[1] = source.getInt(Util.ilog(range - 1));
        int offset = 2;
        for (int cls : this.partitionClassList) {
            int cdim = this.classDimensions[cls];
            int cbits = this.classSubclasses[cls];
            int csub = (1 << cbits) - 1;
            int cval = 0;
            if (cbits > 0) {
                cval = source.getInt(vorbis.getSetupHeader().getCodeBooks()[this.classMasterbooks[cls]].getHuffmanRoot());
            }
            for (int j2 = 0; j2 < cdim; ++j2) {
                int book = this.subclassBooks[cls][cval & csub];
                cval >>>= cbits;
                clone.yList[j2 + offset] = book >= 0 ? source.getInt(vorbis.getSetupHeader().getCodeBooks()[book].getHuffmanRoot()) : 0;
            }
            offset += cdim;
        }
        return clone;
    }

    @Override
    protected void computeFloor(float[] vector2) {
        int n2 = vector2.length;
        int values = this.xList.length;
        boolean[] step2Flags = new boolean[values];
        int range = RANGES[this.multiplier - 1];
        for (int i2 = 2; i2 < values; ++i2) {
            int room;
            int lowNeighbourOffset = this.lowNeighbours[i2];
            int highNeighbourOffset = this.highNeighbours[i2];
            int predicted = Util.renderPoint(this.xList[lowNeighbourOffset], this.xList[highNeighbourOffset], this.yList[lowNeighbourOffset], this.yList[highNeighbourOffset], this.xList[i2]);
            int val = this.yList[i2];
            int highRoom = range - predicted;
            int lowRoom = predicted;
            int n3 = room = highRoom < lowRoom ? highRoom * 2 : lowRoom * 2;
            if (val != 0) {
                step2Flags[lowNeighbourOffset] = true;
                step2Flags[highNeighbourOffset] = true;
                step2Flags[i2] = true;
                if (val >= room) {
                    this.yList[i2] = highRoom > lowRoom ? val - lowRoom + predicted : -val + highRoom + predicted - 1;
                    continue;
                }
                this.yList[i2] = (val & 1) == 1 ? predicted - (val + 1 >> 1) : predicted + (val >> 1);
                continue;
            }
            step2Flags[i2] = false;
            this.yList[i2] = predicted;
        }
        int[] xList2 = new int[values];
        System.arraycopy(this.xList, 0, xList2, 0, values);
        Floor1.sort(xList2, this.yList, step2Flags);
        int hx = 0;
        int hy = 0;
        int lx = 0;
        int ly = this.yList[0] * this.multiplier;
        float[] vector22 = new float[vector2.length];
        float[] vector3 = new float[vector2.length];
        Arrays.fill(vector22, 1.0f);
        System.arraycopy(vector2, 0, vector3, 0, vector2.length);
        for (int i3 = 1; i3 < values; ++i3) {
            if (!step2Flags[i3]) continue;
            hy = this.yList[i3] * this.multiplier;
            hx = xList2[i3];
            Util.renderLine(lx, ly, hx, hy, vector2);
            Util.renderLine(lx, ly, hx, hy, vector22);
            lx = hx;
            ly = hy;
        }
        float r = DB_STATIC_TABLE[hy];
        while (hx < n2 / 2) {
            vector2[hx++] = r;
        }
    }

    public Object clone() {
        Floor1 clone = new Floor1();
        clone.classDimensions = this.classDimensions;
        clone.classMasterbooks = this.classMasterbooks;
        clone.classSubclasses = this.classSubclasses;
        clone.maximumClass = this.maximumClass;
        clone.multiplier = this.multiplier;
        clone.partitionClassList = this.partitionClassList;
        clone.rangeBits = this.rangeBits;
        clone.subclassBooks = this.subclassBooks;
        clone.xList = this.xList;
        clone.yList = this.yList;
        clone.lowNeighbours = this.lowNeighbours;
        clone.highNeighbours = this.highNeighbours;
        return clone;
    }

    private static void sort(int[] x, int[] y, boolean[] b2) {
        int off = 0;
        int len2 = x.length;
        int lim = len2 + off;
        for (int i2 = off; i2 < lim; ++i2) {
            for (int j2 = i2; j2 > off && x[j2 - 1] > x[j2]; --j2) {
                int itmp = x[j2];
                x[j2] = x[j2 - 1];
                x[j2 - 1] = itmp;
                itmp = y[j2];
                y[j2] = y[j2 - 1];
                y[j2 - 1] = itmp;
                boolean btmp = b2[j2];
                b2[j2] = b2[j2 - 1];
                b2[j2 - 1] = btmp;
            }
        }
    }

    private static void swap(int[] x, int a2, int b2) {
        int t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    private static void swap(boolean[] x, int a2, int b2) {
        boolean t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }
}

