/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

class MdctFloat {
    private static final float cPI3_8 = 0.38268343f;
    private static final float cPI2_8 = 0.70710677f;
    private static final float cPI1_8 = 0.9238795f;
    private final int n;
    private final int log2n;
    private final float[] trig;
    private final int[] bitrev;
    private float[] equalizer;
    private final float scale;
    private int itmp1;
    private int itmp2;
    private int itmp3;
    private int itmp4;
    private int itmp5;
    private int itmp6;
    private int itmp7;
    private int itmp8;
    private int itmp9;
    private float dtmp1;
    private float dtmp2;
    private float dtmp3;
    private float dtmp4;
    private float dtmp5;
    private float dtmp6;
    private float dtmp7;
    private float dtmp8;
    private float dtmp9;
    private float[] tmpX = new float[1024];
    private float[] tmpW = new float[1024];

    protected MdctFloat(int n2) {
        int i2;
        this.bitrev = new int[n2 / 4];
        this.trig = new float[n2 + n2 / 4];
        int n22 = n2 >>> 1;
        this.log2n = (int)Math.rint(Math.log(n2) / Math.log(2.0));
        this.n = n2;
        int AE = 0;
        int AO = 1;
        int BE = AE + n2 / 2;
        int BO = BE + 1;
        int CE = BE + n2 / 2;
        int CO = CE + 1;
        for (i2 = 0; i2 < n2 / 4; ++i2) {
            this.trig[AE + i2 * 2] = (float)Math.cos(Math.PI / (double)n2 * (double)(4 * i2));
            this.trig[AO + i2 * 2] = (float)(-Math.sin(Math.PI / (double)n2 * (double)(4 * i2)));
            this.trig[BE + i2 * 2] = (float)Math.cos(Math.PI / (double)(2 * n2) * (double)(2 * i2 + 1));
            this.trig[BO + i2 * 2] = (float)Math.sin(Math.PI / (double)(2 * n2) * (double)(2 * i2 + 1));
        }
        for (i2 = 0; i2 < n2 / 8; ++i2) {
            this.trig[CE + i2 * 2] = (float)Math.cos(Math.PI / (double)n2 * (double)(4 * i2 + 2));
            this.trig[CO + i2 * 2] = (float)(-Math.sin(Math.PI / (double)n2 * (double)(4 * i2 + 2)));
        }
        int mask = (1 << this.log2n - 1) - 1;
        int msb = 1 << this.log2n - 2;
        for (int i3 = 0; i3 < n2 / 8; ++i3) {
            int acc = 0;
            int j2 = 0;
            while (msb >>> j2 != 0) {
                if ((msb >>> j2 & i3) != 0) {
                    acc |= 1 << j2;
                }
                ++j2;
            }
            this.bitrev[i3 * 2] = ~acc & mask;
            this.bitrev[i3 * 2 + 1] = acc;
        }
        this.scale = 4.0f / (float)n2;
    }

    protected void setEqualizer(float[] equalizer) {
        this.equalizer = equalizer;
    }

    protected float[] getEqualizer() {
        return this.equalizer;
    }

    protected synchronized void imdct(float[] frq, float[] window, int[] pcm) {
        int i2;
        float[] in = frq;
        if (this.tmpX.length < this.n / 2) {
            this.tmpX = new float[this.n / 2];
        }
        if (this.tmpW.length < this.n / 2) {
            this.tmpW = new float[this.n / 2];
        }
        float[] x = this.tmpX;
        float[] w = this.tmpW;
        int n2 = this.n >> 1;
        int n4 = this.n >> 2;
        int n8 = this.n >> 3;
        if (this.equalizer != null) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                int n3 = i3;
                frq[n3] = frq[n3] * this.equalizer[i3];
            }
        }
        int inO = -1;
        int xO = 0;
        int A = n2;
        for (i2 = 0; i2 < n8; ++i2) {
            this.dtmp1 = in[inO += 2];
            this.dtmp2 = in[inO += 2];
            this.dtmp3 = this.trig[--A];
            this.dtmp4 = this.trig[--A];
            x[xO++] = -this.dtmp2 * this.dtmp3 - this.dtmp1 * this.dtmp4;
            x[xO++] = this.dtmp1 * this.dtmp3 - this.dtmp2 * this.dtmp4;
        }
        inO = n2;
        for (i2 = 0; i2 < n8; ++i2) {
            this.dtmp1 = in[inO -= 2];
            this.dtmp2 = in[inO -= 2];
            this.dtmp3 = this.trig[--A];
            this.dtmp4 = this.trig[--A];
            x[xO++] = this.dtmp2 * this.dtmp3 + this.dtmp1 * this.dtmp4;
            x[xO++] = this.dtmp2 * this.dtmp4 - this.dtmp1 * this.dtmp3;
        }
        float[] xxx = this.kernel(x, w, this.n, n2, n4, n8);
        int xx = 0;
        int B = n2;
        int o1 = n4;
        int o2 = o1 - 1;
        int o3 = n4 + n2;
        int o4 = o3 - 1;
        for (int i4 = 0; i4 < n4; ++i4) {
            this.dtmp1 = xxx[xx++];
            this.dtmp2 = xxx[xx++];
            this.dtmp3 = this.trig[B++];
            this.dtmp4 = this.trig[B++];
            float temp1 = this.dtmp1 * this.dtmp4 - this.dtmp2 * this.dtmp3;
            float temp2 = -(this.dtmp1 * this.dtmp3 + this.dtmp2 * this.dtmp4);
            pcm[o1] = (int)(-temp1 * window[o1]);
            pcm[o2] = (int)(temp1 * window[o2]);
            pcm[o3] = (int)(temp2 * window[o3]);
            pcm[o4] = (int)(temp2 * window[o4]);
            ++o1;
            --o2;
            ++o3;
            --o4;
        }
    }

    private float[] kernel(float[] x, float[] w, int n2, int n22, int n4, int n8) {
        int i2;
        int xA = n4;
        int xB = 0;
        int w2 = n4;
        int A = n22;
        for (i2 = 0; i2 < n4; ++i2) {
            float x0 = x[xA] - x[xB];
            w[w2 + i2] = x[xA++] + x[xB++];
            float x1 = x[xA] - x[xB];
            w[i2++] = x0 * this.trig[A -= 4] + x1 * this.trig[A + 1];
            w[i2] = x1 * this.trig[A] - x0 * this.trig[A + 1];
            w[w2 + i2] = x[xA++] + x[xB++];
        }
        for (i2 = 0; i2 < this.log2n - 3; ++i2) {
            int k0 = n2 >>> i2 + 2;
            int k1 = 1 << i2 + 3;
            int wbase = n22 - 2;
            A = 0;
            for (int r = 0; r < k0 >>> 2; ++r) {
                int w1 = wbase;
                w2 = w1 - (k0 >> 1);
                float AEv = this.trig[A];
                float AOv = this.trig[A + 1];
                wbase -= 2;
                ++k0;
                for (int s = 0; s < 2 << i2; ++s) {
                    this.dtmp1 = w[w1];
                    this.dtmp2 = w[w2];
                    float wB = this.dtmp1 - this.dtmp2;
                    x[w1] = this.dtmp1 + this.dtmp2;
                    this.dtmp1 = w[++w1];
                    this.dtmp2 = w[++w2];
                    float wA = this.dtmp1 - this.dtmp2;
                    x[w1] = this.dtmp1 + this.dtmp2;
                    x[w2] = wA * AEv - wB * AOv;
                    x[w2 - 1] = wB * AEv + wA * AOv;
                    w1 -= k0;
                    w2 -= k0;
                }
                --k0;
                A += k1;
            }
            float[] temp = w;
            w = x;
            x = temp;
        }
        int C = n2;
        int bit = 0;
        int x1 = 0;
        int x2 = n22 - 1;
        for (int i3 = 0; i3 < n8; ++i3) {
            int t1 = this.bitrev[bit++];
            int t2 = this.bitrev[bit++];
            float wA = w[t1] - w[t2 + 1];
            float wB = w[t1 - 1] + w[t2];
            float wC = w[t1] + w[t2 + 1];
            float wD = w[t1 - 1] - w[t2];
            float wACE = wA * this.trig[C];
            float wBCE = wB * this.trig[C++];
            float wACO = wA * this.trig[C];
            float wBCO = wB * this.trig[C++];
            x[x1++] = (wC + wACO + wBCE) * 16383.0f;
            x[x2--] = (-wD + wBCO - wACE) * 16383.0f;
            x[x1++] = (wD + wBCO - wACE) * 16383.0f;
            x[x2--] = (wC - wACO - wBCE) * 16383.0f;
        }
        return x;
    }
}

