/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import de.jarnbjo.vorbis.AudioPacket;
import de.jarnbjo.vorbis.CommentHeader;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;

public class VorbisStream {
    private LogicalOggStream oggStream;
    private IdentificationHeader identificationHeader;
    private CommentHeader commentHeader;
    private SetupHeader setupHeader;
    private AudioPacket lastAudioPacket;
    private AudioPacket nextAudioPacket;
    private final LinkedList audioPackets = new LinkedList();
    private byte[] currentPcm;
    private int currentPcmIndex;
    private int currentPcmLimit;
    private static final int IDENTIFICATION_HEADER = 1;
    private static final int COMMENT_HEADER = 3;
    private static final int SETUP_HEADER = 5;
    private final Object streamLock = new Object();
    private int currentBitRate = 0;
    private long currentGranulePosition;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;

    public VorbisStream() {
    }

    public VorbisStream(LogicalOggStream oggStream) throws IOException {
        this.oggStream = oggStream;
        block5: for (int i2 = 0; i2 < 3; ++i2) {
            ByteArrayBitInputStream source = new ByteArrayBitInputStream(oggStream.getNextOggPacket());
            int headerType = source.getInt(8);
            switch (headerType) {
                case 1: {
                    this.identificationHeader = new IdentificationHeader(source);
                    continue block5;
                }
                case 3: {
                    this.commentHeader = new CommentHeader(source);
                    continue block5;
                }
                case 5: {
                    this.setupHeader = new SetupHeader(this, source);
                    continue block5;
                }
            }
        }
        if (this.identificationHeader == null) {
            throw new VorbisFormatException("The file has no identification header.");
        }
        if (this.commentHeader == null) {
            throw new VorbisFormatException("The file has no commentHeader.");
        }
        if (this.setupHeader == null) {
            throw new VorbisFormatException("The file has no setup header.");
        }
        this.currentPcm = new byte[this.identificationHeader.getChannels() * this.identificationHeader.getBlockSize1() * 2];
    }

    public IdentificationHeader getIdentificationHeader() {
        return this.identificationHeader;
    }

    public CommentHeader getCommentHeader() {
        return this.commentHeader;
    }

    protected SetupHeader getSetupHeader() {
        return this.setupHeader;
    }

    public boolean isOpen() {
        return this.oggStream.isOpen();
    }

    public void close() throws IOException {
        this.oggStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readPcm(byte[] buffer, int offset, int length) throws IOException {
        Object object = this.streamLock;
        synchronized (object) {
            int channels = this.identificationHeader.getChannels();
            if (this.lastAudioPacket == null) {
                this.lastAudioPacket = this.getNextAudioPacket();
            }
            if (this.currentPcm == null || this.currentPcmIndex >= this.currentPcmLimit) {
                AudioPacket ap = this.getNextAudioPacket();
                try {
                    ap.getPcm(this.lastAudioPacket, this.currentPcm);
                    this.currentPcmLimit = ap.getNumberOfSamples() * this.identificationHeader.getChannels() * 2;
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    return 0;
                }
                this.currentPcmIndex = 0;
                this.lastAudioPacket = ap;
            }
            int written = 0;
            int i2 = 0;
            int arrIx = 0;
            for (i2 = this.currentPcmIndex; i2 < this.currentPcmLimit && arrIx < length; ++i2) {
                buffer[offset + arrIx++] = this.currentPcm[i2];
                ++written;
            }
            this.currentPcmIndex = i2;
            return written;
        }
    }

    private AudioPacket getNextAudioPacket() throws IOException {
        AudioPacket res = null;
        byte[] data = null;
        while (res == null) {
            try {
                data = this.oggStream.getNextOggPacket();
                res = new AudioPacket(this, new ByteArrayBitInputStream(data));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.currentGranulePosition += (long)res.getNumberOfSamples();
        this.currentBitRate = data.length * 8 * this.identificationHeader.getSampleRate() / res.getNumberOfSamples();
        return res;
    }

    public long getCurrentGranulePosition() {
        return this.currentGranulePosition;
    }

    public int getCurrentBitRate() {
        return this.currentBitRate;
    }

    public byte[] processPacket(byte[] packet) throws IOException {
        if (packet.length == 0) {
            throw new VorbisFormatException("Cannot decode a vorbis packet with length = 0");
        }
        if ((packet[0] & 1) == 1) {
            ByteArrayBitInputStream source = new ByteArrayBitInputStream(packet);
            switch (source.getInt(8)) {
                case 1: {
                    this.identificationHeader = new IdentificationHeader(source);
                    break;
                }
                case 3: {
                    this.commentHeader = new CommentHeader(source);
                    break;
                }
                case 5: {
                    this.setupHeader = new SetupHeader(this, source);
                    break;
                }
            }
            return null;
        }
        if (this.identificationHeader == null || this.commentHeader == null || this.setupHeader == null) {
            throw new VorbisFormatException("Cannot decode audio packet before all three header packets have been decoded.");
        }
        AudioPacket ap = new AudioPacket(this, new ByteArrayBitInputStream(packet));
        this.currentGranulePosition += (long)ap.getNumberOfSamples();
        if (this.lastAudioPacket == null) {
            this.lastAudioPacket = ap;
            return null;
        }
        byte[] res = new byte[this.identificationHeader.getChannels() * ap.getNumberOfSamples() * 2];
        try {
            ap.getPcm(this.lastAudioPacket, res);
        }
        catch (IndexOutOfBoundsException e2) {
            Arrays.fill(res, (byte)0);
        }
        this.lastAudioPacket = ap;
        return res;
    }
}

