/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class H261Format
extends VideoFormat {
    protected int stillImageTransmission = -1;
    private static String ENCODING = "h261";

    public H261Format() {
        super(ENCODING);
    }

    public H261Format(Dimension size, int maxDataLength, Class dataType, float frameRate, int stillImageTransmission) {
        super(ENCODING, size, maxDataLength, dataType, frameRate);
        this.stillImageTransmission = stillImageTransmission;
    }

    public int getStillImageTransmission() {
        return this.stillImageTransmission;
    }

    public Object clone() {
        H261Format f2 = new H261Format();
        f2.copy(this);
        return f2;
    }

    protected void copy(Format f2) {
        super.copy(f2);
        this.stillImageTransmission = ((H261Format)f2).stillImageTransmission;
    }

    public String toString() {
        return "H.261 video format";
    }

    public boolean equals(Object format2) {
        if (format2 instanceof H261Format) {
            return super.equals(format2) && this.stillImageTransmission == ((H261Format)format2).stillImageTransmission;
        }
        return false;
    }

    public boolean matches(Format format2) {
        if (!super.matches(format2)) {
            return false;
        }
        if (!(format2 instanceof H261Format)) {
            return true;
        }
        H261Format f2 = (H261Format)format2;
        return this.stillImageTransmission == -1 || f2.stillImageTransmission == -1 || this.stillImageTransmission == f2.stillImageTransmission;
    }

    public Format intersects(Format format2) {
        Format fmt = super.intersects(format2);
        if (fmt == null) {
            return null;
        }
        if (!(format2 instanceof H261Format)) {
            return fmt;
        }
        H261Format other = (H261Format)format2;
        H261Format res = (H261Format)fmt;
        res.stillImageTransmission = this.stillImageTransmission != -1 ? this.stillImageTransmission : other.stillImageTransmission;
        return res;
    }
}

