/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;

public class TestResult {
    protected Vector fFailures = new Vector();
    protected Vector fErrors = new Vector();
    protected Vector fListeners = new Vector();
    protected int fRunTests = 0;
    private boolean fStop = false;

    public synchronized void addError(Test test, Throwable t) {
        this.fErrors.addElement(new TestFailure(test, t));
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).addError(test, t);
        }
    }

    public synchronized void addFailure(Test test, AssertionFailedError t) {
        this.fFailures.addElement(new TestFailure(test, t));
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).addFailure(test, t);
        }
    }

    public synchronized void addListener(TestListener listener) {
        this.fListeners.addElement(listener);
    }

    public synchronized void removeListener(TestListener listener) {
        this.fListeners.removeElement(listener);
    }

    private synchronized Vector cloneListeners() {
        return (Vector)this.fListeners.clone();
    }

    public void endTest(Test test) {
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).endTest(test);
        }
    }

    public synchronized int errorCount() {
        return this.fErrors.size();
    }

    public synchronized Enumeration errors() {
        return this.fErrors.elements();
    }

    public synchronized int failureCount() {
        return this.fFailures.size();
    }

    public synchronized Enumeration failures() {
        return this.fFailures.elements();
    }

    protected void run(final TestCase test) {
        this.startTest(test);
        Protectable p = new Protectable(){

            public void protect() throws Throwable {
                test.runBare();
            }
        };
        this.runProtected(test, p);
        this.endTest(test);
    }

    public synchronized int runCount() {
        return this.fRunTests;
    }

    public void runProtected(Test test, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e2) {
            this.addFailure(test, e2);
        }
        catch (ThreadDeath e3) {
            throw e3;
        }
        catch (Throwable e4) {
            this.addError(test, e4);
        }
    }

    public synchronized boolean shouldStop() {
        return this.fStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTest(Test test) {
        int count = test.countTestCases();
        TestResult testResult = this;
        synchronized (testResult) {
            this.fRunTests += count;
        }
        Enumeration e2 = this.cloneListeners().elements();
        while (e2.hasMoreElements()) {
            ((TestListener)e2.nextElement()).startTest(test);
        }
    }

    public synchronized void stop() {
        this.fStop = true;
    }

    public synchronized boolean wasSuccessful() {
        return this.failureCount() == 0 && this.errorCount() == 0;
    }
}

