/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSuite
implements Test {
    private String fName;
    private Vector fTests = new Vector(10);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$junit$framework$Test;

    public static Test createTest(Class theClass, String name) {
        Object test;
        Constructor constructor;
        try {
            constructor = TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e2) {
            return TestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()");
        }
        try {
            if (constructor.getParameterTypes().length == 0) {
                test = constructor.newInstance(new Object[0]);
                if (test instanceof TestCase) {
                    ((TestCase)test).setName(name);
                }
            } else {
                test = constructor.newInstance(name);
            }
        }
        catch (InstantiationException e3) {
            return TestSuite.warning("Cannot instantiate test case: " + name + " (" + TestSuite.exceptionToString(e3) + ")");
        }
        catch (InvocationTargetException e4) {
            return TestSuite.warning("Exception in constructor: " + name + " (" + TestSuite.exceptionToString(e4.getTargetException()) + ")");
        }
        catch (IllegalAccessException e5) {
            return TestSuite.warning("Cannot access test case: " + name + " (" + TestSuite.exceptionToString(e5) + ")");
        }
        return (Test)test;
    }

    public static Constructor getTestConstructor(Class theClass) throws NoSuchMethodException {
        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TestSuite.class$("java.lang.String")) : class$java$lang$String};
        try {
            return theClass.getConstructor(args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return theClass.getConstructor(new Class[0]);
        }
    }

    public static Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail(message);
            }
        };
    }

    private static String exceptionToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public TestSuite() {
    }

    public TestSuite(Class theClass) {
        this.fName = theClass.getName();
        try {
            TestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException e2) {
            this.addTest(TestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name) or TestCase()"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(TestSuite.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        while ((class$junit$framework$Test == null ? TestSuite.class$("junit.framework.Test") : class$junit$framework$Test).isAssignableFrom(superClass)) {
            Method[] methods = superClass.getDeclaredMethods();
            for (int i2 = 0; i2 < methods.length; ++i2) {
                this.addTestMethod(methods[i2], names, theClass);
            }
            superClass = superClass.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(TestSuite.warning("No tests found in " + theClass.getName()));
        }
    }

    public TestSuite(Class theClass, String name) {
        this(theClass);
        this.setName(name);
    }

    public TestSuite(String name) {
        this.setName(name);
    }

    public TestSuite(Class[] classes) {
        for (int i2 = 0; i2 < classes.length; ++i2) {
            this.addTest(new TestSuite(classes[i2]));
        }
    }

    public TestSuite(Class[] classes, String name) {
        this(classes);
        this.setName(name);
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    public void addTestSuite(Class testClass) {
        this.addTest(new TestSuite(testClass));
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e2 = this.tests();
        while (e2.hasMoreElements()) {
            Test test = (Test)e2.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    public String getName() {
        return this.fName;
    }

    public void run(TestResult result2) {
        Enumeration e2 = this.tests();
        while (e2.hasMoreElements() && !result2.shouldStop()) {
            Test test = (Test)e2.nextElement();
            this.runTest(test, result2);
        }
    }

    public void runTest(Test test, TestResult result2) {
        test.run(result2);
    }

    public void setName(String name) {
        this.fName = name;
    }

    public Test testAt(int index) {
        return (Test)this.fTests.elementAt(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    private void addTestMethod(Method m2, Vector names, Class theClass) {
        String name = m2.getName();
        if (names.contains(name)) {
            return;
        }
        if (!this.isPublicTestMethod(m2)) {
            if (this.isTestMethod(m2)) {
                this.addTest(TestSuite.warning("Test method isn't public: " + m2.getName()));
            }
            return;
        }
        names.addElement(name);
        this.addTest(TestSuite.createTest(theClass, name));
    }

    private boolean isPublicTestMethod(Method m2) {
        return this.isTestMethod(m2) && Modifier.isPublic(m2.getModifiers());
    }

    private boolean isTestMethod(Method m2) {
        String name = m2.getName();
        Class<?>[] parameters = m2.getParameterTypes();
        Class<?> returnType = m2.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

