/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.com.naef.jnlua;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import li.cil.repack.com.naef.jnlua.JavaFunction;
import li.cil.repack.com.naef.jnlua.JavaReflector;
import li.cil.repack.com.naef.jnlua.LuaRuntimeException;
import li.cil.repack.com.naef.jnlua.LuaState;
import li.cil.repack.com.naef.jnlua.LuaType;
import li.cil.repack.com.naef.jnlua.NamedJavaFunction;
import li.cil.repack.com.naef.jnlua.TypedJavaObject;

public class JavaModule {
    private static final JavaModule INSTANCE = new JavaModule();
    private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
    private final NamedJavaFunction[] functions = new NamedJavaFunction[]{new Require(), new New(), new InstanceOf(), new Cast(), new Proxy(), new Pairs(), new IPairs(), new ToTable(), new Elements(), new Fields(), new Methods(), new Properties()};

    public static JavaModule getInstance() {
        return INSTANCE;
    }

    private JavaModule() {
    }

    public void open(LuaState luaState) {
        luaState.register("java", this.functions, true);
    }

    public TypedJavaObject toTable(Map<?, ?> map) {
        return ToTable.toTable(map);
    }

    public TypedJavaObject toTable(List<?> list2) {
        return ToTable.toTable(list2);
    }

    private static Class<?> loadType(LuaState luaState, String typeName) {
        Class<?> clazz = PRIMITIVE_TYPES.get(typeName);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = luaState.getClassLoader().loadClass(typeName);
            return clazz;
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
    }

    private static class Require
    implements NamedJavaFunction {
        private Require() {
        }

        @Override
        public int invoke(LuaState luaState) {
            String className = luaState.checkString(1);
            boolean doImport = luaState.toBoolean(2);
            Class clazz = JavaModule.loadType(luaState, className);
            luaState.pushJavaObject(clazz);
            if (doImport) {
                luaState.rawGet(luaState.getRegistryIndex(), 2);
                String name = clazz.getName();
                int index = name.indexOf(46);
                while (index >= 0) {
                    String part = name.substring(0, index);
                    luaState.getField(-1, part);
                    if (!luaState.isTable(-1)) {
                        luaState.pop(1);
                        luaState.newTable();
                        luaState.pushValue(-1);
                        luaState.setField(-3, part);
                    }
                    luaState.remove(-2);
                    name = name.substring(index + 1);
                    index = name.indexOf(46);
                }
                luaState.pushValue(-2);
                luaState.setField(-2, name);
                luaState.pop(1);
            }
            luaState.pushBoolean(doImport);
            return 2;
        }

        @Override
        public String getName() {
            return "require";
        }
    }

    private static class New
    implements NamedJavaFunction {
        private New() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Object object;
            Class clazz;
            if (luaState.isJavaObject(1, Class.class)) {
                clazz = luaState.checkJavaObject(1, Class.class);
            } else {
                String className = luaState.checkString(1);
                clazz = JavaModule.loadType(luaState, className);
            }
            int dimensionCount = luaState.getTop() - 1;
            switch (dimensionCount) {
                case 0: {
                    try {
                        object = clazz.newInstance();
                        break;
                    }
                    catch (InstantiationException e2) {
                        throw new RuntimeException(e2);
                    }
                    catch (IllegalAccessException e3) {
                        throw new RuntimeException(e3);
                    }
                }
                case 1: {
                    object = Array.newInstance(clazz, luaState.checkInt32(2));
                    break;
                }
                default: {
                    int[] dimensions = new int[dimensionCount];
                    for (int i2 = 0; i2 < dimensionCount; ++i2) {
                        dimensions[i2] = luaState.checkInt32(i2 + 2);
                    }
                    object = Array.newInstance(clazz, dimensions);
                }
            }
            luaState.pushJavaObject(object);
            return 1;
        }

        @Override
        public String getName() {
            return "new";
        }
    }

    private static class InstanceOf
    implements NamedJavaFunction {
        private InstanceOf() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Class clazz;
            Object object = luaState.checkJavaObject(1, Object.class);
            if (luaState.isJavaObject(2, Class.class)) {
                clazz = luaState.checkJavaObject(2, Class.class);
            } else {
                String className = luaState.checkString(2);
                clazz = JavaModule.loadType(luaState, className);
            }
            luaState.pushBoolean(clazz.isInstance(object));
            return 1;
        }

        @Override
        public String getName() {
            return "instanceof";
        }
    }

    private static class Cast
    implements NamedJavaFunction {
        private Cast() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Class clazz;
            if (luaState.isJavaObject(2, Class.class)) {
                clazz = luaState.checkJavaObject(2, Class.class);
            } else {
                String className = luaState.checkString(2);
                clazz = JavaModule.loadType(luaState, className);
            }
            final Object object = luaState.checkJavaObject(1, clazz);
            luaState.pushJavaObject(new TypedJavaObject(){

                @Override
                public Object getObject() {
                    return object;
                }

                @Override
                public Class<?> getType() {
                    return clazz;
                }

                @Override
                public boolean isStrong() {
                    return false;
                }
            });
            return 1;
        }

        @Override
        public String getName() {
            return "cast";
        }
    }

    private static class Proxy
    implements NamedJavaFunction {
        private Proxy() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkType(1, LuaType.TABLE);
            int interfaceCount = luaState.getTop() - 1;
            luaState.checkArg(2, interfaceCount > 0, "no interface specified");
            Class[] interfaces = new Class[interfaceCount];
            for (int i2 = 0; i2 < interfaceCount; ++i2) {
                if (luaState.isJavaObject(i2 + 2, Class.class)) {
                    interfaces[i2] = luaState.checkJavaObject(i2 + 2, Class.class);
                    continue;
                }
                String interfaceName = luaState.checkString(i2 + 2);
                interfaces[i2] = JavaModule.loadType(luaState, interfaceName);
            }
            luaState.pushJavaObjectRaw(luaState.getProxy(1, interfaces));
            return 1;
        }

        @Override
        public String getName() {
            return "proxy";
        }
    }

    private static class Pairs
    implements NamedJavaFunction {
        private Pairs() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("Java object expected, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.PAIRS);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "pairs";
        }
    }

    private static class IPairs
    implements NamedJavaFunction {
        private IPairs() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("Java object expected, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.IPAIRS);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "ipairs";
        }
    }

    private static class ToTable
    implements NamedJavaFunction {
        private ToTable() {
        }

        public static TypedJavaObject toTable(Map<?, ?> map) {
            return new LuaMap(map);
        }

        public static TypedJavaObject toTable(List<?> list2) {
            return new LuaList(list2);
        }

        @Override
        public int invoke(LuaState luaState) {
            if (luaState.isJavaObject(1, Map.class)) {
                Map map = luaState.toJavaObject(1, Map.class);
                luaState.pushJavaObject(new LuaMap(map));
            } else if (luaState.isJavaObject(1, List.class)) {
                List list2 = luaState.toJavaObject(1, List.class);
                luaState.pushJavaObject(new LuaList(list2));
            } else {
                luaState.checkArg(1, false, String.format("expected map or list, got %s", luaState.typeName(1)));
            }
            return 1;
        }

        @Override
        public String getName() {
            return "totable";
        }

        private static class LuaMap
        implements JavaReflector,
        TypedJavaObject {
            private static final JavaFunction INDEX = new Index();
            private static final JavaFunction NEW_INDEX = new NewIndex();
            private Map<Object, Object> map;

            public LuaMap(Map<Object, Object> map) {
                this.map = map;
            }

            public Map<Object, Object> getMap() {
                return this.map;
            }

            @Override
            public JavaFunction getMetamethod(JavaReflector.Metamethod metamethod) {
                switch (metamethod) {
                    case INDEX: {
                        return INDEX;
                    }
                    case NEWINDEX: {
                        return NEW_INDEX;
                    }
                }
                return null;
            }

            @Override
            public Object getObject() {
                return this.map;
            }

            @Override
            public Class<?> getType() {
                return Map.class;
            }

            @Override
            public boolean isStrong() {
                return true;
            }

            private static class Index
            implements JavaFunction {
                private Index() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaMap luaMap = (LuaMap)luaState.toJavaObjectRaw(1);
                    Object key = luaState.toJavaObject(2, Object.class);
                    if (key == null) {
                        throw new LuaRuntimeException(String.format("attempt to read map with %s accessor", luaState.typeName(2)));
                    }
                    luaState.pushJavaObject(luaMap.getMap().get(key));
                    return 1;
                }
            }

            private static class NewIndex
            implements JavaFunction {
                private NewIndex() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaMap luaMap = (LuaMap)luaState.toJavaObjectRaw(1);
                    Object key = luaState.toJavaObject(2, Object.class);
                    if (key == null) {
                        throw new LuaRuntimeException(String.format("attempt to write map with %s accessor", luaState.typeName(2)));
                    }
                    Object value = luaState.toJavaObject(3, Object.class);
                    if (value != null) {
                        luaMap.getMap().put(key, value);
                    } else {
                        luaMap.getMap().remove(key);
                    }
                    return 0;
                }
            }
        }

        private static class LuaList
        implements JavaReflector,
        TypedJavaObject {
            private static final JavaFunction INDEX = new Index();
            private static final JavaFunction NEW_INDEX = new NewIndex();
            private static final JavaFunction LENGTH = new Length();
            private List<Object> list;

            public LuaList(List<Object> list2) {
                this.list = list2;
            }

            public List<Object> getList() {
                return this.list;
            }

            @Override
            public JavaFunction getMetamethod(JavaReflector.Metamethod metamethod) {
                switch (metamethod) {
                    case INDEX: {
                        return INDEX;
                    }
                    case NEWINDEX: {
                        return NEW_INDEX;
                    }
                    case LEN: {
                        return LENGTH;
                    }
                }
                return null;
            }

            @Override
            public Object getObject() {
                return this.list;
            }

            @Override
            public Class<?> getType() {
                return List.class;
            }

            @Override
            public boolean isStrong() {
                return true;
            }

            private static class Index
            implements JavaFunction {
                private Index() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaList luaList = (LuaList)luaState.toJavaObjectRaw(1);
                    if (!luaState.isNumber(2)) {
                        throw new LuaRuntimeException(String.format("attempt to read list with %s accessor", luaState.typeName(2)));
                    }
                    long index = luaState.toInteger(2);
                    luaState.pushJavaObject(luaList.getList().get((int)(index - 1L)));
                    return 1;
                }
            }

            private static class NewIndex
            implements JavaFunction {
                private NewIndex() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaList luaList = (LuaList)luaState.toJavaObjectRaw(1);
                    if (!luaState.isNumber(2)) {
                        throw new LuaRuntimeException(String.format("attempt to write list with %s accessor", luaState.typeName(2)));
                    }
                    long index = luaState.toInteger(2);
                    Object value = luaState.toJavaObject(3, Object.class);
                    if (value != null) {
                        int size = luaList.getList().size();
                        if (index - 1L != (long)size) {
                            luaList.getList().set((int)(index - 1L), value);
                        } else {
                            luaList.getList().add(value);
                        }
                    } else {
                        luaList.getList().remove((int)(index - 1L));
                    }
                    return 0;
                }
            }

            private static class Length
            implements JavaFunction {
                private Length() {
                }

                @Override
                public int invoke(LuaState luaState) {
                    LuaList luaList = (LuaList)luaState.toJavaObjectRaw(1);
                    luaState.pushInteger(luaList.getList().size());
                    return 1;
                }
            }
        }
    }

    private static class Elements
    implements NamedJavaFunction {
        private Elements() {
        }

        @Override
        public int invoke(LuaState luaState) {
            Iterable iterable = luaState.checkJavaObject(1, Iterable.class);
            luaState.pushJavaObject(new ElementIterator(iterable.iterator()));
            luaState.pushJavaObject(iterable);
            luaState.pushNil();
            return 3;
        }

        @Override
        public String getName() {
            return "elements";
        }

        private static class ElementIterator
        implements JavaFunction {
            private Iterator<?> iterator;

            public ElementIterator(Iterator<?> iterator) {
                this.iterator = iterator;
            }

            @Override
            public int invoke(LuaState luaState) {
                if (this.iterator.hasNext()) {
                    luaState.pushJavaObject(this.iterator.next());
                } else {
                    luaState.pushNil();
                }
                return 1;
            }
        }
    }

    private static class Fields
    implements NamedJavaFunction {
        private Fields() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("expected Java object, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.JAVAFIELDS);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "fields";
        }
    }

    private static class Methods
    implements NamedJavaFunction {
        private Methods() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("expected Java object, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.JAVAMETHODS);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "methods";
        }
    }

    private static class Properties
    implements NamedJavaFunction {
        private Properties() {
        }

        @Override
        public int invoke(LuaState luaState) {
            luaState.checkArg(1, luaState.isJavaObjectRaw(1), String.format("expected Java object, got %s", luaState.typeName(1)));
            JavaFunction metamethod = luaState.getMetamethod(luaState.toJavaObjectRaw(1), JavaReflector.Metamethod.JAVAPROPERTIES);
            return metamethod.invoke(luaState);
        }

        @Override
        public String getName() {
            return "properties";
        }
    }
}

