/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import li.cil.repack.org.luaj.vm2.LuaNumber;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;

public final class Buffer {
    private static final int DEFAULT_CAPACITY = 64;
    private static final byte[] NOBYTES = new byte[0];
    private byte[] bytes;
    private int length;
    private int offset;
    private LuaValue value;

    public Buffer() {
        this(64);
    }

    public Buffer(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
        this.length = 0;
        this.offset = 0;
        this.value = null;
    }

    public Buffer(LuaValue value) {
        this.bytes = NOBYTES;
        this.offset = 0;
        this.length = 0;
        this.value = value;
    }

    public LuaValue value() {
        return this.value != null ? this.value : this.tostring();
    }

    public Buffer setvalue(LuaValue value) {
        this.bytes = NOBYTES;
        this.length = 0;
        this.offset = 0;
        this.value = value;
        return this;
    }

    public LuaString tostring() {
        this.realloc(this.length, 0);
        return LuaString.valueOf(this.bytes, this.offset, this.length);
    }

    public String tojstring() {
        return this.value().tojstring();
    }

    public String toString() {
        return this.tojstring();
    }

    public Buffer append(byte b2) {
        this.makeroom(0, 1);
        this.bytes[this.offset + this.length++] = b2;
        return this;
    }

    public Buffer append(LuaValue val) {
        this.append(val.strvalue());
        return this;
    }

    public Buffer append(LuaString str) {
        int n2 = str.m_length;
        this.makeroom(0, n2);
        str.copyInto(0, this.bytes, this.offset + this.length, n2);
        this.length += n2;
        return this;
    }

    public Buffer append(String str) {
        char[] c2 = str.toCharArray();
        int n2 = LuaString.lengthAsUtf8(c2);
        this.makeroom(0, n2);
        LuaString.encodeToUtf8(c2, c2.length, this.bytes, this.offset + this.length);
        this.length += n2;
        return this;
    }

    public Buffer concatTo(LuaValue lhs) {
        return this.setvalue(lhs.concat(this.value()));
    }

    public Buffer concatTo(LuaString lhs) {
        return this.value != null && !this.value.isstring() ? this.setvalue(lhs.concat(this.value)) : this.prepend(lhs);
    }

    public Buffer concatTo(LuaNumber lhs) {
        return this.value != null && !this.value.isstring() ? this.setvalue(lhs.concat(this.value)) : this.prepend(lhs.strvalue());
    }

    public Buffer prepend(LuaString s) {
        int n2 = s.m_length;
        this.makeroom(n2, 0);
        System.arraycopy(s.m_bytes, s.m_offset, this.bytes, this.offset - n2, n2);
        this.offset -= n2;
        this.length += n2;
        this.value = null;
        return this;
    }

    public void makeroom(int nbefore, int nafter) {
        if (this.value != null) {
            LuaString s = this.value.strvalue();
            this.value = null;
            this.length = s.m_length;
            this.offset = nbefore;
            this.bytes = new byte[nbefore + this.length + nafter];
            System.arraycopy(s.m_bytes, s.m_offset, this.bytes, this.offset, this.length);
        } else if (this.offset + this.length + nafter > this.bytes.length || this.offset < nbefore) {
            int n2 = nbefore + this.length + nafter;
            int m2 = n2 < 32 ? 32 : (n2 < this.length * 2 ? this.length * 2 : n2);
            this.realloc(m2, nbefore == 0 ? 0 : m2 - this.length - nafter);
        }
    }

    private void realloc(int newSize, int newOffset) {
        if (newSize != this.bytes.length) {
            byte[] newBytes = new byte[newSize];
            System.arraycopy(this.bytes, this.offset, newBytes, newOffset, this.length);
            this.bytes = newBytes;
            this.offset = newOffset;
        }
    }
}

