/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaFunction;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaTable;
import li.cil.repack.org.luaj.vm2.LuaThread;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Prototype;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.BaseLib;
import li.cil.repack.org.luaj.vm2.lib.DebugLib;
import li.cil.repack.org.luaj.vm2.lib.PackageLib;
import li.cil.repack.org.luaj.vm2.lib.ResourceFinder;

public class Globals
extends LuaTable {
    public InputStream STDIN = null;
    public PrintStream STDOUT = System.out;
    public PrintStream STDERR = System.err;
    public ResourceFinder finder;
    public LuaThread running = new LuaThread(this);
    public BaseLib baselib;
    public PackageLib package_;
    public DebugLib debuglib;
    public Loader loader;
    public Compiler compiler;
    public Undumper undumper;

    @Override
    public Globals checkglobals() {
        return this;
    }

    public LuaValue loadfile(String filename) {
        try {
            return this.load(this.finder.findResource(filename), "@" + filename, "bt", this);
        }
        catch (Exception e2) {
            return Globals.error("load " + filename + ": " + e2);
        }
    }

    public LuaValue load(String script, String chunkname) {
        return this.load(new StrReader(script), chunkname);
    }

    public LuaValue load(String script) {
        return this.load(new StrReader(script), script);
    }

    public LuaValue load(String script, String chunkname, LuaTable environment) {
        return this.load(new StrReader(script), chunkname, environment);
    }

    public LuaValue load(Reader reader, String chunkname) {
        return this.load(new UTF8Stream(reader), chunkname, "t", this);
    }

    public LuaValue load(Reader reader, String chunkname, LuaTable environment) {
        return this.load(new UTF8Stream(reader), chunkname, "t", environment);
    }

    public LuaValue load(InputStream is, String chunkname, String mode, LuaValue environment) {
        try {
            Prototype p = this.loadPrototype(is, chunkname, mode);
            return this.loader.load(p, chunkname, environment);
        }
        catch (LuaError l2) {
            throw l2;
        }
        catch (Exception e2) {
            return Globals.error("load " + chunkname + ": " + e2);
        }
    }

    public Prototype loadPrototype(InputStream is, String chunkname, String mode) throws IOException {
        if (mode.indexOf(98) >= 0) {
            if (this.undumper == null) {
                Globals.error("No undumper.");
            }
            if (!is.markSupported()) {
                is = new BufferedStream(is);
            }
            is.mark(4);
            Prototype p = this.undumper.undump(is, chunkname);
            if (p != null) {
                return p;
            }
            is.reset();
        }
        if (mode.indexOf(116) >= 0) {
            return this.compilePrototype(is, chunkname);
        }
        Globals.error("Failed to load prototype " + chunkname + " using mode '" + mode + "'");
        return null;
    }

    public Prototype compilePrototype(Reader reader, String chunkname) throws IOException {
        return this.compilePrototype(new UTF8Stream(reader), chunkname);
    }

    public Prototype compilePrototype(InputStream stream, String chunkname) throws IOException {
        if (this.compiler == null) {
            Globals.error("No compiler.");
        }
        return this.compiler.compile(stream, chunkname);
    }

    public Varargs yield(Varargs args) {
        if (this.running == null || this.running.isMainThread()) {
            throw new LuaError("cannot yield main thread");
        }
        LuaThread.State s = this.running.state;
        return s.lua_yield(args);
    }

    static class StrReader
    extends Reader {
        final String s;
        int i = 0;
        final int n;

        StrReader(String s) {
            this.s = s;
            this.n = s.length();
        }

        @Override
        public void close() throws IOException {
            this.i = this.n;
        }

        @Override
        public int read() throws IOException {
            return this.i < this.n ? (int)this.s.charAt(this.i++) : -1;
        }

        @Override
        public int read(char[] cbuf, int off, int len2) throws IOException {
            int j2 = 0;
            while (j2 < len2 && this.i < this.n) {
                cbuf[off + j2] = this.s.charAt(this.i);
                ++j2;
                ++this.i;
            }
            return j2 > 0 || len2 == 0 ? j2 : -1;
        }
    }

    static class UTF8Stream
    extends AbstractBufferedStream {
        private final char[] c = new char[32];
        private final Reader r;

        UTF8Stream(Reader r) {
            super(96);
            this.r = r;
        }

        @Override
        protected int avail() throws IOException {
            if (this.i < this.j) {
                return this.j - this.i;
            }
            int n2 = this.r.read(this.c);
            if (n2 < 0) {
                return -1;
            }
            if (n2 == 0) {
                int u = this.r.read();
                if (u < 0) {
                    return -1;
                }
                this.c[0] = (char)u;
                n2 = 1;
            }
            this.i = 0;
            this.j = LuaString.encodeToUtf8(this.c, n2, this.b, 0);
            return this.j;
        }

        @Override
        public void close() throws IOException {
            this.r.close();
        }
    }

    public static interface Loader {
        public LuaFunction load(Prototype var1, String var2, LuaValue var3) throws IOException;
    }

    public static interface Undumper {
        public Prototype undump(InputStream var1, String var2) throws IOException;
    }

    static class BufferedStream
    extends AbstractBufferedStream {
        private final InputStream s;

        public BufferedStream(InputStream s) {
            this(128, s);
        }

        BufferedStream(int buflen, InputStream s) {
            super(buflen);
            this.s = s;
        }

        @Override
        protected int avail() throws IOException {
            int n2;
            if (this.i < this.j) {
                return this.j - this.i;
            }
            if (this.j >= this.b.length) {
                this.j = 0;
                this.i = 0;
            }
            if ((n2 = this.s.read(this.b, this.j, this.b.length - this.j)) < 0) {
                return -1;
            }
            if (n2 == 0) {
                int u = this.s.read();
                if (u < 0) {
                    return -1;
                }
                this.b[this.j] = (byte)u;
                n2 = 1;
            }
            this.j += n2;
            return n2;
        }

        @Override
        public void close() throws IOException {
            this.s.close();
        }

        @Override
        public synchronized void mark(int n2) {
            if (this.i > 0 || n2 > this.b.length) {
                byte[] dest = n2 > this.b.length ? new byte[n2] : this.b;
                System.arraycopy(this.b, this.i, dest, 0, this.j - this.i);
                this.j -= this.i;
                this.i = 0;
                this.b = dest;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.i = 0;
        }
    }

    public static interface Compiler {
        public Prototype compile(InputStream var1, String var2) throws IOException;
    }

    static abstract class AbstractBufferedStream
    extends InputStream {
        protected byte[] b;
        protected int i = 0;
        protected int j = 0;

        protected AbstractBufferedStream(int buflen) {
            this.b = new byte[buflen];
        }

        protected abstract int avail() throws IOException;

        @Override
        public int read() throws IOException {
            int a2 = this.avail();
            return a2 <= 0 ? -1 : 0xFF & this.b[this.i++];
        }

        @Override
        public int read(byte[] b2) throws IOException {
            return this.read(b2, 0, b2.length);
        }

        @Override
        public int read(byte[] b2, int i0, int n2) throws IOException {
            int a2 = this.avail();
            if (a2 <= 0) {
                return -1;
            }
            int n_read = Math.min(a2, n2);
            System.arraycopy(this.b, this.i, b2, i0, n_read);
            this.i += n_read;
            return n_read;
        }

        @Override
        public long skip(long n2) throws IOException {
            long k2 = Math.min(n2, (long)(this.j - this.i));
            this.i = (int)((long)this.i + k2);
            return k2;
        }

        @Override
        public int available() throws IOException {
            return this.j - this.i;
        }
    }
}

