/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import li.cil.repack.org.luaj.vm2.Globals;
import li.cil.repack.org.luaj.vm2.LocVars;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaInteger;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Prototype;
import li.cil.repack.org.luaj.vm2.Upvaldesc;

public class LoadState {
    public static final Globals.Undumper instance = new GlobalsUndumper();
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES = 0;
    public static final int NUMBER_FORMAT_INTS_ONLY = 1;
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
    public static final int LUA_TINT = -2;
    public static final int LUA_TNONE = -1;
    public static final int LUA_TNIL = 0;
    public static final int LUA_TBOOLEAN = 1;
    public static final int LUA_TLIGHTUSERDATA = 2;
    public static final int LUA_TNUMBER = 3;
    public static final int LUA_TSTRING = 4;
    public static final int LUA_TTABLE = 5;
    public static final int LUA_TFUNCTION = 6;
    public static final int LUA_TUSERDATA = 7;
    public static final int LUA_TTHREAD = 8;
    public static final int LUA_TVALUE = 9;
    public static String encoding = null;
    public static final byte[] LUA_SIGNATURE = new byte[]{27, 76, 117, 97};
    public static final byte[] LUAC_TAIL = new byte[]{25, -109, 13, 10, 26, 10};
    public static final String SOURCE_BINARY_STRING = "binary string";
    public static final int LUAC_VERSION = 82;
    public static final int LUAC_FORMAT = 0;
    public static final int LUAC_HEADERSIZE = 12;
    private int luacVersion;
    private int luacFormat;
    private boolean luacLittleEndian;
    private int luacSizeofInt;
    private int luacSizeofSizeT;
    private int luacSizeofInstruction;
    private int luacSizeofLuaNumber;
    private int luacNumberFormat;
    public final DataInputStream is;
    String name;
    private static final LuaValue[] NOVALUES = new LuaValue[0];
    private static final Prototype[] NOPROTOS = new Prototype[0];
    private static final LocVars[] NOLOCVARS = new LocVars[0];
    private static final Upvaldesc[] NOUPVALDESCS = new Upvaldesc[0];
    private static final int[] NOINTS = new int[0];
    private byte[] buf = new byte[512];

    public static void install(Globals globals) {
        globals.undumper = instance;
    }

    int loadInt() throws IOException {
        this.is.readFully(this.buf, 0, 4);
        return this.luacLittleEndian ? this.buf[3] << 24 | (0xFF & this.buf[2]) << 16 | (0xFF & this.buf[1]) << 8 | 0xFF & this.buf[0] : this.buf[0] << 24 | (0xFF & this.buf[1]) << 16 | (0xFF & this.buf[2]) << 8 | 0xFF & this.buf[3];
    }

    int[] loadIntArray() throws IOException {
        int n2 = this.loadInt();
        if (n2 == 0) {
            return NOINTS;
        }
        int m2 = n2 << 2;
        if (this.buf.length < m2) {
            this.buf = new byte[m2];
        }
        this.is.readFully(this.buf, 0, m2);
        int[] array = new int[n2];
        int i2 = 0;
        int j2 = 0;
        while (i2 < n2) {
            array[i2] = this.luacLittleEndian ? this.buf[j2 + 3] << 24 | (0xFF & this.buf[j2 + 2]) << 16 | (0xFF & this.buf[j2 + 1]) << 8 | 0xFF & this.buf[j2 + 0] : this.buf[j2 + 0] << 24 | (0xFF & this.buf[j2 + 1]) << 16 | (0xFF & this.buf[j2 + 2]) << 8 | 0xFF & this.buf[j2 + 3];
            ++i2;
            j2 += 4;
        }
        return array;
    }

    long loadInt64() throws IOException {
        int b2;
        int a2;
        if (this.luacLittleEndian) {
            a2 = this.loadInt();
            b2 = this.loadInt();
        } else {
            b2 = this.loadInt();
            a2 = this.loadInt();
        }
        return (long)b2 << 32 | (long)a2 & 0xFFFFFFFFL;
    }

    LuaString loadString() throws IOException {
        int size;
        int n2 = size = this.luacSizeofSizeT == 8 ? (int)this.loadInt64() : this.loadInt();
        if (size == 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        this.is.readFully(bytes, 0, size);
        return LuaString.valueUsing(bytes, 0, bytes.length - 1);
    }

    public static LuaValue longBitsToLuaNumber(long bits) {
        int shift;
        long intPrecMask;
        long f2;
        if ((bits & Long.MAX_VALUE) == 0L) {
            return LuaValue.ZERO;
        }
        int e2 = (int)(bits >> 52 & 0x7FFL) - 1023;
        if (e2 >= 0 && e2 < 31 && ((f2 = bits & 0xFFFFFFFFFFFFFL) & (intPrecMask = (1L << (shift = 52 - e2)) - 1L)) == 0L) {
            int intValue = (int)(f2 >> shift) | 1 << e2;
            return LuaInteger.valueOf(bits >> 63 != 0L ? -intValue : intValue);
        }
        return LuaValue.valueOf(Double.longBitsToDouble(bits));
    }

    LuaValue loadNumber() throws IOException {
        if (this.luacNumberFormat == 1) {
            return LuaInteger.valueOf(this.loadInt());
        }
        return LoadState.longBitsToLuaNumber(this.loadInt64());
    }

    void loadConstants(Prototype f2) throws IOException {
        int n2 = this.loadInt();
        LuaValue[] values = n2 > 0 ? new LuaValue[n2] : NOVALUES;
        block7: for (int i2 = 0; i2 < n2; ++i2) {
            switch (this.is.readByte()) {
                case 0: {
                    values[i2] = LuaValue.NIL;
                    continue block7;
                }
                case 1: {
                    values[i2] = 0 != this.is.readUnsignedByte() ? LuaValue.TRUE : LuaValue.FALSE;
                    continue block7;
                }
                case -2: {
                    values[i2] = LuaInteger.valueOf(this.loadInt());
                    continue block7;
                }
                case 3: {
                    values[i2] = this.loadNumber();
                    continue block7;
                }
                case 4: {
                    values[i2] = this.loadString();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("bad constant");
                }
            }
        }
        f2.k = values;
        n2 = this.loadInt();
        Prototype[] protos = n2 > 0 ? new Prototype[n2] : NOPROTOS;
        for (int i3 = 0; i3 < n2; ++i3) {
            protos[i3] = this.loadFunction(f2.source);
        }
        f2.p = protos;
    }

    void loadUpvalues(Prototype f2) throws IOException {
        int n2 = this.loadInt();
        f2.upvalues = n2 > 0 ? new Upvaldesc[n2] : NOUPVALDESCS;
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean instack = this.is.readByte() != 0;
            int idx = this.is.readByte() & 0xFF;
            f2.upvalues[i2] = new Upvaldesc(null, instack, idx);
        }
    }

    void loadDebug(Prototype f2) throws IOException {
        int i2;
        f2.source = this.loadString();
        f2.lineinfo = this.loadIntArray();
        int n2 = this.loadInt();
        f2.locvars = n2 > 0 ? new LocVars[n2] : NOLOCVARS;
        for (i2 = 0; i2 < n2; ++i2) {
            LuaString varname = this.loadString();
            int startpc = this.loadInt();
            int endpc = this.loadInt();
            f2.locvars[i2] = new LocVars(varname, startpc, endpc);
        }
        n2 = this.loadInt();
        for (i2 = 0; i2 < n2; ++i2) {
            f2.upvalues[i2].name = this.loadString();
        }
    }

    public Prototype loadFunction(LuaString p) throws IOException {
        Prototype f2 = new Prototype();
        f2.linedefined = this.loadInt();
        f2.lastlinedefined = this.loadInt();
        f2.numparams = this.is.readUnsignedByte();
        f2.is_vararg = this.is.readUnsignedByte();
        f2.maxstacksize = this.is.readUnsignedByte();
        f2.code = this.loadIntArray();
        this.loadConstants(f2);
        this.loadUpvalues(f2);
        this.loadDebug(f2);
        return f2;
    }

    public void loadHeader() throws IOException {
        this.luacVersion = this.is.readByte();
        this.luacFormat = this.is.readByte();
        this.luacLittleEndian = 0 != this.is.readByte();
        this.luacSizeofInt = this.is.readByte();
        this.luacSizeofSizeT = this.is.readByte();
        this.luacSizeofInstruction = this.is.readByte();
        this.luacSizeofLuaNumber = this.is.readByte();
        this.luacNumberFormat = this.is.readByte();
        for (int i2 = 0; i2 < LUAC_TAIL.length; ++i2) {
            if (this.is.readByte() == LUAC_TAIL[i2]) continue;
            throw new LuaError("Unexpeted byte in luac tail of header, index=" + i2);
        }
    }

    public static Prototype undump(InputStream stream, String chunkname) throws IOException {
        if (stream.read() != LUA_SIGNATURE[0] || stream.read() != LUA_SIGNATURE[1] || stream.read() != LUA_SIGNATURE[2] || stream.read() != LUA_SIGNATURE[3]) {
            return null;
        }
        String sname = LoadState.getSourceName(chunkname);
        LoadState s = new LoadState(stream, sname);
        s.loadHeader();
        switch (s.luacNumberFormat) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new LuaError("unsupported int size");
            }
        }
        return s.loadFunction(LuaString.valueOf(sname));
    }

    public static String getSourceName(String name) {
        String sname = name;
        if (name.startsWith("@") || name.startsWith("=")) {
            sname = name.substring(1);
        } else if (name.startsWith("\u001b")) {
            sname = SOURCE_BINARY_STRING;
        }
        return sname;
    }

    private LoadState(InputStream stream, String name) {
        this.name = name;
        this.is = new DataInputStream(stream);
    }

    private static final class GlobalsUndumper
    implements Globals.Undumper {
        private GlobalsUndumper() {
        }

        @Override
        public Prototype undump(InputStream stream, String chunkname) throws IOException {
            return LoadState.undump(stream, chunkname);
        }
    }
}

