/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import java.lang.ref.WeakReference;
import java.util.Vector;
import li.cil.repack.org.luaj.vm2.Buffer;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaInteger;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Metatable;
import li.cil.repack.org.luaj.vm2.Varargs;

public class LuaTable
extends LuaValue
implements Metatable {
    private static final int MIN_HASH_CAPACITY = 2;
    protected LuaValue[] array;
    protected Slot[] hash;
    protected int hashEntries;
    protected Metatable m_metatable;
    private static final Slot[] NOBUCKETS = new Slot[0];

    public LuaTable() {
        this.array = NOVALS;
        this.hash = NOBUCKETS;
    }

    public LuaTable(int narray, int nhash) {
        this.presize(narray, nhash);
    }

    public LuaTable(LuaValue[] named, LuaValue[] unnamed, Varargs lastarg) {
        int i2;
        int nn = named != null ? named.length : 0;
        int nu = unnamed != null ? unnamed.length : 0;
        int nl = lastarg != null ? lastarg.narg() : 0;
        this.presize(nu + nl, nn >> 1);
        for (i2 = 0; i2 < nu; ++i2) {
            this.rawset(i2 + 1, unnamed[i2]);
        }
        if (lastarg != null) {
            int n2 = lastarg.narg();
            for (i2 = 1; i2 <= n2; ++i2) {
                this.rawset(nu + i2, lastarg.arg(i2));
            }
        }
        for (i2 = 0; i2 < nn; i2 += 2) {
            if (named[i2 + 1].isnil()) continue;
            this.rawset(named[i2], named[i2 + 1]);
        }
    }

    public LuaTable(Varargs varargs2) {
        this(varargs2, 1);
    }

    public LuaTable(Varargs varargs2, int firstarg) {
        int nskip = firstarg - 1;
        int n2 = Math.max(varargs2.narg() - nskip, 0);
        this.presize(n2, 1);
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.set(i2, varargs2.arg(i2 + nskip));
        }
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public String typename() {
        return "table";
    }

    @Override
    public boolean istable() {
        return true;
    }

    @Override
    public LuaTable checktable() {
        return this;
    }

    @Override
    public LuaTable opttable(LuaTable defval) {
        return this;
    }

    @Override
    public void presize(int narray) {
        if (narray > this.array.length) {
            this.array = LuaTable.resize(this.array, 1 << LuaTable.log2(narray));
        }
    }

    public void presize(int narray, int nhash) {
        if (nhash > 0 && nhash < 2) {
            nhash = 2;
        }
        this.array = narray > 0 ? new LuaValue[1 << LuaTable.log2(narray)] : NOVALS;
        this.hash = nhash > 0 ? new Slot[1 << LuaTable.log2(nhash)] : NOBUCKETS;
        this.hashEntries = 0;
    }

    private static LuaValue[] resize(LuaValue[] old, int n2) {
        LuaValue[] v = new LuaValue[n2];
        System.arraycopy(old, 0, v, 0, old.length);
        return v;
    }

    protected int getArrayLength() {
        return this.array.length;
    }

    protected int getHashLength() {
        return this.hash.length;
    }

    @Override
    public LuaValue getmetatable() {
        return this.m_metatable != null ? this.m_metatable.toLuaValue() : null;
    }

    @Override
    public LuaValue setmetatable(LuaValue metatable) {
        boolean hadWeakKeys = this.m_metatable != null && this.m_metatable.useWeakKeys();
        boolean hadWeakValues = this.m_metatable != null && this.m_metatable.useWeakValues();
        this.m_metatable = LuaTable.metatableOf(metatable);
        if (hadWeakKeys != (this.m_metatable != null && this.m_metatable.useWeakKeys()) || hadWeakValues != (this.m_metatable != null && this.m_metatable.useWeakValues())) {
            this.rehash(0);
        }
        return this;
    }

    @Override
    public LuaValue get(int key) {
        LuaValue v = this.rawget(key);
        return v.isnil() && this.m_metatable != null ? LuaTable.gettable(this, LuaTable.valueOf(key)) : v;
    }

    @Override
    public LuaValue get(LuaValue key) {
        LuaValue v = this.rawget(key);
        return v.isnil() && this.m_metatable != null ? LuaTable.gettable(this, key) : v;
    }

    @Override
    public LuaValue rawget(int key) {
        if (key > 0 && key <= this.array.length) {
            LuaValue v = this.m_metatable == null ? this.array[key - 1] : this.m_metatable.arrayget(this.array, key - 1);
            return v != null ? v : NIL;
        }
        return this.hashget(LuaInteger.valueOf(key));
    }

    @Override
    public LuaValue rawget(LuaValue key) {
        int ikey;
        if (key.isinttype() && (ikey = key.toint()) > 0 && ikey <= this.array.length) {
            LuaValue v = this.m_metatable == null ? this.array[ikey - 1] : this.m_metatable.arrayget(this.array, ikey - 1);
            return v != null ? v : NIL;
        }
        return this.hashget(key);
    }

    protected LuaValue hashget(LuaValue key) {
        if (this.hashEntries > 0) {
            for (Slot slot = this.hash[this.hashSlot(key)]; slot != null; slot = slot.rest()) {
                StrongSlot foundSlot = slot.find(key);
                if (foundSlot == null) continue;
                return foundSlot.value();
            }
        }
        return NIL;
    }

    @Override
    public void set(int key, LuaValue value) {
        if (this.m_metatable == null || !this.rawget(key).isnil() || !LuaTable.settable(this, LuaInteger.valueOf(key), value)) {
            this.rawset(key, value);
        }
    }

    @Override
    public void set(LuaValue key, LuaValue value) {
        if (key == null || !key.isvalidkey() && !this.metatag(NEWINDEX).isfunction()) {
            throw new LuaError("value ('" + key + "') can not be used as a table index");
        }
        if (this.m_metatable == null || !this.rawget(key).isnil() || !LuaTable.settable(this, key, value)) {
            this.rawset(key, value);
        }
    }

    @Override
    public void rawset(int key, LuaValue value) {
        if (!this.arrayset(key, value)) {
            this.hashset(LuaInteger.valueOf(key), value);
        }
    }

    @Override
    public void rawset(LuaValue key, LuaValue value) {
        if (!key.isinttype() || !this.arrayset(key.toint(), value)) {
            this.hashset(key, value);
        }
    }

    private boolean arrayset(int key, LuaValue value) {
        if (key > 0 && key <= this.array.length) {
            this.array[key - 1] = value.isnil() ? null : (this.m_metatable != null ? this.m_metatable.wrap(value) : value);
            return true;
        }
        return false;
    }

    public LuaValue remove(int pos) {
        LuaValue v;
        int n2 = this.length();
        if (pos == 0) {
            pos = n2;
        } else if (pos > n2) {
            return NONE;
        }
        LuaValue r = v = this.get(pos);
        while (!r.isnil()) {
            r = this.get(pos + 1);
            this.set(pos++, r);
        }
        return v.isnil() ? NONE : v;
    }

    public void insert(int pos, LuaValue value) {
        if (pos == 0) {
            pos = this.length() + 1;
        }
        while (!value.isnil()) {
            LuaValue v = this.get(pos);
            this.set(pos++, value);
            value = v;
        }
    }

    public LuaValue concat(LuaString sep, int i2, int j2) {
        Buffer sb = new Buffer();
        if (i2 <= j2) {
            sb.append(this.get(i2).checkstring());
            while (++i2 <= j2) {
                sb.append(sep);
                sb.append(this.get(i2).checkstring());
            }
        }
        return sb.tostring();
    }

    @Override
    public int length() {
        if (this.m_metatable != null) {
            LuaValue len2 = this.len();
            if (!len2.isint()) {
                throw new LuaError("table length is not an integer: " + len2);
            }
            return len2.toint();
        }
        return this.rawlen();
    }

    @Override
    public LuaValue len() {
        LuaValue h2 = this.metatag(LEN);
        if (h2.toboolean()) {
            return h2.call(this);
        }
        return LuaInteger.valueOf(this.rawlen());
    }

    @Override
    public int rawlen() {
        int a2 = this.getArrayLength();
        int n2 = a2 + 1;
        int m2 = 0;
        while (!this.rawget(n2).isnil()) {
            m2 = n2;
            n2 += a2 + this.getHashLength() + 1;
        }
        while (n2 > m2 + 1) {
            int k2 = (n2 + m2) / 2;
            if (!this.rawget(k2).isnil()) {
                m2 = k2;
                continue;
            }
            n2 = k2;
        }
        return m2;
    }

    @Override
    public Varargs next(LuaValue key) {
        int i2 = 0;
        if (!(key.isnil() || key.isinttype() && (i2 = key.toint()) > 0 && i2 <= this.array.length)) {
            if (this.hash.length == 0) {
                LuaTable.error("invalid key to 'next' 1: " + key);
            }
            i2 = this.hashSlot(key);
            boolean found = false;
            for (Slot slot = this.hash[i2]; slot != null; slot = slot.rest()) {
                if (found) {
                    StrongSlot nextEntry = slot.first();
                    if (nextEntry == null) continue;
                    return nextEntry.toVarargs();
                }
                if (!slot.keyeq(key)) continue;
                found = true;
            }
            if (!found) {
                LuaTable.error("invalid key to 'next' 2: " + key);
            }
            i2 += 1 + this.array.length;
        }
        while (i2 < this.array.length) {
            if (this.array[i2] != null) {
                LuaValue value;
                LuaValue luaValue = value = this.m_metatable == null ? this.array[i2] : this.m_metatable.arrayget(this.array, i2);
                if (value != null) {
                    return LuaTable.varargsOf(LuaInteger.valueOf(i2 + 1), (Varargs)value);
                }
            }
            ++i2;
        }
        i2 -= this.array.length;
        while (i2 < this.hash.length) {
            for (Slot slot = this.hash[i2]; slot != null; slot = slot.rest()) {
                StrongSlot first = slot.first();
                if (first == null) continue;
                return first.toVarargs();
            }
            ++i2;
        }
        return NIL;
    }

    @Override
    public Varargs inext(LuaValue key) {
        int k2 = key.checkint() + 1;
        LuaValue v = this.rawget(k2);
        return v.isnil() ? NONE : LuaTable.varargsOf(LuaInteger.valueOf(k2), (Varargs)v);
    }

    public void hashset(LuaValue key, LuaValue value) {
        if (value.isnil()) {
            this.hashRemove(key);
        } else {
            int index = 0;
            if (this.hash.length > 0) {
                index = this.hashSlot(key);
                for (Slot slot = this.hash[index]; slot != null; slot = slot.rest()) {
                    StrongSlot foundSlot = slot.find(key);
                    if (foundSlot == null) continue;
                    this.hash[index] = this.hash[index].set(foundSlot, value);
                    return;
                }
            }
            if (this.checkLoadFactor()) {
                if ((this.m_metatable == null || !this.m_metatable.useWeakValues()) && key.isinttype() && key.toint() > 0) {
                    this.rehash(key.toint());
                    if (this.arrayset(key.toint(), value)) {
                        return;
                    }
                } else {
                    this.rehash(-1);
                }
                index = this.hashSlot(key);
            }
            Entry entry = this.m_metatable != null ? this.m_metatable.entry(key, value) : LuaTable.defaultEntry(key, value);
            this.hash[index] = this.hash[index] != null ? this.hash[index].add(entry) : entry;
            ++this.hashEntries;
        }
    }

    public static int hashpow2(int hashCode, int mask) {
        return hashCode & mask;
    }

    public static int hashmod(int hashCode, int mask) {
        return (hashCode & Integer.MAX_VALUE) % mask;
    }

    public static int hashSlot(LuaValue key, int hashMask) {
        switch (key.type()) {
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                return LuaTable.hashmod(key.hashCode(), hashMask);
            }
        }
        return LuaTable.hashpow2(key.hashCode(), hashMask);
    }

    private int hashSlot(LuaValue key) {
        return LuaTable.hashSlot(key, this.hash.length - 1);
    }

    private void hashRemove(LuaValue key) {
        if (this.hash.length > 0) {
            int index = this.hashSlot(key);
            for (Slot slot = this.hash[index]; slot != null; slot = slot.rest()) {
                StrongSlot foundSlot = slot.find(key);
                if (foundSlot == null) continue;
                this.hash[index] = this.hash[index].remove(foundSlot);
                --this.hashEntries;
                return;
            }
        }
    }

    private boolean checkLoadFactor() {
        return this.hashEntries >= this.hash.length;
    }

    private int countHashKeys() {
        int keys = 0;
        Slot[] slotArray = this.hash;
        int n2 = slotArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Slot element;
            for (Slot slot = element = slotArray[i2]; slot != null; slot = slot.rest()) {
                if (slot.first() == null) continue;
                ++keys;
            }
        }
        return keys;
    }

    private void dropWeakArrayValues() {
        for (int i2 = 0; i2 < this.array.length; ++i2) {
            this.m_metatable.arrayget(this.array, i2);
        }
    }

    private int countIntKeys(int[] nums) {
        int total = 0;
        int i2 = 1;
        for (int bit = 0; bit < 31 && i2 <= this.array.length; ++bit) {
            int j2 = Math.min(this.array.length, 1 << bit);
            int c2 = 0;
            while (i2 <= j2) {
                if (this.array[i2++ - 1] == null) continue;
                ++c2;
            }
            nums[bit] = c2;
            total += c2;
        }
        for (i2 = 0; i2 < this.hash.length; ++i2) {
            for (Slot s = this.hash[i2]; s != null; s = s.rest()) {
                int k2 = s.arraykey(Integer.MAX_VALUE);
                if (k2 <= 0) continue;
                int n2 = LuaTable.log2(k2);
                nums[n2] = nums[n2] + 1;
                ++total;
            }
        }
        return total;
    }

    static int log2(int x) {
        int lg = 0;
        if (--x < 0) {
            return Integer.MIN_VALUE;
        }
        if ((x & 0xFFFF0000) != 0) {
            lg = 16;
            x >>>= 16;
        }
        if ((x & 0xFF00) != 0) {
            lg += 8;
            x >>>= 8;
        }
        if ((x & 0xF0) != 0) {
            lg += 4;
            x >>>= 4;
        }
        switch (x) {
            case 0: {
                return 0;
            }
            case 1: {
                ++lg;
                break;
            }
            case 2: {
                lg += 2;
                break;
            }
            case 3: {
                lg += 2;
                break;
            }
            case 4: {
                lg += 3;
                break;
            }
            case 5: {
                lg += 3;
                break;
            }
            case 6: {
                lg += 3;
                break;
            }
            case 7: {
                lg += 3;
                break;
            }
            case 8: {
                lg += 4;
                break;
            }
            case 9: {
                lg += 4;
                break;
            }
            case 10: {
                lg += 4;
                break;
            }
            case 11: {
                lg += 4;
                break;
            }
            case 12: {
                lg += 4;
                break;
            }
            case 13: {
                lg += 4;
                break;
            }
            case 14: {
                lg += 4;
                break;
            }
            case 15: {
                lg += 4;
            }
        }
        return lg;
    }

    private void rehash(int newKey) {
        int i2;
        Slot[] newHash;
        int newHashMask;
        int newCapacity;
        LuaValue[] newArray;
        if (this.m_metatable != null && (this.m_metatable.useWeakKeys() || this.m_metatable.useWeakValues())) {
            this.hashEntries = this.countHashKeys();
            if (this.m_metatable.useWeakValues()) {
                this.dropWeakArrayValues();
            }
        }
        int[] nums = new int[32];
        int total = this.countIntKeys(nums);
        if (newKey > 0) {
            ++total;
            int n2 = LuaTable.log2(newKey);
            nums[n2] = nums[n2] + 1;
        }
        int keys = nums[0];
        int newArraySize = 0;
        for (int log2 = 1; log2 < 32; ++log2) {
            keys += nums[log2];
            if (total * 2 < 1 << log2) break;
            if (keys < 1 << log2 - 1) continue;
            newArraySize = 1 << log2;
        }
        LuaValue[] oldArray = this.array;
        Slot[] oldHash = this.hash;
        int movingToArray = 0;
        if (newKey > 0 && newKey <= newArraySize) {
            --movingToArray;
        }
        if (newArraySize != oldArray.length) {
            int i3;
            int j2;
            newArray = new LuaValue[newArraySize];
            if (newArraySize > oldArray.length) {
                j2 = LuaTable.log2(newArraySize) + 1;
                for (i3 = LuaTable.log2(oldArray.length + 1); i3 < j2; ++i3) {
                    movingToArray += nums[i3];
                }
            } else if (oldArray.length > newArraySize) {
                j2 = LuaTable.log2(oldArray.length) + 1;
                for (i3 = LuaTable.log2(newArraySize + 1); i3 < j2; ++i3) {
                    movingToArray -= nums[i3];
                }
            }
            System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newArraySize));
        } else {
            newArray = this.array;
        }
        int newHashSize = this.hashEntries - movingToArray + (newKey < 0 || newKey > newArraySize ? 1 : 0);
        int oldCapacity = oldHash.length;
        if (newHashSize > 0) {
            newCapacity = newHashSize < 2 ? 2 : 1 << LuaTable.log2(newHashSize);
            newHashMask = newCapacity - 1;
            newHash = new Slot[newCapacity];
        } else {
            newCapacity = 0;
            newHashMask = 0;
            newHash = NOBUCKETS;
        }
        for (i2 = 0; i2 < oldCapacity; ++i2) {
            for (Slot slot = oldHash[i2]; slot != null; slot = slot.rest()) {
                int k2 = slot.arraykey(newArraySize);
                if (k2 > 0) {
                    StrongSlot entry = slot.first();
                    if (entry == null) continue;
                    newArray[k2 - 1] = entry.value();
                    continue;
                }
                if (slot instanceof DeadSlot) continue;
                int j3 = slot.keyindex(newHashMask);
                newHash[j3] = slot.relink(newHash[j3]);
            }
        }
        i2 = newArraySize;
        while (i2 < oldArray.length) {
            Slot newEntry;
            LuaValue v;
            if ((v = oldArray[i2++]) == null) continue;
            int slot = LuaTable.hashmod(LuaInteger.hashCode(i2), newHashMask);
            if (this.m_metatable != null) {
                newEntry = this.m_metatable.entry(LuaTable.valueOf(i2), v);
                if (newEntry == null) {
                    continue;
                }
            } else {
                newEntry = LuaTable.defaultEntry(LuaTable.valueOf(i2), v);
            }
            newHash[slot] = newHash[slot] != null ? newHash[slot].add(newEntry) : newEntry;
        }
        this.hash = newHash;
        this.array = newArray;
        this.hashEntries -= movingToArray;
    }

    @Override
    public Slot entry(LuaValue key, LuaValue value) {
        return LuaTable.defaultEntry(key, value);
    }

    protected static boolean isLargeKey(LuaValue key) {
        switch (key.type()) {
            case 4: {
                return key.rawlen() > 32;
            }
            case 1: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    protected static Entry defaultEntry(LuaValue key, LuaValue value) {
        if (key.isinttype()) {
            return new IntKeyEntry(key.toint(), value);
        }
        if (value.type() == 3) {
            return new NumberValueEntry(key, value.todouble());
        }
        return new NormalEntry(key, value);
    }

    public void sort(LuaValue comparator) {
        int n2;
        if (this.len().tolong() >= Integer.MAX_VALUE) {
            throw new LuaError("array too big: " + this.len().tolong());
        }
        if (this.m_metatable != null && this.m_metatable.useWeakValues()) {
            this.dropWeakArrayValues();
        }
        if ((n2 = this.length()) > 1) {
            this.heapSort(n2, comparator.isnil() ? null : comparator);
        }
    }

    private void heapSort(int count, LuaValue cmpfunc) {
        this.heapify(count, cmpfunc);
        int end = count;
        while (end > 1) {
            LuaValue a2 = this.get(end);
            this.set(end, this.get(1));
            this.set(1, a2);
            this.siftDown(1, --end, cmpfunc);
        }
    }

    private void heapify(int count, LuaValue cmpfunc) {
        for (int start = count / 2; start > 0; --start) {
            this.siftDown(start, count, cmpfunc);
        }
    }

    private void siftDown(int start, int end, LuaValue cmpfunc) {
        int root = start;
        while (root * 2 <= end) {
            int child = root * 2;
            if (child < end && this.compare(child, child + 1, cmpfunc)) {
                ++child;
            }
            if (this.compare(root, child, cmpfunc)) {
                LuaValue a2 = this.get(root);
                this.set(root, this.get(child));
                this.set(child, a2);
                root = child;
                continue;
            }
            return;
        }
    }

    private boolean compare(int i2, int j2, LuaValue cmpfunc) {
        LuaValue a2 = this.get(i2);
        LuaValue b2 = this.get(j2);
        if (a2 == null || b2 == null) {
            return false;
        }
        if (cmpfunc != null) {
            return cmpfunc.call(a2, b2).toboolean();
        }
        return a2.lt_b(b2);
    }

    public int keyCount() {
        LuaValue k2 = LuaValue.NIL;
        int i2 = 0;
        Varargs n2;
        while (!(k2 = (n2 = this.next(k2)).arg1()).isnil()) {
            ++i2;
        }
        return i2;
    }

    public LuaValue[] keys() {
        Varargs n2;
        Vector<LuaValue> l2 = new Vector<LuaValue>();
        LuaValue k2 = LuaValue.NIL;
        while (!(k2 = (n2 = this.next(k2)).arg1()).isnil()) {
            l2.addElement(k2);
        }
        Object[] a2 = new LuaValue[l2.size()];
        l2.copyInto(a2);
        return a2;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return this.eq_b(val) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        if (this == val) {
            return true;
        }
        if (this.m_metatable == null || !val.istable()) {
            return false;
        }
        LuaValue valmt = val.getmetatable();
        return valmt != null && LuaValue.eqmtcall(this, this.m_metatable.toLuaValue(), val, valmt);
    }

    public Varargs unpack() {
        return this.unpack(1, this.rawlen());
    }

    public Varargs unpack(int i2) {
        return this.unpack(i2, this.rawlen());
    }

    public Varargs unpack(int i2, int j2) {
        if (j2 < i2) {
            return NONE;
        }
        int count = j2 - i2;
        if (count < 0) {
            throw new LuaError("too many results to unpack: greater 2147483647");
        }
        int max2 = 0xFFFFFF;
        if (count >= max2) {
            throw new LuaError("too many results to unpack: " + count + " (max is " + max2 + ')');
        }
        int n2 = j2 + 1 - i2;
        switch (n2) {
            case 0: {
                return NONE;
            }
            case 1: {
                return this.get(i2);
            }
            case 2: {
                return LuaTable.varargsOf(this.get(i2), (Varargs)this.get(i2 + 1));
            }
        }
        if (n2 < 0) {
            return NONE;
        }
        try {
            LuaValue[] v = new LuaValue[n2];
            while (--n2 >= 0) {
                v[n2] = this.get(i2 + n2);
            }
            return LuaTable.varargsOf(v);
        }
        catch (OutOfMemoryError e2) {
            throw new LuaError("too many results to unpack [out of memory]: " + n2);
        }
    }

    @Override
    public boolean useWeakKeys() {
        return false;
    }

    @Override
    public boolean useWeakValues() {
        return false;
    }

    @Override
    public LuaValue toLuaValue() {
        return this;
    }

    @Override
    public LuaValue wrap(LuaValue value) {
        return value;
    }

    @Override
    public LuaValue arrayget(LuaValue[] array, int index) {
        return array[index];
    }

    static interface Slot {
        public int keyindex(int var1);

        public StrongSlot first();

        public StrongSlot find(LuaValue var1);

        public boolean keyeq(LuaValue var1);

        public Slot rest();

        public int arraykey(int var1);

        public Slot set(StrongSlot var1, LuaValue var2);

        public Slot add(Slot var1);

        public Slot remove(StrongSlot var1);

        public Slot relink(Slot var1);
    }

    static interface StrongSlot
    extends Slot {
        public LuaValue key();

        public LuaValue value();

        public Varargs toVarargs();
    }

    static abstract class Entry
    extends Varargs
    implements StrongSlot {
        Entry() {
        }

        @Override
        public abstract LuaValue key();

        @Override
        public abstract LuaValue value();

        abstract Entry set(LuaValue var1);

        @Override
        public abstract boolean keyeq(LuaValue var1);

        @Override
        public abstract int keyindex(int var1);

        @Override
        public int arraykey(int max2) {
            return 0;
        }

        @Override
        public LuaValue arg(int i2) {
            switch (i2) {
                case 1: {
                    return this.key();
                }
                case 2: {
                    return this.value();
                }
            }
            return LuaValue.NIL;
        }

        @Override
        public int narg() {
            return 2;
        }

        @Override
        public Varargs toVarargs() {
            return LuaValue.varargsOf(this.key(), (Varargs)this.value());
        }

        @Override
        public LuaValue arg1() {
            return this.key();
        }

        @Override
        public Varargs subargs(int start) {
            switch (start) {
                case 1: {
                    return this;
                }
                case 2: {
                    return this.value();
                }
            }
            return LuaValue.NONE;
        }

        @Override
        public StrongSlot first() {
            return this;
        }

        @Override
        public Slot rest() {
            return null;
        }

        @Override
        public StrongSlot find(LuaValue key) {
            return this.keyeq(key) ? this : null;
        }

        @Override
        public Slot set(StrongSlot target, LuaValue value) {
            return this.set(value);
        }

        @Override
        public Slot add(Slot entry) {
            return new LinkSlot(this, entry);
        }

        @Override
        public Slot remove(StrongSlot target) {
            return new DeadSlot(this.key(), null);
        }

        @Override
        public Slot relink(Slot rest) {
            return rest != null ? new LinkSlot(this, rest) : this;
        }
    }

    private static class DeadSlot
    implements Slot {
        private final Object key;
        private Slot next;

        private DeadSlot(LuaValue key, Slot next2) {
            this.key = LuaTable.isLargeKey(key) ? new WeakReference<LuaValue>(key) : key;
            this.next = next2;
        }

        private LuaValue key() {
            return (LuaValue)(this.key instanceof WeakReference ? ((WeakReference)this.key).get() : this.key);
        }

        @Override
        public int keyindex(int hashMask) {
            return 0;
        }

        @Override
        public StrongSlot first() {
            return null;
        }

        @Override
        public StrongSlot find(LuaValue key) {
            return null;
        }

        @Override
        public boolean keyeq(LuaValue key) {
            LuaValue k2 = this.key();
            return k2 != null && key.raweq(k2);
        }

        @Override
        public Slot rest() {
            return this.next;
        }

        @Override
        public int arraykey(int max2) {
            return -1;
        }

        @Override
        public Slot set(StrongSlot target, LuaValue value) {
            Slot next2;
            Slot slot = next2 = this.next != null ? this.next.set(target, value) : null;
            if (this.key() != null) {
                this.next = next2;
                return this;
            }
            return next2;
        }

        @Override
        public Slot add(Slot newEntry) {
            return this.next != null ? this.next.add(newEntry) : newEntry;
        }

        @Override
        public Slot remove(StrongSlot target) {
            if (this.key() != null) {
                this.next = this.next.remove(target);
                return this;
            }
            return this.next;
        }

        @Override
        public Slot relink(Slot rest) {
            return rest;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("<dead");
            LuaValue k2 = this.key();
            if (k2 != null) {
                buf.append(": ");
                buf.append(k2.toString());
            }
            buf.append('>');
            if (this.next != null) {
                buf.append("; ");
                buf.append(this.next.toString());
            }
            return buf.toString();
        }
    }

    private static class IntKeyEntry
    extends Entry {
        private final int key;
        private LuaValue value;

        IntKeyEntry(int key, LuaValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public LuaValue key() {
            return LuaValue.valueOf(this.key);
        }

        @Override
        public int arraykey(int max2) {
            return this.key >= 1 && this.key <= max2 ? this.key : 0;
        }

        @Override
        public LuaValue value() {
            return this.value;
        }

        @Override
        public Entry set(LuaValue value) {
            this.value = value;
            return this;
        }

        @Override
        public int keyindex(int mask) {
            return LuaTable.hashmod(LuaInteger.hashCode(this.key), mask);
        }

        @Override
        public boolean keyeq(LuaValue key) {
            return key.raweq(this.key);
        }
    }

    private static class NumberValueEntry
    extends Entry {
        private double value;
        private final LuaValue key;

        NumberValueEntry(LuaValue key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public LuaValue key() {
            return this.key;
        }

        @Override
        public LuaValue value() {
            return LuaValue.valueOf(this.value);
        }

        @Override
        public Entry set(LuaValue value) {
            LuaValue n2;
            if (value.type() == 3 && !(n2 = value.tonumber()).isnil()) {
                this.value = n2.todouble();
                return this;
            }
            return new NormalEntry(this.key, value);
        }

        @Override
        public int keyindex(int mask) {
            return LuaTable.hashSlot(this.key, mask);
        }

        @Override
        public boolean keyeq(LuaValue key) {
            return key.raweq(this.key);
        }
    }

    static class NormalEntry
    extends Entry {
        private final LuaValue key;
        private LuaValue value;

        NormalEntry(LuaValue key, LuaValue value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public LuaValue key() {
            return this.key;
        }

        @Override
        public LuaValue value() {
            return this.value;
        }

        @Override
        public Entry set(LuaValue value) {
            this.value = value;
            return this;
        }

        @Override
        public Varargs toVarargs() {
            return this;
        }

        @Override
        public int keyindex(int hashMask) {
            return LuaTable.hashSlot(this.key, hashMask);
        }

        @Override
        public boolean keyeq(LuaValue key) {
            return key.raweq(this.key);
        }
    }

    private static class LinkSlot
    implements StrongSlot {
        private Entry entry;
        private Slot next;

        LinkSlot(Entry entry, Slot next2) {
            this.entry = entry;
            this.next = next2;
        }

        @Override
        public LuaValue key() {
            return this.entry.key();
        }

        @Override
        public int keyindex(int hashMask) {
            return this.entry.keyindex(hashMask);
        }

        @Override
        public LuaValue value() {
            return this.entry.value();
        }

        @Override
        public Varargs toVarargs() {
            return this.entry.toVarargs();
        }

        @Override
        public StrongSlot first() {
            return this.entry;
        }

        @Override
        public StrongSlot find(LuaValue key) {
            return this.entry.keyeq(key) ? this : null;
        }

        @Override
        public boolean keyeq(LuaValue key) {
            return this.entry.keyeq(key);
        }

        @Override
        public Slot rest() {
            return this.next;
        }

        @Override
        public int arraykey(int max2) {
            return this.entry.arraykey(max2);
        }

        @Override
        public Slot set(StrongSlot target, LuaValue value) {
            if (target == this) {
                this.entry = this.entry.set(value);
                return this;
            }
            return this.setnext(this.next.set(target, value));
        }

        @Override
        public Slot add(Slot entry) {
            return this.setnext(this.next.add(entry));
        }

        @Override
        public Slot remove(StrongSlot target) {
            if (this == target) {
                return new DeadSlot(this.key(), this.next);
            }
            this.next = this.next.remove(target);
            return this;
        }

        @Override
        public Slot relink(Slot rest) {
            return rest != null ? new LinkSlot(this.entry, rest) : this.entry;
        }

        private Slot setnext(Slot next2) {
            if (next2 != null) {
                this.next = next2;
                return this;
            }
            return this.entry;
        }

        public String toString() {
            return this.entry + "; " + this.next;
        }
    }
}

