/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import li.cil.repack.org.luaj.vm2.Lua;
import li.cil.repack.org.luaj.vm2.LuaClosure;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Prototype;
import li.cil.repack.org.luaj.vm2.Upvaldesc;
import li.cil.repack.org.luaj.vm2.Varargs;

public class Print
extends Lua {
    private static final String STRING_FOR_NULL = "null";
    public static PrintStream ps = System.out;
    public static final String[] OPNAMES = new String[]{"MOVE", "LOADK", "LOADKX", "LOADBOOL", "LOADNIL", "GETUPVAL", "GETTABUP", "GETTABLE", "SETTABUP", "SETUPVAL", "SETTABLE", "NEWTABLE", "SELF", "ADD", "SUB", "MUL", "DIV", "MOD", "POW", "UNM", "NOT", "LEN", "CONCAT", "JMP", "EQ", "LT", "LE", "TEST", "TESTSET", "CALL", "TAILCALL", "RETURN", "FORLOOP", "FORPREP", "TFORCALL", "TFORLOOP", "SETLIST", "CLOSURE", "VARARG", "EXTRAARG", null};

    static void printString(PrintStream ps, LuaString s) {
        ps.print('\"');
        int n2 = s.m_length;
        block11: for (int i2 = 0; i2 < n2; ++i2) {
            byte c2 = s.m_bytes[s.m_offset + i2];
            if (c2 >= 32 && c2 <= 126 && c2 != 34 && c2 != 92) {
                ps.print((char)c2);
                continue;
            }
            switch (c2) {
                case 34: {
                    ps.print("\\\"");
                    continue block11;
                }
                case 92: {
                    ps.print("\\\\");
                    continue block11;
                }
                case 7: {
                    ps.print("\\a");
                    continue block11;
                }
                case 8: {
                    ps.print("\\b");
                    continue block11;
                }
                case 12: {
                    ps.print("\\f");
                    continue block11;
                }
                case 9: {
                    ps.print("\\t");
                    continue block11;
                }
                case 13: {
                    ps.print("\\r");
                    continue block11;
                }
                case 10: {
                    ps.print("\\n");
                    continue block11;
                }
                case 11: {
                    ps.print("\\v");
                    continue block11;
                }
                default: {
                    ps.print('\\');
                    ps.print(Integer.toString(0x4E7 & c2).substring(1));
                }
            }
        }
        ps.print('\"');
    }

    static void printValue(PrintStream ps, LuaValue v) {
        if (v == null) {
            ps.print(STRING_FOR_NULL);
            return;
        }
        switch (v.type()) {
            case 4: {
                Print.printString(ps, (LuaString)v);
                break;
            }
            default: {
                ps.print(v.tojstring());
            }
        }
    }

    static void printConstant(PrintStream ps, Prototype f2, int i2) {
        Print.printValue(ps, i2 < f2.k.length ? f2.k[i2] : LuaValue.valueOf("UNKNOWN_CONST_" + i2));
    }

    static void printUpvalue(PrintStream ps, Upvaldesc u) {
        ps.print(u.idx + " ");
        Print.printValue(ps, u.name);
    }

    public static void printCode(Prototype f2) {
        int[] code = f2.code;
        int n2 = code.length;
        for (int pc = 0; pc < n2; ++pc) {
            pc = Print.printOpCode(f2, pc);
            ps.println();
        }
    }

    public static int printOpCode(Prototype f2, int pc) {
        return Print.printOpCode(ps, f2, pc);
    }

    public static int printOpCode(PrintStream ps, Prototype f2, int pc) {
        int[] code = f2.code;
        int i2 = code[pc];
        int o2 = Print.GET_OPCODE(i2);
        int a2 = Print.GETARG_A(i2);
        int b2 = Print.GETARG_B(i2);
        int c2 = Print.GETARG_C(i2);
        int bx = Print.GETARG_Bx(i2);
        int sbx = Print.GETARG_sBx(i2);
        int line = Print.getline(f2, pc);
        ps.print("  " + (pc + 1) + "  ");
        if (line > 0) {
            ps.print("[" + line + "]  ");
        } else {
            ps.print("[-]  ");
        }
        if (o2 >= OPNAMES.length - 1) {
            ps.print("UNKNOWN_OP_" + o2 + "  ");
        } else {
            ps.print(OPNAMES[o2] + "  ");
            switch (Print.getOpMode(o2)) {
                case 0: {
                    ps.print(a2);
                    if (Print.getBMode(o2) != 0) {
                        ps.print(" " + (Print.ISK(b2) ? -1 - Print.INDEXK(b2) : b2));
                    }
                    if (Print.getCMode(o2) == 0) break;
                    ps.print(" " + (Print.ISK(c2) ? -1 - Print.INDEXK(c2) : c2));
                    break;
                }
                case 1: {
                    if (Print.getBMode(o2) == 3) {
                        ps.print(a2 + " " + (-1 - bx));
                        break;
                    }
                    ps.print(a2 + " " + bx);
                    break;
                }
                case 2: {
                    if (o2 == 23) {
                        ps.print(sbx);
                        break;
                    }
                    ps.print(a2 + " " + sbx);
                }
            }
            switch (o2) {
                case 1: {
                    ps.print("  ; ");
                    Print.printConstant(ps, f2, bx);
                    break;
                }
                case 5: 
                case 9: {
                    ps.print("  ; ");
                    if (b2 < f2.upvalues.length) {
                        Print.printUpvalue(ps, f2.upvalues[b2]);
                        break;
                    }
                    ps.print("UNKNOWN_UPVALUE_" + b2);
                    break;
                }
                case 6: {
                    ps.print("  ; ");
                    if (b2 < f2.upvalues.length) {
                        Print.printUpvalue(ps, f2.upvalues[b2]);
                    } else {
                        ps.print("UNKNOWN_UPVALUE_" + b2);
                    }
                    ps.print(" ");
                    if (Print.ISK(c2)) {
                        Print.printConstant(ps, f2, Print.INDEXK(c2));
                        break;
                    }
                    ps.print("-");
                    break;
                }
                case 8: {
                    ps.print("  ; ");
                    if (a2 < f2.upvalues.length) {
                        Print.printUpvalue(ps, f2.upvalues[a2]);
                    } else {
                        ps.print("UNKNOWN_UPVALUE_" + a2);
                    }
                    ps.print(" ");
                    if (Print.ISK(b2)) {
                        Print.printConstant(ps, f2, Print.INDEXK(b2));
                    } else {
                        ps.print("-");
                    }
                    ps.print(" ");
                    if (Print.ISK(c2)) {
                        Print.printConstant(ps, f2, Print.INDEXK(c2));
                        break;
                    }
                    ps.print("-");
                    break;
                }
                case 7: 
                case 12: {
                    if (!Print.ISK(c2)) break;
                    ps.print("  ; ");
                    Print.printConstant(ps, f2, Print.INDEXK(c2));
                    break;
                }
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 18: 
                case 24: 
                case 25: 
                case 26: {
                    if (!Print.ISK(b2) && !Print.ISK(c2)) break;
                    ps.print("  ; ");
                    if (Print.ISK(b2)) {
                        Print.printConstant(ps, f2, Print.INDEXK(b2));
                    } else {
                        ps.print("-");
                    }
                    ps.print(" ");
                    if (Print.ISK(c2)) {
                        Print.printConstant(ps, f2, Print.INDEXK(c2));
                        break;
                    }
                    ps.print("-");
                    break;
                }
                case 23: 
                case 32: 
                case 33: {
                    ps.print("  ; to " + (sbx + pc + 2));
                    break;
                }
                case 37: {
                    if (bx < f2.p.length) {
                        ps.print("  ; " + f2.p[bx].getClass().getName());
                        break;
                    }
                    ps.print("  ; UNKNOWN_PROTYPE_" + bx);
                    break;
                }
                case 36: {
                    if (c2 == 0) {
                        ps.print("  ; " + code[++pc] + " (stored in the next OP)");
                        break;
                    }
                    ps.print("  ; " + c2);
                    break;
                }
                case 38: {
                    ps.print("  ; is_vararg=" + f2.is_vararg);
                    break;
                }
            }
        }
        return pc;
    }

    private static int getline(Prototype f2, int pc) {
        return pc > 0 && f2.lineinfo != null && pc < f2.lineinfo.length ? f2.lineinfo[pc] : -1;
    }

    static void printHeader(Prototype f2) {
        String s = String.valueOf(f2.source);
        s = s.startsWith("@") || s.startsWith("=") ? s.substring(1) : ("\u001bLua".equals(s) ? "(bstring)" : "(string)");
        String a2 = f2.linedefined == 0 ? "main" : "function";
        ps.print("\n%" + a2 + " <" + s + ":" + f2.linedefined + "," + f2.lastlinedefined + "> (" + f2.code.length + " instructions, " + f2.code.length * 4 + " bytes at " + Print.id(f2) + ")\n");
        ps.print(f2.numparams + " param, " + f2.maxstacksize + " slot, " + f2.upvalues.length + " upvalue, ");
        ps.print(f2.locvars.length + " local, " + f2.k.length + " constant, " + f2.p.length + " function\n");
    }

    static void printConstants(Prototype f2) {
        int n2 = f2.k.length;
        ps.print("constants (" + n2 + ") for " + Print.id(f2) + ":\n");
        for (int i2 = 0; i2 < n2; ++i2) {
            ps.print("  " + (i2 + 1) + "  ");
            Print.printValue(ps, f2.k[i2]);
            ps.print("\n");
        }
    }

    static void printLocals(Prototype f2) {
        int n2 = f2.locvars.length;
        ps.print("locals (" + n2 + ") for " + Print.id(f2) + ":\n");
        for (int i2 = 0; i2 < n2; ++i2) {
            ps.println("  " + i2 + "  " + f2.locvars[i2].varname + " " + (f2.locvars[i2].startpc + 1) + " " + (f2.locvars[i2].endpc + 1));
        }
    }

    static void printUpValues(Prototype f2) {
        int n2 = f2.upvalues.length;
        ps.print("upvalues (" + n2 + ") for " + Print.id(f2) + ":\n");
        for (int i2 = 0; i2 < n2; ++i2) {
            ps.print("  " + i2 + "  " + f2.upvalues[i2] + "\n");
        }
    }

    public static void print(Prototype prototype) {
        Print.printFunction(prototype, true);
    }

    public static void printFunction(Prototype prototype, boolean full) {
        int n2 = prototype.p.length;
        Print.printHeader(prototype);
        Print.printCode(prototype);
        if (full) {
            Print.printConstants(prototype);
            Print.printLocals(prototype);
            Print.printUpValues(prototype);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Print.printFunction(prototype.p[i2], full);
        }
    }

    private static void format(String s, int maxcols) {
        int n2 = s.length();
        if (n2 > maxcols) {
            ps.print(s.substring(0, maxcols));
        } else {
            ps.print(s);
            int i2 = maxcols - n2;
            while (--i2 >= 0) {
                ps.print(' ');
            }
        }
    }

    private static String id(Prototype f2) {
        return "Proto";
    }

    private void _assert(boolean b2) {
        if (!b2) {
            throw new NullPointerException("_assert failed");
        }
    }

    public static void printState(LuaClosure cl, int pc, LuaValue[] stack, int top, Varargs varargs2) {
        PrintStream previous = ps;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ps = new PrintStream(baos);
        Print.printOpCode(cl.p, pc);
        ps.flush();
        ps.close();
        ps = previous;
        Print.format(baos.toString(), 50);
        Print.printStack(stack, top, varargs2);
        ps.println();
    }

    public static void printStack(LuaValue[] stack, int top, Varargs varargs2) {
        ps.print('[');
        for (int i2 = 0; i2 < stack.length; ++i2) {
            LuaValue v = stack[i2];
            if (v == null) {
                ps.print(STRING_FOR_NULL);
            } else {
                switch (v.type()) {
                    case 4: {
                        LuaString s = v.checkstring();
                        ps.print(s.length() < 48 ? s.tojstring() : s.substring(0, 32).tojstring() + "...+" + (s.length() - 32) + "b");
                        break;
                    }
                    case 6: {
                        ps.print(v.tojstring());
                        break;
                    }
                    case 7: {
                        Object o2 = v.touserdata();
                        if (o2 != null) {
                            String n2 = o2.getClass().getName();
                            n2 = n2.substring(n2.lastIndexOf(46) + 1);
                            ps.print(n2 + ": " + Integer.toHexString(o2.hashCode()));
                            break;
                        }
                        ps.print(v.toString());
                        break;
                    }
                    default: {
                        ps.print(v.tojstring());
                    }
                }
            }
            if (i2 + 1 == top) {
                ps.print(']');
            }
            ps.print(" | ");
        }
        ps.print(varargs2);
    }
}

