/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import li.cil.repack.org.luaj.vm2.Buffer;
import li.cil.repack.org.luaj.vm2.LuaClosure;
import li.cil.repack.org.luaj.vm2.LuaFunction;
import li.cil.repack.org.luaj.vm2.LuaInteger;
import li.cil.repack.org.luaj.vm2.LuaNumber;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaTable;
import li.cil.repack.org.luaj.vm2.LuaThread;
import li.cil.repack.org.luaj.vm2.LuaValue;

public abstract class Varargs {
    public abstract LuaValue arg(int var1);

    public abstract int narg();

    public abstract LuaValue arg1();

    public Varargs eval() {
        return this;
    }

    public boolean isTailcall() {
        return false;
    }

    public int type(int i2) {
        return this.arg(i2).type();
    }

    public boolean isnil(int i2) {
        return this.arg(i2).isnil();
    }

    public boolean isfunction(int i2) {
        return this.arg(i2).isfunction();
    }

    public boolean isnumber(int i2) {
        return this.arg(i2).isnumber();
    }

    public boolean isstring(int i2) {
        return this.arg(i2).isstring();
    }

    public boolean istable(int i2) {
        return this.arg(i2).istable();
    }

    public boolean isthread(int i2) {
        return this.arg(i2).isthread();
    }

    public boolean isuserdata(int i2) {
        return this.arg(i2).isuserdata();
    }

    public boolean isvalue(int i2) {
        return i2 > 0 && i2 <= this.narg();
    }

    public boolean optboolean(int i2, boolean defval) {
        return this.arg(i2).optboolean(defval);
    }

    public LuaClosure optclosure(int i2, LuaClosure defval) {
        return this.arg(i2).optclosure(defval);
    }

    public double optdouble(int i2, double defval) {
        return this.arg(i2).optdouble(defval);
    }

    public LuaFunction optfunction(int i2, LuaFunction defval) {
        return this.arg(i2).optfunction(defval);
    }

    public int optint(int i2, int defval) {
        return this.arg(i2).optint(defval);
    }

    public LuaInteger optinteger(int i2, LuaInteger defval) {
        return this.arg(i2).optinteger(defval);
    }

    public long optlong(int i2, long defval) {
        return this.arg(i2).optlong(defval);
    }

    public LuaNumber optnumber(int i2, LuaNumber defval) {
        return this.arg(i2).optnumber(defval);
    }

    public String optjstring(int i2, String defval) {
        return this.arg(i2).optjstring(defval);
    }

    public LuaString optstring(int i2, LuaString defval) {
        return this.arg(i2).optstring(defval);
    }

    public LuaTable opttable(int i2, LuaTable defval) {
        return this.arg(i2).opttable(defval);
    }

    public LuaThread optthread(int i2, LuaThread defval) {
        return this.arg(i2).optthread(defval);
    }

    public Object optuserdata(int i2, Object defval) {
        return this.arg(i2).optuserdata(defval);
    }

    public Object optuserdata(int i2, Class c2, Object defval) {
        return this.arg(i2).optuserdata(c2, defval);
    }

    public LuaValue optvalue(int i2, LuaValue defval) {
        return i2 > 0 && i2 <= this.narg() ? this.arg(i2) : defval;
    }

    public boolean checkboolean(int i2) {
        return this.arg(i2).checkboolean();
    }

    public LuaClosure checkclosure(int i2) {
        return this.arg(i2).checkclosure();
    }

    public double checkdouble(int i2) {
        return this.arg(i2).checkdouble();
    }

    public LuaFunction checkfunction(int i2) {
        return this.arg(i2).checkfunction();
    }

    public int checkint(int i2) {
        return this.arg(i2).checkint();
    }

    public LuaInteger checkinteger(int i2) {
        return this.arg(i2).checkinteger();
    }

    public long checklong(int i2) {
        return this.arg(i2).checklong();
    }

    public LuaNumber checknumber(int i2) {
        return this.arg(i2).checknumber();
    }

    public String checkjstring(int i2) {
        return this.arg(i2).checkjstring();
    }

    public LuaString checkstring(int i2) {
        return this.arg(i2).checkstring();
    }

    public LuaTable checktable(int i2) {
        return this.arg(i2).checktable();
    }

    public LuaThread checkthread(int i2) {
        return this.arg(i2).checkthread();
    }

    public Object checkuserdata(int i2) {
        return this.arg(i2).checkuserdata();
    }

    public Object checkuserdata(int i2, Class c2) {
        return this.arg(i2).checkuserdata(c2);
    }

    public LuaValue checkvalue(int i2) {
        return i2 <= this.narg() ? this.arg(i2) : LuaValue.argerror(i2, "value expected");
    }

    public LuaValue checknotnil(int i2) {
        return this.arg(i2).checknotnil();
    }

    public void argcheck(boolean test, int i2, String msg) {
        if (!test) {
            LuaValue.argerror(i2, msg);
        }
    }

    public boolean isnoneornil(int i2) {
        return i2 > this.narg() || this.arg(i2).isnil();
    }

    public boolean toboolean(int i2) {
        return this.arg(i2).toboolean();
    }

    public byte tobyte(int i2) {
        return this.arg(i2).tobyte();
    }

    public char tochar(int i2) {
        return this.arg(i2).tochar();
    }

    public double todouble(int i2) {
        return this.arg(i2).todouble();
    }

    public float tofloat(int i2) {
        return this.arg(i2).tofloat();
    }

    public int toint(int i2) {
        return this.arg(i2).toint();
    }

    public long tolong(int i2) {
        return this.arg(i2).tolong();
    }

    public String tojstring(int i2) {
        return this.arg(i2).tojstring();
    }

    public short toshort(int i2) {
        return this.arg(i2).toshort();
    }

    public Object touserdata(int i2) {
        return this.arg(i2).touserdata();
    }

    public Object touserdata(int i2, Class c2) {
        return this.arg(i2).touserdata(c2);
    }

    public String tojstring() {
        Buffer sb = new Buffer();
        sb.append("(");
        int n2 = this.narg();
        for (int i2 = 1; i2 <= n2; ++i2) {
            if (i2 > 1) {
                sb.append(",");
            }
            sb.append(this.arg(i2).tojstring());
        }
        sb.append(")");
        return sb.tojstring();
    }

    public String toString() {
        return this.tojstring();
    }

    public abstract Varargs subargs(int var1);

    void copyto(LuaValue[] dest, int offset, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            dest[offset + i2] = this.arg(i2 + 1);
        }
    }

    public Varargs dealias() {
        int n2 = this.narg();
        switch (n2) {
            case 0: {
                return LuaValue.NONE;
            }
            case 1: {
                return this.arg1();
            }
            case 2: {
                return new PairVarargs(this.arg1(), this.arg(2));
            }
        }
        LuaValue[] v = new LuaValue[n2];
        this.copyto(v, 0, n2);
        return new ArrayVarargs(v, LuaValue.NONE);
    }

    static final class PairVarargs
    extends Varargs {
        private final LuaValue v1;
        private final Varargs v2;

        PairVarargs(LuaValue v1, Varargs v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        public LuaValue arg(int i2) {
            return i2 == 1 ? this.v1 : this.v2.arg(i2 - 1);
        }

        @Override
        public int narg() {
            return 1 + this.v2.narg();
        }

        @Override
        public LuaValue arg1() {
            return this.v1;
        }

        @Override
        public Varargs subargs(int start) {
            if (start == 1) {
                return this;
            }
            if (start == 2) {
                return this.v2;
            }
            if (start > 2) {
                return this.v2.subargs(start - 1);
            }
            return LuaValue.argerror(1, "start must be > 0");
        }
    }

    static final class ArrayVarargs
    extends Varargs {
        private final LuaValue[] v;
        private final Varargs r;

        ArrayVarargs(LuaValue[] v, Varargs r) {
            this.v = v;
            this.r = r;
        }

        @Override
        public LuaValue arg(int i2) {
            return i2 < 1 ? LuaValue.NIL : (i2 <= this.v.length ? this.v[i2 - 1] : this.r.arg(i2 - this.v.length));
        }

        @Override
        public int narg() {
            return this.v.length + this.r.narg();
        }

        @Override
        public LuaValue arg1() {
            return this.v.length > 0 ? this.v[0] : this.r.arg1();
        }

        @Override
        public Varargs subargs(int start) {
            if (start <= 0) {
                LuaValue.argerror(1, "start must be > 0");
            }
            if (start == 1) {
                return this;
            }
            if (start > this.v.length) {
                return this.r.subargs(start - this.v.length);
            }
            return LuaValue.varargsOf(this.v, start - 1, this.v.length - (start - 1), this.r);
        }

        @Override
        void copyto(LuaValue[] dest, int offset, int length) {
            int n2 = Math.min(this.v.length, length);
            System.arraycopy(this.v, 0, dest, offset, n2);
            this.r.copyto(dest, offset + n2, length - n2);
        }
    }

    static final class ArrayPartVarargs
    extends Varargs {
        private final int offset;
        private final LuaValue[] v;
        private final int length;
        private final Varargs more;

        ArrayPartVarargs(LuaValue[] v, int offset, int length) {
            this.v = v;
            this.offset = offset;
            this.length = length;
            this.more = LuaValue.NONE;
        }

        public ArrayPartVarargs(LuaValue[] v, int offset, int length, Varargs more) {
            this.v = v;
            this.offset = offset;
            this.length = length;
            this.more = more;
        }

        @Override
        public LuaValue arg(int i2) {
            return i2 < 1 ? LuaValue.NIL : (i2 <= this.length ? this.v[this.offset + i2 - 1] : this.more.arg(i2 - this.length));
        }

        @Override
        public int narg() {
            return this.length + this.more.narg();
        }

        @Override
        public LuaValue arg1() {
            return this.length > 0 ? this.v[this.offset] : this.more.arg1();
        }

        @Override
        public Varargs subargs(int start) {
            if (start <= 0) {
                LuaValue.argerror(1, "start must be > 0");
            }
            if (start == 1) {
                return this;
            }
            if (start > this.length) {
                return this.more.subargs(start - this.length);
            }
            return LuaValue.varargsOf(this.v, this.offset + start - 1, this.length - (start - 1), this.more);
        }

        @Override
        void copyto(LuaValue[] dest, int offset, int length) {
            int n2 = Math.min(this.length, length);
            System.arraycopy(this.v, this.offset, dest, offset, n2);
            this.more.copyto(dest, offset + n2, length - n2);
        }
    }

    static class SubVarargs
    extends Varargs {
        private final Varargs v;
        private final int start;
        private final int end;

        public SubVarargs(Varargs varargs2, int start, int end) {
            this.v = varargs2;
            this.start = start;
            this.end = end;
        }

        @Override
        public LuaValue arg(int i2) {
            return (i2 += this.start - 1) >= this.start && i2 <= this.end ? this.v.arg(i2) : LuaValue.NIL;
        }

        @Override
        public LuaValue arg1() {
            return this.v.arg(this.start);
        }

        @Override
        public int narg() {
            return this.end + 1 - this.start;
        }

        @Override
        public Varargs subargs(int start) {
            if (start == 1) {
                return this;
            }
            int newstart = this.start + start - 1;
            if (start > 0) {
                if (newstart >= this.end) {
                    return LuaValue.NONE;
                }
                if (newstart == this.end) {
                    return this.v.arg(this.end);
                }
                if (newstart == this.end - 1) {
                    return new PairVarargs(this.v.arg(this.end - 1), this.v.arg(this.end));
                }
                return new SubVarargs(this.v, newstart, this.end);
            }
            return new SubVarargs(this.v, newstart, this.end);
        }
    }
}

