/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.compiler;

import li.cil.repack.org.luaj.vm2.LocVars;
import li.cil.repack.org.luaj.vm2.Lua;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Prototype;
import li.cil.repack.org.luaj.vm2.Upvaldesc;
import li.cil.repack.org.luaj.vm2.compiler.InstructionPtr;
import li.cil.repack.org.luaj.vm2.compiler.LexState;

public class Constants
extends Lua {
    public static final int MAXSTACK = 250;
    static final int LUAI_MAXUPVAL = 255;
    static final int LUAI_MAXVARS = 200;
    static final int NO_REG = 255;
    static final int iABC = 0;
    static final int iABx = 1;
    static final int iAsBx = 2;
    static final int OpArgN = 0;
    static final int OpArgU = 1;
    static final int OpArgR = 2;
    static final int OpArgK = 3;

    protected static void _assert(boolean b2) {
        if (!b2) {
            throw new LuaError("compiler assert failed");
        }
    }

    static void SET_OPCODE(InstructionPtr i2, int o2) {
        i2.set(i2.get() & 0xFFFFFFC0 | o2 << 0 & 0x3F);
    }

    static void SETARG_A(int[] code, int index, int u) {
        code[index] = code[index] & 0xFFFFC03F | u << 6 & 0x3FC0;
    }

    static void SETARG_A(InstructionPtr i2, int u) {
        i2.set(i2.get() & 0xFFFFC03F | u << 6 & 0x3FC0);
    }

    static void SETARG_B(InstructionPtr i2, int u) {
        i2.set(i2.get() & 0x7FFFFF | u << 23 & 0xFF800000);
    }

    static void SETARG_C(InstructionPtr i2, int u) {
        i2.set(i2.get() & 0xFF803FFF | u << 14 & 0x7FC000);
    }

    static void SETARG_Bx(InstructionPtr i2, int u) {
        i2.set(i2.get() & 0x3FFF | u << 14 & 0xFFFFC000);
    }

    static void SETARG_sBx(InstructionPtr i2, int u) {
        Constants.SETARG_Bx(i2, u + 131071);
    }

    static int CREATE_ABC(int o2, int a2, int b2, int c2) {
        return o2 << 0 & 0x3F | a2 << 6 & 0x3FC0 | b2 << 23 & 0xFF800000 | c2 << 14 & 0x7FC000;
    }

    static int CREATE_ABx(int o2, int a2, int bc) {
        return o2 << 0 & 0x3F | a2 << 6 & 0x3FC0 | bc << 14 & 0xFFFFC000;
    }

    static int CREATE_Ax(int o2, int a2) {
        return o2 << 0 & 0x3F | a2 << 6 & 0xFFFFFFC0;
    }

    static LuaValue[] realloc(LuaValue[] v, int n2) {
        LuaValue[] a2 = new LuaValue[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static Prototype[] realloc(Prototype[] v, int n2) {
        Prototype[] a2 = new Prototype[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static LuaString[] realloc(LuaString[] v, int n2) {
        LuaString[] a2 = new LuaString[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static LocVars[] realloc(LocVars[] v, int n2) {
        LocVars[] a2 = new LocVars[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static Upvaldesc[] realloc(Upvaldesc[] v, int n2) {
        Upvaldesc[] a2 = new Upvaldesc[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static LexState.Vardesc[] realloc(LexState.Vardesc[] v, int n2) {
        LexState.Vardesc[] a2 = new LexState.Vardesc[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static LexState.Labeldesc[] grow(LexState.Labeldesc[] v, int min_n) {
        return v == null ? new LexState.Labeldesc[2] : (v.length < min_n ? Constants.realloc(v, v.length * 2) : v);
    }

    static LexState.Labeldesc[] realloc(LexState.Labeldesc[] v, int n2) {
        LexState.Labeldesc[] a2 = new LexState.Labeldesc[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static int[] realloc(int[] v, int n2) {
        int[] a2 = new int[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static byte[] realloc(byte[] v, int n2) {
        byte[] a2 = new byte[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    static char[] realloc(char[] v, int n2) {
        char[] a2 = new char[n2];
        if (v != null) {
            System.arraycopy(v, 0, a2, 0, Math.min(v.length, n2));
        }
        return a2;
    }

    protected Constants() {
    }
}

