/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import li.cil.repack.org.luaj.vm2.Buffer;
import li.cil.repack.org.luaj.vm2.LuaClosure;
import li.cil.repack.org.luaj.vm2.LuaFunction;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaTable;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.compat.JavaCompat;
import li.cil.repack.org.luaj.vm2.compiler.DumpState;
import li.cil.repack.org.luaj.vm2.lib.OneArgFunction;
import li.cil.repack.org.luaj.vm2.lib.TwoArgFunction;
import li.cil.repack.org.luaj.vm2.lib.VarArgFunction;

public class StringLib
extends TwoArgFunction {
    private static final String FLAGS = "-+ #0";
    private static final int L_ESC = 37;
    private static final LuaString SPECIALS = StringLib.valueOf("^$*+?.([%-");
    private static final int MAX_CAPTURES = 32;
    private static final int MAXCCALLS = 200;
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;
    private static final byte MASK_ALPHA = 1;
    private static final byte MASK_LOWERCASE = 2;
    private static final byte MASK_UPPERCASE = 4;
    private static final byte MASK_DIGIT = 8;
    private static final byte MASK_PUNCT = 16;
    private static final byte MASK_SPACE = 32;
    private static final byte MASK_CONTROL = 64;
    private static final byte MASK_HEXDIGIT = -128;
    static final byte[] CHAR_TABLE = new byte[256];

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        LuaTable string = new LuaTable();
        string.set("byte", (LuaValue)new _byte());
        string.set("char", (LuaValue)new _char());
        string.set("dump", (LuaValue)new dump());
        string.set("find", (LuaValue)new find());
        string.set("format", (LuaValue)new format());
        string.set("gmatch", (LuaValue)new gmatch());
        string.set("gsub", (LuaValue)new gsub());
        string.set("len", (LuaValue)new len());
        string.set("lower", (LuaValue)new lower());
        string.set("match", (LuaValue)new match());
        string.set("rep", (LuaValue)new rep());
        string.set("reverse", (LuaValue)new reverse());
        string.set("sub", (LuaValue)new sub());
        string.set("upper", (LuaValue)new upper());
        env.set("string", (LuaValue)string);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("string", (LuaValue)string);
        }
        if (LuaString.s_metatable == null) {
            LuaString.s_metatable = LuaValue.tableOf(new LuaValue[]{INDEX, string});
        }
        return string;
    }

    static void addquoted(Buffer buf, LuaString s) {
        buf.append((byte)34);
        int n2 = s.length();
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            int c2 = s.luaByte(i2);
            switch (c2) {
                case 10: 
                case 34: 
                case 92: {
                    buf.append((byte)92);
                    buf.append((byte)c2);
                    continue block3;
                }
                default: {
                    if (c2 <= 31 || c2 == 127) {
                        buf.append((byte)92);
                        if (i2 + 1 == n2 || s.luaByte(i2 + 1) < 48 || s.luaByte(i2 + 1) > 57) {
                            buf.append(Integer.toString(c2));
                            continue block3;
                        }
                        buf.append((byte)48);
                        buf.append((byte)(48 + c2 / 10));
                        buf.append((byte)(48 + c2 % 10));
                        continue block3;
                    }
                    buf.append((byte)c2);
                }
            }
        }
        buf.append((byte)34);
    }

    protected String format(String src, double x) {
        return String.valueOf(x);
    }

    static Varargs str_find_aux(Varargs args, boolean find2) {
        boolean fastMatch;
        LuaString s = args.checkstring(1);
        LuaString pat = args.checkstring(2);
        int init = args.optint(3, 1);
        if (init > 0) {
            init = Math.min(init - 1, s.length());
        } else if (init < 0) {
            init = Math.max(0, s.length() + init);
        }
        boolean bl = fastMatch = find2 && (args.arg(4).toboolean() || pat.indexOfAny(SPECIALS) == -1);
        if (fastMatch) {
            int result2 = s.indexOf(pat, init);
            if (result2 != -1) {
                return StringLib.varargsOf(StringLib.valueOf(result2 + 1), (Varargs)StringLib.valueOf(result2 + pat.length()));
            }
        } else {
            MatchState ms = new MatchState(args, s, pat);
            boolean anchor = false;
            int poff = 0;
            if (pat.length() > 0 && pat.luaByte(0) == 94) {
                anchor = true;
                poff = 1;
            }
            int soff = init;
            do {
                ms.reset();
                int res = ms.match(soff, poff);
                if (res == -1) continue;
                if (find2) {
                    return StringLib.varargsOf(StringLib.valueOf(soff + 1), StringLib.valueOf(res), ms.push_captures(false, soff, res));
                }
                return ms.push_captures(true, soff, res);
            } while (soff++ < s.length() && !anchor);
        }
        return NIL;
    }

    static int posrelat(int pos, int len2) {
        return pos >= 0 ? pos : len2 + pos + 1;
    }

    static {
        for (int i2 = 0; i2 < 128; ++i2) {
            char c2 = (char)i2;
            StringLib.CHAR_TABLE[i2] = (byte)((Character.isDigit(c2) ? 8 : 0) | (Character.isLowerCase(c2) ? 2 : 0) | (Character.isUpperCase(c2) ? 4 : 0) | (c2 < ' ' || c2 == '\u007f' ? 64 : 0));
            if (c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' || c2 >= '0' && c2 <= '9') {
                int n2 = i2;
                CHAR_TABLE[n2] = (byte)(CHAR_TABLE[n2] | 0xFFFFFF80);
            }
            if (c2 >= '!' && c2 <= '/' || c2 >= ':' && c2 <= '@' || c2 >= '[' && c2 <= '`' || c2 >= '{' && c2 <= '~') {
                int n3 = i2;
                CHAR_TABLE[n3] = (byte)(CHAR_TABLE[n3] | 0x10);
            }
            if ((CHAR_TABLE[i2] & 6) == 0) continue;
            int n4 = i2;
            CHAR_TABLE[n4] = (byte)(CHAR_TABLE[n4] | 1);
        }
        StringLib.CHAR_TABLE[32] = 32;
        CHAR_TABLE[13] = (byte)(CHAR_TABLE[13] | 0x20);
        CHAR_TABLE[10] = (byte)(CHAR_TABLE[10] | 0x20);
        CHAR_TABLE[9] = (byte)(CHAR_TABLE[9] | 0x20);
        CHAR_TABLE[11] = (byte)(CHAR_TABLE[11] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
    }

    static final class _byte
    extends VarArgFunction {
        _byte() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString s = args.checkstring(1);
            int l2 = s.m_length;
            int posi = StringLib.posrelat(args.optint(2, 1), l2);
            int pose = StringLib.posrelat(args.optint(3, posi), l2);
            if (posi <= 0) {
                posi = 1;
            }
            if (pose > l2) {
                pose = l2;
            }
            if (posi > pose) {
                return NONE;
            }
            int n2 = pose - posi + 1;
            if (posi + n2 <= pose) {
                _byte.error("string slice too long");
            }
            LuaValue[] v = new LuaValue[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                v[i2] = _byte.valueOf(s.luaByte(posi + i2 - 1));
            }
            return _byte.varargsOf(v);
        }
    }

    static final class _char
    extends VarArgFunction {
        _char() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int n2 = args.narg();
            byte[] bytes = new byte[n2];
            int i2 = 0;
            int a2 = 1;
            while (i2 < n2) {
                int c2 = args.checkint(a2);
                if (c2 < 0 || c2 >= 256) {
                    _char.argerror(a2, "invalid value for string.char [0; 255]: " + c2);
                }
                bytes[i2] = (byte)c2;
                ++i2;
                ++a2;
            }
            return LuaString.valueUsing(bytes);
        }
    }

    static final class dump
    extends VarArgFunction {
        dump() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaFunction f2 = args.checkfunction(1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                DumpState.dump(((LuaClosure)f2).p, baos, args.optboolean(2, true));
                return LuaString.valueUsing(baos.toByteArray());
            }
            catch (IOException e2) {
                return dump.error(e2.getMessage());
            }
        }
    }

    static final class find
    extends VarArgFunction {
        find() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return StringLib.str_find_aux(args, true);
        }
    }

    final class format
    extends VarArgFunction {
        format() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString fmt = args.checkstring(1);
            int n2 = fmt.length();
            Buffer result2 = new Buffer(n2);
            int arg = 1;
            int i2 = 0;
            block12: while (i2 < n2) {
                int c2 = fmt.luaByte(i2++);
                switch (c2) {
                    case 10: {
                        result2.append("\n");
                        continue block12;
                    }
                    default: {
                        result2.append((byte)c2);
                        continue block12;
                    }
                    case 37: 
                }
                if (i2 >= n2) continue;
                c2 = fmt.luaByte(i2);
                if (c2 == 37) {
                    ++i2;
                    result2.append((byte)37);
                    continue;
                }
                ++arg;
                FormatDesc fdsc = new FormatDesc(args, fmt, i2);
                i2 += fdsc.length;
                switch (fdsc.conversion) {
                    case 99: {
                        fdsc.format(result2, (byte)args.checkint(arg));
                        break;
                    }
                    case 100: 
                    case 105: {
                        fdsc.format(result2, args.checklong(arg));
                        break;
                    }
                    case 88: 
                    case 111: 
                    case 117: 
                    case 120: {
                        fdsc.format(result2, args.checklong(arg));
                        break;
                    }
                    case 65: 
                    case 69: 
                    case 71: 
                    case 97: 
                    case 101: 
                    case 102: 
                    case 103: {
                        String bstr;
                        String nprefix;
                        double j2 = args.checkdouble(arg);
                        if (Double.isNaN(j2) || Double.isInfinite(j2)) {
                            nprefix = "";
                            if (JavaCompat.INSTANCE.doubleToRawLongBits(j2) < 0L) {
                                nprefix = "-";
                            } else if (fdsc.explicitPlus) {
                                nprefix = "+";
                            } else if (fdsc.space) {
                                nprefix = " ";
                            }
                            String string = bstr = Double.isNaN(j2) ? "nan" : "inf";
                            if (fdsc.conversion == 69 || fdsc.conversion == 71) {
                                bstr = bstr.toUpperCase();
                            }
                            fdsc.precision = -1;
                            fdsc.zeroPad = false;
                            fdsc.format(result2, format.valueOf(nprefix + bstr));
                            break;
                        }
                        if ((fdsc.conversion == 103 || fdsc.conversion == 71) && fdsc.precision == -1) {
                            nprefix = "";
                            if (j2 >= 0.0) {
                                if (fdsc.explicitPlus) {
                                    nprefix = "+";
                                } else if (fdsc.space) {
                                    nprefix = " ";
                                }
                            }
                            bstr = Double.toString(j2);
                            bstr = fdsc.conversion == 71 ? bstr.toUpperCase() : bstr.toLowerCase();
                            fdsc.format(result2, format.valueOf(nprefix + bstr));
                            break;
                        }
                        fdsc.format(result2, args.checkdouble(arg));
                        break;
                    }
                    case 113: {
                        StringLib.addquoted(result2, args.checkstring(arg));
                        break;
                    }
                    case 115: {
                        LuaValue v;
                        LuaValue argv = args.checkvalue(arg);
                        LuaValue h2 = argv.metatag(TOSTRING);
                        if (!h2.isnil()) {
                            v = h2.call(argv).tostring();
                            return !v.isnil() ? v : StringLib.valueOf("(null)");
                        }
                        v = argv.tostring();
                        LuaString s = !v.isnil() ? v.checkstring() : StringLib.valueOf(argv.tojstring());
                        if (fdsc.precision == -1 && s.length() >= 100) {
                            result2.append(s);
                            break;
                        }
                        fdsc.zeroPad = false;
                        fdsc.format(result2, s);
                        break;
                    }
                    default: {
                        format.error("invalid option '%" + (char)fdsc.conversion + "' to 'format'");
                    }
                }
            }
            return result2.tostring();
        }
    }

    static final class gmatch
    extends VarArgFunction {
        gmatch() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString src = args.checkstring(1);
            LuaString pat = args.checkstring(2);
            return new GMatchAux(args, src, pat);
        }
    }

    static final class gsub
    extends VarArgFunction {
        gsub() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString src = args.checkstring(1);
            int srclen = src.length();
            LuaString p = args.checkstring(2);
            int lastmatch = -1;
            LuaValue repl = args.arg(3);
            int max_s = args.optint(4, srclen + 1);
            if (max_s < 0) {
                max_s = srclen + 1;
            }
            boolean anchor = p.length() > 0 && p.charAt(0) == 94;
            Buffer lbuf = new Buffer(srclen);
            MatchState ms = new MatchState(args, src, p);
            int soffset = 0;
            int n2 = 0;
            while (n2 < max_s) {
                ms.reset();
                int res = ms.match(soffset, anchor ? 1 : 0);
                if (res != -1 && res != lastmatch) {
                    ++n2;
                    ms.add_value(lbuf, soffset, res, repl);
                    soffset = lastmatch = res;
                } else {
                    if (soffset >= srclen) break;
                    lbuf.append((byte)src.luaByte(soffset++));
                }
                if (!anchor) continue;
                break;
            }
            lbuf.append(src.substring(soffset, srclen));
            return gsub.varargsOf(lbuf.tostring(), (Varargs)gsub.valueOf(n2));
        }
    }

    static final class len
    extends OneArgFunction {
        len() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return arg.checkstring().len();
        }
    }

    static final class lower
    extends OneArgFunction {
        lower() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return lower.valueOf(arg.checkjstring().toLowerCase());
        }
    }

    static final class match
    extends VarArgFunction {
        match() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return StringLib.str_find_aux(args, false);
        }
    }

    static final class rep
    extends VarArgFunction {
        rep() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString s = args.checkstring(1);
            int n2 = args.checkint(2);
            LuaString sep = args.optstring(3, EMPTYSTRING);
            if (n2 <= 0) {
                return EMPTYSTRING;
            }
            int len2 = s.length();
            int lsep = sep.length();
            byte[] bytes = new byte[len2 * n2 + lsep * (n2 - 1)];
            int offset = 0;
            while (n2-- > 1) {
                s.copyInto(0, bytes, offset, len2);
                offset += len2;
                if (lsep <= 0) continue;
                sep.copyInto(0, bytes, offset, lsep);
                offset += lsep;
            }
            s.copyInto(0, bytes, offset, len2);
            return LuaString.valueUsing(bytes);
        }
    }

    static final class reverse
    extends OneArgFunction {
        reverse() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            LuaString s = arg.checkstring();
            int n2 = s.length();
            byte[] b2 = new byte[n2];
            int i2 = 0;
            int j2 = n2 - 1;
            while (i2 < n2) {
                b2[j2] = (byte)s.luaByte(i2);
                ++i2;
                --j2;
            }
            return LuaString.valueUsing(b2);
        }
    }

    static final class sub
    extends VarArgFunction {
        sub() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaString s = args.checkstring(1);
            int l2 = s.length();
            int start = StringLib.posrelat(args.checkint(2), l2);
            int end = StringLib.posrelat(args.optint(3, -1), l2);
            if (start < 1) {
                start = 1;
            }
            if (end > l2) {
                end = l2;
            }
            if (start <= end) {
                return s.substring(start - 1, end);
            }
            return EMPTYSTRING;
        }
    }

    static final class upper
    extends OneArgFunction {
        upper() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return upper.valueOf(arg.checkjstring().toUpperCase());
        }
    }

    static class MatchState {
        int matchdepth;
        final LuaString s;
        final LuaString p;
        final Varargs args;
        int level;
        int[] cinit;
        int[] clen;

        MatchState(Varargs args, LuaString s, LuaString pattern) {
            this.s = s;
            this.p = pattern;
            this.args = args;
            this.level = 0;
            this.cinit = new int[32];
            this.clen = new int[32];
            this.matchdepth = 200;
        }

        void reset() {
            this.level = 0;
            this.matchdepth = 200;
        }

        private void add_s(Buffer lbuf, LuaString news, int soff, int e2) {
            int l2 = news.length();
            for (int i2 = 0; i2 < l2; ++i2) {
                byte b2 = (byte)news.luaByte(i2);
                if (b2 != 37) {
                    lbuf.append(b2);
                    continue;
                }
                if (!Character.isDigit((char)(b2 = (byte)(++i2 < l2 ? news.luaByte(i2) : 0)))) {
                    if (b2 != 37) {
                        LuaValue.error("invalid use of '%' in replacement string: after '%' must be '0'-'9' or '%', but found " + (i2 < l2 ? "symbol '" + (char)b2 + "' with code " + b2 + " at pos " + (i2 + 1) : "end of string"));
                    }
                    lbuf.append(b2);
                    continue;
                }
                if (b2 == 48) {
                    lbuf.append(this.s.substring(soff, e2));
                    continue;
                }
                lbuf.append(this.push_onecapture(b2 - 49, soff, e2).strvalue());
            }
        }

        public void add_value(Buffer lbuf, int soffset, int end, LuaValue repl) {
            switch (repl.type()) {
                case 3: 
                case 4: {
                    this.add_s(lbuf, repl.strvalue(), soffset, end);
                    return;
                }
                case 6: {
                    repl = repl.invoke(this.push_captures(true, soffset, end)).arg1();
                    break;
                }
                case 5: {
                    repl = repl.get(this.push_onecapture(0, soffset, end));
                    break;
                }
                default: {
                    LuaValue.error("bad argument: string/function/table expected");
                    return;
                }
            }
            if (!repl.toboolean()) {
                repl = this.s.substring(soffset, end);
            } else if (!repl.isstring()) {
                LuaValue.error("invalid replacement value (a " + repl.typename() + ")");
            }
            lbuf.append(repl.strvalue());
        }

        Varargs push_captures(boolean wholeMatch, int soff, int end) {
            int nlevels = this.level == 0 && wholeMatch ? 1 : this.level;
            switch (nlevels) {
                case 0: {
                    return LuaValue.NONE;
                }
                case 1: {
                    return this.push_onecapture(0, soff, end);
                }
            }
            LuaValue[] v = new LuaValue[nlevels];
            for (int i2 = 0; i2 < nlevels; ++i2) {
                v[i2] = this.push_onecapture(i2, soff, end);
            }
            return LuaValue.varargsOf(v);
        }

        private LuaValue push_onecapture(int i2, int soff, int end) {
            if (i2 >= this.level) {
                if (i2 == 0) {
                    return this.s.substring(soff, end);
                }
                return LuaValue.error("invalid capture index %" + (i2 + 1));
            }
            int l2 = this.clen[i2];
            if (l2 == -1) {
                return LuaValue.error("unfinished capture");
            }
            if (l2 == -2) {
                return LuaValue.valueOf(this.cinit[i2] + 1);
            }
            int begin = this.cinit[i2];
            return this.s.substring(begin, begin + l2);
        }

        private int check_capture(int l2) {
            if ((l2 -= 49) < 0 || l2 >= this.level || this.clen[l2] == -1) {
                LuaValue.error("invalid capture index %" + (l2 + 1));
            }
            return l2;
        }

        private int capture_to_close() {
            int level = this.level;
            --level;
            while (level >= 0) {
                if (this.clen[level] == -1) {
                    return level;
                }
                --level;
            }
            LuaValue.error("invalid pattern capture");
            return 0;
        }

        int classend(int poffset) {
            switch (this.p.luaByte(poffset++)) {
                case 37: {
                    if (poffset == this.p.length()) {
                        LuaValue.error("malformed pattern (ends with '%')");
                    }
                    return poffset + 1;
                }
                case 91: {
                    if (poffset != this.p.length() && this.p.luaByte(poffset) == 94) {
                        ++poffset;
                    }
                    do {
                        if (poffset == this.p.length()) {
                            LuaValue.error("malformed pattern (missing ']')");
                        }
                        if (this.p.luaByte(poffset++) != 37 || poffset >= this.p.length()) continue;
                        ++poffset;
                    } while (poffset == this.p.length() || this.p.luaByte(poffset) != 93);
                    return poffset + 1;
                }
            }
            return poffset;
        }

        static boolean match_class(int c2, int cl) {
            boolean res;
            char lcl = Character.toLowerCase((char)cl);
            byte cdata = CHAR_TABLE[c2];
            switch (lcl) {
                case 'a': {
                    res = (cdata & 1) != 0;
                    break;
                }
                case 'd': {
                    res = (cdata & 8) != 0;
                    break;
                }
                case 'l': {
                    res = (cdata & 2) != 0;
                    break;
                }
                case 'u': {
                    res = (cdata & 4) != 0;
                    break;
                }
                case 'c': {
                    res = (cdata & 0x40) != 0;
                    break;
                }
                case 'p': {
                    res = (cdata & 0x10) != 0;
                    break;
                }
                case 's': {
                    res = (cdata & 0x20) != 0;
                    break;
                }
                case 'g': {
                    res = (cdata & 0x19) != 0;
                    break;
                }
                case 'w': {
                    res = (cdata & 9) != 0;
                    break;
                }
                case 'x': {
                    res = (cdata & 0xFFFFFF80) != 0;
                    break;
                }
                case 'z': {
                    res = c2 == 0;
                    break;
                }
                default: {
                    return cl == c2;
                }
            }
            return lcl == cl ? res : !res;
        }

        boolean matchbracketclass(int c2, int poff, int ec) {
            boolean sig = true;
            if (this.p.luaByte(poff + 1) == 94) {
                sig = false;
                ++poff;
            }
            while (++poff < ec) {
                if (!(this.p.luaByte(poff) == 37 ? MatchState.match_class(c2, this.p.luaByte(++poff)) : (this.p.luaByte(poff + 1) == 45 && poff + 2 < ec ? this.p.luaByte((poff += 2) - 2) <= c2 && c2 <= this.p.luaByte(poff) : this.p.luaByte(poff) == c2))) continue;
                return sig;
            }
            return !sig;
        }

        boolean singlematch(int c2, int poff, int ep) {
            switch (this.p.luaByte(poff)) {
                case 46: {
                    return true;
                }
                case 37: {
                    return MatchState.match_class(c2, this.p.luaByte(poff + 1));
                }
                case 91: {
                    return this.matchbracketclass(c2, poff, ep - 1);
                }
            }
            return this.p.luaByte(poff) == c2;
        }

        int match(int soffset, int poffset) {
            if (this.matchdepth-- == 0) {
                LuaValue.error("pattern too complex");
            }
            try {
                block33: while (true) {
                    int ep;
                    int n2;
                    if (poffset == this.p.length()) {
                        n2 = soffset;
                        return n2;
                    }
                    switch (this.p.luaByte(poffset)) {
                        case 40: {
                            if (++poffset < this.p.length() && this.p.luaByte(poffset) == 41) {
                                n2 = this.start_capture(soffset, poffset + 1, -2);
                                return n2;
                            }
                            n2 = this.start_capture(soffset, poffset, -1);
                            return n2;
                        }
                        case 41: {
                            n2 = this.end_capture(soffset, poffset + 1);
                            return n2;
                        }
                        case 37: {
                            int previous;
                            if (poffset + 1 == this.p.length()) {
                                LuaValue.error("malformed pattern (ends with '%')");
                            }
                            switch (this.p.luaByte(poffset + 1)) {
                                case 98: {
                                    soffset = this.matchbalance(soffset, poffset + 2);
                                    if (soffset == -1) {
                                        n2 = -1;
                                        return n2;
                                    }
                                    poffset += 4;
                                    continue block33;
                                }
                                case 102: {
                                    int next2;
                                    if ((poffset += 2) == this.p.length() || this.p.luaByte(poffset) != 91) {
                                        LuaValue.error("missing '[' after '%f' in pattern");
                                    }
                                    ep = this.classend(poffset);
                                    previous = soffset == 0 ? 0 : this.s.luaByte(soffset - 1);
                                    int n3 = next2 = soffset == this.s.length() ? 0 : this.s.luaByte(soffset);
                                    if (this.matchbracketclass(previous, poffset, ep - 1) || !this.matchbracketclass(next2, poffset, ep - 1)) {
                                        int n4 = -1;
                                        return n4;
                                    }
                                    poffset = ep;
                                    continue block33;
                                }
                            }
                            int c2 = this.p.luaByte(poffset + 1);
                            if (Character.isDigit((char)c2)) {
                                if ((soffset = this.match_capture(soffset, c2)) == -1) {
                                    previous = -1;
                                    return previous;
                                }
                                previous = this.match(soffset, poffset + 2);
                                return previous;
                            }
                        }
                        case 36: {
                            if (poffset + 1 != this.p.length()) break;
                            int c2 = soffset == this.s.length() ? soffset : -1;
                            return c2;
                        }
                    }
                    ep = this.classend(poffset);
                    boolean m2 = soffset < this.s.length() && this.singlematch(this.s.luaByte(soffset), poffset, ep);
                    int pc = ep < this.p.length() ? this.p.luaByte(ep) : 0;
                    switch (pc) {
                        case 63: {
                            int res;
                            if (m2 && (res = this.match(soffset + 1, ep + 1)) != -1) {
                                int n5 = res;
                                return n5;
                            }
                            poffset = ep + 1;
                            continue block33;
                        }
                        case 42: {
                            int n6 = this.max_expand(soffset, poffset, ep);
                            return n6;
                        }
                        case 43: {
                            int n7 = m2 ? this.max_expand(soffset + 1, poffset, ep) : -1;
                            return n7;
                        }
                        case 45: {
                            int n8 = this.min_expand(soffset, poffset, ep);
                            return n8;
                        }
                    }
                    if (!m2) {
                        int n9 = -1;
                        return n9;
                    }
                    ++soffset;
                    poffset = ep;
                }
            }
            finally {
                ++this.matchdepth;
            }
        }

        int max_expand(int soff, int poff, int ep) {
            int i2 = 0;
            while (soff + i2 < this.s.length() && this.singlematch(this.s.luaByte(soff + i2), poff, ep)) {
                ++i2;
            }
            while (i2 >= 0) {
                int res = this.match(soff + i2, ep + 1);
                if (res != -1) {
                    return res;
                }
                --i2;
            }
            return -1;
        }

        int min_expand(int soff, int poff, int ep) {
            while (true) {
                int res;
                if ((res = this.match(soff, ep + 1)) != -1) {
                    return res;
                }
                if (soff >= this.s.length() || !this.singlematch(this.s.luaByte(soff), poff, ep)) break;
                ++soff;
            }
            return -1;
        }

        int start_capture(int soff, int poff, int what) {
            int level = this.level;
            if (level >= 32) {
                LuaValue.error("too many captures");
            }
            this.cinit[level] = soff;
            this.clen[level] = what;
            this.level = level + 1;
            int res = this.match(soff, poff);
            if (res == -1) {
                --this.level;
            }
            return res;
        }

        int end_capture(int soff, int poff) {
            int l2 = this.capture_to_close();
            this.clen[l2] = soff - this.cinit[l2];
            int res = this.match(soff, poff);
            if (res == -1) {
                this.clen[l2] = -1;
            }
            return res;
        }

        int match_capture(int soff, int l2) {
            l2 = this.check_capture(l2);
            int len2 = this.clen[l2];
            if (this.s.length() - soff >= len2 && LuaString.equals(this.s, this.cinit[l2], this.s, soff, len2)) {
                return soff + len2;
            }
            return -1;
        }

        int matchbalance(int soff, int poff) {
            int slen;
            int plen = this.p.length();
            if (poff == plen || poff + 1 == plen) {
                LuaValue.error("malformed pattern (missing arguments to '%b')");
            }
            if (soff >= (slen = this.s.length())) {
                return -1;
            }
            int b2 = this.p.luaByte(poff);
            if (this.s.luaByte(soff) != b2) {
                return -1;
            }
            int e2 = this.p.luaByte(poff + 1);
            int cont = 1;
            while (++soff < slen) {
                if (this.s.luaByte(soff) == e2) {
                    if (--cont != 0) continue;
                    return soff + 1;
                }
                if (this.s.luaByte(soff) != b2) continue;
                ++cont;
            }
            return -1;
        }
    }

    static class GMatchAux
    extends VarArgFunction {
        private final int srclen;
        private final MatchState ms;
        private int soffset;
        private int lastmatch;

        public GMatchAux(Varargs args, LuaString src, LuaString pat) {
            this.srclen = src.length();
            this.ms = new MatchState(args, src, pat);
            this.soffset = 0;
            this.lastmatch = -1;
        }

        @Override
        public Varargs invoke(Varargs args) {
            while (this.soffset <= this.srclen) {
                this.ms.reset();
                int res = this.ms.match(this.soffset, 0);
                if (res >= 0 && res != this.lastmatch) {
                    int soff = this.soffset;
                    this.lastmatch = this.soffset = res;
                    return this.ms.push_captures(true, soff, res);
                }
                ++this.soffset;
            }
            return NIL;
        }
    }

    class FormatDesc {
        private boolean leftAdjust;
        private boolean zeroPad;
        private boolean explicitPlus;
        private boolean space;
        private boolean alternateForm;
        private static final int MAX_FLAGS = 5;
        private int width;
        int precision;
        public final int conversion;
        public final int length;
        public final String src;

        public FormatDesc(Varargs args, LuaString strfrmt, int start) {
            int p = start;
            int n2 = strfrmt.length();
            int c2 = 0;
            boolean moreFlags = true;
            block7: while (moreFlags) {
                c2 = p < n2 ? strfrmt.luaByte(p++) : 0;
                switch (c2) {
                    case 45: {
                        this.leftAdjust = true;
                        continue block7;
                    }
                    case 43: {
                        this.explicitPlus = true;
                        continue block7;
                    }
                    case 32: {
                        this.space = true;
                        continue block7;
                    }
                    case 35: {
                        this.alternateForm = true;
                        continue block7;
                    }
                    case 48: {
                        this.zeroPad = true;
                        continue block7;
                    }
                }
                moreFlags = false;
            }
            if (p - start > 5) {
                LuaValue.error("invalid format (repeated flags)");
            }
            this.width = -1;
            if (Character.isDigit((char)c2)) {
                this.width = c2 - 48;
                int n3 = c2 = p < n2 ? strfrmt.luaByte(p++) : 0;
                if (Character.isDigit((char)c2)) {
                    this.width = this.width * 10 + (c2 - 48);
                    int n4 = c2 = p < n2 ? strfrmt.luaByte(p++) : 0;
                }
            }
            if (c2 == 46) {
                this.precision = 0;
                int n5 = c2 = p < n2 ? strfrmt.luaByte(p++) : 0;
                if (Character.isDigit((char)c2)) {
                    this.precision = c2 - 48;
                    int n6 = c2 = p < n2 ? strfrmt.luaByte(p++) : 0;
                    if (Character.isDigit((char)c2)) {
                        this.precision = this.precision * 10 + (c2 - 48);
                        c2 = p < n2 ? strfrmt.luaByte(p++) : 0;
                    }
                }
            } else {
                this.precision = -1;
            }
            if (Character.isDigit((char)c2)) {
                LuaValue.error("invalid format (width or precision too long)");
            }
            if (this.width == -1) {
                this.leftAdjust = false;
                this.zeroPad = false;
            } else {
                this.zeroPad &= !this.leftAdjust;
            }
            this.space &= !this.explicitPlus;
            this.conversion = c2;
            this.length = p - start;
            this.src = strfrmt.substring(start - 1, p).tojstring();
        }

        public void format(Buffer buf, byte c2) {
            if (!this.leftAdjust) {
                this.pad(buf, ' ', this.width - 1);
            }
            buf.append(c2);
            if (this.leftAdjust) {
                this.pad(buf, ' ', this.width - 1);
            }
        }

        public void format(Buffer buf, long number) {
            int nspaces;
            boolean allowPlusSpace;
            int minwidth;
            String digits;
            if (number == 0L && this.precision == 0) {
                digits = "";
            } else {
                int radix;
                switch (this.conversion) {
                    case 88: 
                    case 120: {
                        radix = 16;
                        break;
                    }
                    case 111: {
                        radix = 8;
                        break;
                    }
                    default: {
                        radix = 10;
                    }
                }
                digits = Long.toString(number, radix);
                if (this.conversion == 88) {
                    digits = digits.toUpperCase();
                }
            }
            int ndigits = minwidth = digits.length();
            boolean bl = allowPlusSpace = this.conversion == 100 || this.conversion == 105;
            if (number < 0L) {
                --ndigits;
            } else if (allowPlusSpace && (this.explicitPlus || this.space)) {
                ++minwidth;
            }
            int nzeros = this.precision > ndigits ? this.precision - ndigits : (this.precision == -1 && this.zeroPad && this.width > minwidth ? this.width - minwidth : 0);
            int n2 = nspaces = this.width > (minwidth += nzeros) ? this.width - minwidth : 0;
            if (!this.leftAdjust) {
                this.pad(buf, ' ', nspaces);
            }
            if (number < 0L) {
                if (nzeros > 0) {
                    buf.append((byte)45);
                    digits = digits.substring(1);
                }
            } else if (allowPlusSpace && this.explicitPlus) {
                buf.append((byte)43);
            } else if (allowPlusSpace && this.space) {
                buf.append((byte)32);
            }
            if (this.alternateForm) {
                switch (this.conversion) {
                    case 111: {
                        buf.append((byte)48);
                        break;
                    }
                    case 120: {
                        buf.append("0x");
                        break;
                    }
                    case 88: {
                        buf.append("0X");
                    }
                }
            }
            if (nzeros > 0) {
                this.pad(buf, '0', nzeros);
            }
            buf.append(digits);
            if (this.leftAdjust) {
                this.pad(buf, ' ', nspaces);
            }
        }

        public void format(Buffer buf, double x) {
            String sFormat = "%";
            if (this.leftAdjust) {
                sFormat = sFormat + "-";
            }
            if (this.explicitPlus) {
                sFormat = sFormat + "+";
            }
            if (this.space) {
                sFormat = sFormat + " ";
            }
            if (this.alternateForm && this.conversion != 103 && this.conversion != 71) {
                sFormat = sFormat + "#";
            }
            if (this.zeroPad) {
                sFormat = sFormat + "0";
            }
            if (this.width != -1) {
                sFormat = sFormat + this.width;
            }
            if (this.precision != -1) {
                sFormat = sFormat + "." + this.precision;
            }
            sFormat = sFormat + (char)this.conversion;
            buf.append(StringLib.this.format(sFormat, x));
        }

        public void format(Buffer buf, LuaString s) {
            int newLength;
            int nullindex = s.indexOf((byte)0, 0);
            if (nullindex != -1) {
                s = s.substring(0, nullindex);
            }
            int n2 = newLength = this.precision == -1 ? s.length() : Math.min(this.precision, s.length());
            if (!this.leftAdjust) {
                this.pad(buf, this.zeroPad ? (char)'0' : ' ', this.width - newLength);
            }
            buf.append(s);
            if (this.leftAdjust) {
                this.pad(buf, ' ', this.width - newLength);
            }
        }

        public final void pad(Buffer buf, char c2, int n2) {
            byte b2 = (byte)c2;
            while (n2-- > 0) {
                buf.append(b2);
            }
        }
    }
}

