/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import li.cil.repack.org.luaj.vm2.LuaDouble;
import li.cil.repack.org.luaj.vm2.LuaInteger;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaArray;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaClass;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaInstance;

public class CoerceJavaToLua {
    static final Map COERCIONS = Collections.synchronizedMap(new HashMap());
    static final Coercion instanceCoercion;
    static final Coercion arrayCoercion;
    static final Coercion luaCoercion;

    public static LuaValue coerce(Object o2) {
        if (o2 == null) {
            return LuaValue.NIL;
        }
        Class<?> clazz = o2.getClass();
        Coercion c2 = (Coercion)COERCIONS.get(clazz);
        if (c2 == null) {
            c2 = clazz.isArray() ? arrayCoercion : (o2 instanceof LuaValue ? luaCoercion : instanceCoercion);
            COERCIONS.put(clazz, c2);
        }
        return c2.coerce(o2);
    }

    static {
        BoolCoercion boolCoercion = new BoolCoercion();
        IntCoercion intCoercion = new IntCoercion();
        CharCoercion charCoercion = new CharCoercion();
        DoubleCoercion doubleCoercion = new DoubleCoercion();
        StringCoercion stringCoercion = new StringCoercion();
        BytesCoercion bytesCoercion = new BytesCoercion();
        ClassCoercion classCoercion = new ClassCoercion();
        COERCIONS.put(Boolean.class, boolCoercion);
        COERCIONS.put(Byte.class, intCoercion);
        COERCIONS.put(Character.class, charCoercion);
        COERCIONS.put(Short.class, intCoercion);
        COERCIONS.put(Integer.class, intCoercion);
        COERCIONS.put(Long.class, doubleCoercion);
        COERCIONS.put(Float.class, doubleCoercion);
        COERCIONS.put(Double.class, doubleCoercion);
        COERCIONS.put(String.class, stringCoercion);
        COERCIONS.put(byte[].class, bytesCoercion);
        COERCIONS.put(Class.class, classCoercion);
        instanceCoercion = new InstanceCoercion();
        arrayCoercion = new ArrayCoercion();
        luaCoercion = new LuaCoercion();
    }

    static interface Coercion {
        public LuaValue coerce(Object var1);
    }

    private static final class BoolCoercion
    implements Coercion {
        private BoolCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            Boolean b2 = (Boolean)javaValue;
            return b2 != false ? LuaValue.TRUE : LuaValue.FALSE;
        }
    }

    private static final class IntCoercion
    implements Coercion {
        private IntCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            Number n2 = (Number)javaValue;
            return LuaInteger.valueOf(n2.intValue());
        }
    }

    private static final class CharCoercion
    implements Coercion {
        private CharCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            Character c2 = (Character)javaValue;
            return LuaInteger.valueOf(c2.charValue());
        }
    }

    private static final class DoubleCoercion
    implements Coercion {
        private DoubleCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            Number n2 = (Number)javaValue;
            return LuaDouble.valueOf(n2.doubleValue());
        }
    }

    private static final class StringCoercion
    implements Coercion {
        private StringCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            return LuaString.valueOf(javaValue.toString());
        }
    }

    private static final class BytesCoercion
    implements Coercion {
        private BytesCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            return LuaValue.valueOf((byte[])javaValue);
        }
    }

    private static final class ClassCoercion
    implements Coercion {
        private ClassCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            return JavaClass.forClass((Class)javaValue);
        }
    }

    private static final class InstanceCoercion
    implements Coercion {
        private InstanceCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            return new JavaInstance(javaValue);
        }
    }

    private static final class ArrayCoercion
    implements Coercion {
        private ArrayCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            return new JavaArray(javaValue);
        }
    }

    private static final class LuaCoercion
    implements Coercion {
        private LuaCoercion() {
        }

        @Override
        public LuaValue coerce(Object javaValue) {
            return (LuaValue)javaValue;
        }
    }
}

