/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaTable;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.VarArgFunction;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceJavaToLua;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceLuaToJava;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaClass;

public class LuajavaLib
extends VarArgFunction {
    static final int INIT = 0;
    static final int BINDCLASS = 1;
    static final int NEWINSTANCE = 2;
    static final int NEW = 3;
    static final int CREATEPROXY = 4;
    static final int LOADLIB = 5;
    static final String[] NAMES = new String[]{"bindClass", "newInstance", "new", "createProxy", "loadLib"};
    static final int METHOD_MODIFIERS_VARARGS = 128;

    @Override
    public Varargs invoke(Varargs args) {
        try {
            switch (this.opcode) {
                case 0: {
                    LuaValue env = args.arg(2);
                    LuaTable t = new LuaTable();
                    this.bind(t, this.getClass(), NAMES, 1);
                    env.set("luajava", (LuaValue)t);
                    if (!env.get("package").isnil()) {
                        env.get("package").get("loaded").set("luajava", (LuaValue)t);
                    }
                    return t;
                }
                case 1: {
                    Class clazz = this.classForName(args.checkjstring(1));
                    return JavaClass.forClass(clazz);
                }
                case 2: 
                case 3: {
                    LuaValue c2 = args.checkvalue(1);
                    Class clazz = this.opcode == 2 ? this.classForName(c2.tojstring()) : (Class)c2.checkuserdata(Class.class);
                    Varargs consargs = args.subargs(2);
                    return JavaClass.forClass(clazz).getConstructor().invoke(consargs);
                }
                case 4: {
                    int niface = args.narg() - 1;
                    if (niface <= 0) {
                        throw new LuaError("no interfaces");
                    }
                    LuaTable lobj = args.checktable(niface + 1);
                    Class[] ifaces = new Class[niface];
                    for (int i2 = 0; i2 < niface; ++i2) {
                        ifaces[i2] = this.classForName(args.checkjstring(i2 + 1));
                    }
                    ProxyInvocationHandler handler = new ProxyInvocationHandler(lobj);
                    Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), ifaces, (InvocationHandler)handler);
                    return LuaValue.userdataOf(proxy);
                }
                case 5: {
                    String classname = args.checkjstring(1);
                    String methodname = args.checkjstring(2);
                    Class clazz = this.classForName(classname);
                    Method method = clazz.getMethod(methodname, new Class[0]);
                    Object result2 = method.invoke((Object)clazz, new Object[0]);
                    if (result2 instanceof LuaValue) {
                        return (LuaValue)result2;
                    }
                    return NIL;
                }
            }
            throw new LuaError("not yet supported: " + this);
        }
        catch (LuaError e2) {
            throw e2;
        }
        catch (InvocationTargetException ite) {
            throw new LuaError(ite.getTargetException());
        }
        catch (Exception e3) {
            throw new LuaError(e3);
        }
    }

    protected Class classForName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, ClassLoader.getSystemClassLoader());
    }

    private static final class ProxyInvocationHandler
    implements InvocationHandler {
        private final LuaValue lobj;

        private ProxyInvocationHandler(LuaValue lobj) {
            this.lobj = lobj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            LuaValue[] v;
            int n2;
            String name = method.getName();
            LuaValue func = this.lobj.get(name);
            if (func.isnil()) {
                return null;
            }
            boolean isvarargs = (method.getModifiers() & 0x80) != 0;
            int n3 = n2 = args != null ? args.length : 0;
            if (isvarargs) {
                int i2;
                Object o2 = args[--n2];
                int m2 = Array.getLength(o2);
                v = new LuaValue[n2 + m2];
                for (i2 = 0; i2 < n2; ++i2) {
                    v[i2] = CoerceJavaToLua.coerce(args[i2]);
                }
                for (i2 = 0; i2 < m2; ++i2) {
                    v[i2 + n2] = CoerceJavaToLua.coerce(Array.get(o2, i2));
                }
            } else {
                v = new LuaValue[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    v[i3] = CoerceJavaToLua.coerce(args[i3]);
                }
            }
            LuaValue result2 = func.invoke(v).arg1();
            return CoerceLuaToJava.coerce(result2, method.getReturnType());
        }
    }
}

