/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop;

import java.io.Serializable;
import ocelot.desktop.ColorScheme$;
import ocelot.desktop.color.IntColor;
import ocelot.desktop.color.RGBAColorNorm;
import ocelot.desktop.util.Logging;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.mutable.HashMap;
import scala.io.Source;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00054AAD\b\u0001)!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003B\u0002!\u0001A\u0003%q\u0005C\u0003B\u0001\u0011\u0005!\tC\u0003F\u0001\u0011\u0005a\tC\u0003M\u0001\u0011\u0005QjB\u0003W\u001f!\u0005qKB\u0003\u000f\u001f!\u0005\u0001\fC\u0003\"\u0011\u0011\u0005\u0011\fC\u0004[\u0011\t\u0007I\u0011A.\t\rqC\u0001\u0015!\u0003$\u0011\u0015a\u0005\u0002\"\u0001^\u0011\u0015\t\u0005\u0002\"\u0001`\u0005-\u0019u\u000e\\8s'\u000eDW-\\3\u000b\u0005A\t\u0012a\u00023fg.$x\u000e\u001d\u0006\u0002%\u00051qnY3m_R\u001c\u0001aE\u0002\u0001+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0010\u0003\u0011)H/\u001b7\n\u0005\u0001j\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003=\tq!\u001a8ue&,7/F\u0001(!\u0011ASf\f\u001e\u000e\u0003%R!AK\u0016\u0002\u000f5,H/\u00192mK*\u0011AfF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0018*\u0005\u001dA\u0015m\u001d5NCB\u0004\"\u0001M\u001c\u000f\u0005E*\u0004C\u0001\u001a\u0018\u001b\u0005\u0019$B\u0001\u001b\u0014\u0003\u0019a$o\\8u}%\u0011agF\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027/A\u00111HP\u0007\u0002y)\u0011QhD\u0001\u0006G>dwN]\u0005\u0003\u007fq\u0012QBU$C\u0003\u000e{Gn\u001c:O_Jl\u0017\u0001C3oiJLWm\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005i\u001a\u0005\"\u0002#\u0005\u0001\u0004y\u0013aA6fs\u0006\u0019\u0011\r\u001a3\u0015\u0007\u001dS5\n\u0005\u0002\u0017\u0011&\u0011\u0011j\u0006\u0002\u0005+:LG\u000fC\u0003E\u000b\u0001\u0007q\u0006C\u0003>\u000b\u0001\u0007!(\u0001\u0003m_\u0006$GCA$O\u0011\u0015ye\u00011\u0001Q\u0003\u0019\u0019x.\u001e:dKB\u0011\u0011\u000bV\u0007\u0002%*\u00111kF\u0001\u0003S>L!!\u0016*\u0003\rM{WO]2f\u0003-\u0019u\u000e\\8s'\u000eDW-\\3\u0011\u0005\u0011B1C\u0001\u0005\u0016)\u00059\u0016aB$f]\u0016\u0014\u0018\r\\\u000b\u0002G\u0005Aq)\u001a8fe\u0006d\u0007\u0005\u0006\u0002H=\")q\n\u0004a\u0001!R\u0011!\b\u0019\u0005\u0006\t6\u0001\ra\f")
public class ColorScheme
implements Logging {
    private final HashMap<String, RGBAColorNorm> entries;
    private Logger logger;

    public static ColorScheme General() {
        return ColorScheme$.MODULE$.General();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private HashMap<String, RGBAColorNorm> entries() {
        return this.entries;
    }

    public RGBAColorNorm apply(String key) {
        return this.entries().apply(key);
    }

    public void add(String key, RGBAColorNorm color) {
        this.entries().addOne(new Tuple2<String, RGBAColorNorm>(key, color));
    }

    public void load(Source source) {
        this.logger().info("Loading color scheme");
        int oldSize = this.entries().size();
        source.getLines().foreach((Function1<String, Object> & Serializable)line_ -> {
            String line = line_.trim();
            if (!line.startsWith("#") && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(line))) {
                String[] split = line.split("\\s*=\\s*");
                String key = split[0];
                String value = split[1];
                if (value.startsWith("#")) {
                    RGBAColorNorm rGBAColorNorm;
                    long bytes = Long.parseLong(value.substring(1), 16);
                    if (value.length() == 9) {
                        long rgb = bytes >> 8;
                        rGBAColorNorm = new IntColor((int)rgb).toRGBANorm().withAlpha((float)(bytes & 0xFFL) / 255.0f);
                    } else {
                        rGBAColorNorm = new IntColor((int)bytes).toRGBANorm();
                    }
                    RGBAColorNorm color = rGBAColorNorm;
                    return this.entries().addOne(new Tuple2<String, RGBAColorNorm>(key, color));
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        this.logger().info(new StringBuilder(14).append("Loaded ").append(this.entries().size() - oldSize).append(" colors").toString());
    }

    public ColorScheme() {
        Logging.$init$(this);
        this.entries = new HashMap();
        Statics.releaseFence();
    }
}

