/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.audio;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import ocelot.desktop.Settings$;
import ocelot.desktop.audio.AL10W$;
import ocelot.desktop.audio.Audio$;
import ocelot.desktop.audio.OpenAlException;
import ocelot.desktop.audio.OpenAlException$;
import ocelot.desktop.audio.SoundBuffer;
import ocelot.desktop.audio.SoundCategory$;
import ocelot.desktop.audio.SoundSamples;
import ocelot.desktop.audio.SoundSource;
import ocelot.desktop.audio.SoundSource$;
import ocelot.desktop.audio.SoundSource$Status$;
import ocelot.desktop.audio.SoundStream;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Transaction;
import ocelot.desktop.util.Transaction$;
import org.apache.logging.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception$;

public final class Audio$
implements Logging {
    public static final Audio$ MODULE$ = new Audio$();
    private static final int sampleRate;
    private static final HashMap<SoundSource, Object> ocelot$desktop$audio$Audio$$sources;
    private static boolean _disabled;
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
        sampleRate = 44100;
        ocelot$desktop$audio$Audio$$sources = new HashMap();
        _disabled = true;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public int sampleRate() {
        return sampleRate;
    }

    public HashMap<SoundSource, Object> ocelot$desktop$audio$Audio$$sources() {
        return ocelot$desktop$audio$Audio$$sources;
    }

    private boolean _disabled() {
        return _disabled;
    }

    private void _disabled_$eq(boolean x$1) {
        _disabled = x$1;
    }

    public void init() {
        try {
            AL.create();
            this.logger().info(new StringBuilder(15).append("OpenAL device: ").append(ALC10.alcGetString(AL.getDevice(), 4101)).toString());
            this._disabled_$eq(false);
        }
        catch (LWJGLException e2) {
            this.logger().error("Unable to initialize OpenAL. Disabling sound");
            e2.printStackTrace();
        }
    }

    public boolean isDisabled() {
        return this._disabled();
    }

    public Tuple2<SoundStream, SoundSource> newStream(Enumeration.Value soundCategory, float pitch, float volume) {
        ObjectRef<Object> source = ObjectRef.create(null);
        SoundStream stream = new SoundStream(source){
            private final ObjectRef source$1;

            public void enqueue(SoundSamples samples) {
                Audio$ audio$ = Audio$.MODULE$;
                synchronized (audio$) {
                    OpenAlException$.MODULE$.ignoring().apply((Function0<Option> & Serializable)() -> Transaction$.MODULE$.runAbortable((Function1<Transaction.AbortableTransaction, Object> & Serializable)tx -> {
                        anon.1.$anonfun$enqueue$2(this, samples, tx);
                        return BoxedUnit.UNIT;
                    }));
                }
            }

            public static final /* synthetic */ int $anonfun$enqueue$3(anon.1 $this, Transaction tx) {
                int sourceId = AL10W$.MODULE$.alGenSources();
                tx.onFailure(() -> AL10W$.MODULE$.alDeleteSources(sourceId));
                AL10W$.MODULE$.alSourcef(sourceId, 4099, ((SoundSource)$this.source$1.elem).pitch());
                Audio$.MODULE$.ocelot$desktop$audio$Audio$$setPosition(sourceId, (SoundSource)$this.source$1.elem);
                Audio$.MODULE$.ocelot$desktop$audio$Audio$$setGain(sourceId, (SoundSource)$this.source$1.elem);
                Audio$.MODULE$.ocelot$desktop$audio$Audio$$sources().put((SoundSource)$this.source$1.elem, BoxesRunTime.boxToInteger(sourceId));
                return sourceId;
            }

            public static final /* synthetic */ void $anonfun$enqueue$2(anon.1 $this, SoundSamples samples$1, Transaction.AbortableTransaction tx2) {
                if (!Audio$.MODULE$.isDisabled()) {
                    int sourceId = Audio$.MODULE$.ocelot$desktop$audio$Audio$$sources().contains((SoundSource)$this.source$1.elem) ? BoxesRunTime.unboxToInt(Audio$.MODULE$.ocelot$desktop$audio$Audio$$sources().apply((SoundSource)$this.source$1.elem)) : BoxesRunTime.unboxToInt(Transaction$.MODULE$.run((Function1<Transaction, Object> & Serializable)tx -> BoxesRunTime.boxToInteger(anon.1.$anonfun$enqueue$3($this, tx))));
                    Audio$.MODULE$.ocelot$desktop$audio$Audio$$cleanupSourceBuffers(sourceId);
                    int bufferId = BoxesRunTime.unboxToInt(samples$1.genBuffer().getOrElse((Function0<Nothing$> & Serializable)() -> tx2.abort()));
                    tx2.onFailure(() -> AL10W$.MODULE$.alDeleteBuffers(bufferId));
                    AL10W$.MODULE$.alSourceQueueBuffers(sourceId, bufferId);
                    if (AL10W$.MODULE$.alGetSourcei(sourceId, 4112) != 4114) {
                        AL10W$.MODULE$.alSourcePlay(sourceId);
                        return;
                    }
                    return;
                }
            }
            {
                this.source$1 = source$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$enqueue$1(ocelot.desktop.audio.Audio$$anon$1 ocelot.desktop.audio.SoundSamples ), $anonfun$enqueue$2$adapted(ocelot.desktop.audio.Audio$$anon$1 ocelot.desktop.audio.SoundSamples ocelot.desktop.util.Transaction$AbortableTransaction ), $anonfun$enqueue$3$adapted(ocelot.desktop.audio.Audio$$anon$1 ocelot.desktop.util.Transaction ), $anonfun$enqueue$4(int ), $anonfun$enqueue$5(ocelot.desktop.util.Transaction$AbortableTransaction ), $anonfun$enqueue$6(int )}, serializedLambda);
            }
        };
        source.elem = SoundSource$.MODULE$.fromStream(stream, soundCategory, false, pitch, volume).build();
        return new Tuple2<SoundStream, SoundSource>(stream, (SoundSource)source.elem);
    }

    public float newStream$default$2() {
        return 1.0f;
    }

    public float newStream$default$3() {
        return 1.0f;
    }

    public synchronized Enumeration.Value getSourceStatus(SoundSource source) {
        int n2;
        if (!this.ocelot$desktop$audio$Audio$$sources().contains(source)) {
            return SoundSource$Status$.MODULE$.Stopped();
        }
        int sourceId = BoxesRunTime.unboxToInt(this.ocelot$desktop$audio$Audio$$sources().apply(source));
        boolean bl = false;
        Some some = null;
        Option<Object> option = Exception$.MODULE$.catching((Seq<Class<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{OpenAlException.class})).opt(() -> AL10W$.MODULE$.alGetSourcei(sourceId, 4112));
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int n3 = BoxesRunTime.unboxToInt(some.value());
            if (4114 == n3) {
                return SoundSource$Status$.MODULE$.Playing();
            }
        }
        if (bl && 4115 == (n2 = BoxesRunTime.unboxToInt(some.value()))) {
            return SoundSource$Status$.MODULE$.Paused();
        }
        return SoundSource$Status$.MODULE$.Stopped();
    }

    public void playSource(SoundSource source) {
        Object object = new Object();
        try {
            Audio$ audio$ = this;
            synchronized (audio$) {
                OpenAlException$.MODULE$.ignoring().apply((Function0<Option> & Serializable)() -> {
                    if (MODULE$.isDisabled()) {
                        throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                    }
                    Enumeration.Value value = MODULE$.getSourceStatus(source);
                    Enumeration.Value value2 = SoundSource$Status$.MODULE$.Playing();
                    if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
                        throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                    }
                    if (MODULE$.ocelot$desktop$audio$Audio$$sources().contains(source)) {
                        AL10W$.MODULE$.alSourcePlay(BoxesRunTime.unboxToInt(MODULE$.ocelot$desktop$audio$Audio$$sources().apply(source)));
                        throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                    }
                    return Transaction$.MODULE$.runAbortable((Function1<Transaction.AbortableTransaction, Option> & Serializable)tx -> {
                        int sourceId = AL10W$.MODULE$.alGenSources();
                        tx.onFailure(() -> AL10W$.MODULE$.alDeleteSources(sourceId));
                        SoundSource.Kind kind = source.kind();
                        if (kind instanceof SoundSource.Kind.Buffer) {
                            SoundSource.Kind.Buffer buffer = (SoundSource.Kind.Buffer)kind;
                            SoundBuffer buffer2 = buffer.buffer();
                            Option<Object> option = buffer2.bufferId();
                            if (!(option instanceof Some)) {
                                if (None$.MODULE$.equals(option)) {
                                    MODULE$.logger().error(new StringBuilder(50).append("Called play on a SoundBuffer ").append(buffer2).append(" with bufferId = None").toString());
                                    throw tx.abort();
                                }
                                throw new MatchError(option);
                            }
                            Some some = (Some)option;
                            int bufferId = BoxesRunTime.unboxToInt(some.value());
                            AL10W$.MODULE$.alSourcei(sourceId, 4105, bufferId);
                        } else if (kind instanceof SoundSource.Kind.Samples) {
                            SoundSource.Kind.Samples samples = (SoundSource.Kind.Samples)kind;
                            SoundSamples samples2 = samples.samples();
                            BoxedUnit cfr_ignored_0 = (BoxedUnit)Transaction$.MODULE$.run((Function1<Transaction, Object> & Serializable)innerTx -> {
                                Audio$.$anonfun$playSource$4(samples2, tx, sourceId, innerTx);
                                return BoxedUnit.UNIT;
                            });
                        } else if (kind instanceof SoundSource.Kind.Stream) {
                        } else {
                            throw new MatchError(kind);
                        }
                        AL10W$.MODULE$.alSourcef(sourceId, 4099, source.pitch());
                        MODULE$.ocelot$desktop$audio$Audio$$setPosition(sourceId, source);
                        AL10W$.MODULE$.alSourcei(sourceId, 4103, source.looping() ? 1 : 0);
                        MODULE$.ocelot$desktop$audio$Audio$$setGain(sourceId, source);
                        AL10W$.MODULE$.alSourcePlay(sourceId);
                        return MODULE$.ocelot$desktop$audio$Audio$$sources().put(source, BoxesRunTime.boxToInteger(sourceId));
                    });
                });
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public synchronized void pauseSource(SoundSource source) {
        Object object = new Object();
        try {
            OpenAlException$.MODULE$.ignoring().apply(() -> {
                if (MODULE$.isDisabled()) {
                    throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                }
                Enumeration.Value value = MODULE$.getSourceStatus(source);
                Enumeration.Value value2 = SoundSource$Status$.MODULE$.Paused();
                if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
                    throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                }
                if (MODULE$.ocelot$desktop$audio$Audio$$sources().contains(source)) {
                    AL10W$.MODULE$.alSourcePause(BoxesRunTime.unboxToInt(MODULE$.ocelot$desktop$audio$Audio$$sources().apply(source)));
                    return;
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public synchronized void stopSource(SoundSource source) {
        Object object = new Object();
        try {
            OpenAlException$.MODULE$.ignoring().apply(() -> {
                if (MODULE$.isDisabled()) {
                    throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                }
                Enumeration.Value value = MODULE$.getSourceStatus(source);
                Enumeration.Value value2 = SoundSource$Status$.MODULE$.Stopped();
                if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
                    throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                }
                if (MODULE$.ocelot$desktop$audio$Audio$$sources().contains(source)) {
                    AL10W$.MODULE$.alSourceStop(BoxesRunTime.unboxToInt(MODULE$.ocelot$desktop$audio$Audio$$sources().apply(source)));
                    return;
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public void ocelot$desktop$audio$Audio$$setPosition(int sourceId, SoundSource source) {
        AL10W$.MODULE$.alSource3f(sourceId, 4100, source.position().x(), source.position().y(), source.position().z());
    }

    public void ocelot$desktop$audio$Audio$$setGain(int sourceId, SoundSource source) {
        AL10W$.MODULE$.alSourcef(sourceId, 4106, source.volume() * SoundCategory$.MODULE$.getSettingsValue(source.soundCategory()) * Settings$.MODULE$.get().volumeMaster());
    }

    public void update() {
        block4: {
            Audio$ audio$ = this;
            synchronized (audio$) {
                block3: {
                    if (this.isDisabled()) break block3;
                    this.ocelot$desktop$audio$Audio$$sources().filterInPlace((Function2<SoundSource, Object, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(Audio$.$anonfun$update$1(x0$1, BoxesRunTime.unboxToInt(x1$1))));
                    break block4;
                }
                return;
            }
        }
    }

    public synchronized void destroy() {
        if (this.isDisabled()) {
            return;
        }
        ((IterableOps.WithFilter)this.ocelot$desktop$audio$Audio$$sources().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Audio$.$anonfun$destroy$1(check$ifrefutable$1)))).foreach((Function1<Tuple2, Object> & Serializable)x$1 -> {
            Audio$.$anonfun$destroy$2(x$1);
            return BoxedUnit.UNIT;
        });
        this.ocelot$desktop$audio$Audio$$sources().clear();
        AL.destroy();
        this._disabled_$eq(true);
    }

    private void deleteSource(int sourceId) throws OpenAlException {
        AL10W$.MODULE$.alSourceStop(sourceId);
        this.ocelot$desktop$audio$Audio$$cleanupSourceBuffers(sourceId);
        AL10W$.MODULE$.alDeleteSources(sourceId);
    }

    public void ocelot$desktop$audio$Audio$$cleanupSourceBuffers(int sourceId) throws OpenAlException {
        int count = AL10W$.MODULE$.alGetSourcei(sourceId, 4118);
        if (count <= 0) {
            return;
        }
        ByteBuffer buff = ByteBuffer.allocateDirect(count * 4);
        buff.order(ByteOrder.nativeOrder());
        IntBuffer buf = buff.asIntBuffer();
        AL10W$.MODULE$.alSourceUnqueueBuffers(sourceId, buf);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp(i2 -> AL10W$.MODULE$.alDeleteBuffers(buf.get(i2)));
    }

    public synchronized void removeAllSources() {
        this.ocelot$desktop$audio$Audio$$sources().values().foreach(sourceId -> MODULE$.deleteSource(sourceId));
        this.ocelot$desktop$audio$Audio$$sources().clear();
    }

    public static final /* synthetic */ void $anonfun$playSource$4(SoundSamples samples$2, Transaction.AbortableTransaction tx$2, int sourceId$3, Transaction innerTx) {
        int bufferId = BoxesRunTime.unboxToInt(samples$2.genBuffer().getOrElse((Function0<Nothing$> & Serializable)() -> tx$2.abort()));
        innerTx.onFailure(() -> AL10W$.MODULE$.alDeleteBuffers(bufferId));
        AL10W$.MODULE$.alSourceQueueBuffers(sourceId$3, bufferId);
    }

    public static final /* synthetic */ boolean $anonfun$update$1(SoundSource x0$1, int x1$1) {
        Tuple2<SoundSource, Integer> tuple2 = new Tuple2<SoundSource, Integer>(x0$1, BoxesRunTime.boxToInteger(x1$1));
        if (tuple2 != null) {
            SoundSource source = tuple2._1();
            int sourceId = tuple2._2$mcI$sp();
            return BoxesRunTime.unboxToBoolean(OpenAlException$.MODULE$.defaulting(() -> false).apply(() -> {
                MODULE$.ocelot$desktop$audio$Audio$$cleanupSourceBuffers(sourceId);
                MODULE$.ocelot$desktop$audio$Audio$$setPosition(sourceId, source);
                MODULE$.ocelot$desktop$audio$Audio$$setGain(sourceId, source);
                int n2 = AL10W$.MODULE$.alGetSourcei(sourceId, 4112);
                switch (n2) {
                    case 4116: {
                        MODULE$.deleteSource(sourceId);
                        return false;
                    }
                }
                return true;
            }));
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$destroy$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$destroy$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int sourceId = tuple2._2$mcI$sp();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)OpenAlException$.MODULE$.ignoring().apply(() -> MODULE$.deleteSource(sourceId));
            return;
        }
        throw new MatchError(tuple2);
    }

    private Audio$() {
    }
}

