/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.audio;

import de.jarnbjo.ogg.BasicStream;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import ocelot.desktop.audio.SoundSamples;
import ocelot.desktop.audio.SoundSamples$Format$;
import scala.Enumeration;
import scala.MatchError;
import scala.runtime.BoxesRunTime;

public final class OggDecoder$ {
    public static final OggDecoder$ MODULE$ = new OggDecoder$();

    public SoundSamples decode(InputStream input) {
        VorbisStream stream = new VorbisStream((LogicalOggStream)new BasicStream(input).getLogicalStreams().iterator().next());
        int rate = stream.getIdentificationHeader().getSampleRate();
        int channels = stream.getIdentificationHeader().getChannels();
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        try {
            while (true) {
                int read = stream.readPcm(buffer, 0, buffer.length);
                for (int i2 = 0; i2 < read; i2 += 2) {
                    byte tB = buffer[i2];
                    buffer[i2] = buffer[i2 + 1];
                    buffer[i2 + 1] = tB;
                }
                dataOut.write(buffer, 0, read);
            }
        }
        catch (EndOfOggStreamException endOfOggStreamException) {
            Enumeration.Value value;
            ByteBuffer data = ByteBuffer.allocateDirect(dataOut.size());
            data.put(dataOut.toByteArray());
            data.rewind();
            int n2 = channels;
            switch (n2) {
                case 1: {
                    value = SoundSamples$Format$.MODULE$.Mono16();
                    break;
                }
                case 2: {
                    value = SoundSamples$Format$.MODULE$.Stereo16();
                    break;
                }
                default: {
                    throw new MatchError(BoxesRunTime.boxToInteger(n2));
                }
            }
            Enumeration.Value format2 = value;
            return new SoundSamples(data, rate, format2);
        }
    }

    private OggDecoder$() {
    }
}

