/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.graphics.render;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import ocelot.desktop.graphics.ShaderProgram;
import ocelot.desktop.graphics.buffer.BufferPut;
import ocelot.desktop.graphics.buffer.Index;
import ocelot.desktop.graphics.buffer.IndexBuffer;
import ocelot.desktop.graphics.buffer.VertexBuffer;
import ocelot.desktop.graphics.mesh.Mesh;
import ocelot.desktop.graphics.mesh.Vertex;
import ocelot.desktop.graphics.mesh.VertexArray;
import ocelot.desktop.graphics.mesh.VertexType;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBDrawInstanced;
import org.lwjgl.opengl.GLContext;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001\u0002\u0010 \u0001!B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001b\u0001!\u0002\u0013)\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00028\t\u000fU\u0004!\u0019!C\u0005m\"1\u0001\u0010\u0001Q\u0001\n]Dq!\u001f\u0001C\u0002\u0013%!\u0010\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001f\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u00111\u0003\u0001!\u0002\u0013\t\u0019\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\r\u0003\u007f\u0001\u0001\u0013!EDB\u0013%\u0011\u0011\t\u0005\u000b\u00033\u0002\u0001R1A\u0005\n\u0005m\u0003BCA/\u0001!\u0015\r\u0011\"\u0003\u0002\\!Q\u0011q\f\u0001\t\u0006\u0004%I!!\u0019\t\u0015\u0005=\u0004\u0001#b\u0001\n\u0013\t\t\u0007C\u0004\u0002r\u0001!I!!\u0010\t\u000f\u0005M\u0004\u0001\"\u0003\u0002>!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBAC\u0001\u0011\u0005\u0013Q\b\u0002\u0011\u0013:\u001cH/\u00198dKJ+g\u000eZ3sKJT!\u0001I\u0011\u0002\rI,g\u000eZ3s\u0015\t\u00113%\u0001\u0005he\u0006\u0004\b.[2t\u0015\t!S%A\u0004eKN\\Go\u001c9\u000b\u0003\u0019\naa\\2fY>$8\u0001A\u000b\u0004S\u0005C6\u0003\u0002\u0001+aY\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00195\u001b\u0005\u0011$BA\u001a$\u0003\u0011)H/\u001b7\n\u0005U\u0012$\u0001\u0003*fg>,(oY3\u0011\u0005E:\u0014B\u0001\u001d3\u0005\u001daunZ4j]\u001e\fA!\\3tQB\u00191(P \u000e\u0003qR!!O\u0011\n\u0005yb$\u0001B'fg\"\u0004\"\u0001Q!\r\u0001\u0011)!\t\u0001b\u0001\u0007\n\ta+\u0005\u0002E\u000fB\u00111&R\u0005\u0003\r2\u0012qAT8uQ&tw\r\u0005\u0002<\u0011&\u0011\u0011\n\u0010\u0002\u0007-\u0016\u0014H/\u001a=\u0002\u0019%t7\u000f^1oG\u0016$\u0016\u0010]3\u0011\u0005mb\u0015BA'=\u0005)1VM\u001d;fqRK\b/Z\u0001\u0007g\"\fG-\u001a:\u0011\u0005A\u000bV\"A\u0011\n\u0005I\u000b#!D*iC\u0012,'\u000f\u0015:pOJ\fW.\u0001\u0004=S:LGO\u0010\u000b\u0005+j[F\f\u0005\u0003W\u0001}:V\"A\u0010\u0011\u0005\u0001CF!B-\u0001\u0005\u0004\u0019%!A%\t\u000be\"\u0001\u0019\u0001\u001e\t\u000b)#\u0001\u0019A&\t\u000b9#\u0001\u0019A(\u0002\u001f%s\u0017\u000e^5bY\u000e\u000b\u0007/Y2jif,\u0012a\u0018\t\u0003W\u0001L!!\u0019\u0017\u0003\u0007%sG/\u0001\tJ]&$\u0018.\u00197DCB\f7-\u001b;zA\u0005aa/\u001a:uKb\u0014UO\u001a4feV\tQ\rE\u0002gS~j\u0011a\u001a\u0006\u0003Q\u0006\naAY;gM\u0016\u0014\u0018B\u00016h\u000511VM\u001d;fq\n+hMZ3s\u000351XM\u001d;fq\n+hMZ3sA\u0005Y\u0011N\u001c3fq\n+hMZ3s+\u0005q\u0007cA\u0016pc&\u0011\u0001\u000f\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0019\u0014\u0018BA:h\u0005-Ie\u000eZ3y\u0005V4g-\u001a:\u0002\u0019%tG-\u001a=Ck\u001a4WM\u001d\u0011\u0002\u001d%t7\u000f^1oG\u0016\u0014UO\u001a4feV\tq\u000fE\u0002gS^\u000bq\"\u001b8ti\u0006t7-\u001a\"vM\u001a,'\u000fI\u0001\fm\u0016\u0014H/\u001a=BeJ\f\u00170F\u0001|!\tYD0\u0003\u0002~y\tYa+\u001a:uKb\f%O]1z\u000311XM\u001d;fq\u0006\u0013(/Y=!\u0003%Ign\u001d;b]\u000e,7/\u0006\u0002\u0002\u0004A)\u0011QAA\b/6\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0004nkR\f'\r\\3\u000b\u0007\u00055A&\u0001\u0006d_2dWm\u0019;j_:LA!!\u0005\u0002\b\tY\u0011I\u001d:bs\n+hMZ3s\u0003)Ign\u001d;b]\u000e,7\u000fI\u0001\tg\u000eDW\rZ;mKR!\u0011\u0011DA\u0010!\rY\u00131D\u0005\u0004\u0003;a#\u0001B+oSRDa!!\t\u0012\u0001\u00049\u0016\u0001C5ogR\fgnY3\u0002\tM|'\u000f\u001e\u000b\u0005\u00033\t9\u0003C\u0004\u0002*I\u0001\r!a\u000b\u0002\u00191$8i\\7qCJ\fGo\u001c:\u0011\u000f-\nicV,\u00022%\u0019\u0011q\u0006\u0017\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004cA\u0016\u00024%\u0019\u0011Q\u0007\u0017\u0003\u000f\t{w\u000e\\3b]\u00069\u0011n]#naRLXCAA\u0019\u0003\u00151G.^:i)\t\tI\"A\u0002yIE*\"!a\u0011\u0011\u000f-\n)%!\u0013\u0002J%\u0019\u0011q\t\u0017\u0003\rQ+\b\u000f\\33!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA\u0001\\1oO*\u0011\u00111K\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002X\u00055#AB(cU\u0016\u001cG/A\u000ehY\u0012\u0013\u0018m^!se\u0006L8/\u00138ti\u0006t7-\u001a3B%\n\u0003HO]\u000b\u0003\u0003\u0013\nQd\u001a7Ee\u0006<X\t\\3nK:$8/\u00138ti\u0006t7-\u001a3B%\n\u0003HO]\u0001\u001c]\u001edGI]1x\u000b2,W.\u001a8ug&s7\u000f^1oG\u0016$\u0017I\u0015\"\u0016\u0005\u0005\r\u0004\u0003BA3\u0003Wj!!a\u001a\u000b\t\u0005%\u0014QJ\u0001\be\u00164G.Z2u\u0013\u0011\ti'a\u001a\u0003\r5+G\u000f[8e\u0003eqw\r\u001c#sC^\f%O]1zg&s7\u000f^1oG\u0016$\u0017I\u0015\"\u0002\t\u0011\u0014\u0018m^\u0001\u0006oJLG/Z\u0001\u000ea\u0006\u001c7.\u00138ti\u0006t7-Z:\u0016\u0005\u0005e\u0004\u0003BA>\u0003\u0003k!!! \u000b\t\u0005}\u0014\u0011K\u0001\u0004]&|\u0017\u0002BAB\u0003{\u0012!BQ=uK\n+hMZ3s\u000311'/Z3SKN|WO]2f\u0001")
public class InstanceRenderer<V extends Vertex, I extends Vertex>
implements Resource,
Logging {
    private Tuple2<Object, Object> x$1;
    private Object glDrawArraysInstancedARBptr;
    private Object glDrawElementsInstancedARBptr;
    private Method nglDrawElementsInstancedARB;
    private Method nglDrawArraysInstancedARB;
    private final Mesh<V> mesh;
    private final ShaderProgram shader;
    private final int InitialCapacity;
    private final VertexBuffer<V> vertexBuffer;
    private final Option<IndexBuffer> indexBuffer;
    private final VertexBuffer<I> instanceBuffer;
    private final VertexArray vertexArray;
    private final ArrayBuffer<I> instances;
    private Logger logger;
    private volatile byte bitmap$0;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int InitialCapacity() {
        return this.InitialCapacity;
    }

    private VertexBuffer<V> vertexBuffer() {
        return this.vertexBuffer;
    }

    private Option<IndexBuffer> indexBuffer() {
        return this.indexBuffer;
    }

    private VertexBuffer<I> instanceBuffer() {
        return this.instanceBuffer;
    }

    private VertexArray vertexArray() {
        return this.vertexArray;
    }

    private ArrayBuffer<I> instances() {
        return this.instances;
    }

    public void schedule(I instance) {
        this.instances().$plus$eq(instance);
    }

    public void sort(Function2<I, I, Object> ltComparator) {
        this.instances().sortInPlaceWith(ltComparator);
    }

    public boolean isEmpty() {
        return this.instances().isEmpty();
    }

    public void flush() {
        this.write();
        this.draw();
    }

    private Tuple2<Object, Object> x$1$lzycompute() {
        InstanceRenderer instanceRenderer = this;
        synchronized (instanceRenderer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Method method = GLContext.class.getDeclaredMethod("getFunctionAddress", String.class);
                method.setAccessible(true);
                Tuple2<Object, Object> tuple2 = new Tuple2<Object, Object>(method.invoke(null, "glDrawArraysInstancedARB"), method.invoke(null, "glDrawElementsInstancedARB"));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Object glDrawArraysInstancedARBptr = tuple2._1();
                Object glDrawElementsInstancedARBptr = tuple2._2();
                this.x$1 = new Tuple2<Object, Object>(glDrawArraysInstancedARBptr, glDrawElementsInstancedARBptr);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private Object glDrawArraysInstancedARBptr$lzycompute() {
        InstanceRenderer instanceRenderer = this;
        synchronized (instanceRenderer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.glDrawArraysInstancedARBptr = this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.glDrawArraysInstancedARBptr;
    }

    private Object glDrawArraysInstancedARBptr() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.glDrawArraysInstancedARBptr$lzycompute();
        }
        return this.glDrawArraysInstancedARBptr;
    }

    private Object glDrawElementsInstancedARBptr$lzycompute() {
        InstanceRenderer instanceRenderer = this;
        synchronized (instanceRenderer) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.glDrawElementsInstancedARBptr = this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.glDrawElementsInstancedARBptr;
    }

    private Object glDrawElementsInstancedARBptr() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.glDrawElementsInstancedARBptr$lzycompute();
        }
        return this.glDrawElementsInstancedARBptr;
    }

    /*
     * WARNING - void declaration
     */
    private Method nglDrawElementsInstancedARB$lzycompute() {
        InstanceRenderer instanceRenderer = this;
        synchronized (instanceRenderer) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                void var2_2;
                Method method = ARBDrawInstanced.class.getDeclaredMethod("nglDrawElementsInstancedARB", Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Long.TYPE);
                method.setAccessible(true);
                this.nglDrawElementsInstancedARB = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.nglDrawElementsInstancedARB;
    }

    private Method nglDrawElementsInstancedARB() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.nglDrawElementsInstancedARB$lzycompute();
        }
        return this.nglDrawElementsInstancedARB;
    }

    /*
     * WARNING - void declaration
     */
    private Method nglDrawArraysInstancedARB$lzycompute() {
        InstanceRenderer instanceRenderer = this;
        synchronized (instanceRenderer) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                void var2_2;
                Method method = ARBDrawInstanced.class.getDeclaredMethod("nglDrawArraysInstancedARB", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE);
                method.setAccessible(true);
                this.nglDrawArraysInstancedARB = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.nglDrawArraysInstancedARB;
    }

    private Method nglDrawArraysInstancedARB() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.nglDrawArraysInstancedARB$lzycompute();
        }
        return this.nglDrawArraysInstancedARB;
    }

    private void draw() {
        if (this.instances().isEmpty()) {
            return;
        }
        this.shader.bind();
        this.vertexArray().bind();
        Option<IndexBuffer> option = this.indexBuffer();
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexBuffer ib = (IndexBuffer)some.value();
            this.nglDrawElementsInstancedARB().invoke(null, BoxesRunTime.boxToInteger(this.mesh.primitiveType().toGL()), BoxesRunTime.boxToInteger(ib.capacity()), BoxesRunTime.boxToInteger(5125), BoxesRunTime.boxToLong(0L), BoxesRunTime.boxToInteger(this.instances().length()), this.glDrawElementsInstancedARBptr());
        } else if (None$.MODULE$.equals(option)) {
            this.nglDrawArraysInstancedARB().invoke(null, BoxesRunTime.boxToInteger(this.mesh.primitiveType().toGL()), BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(this.vertexBuffer().capacity()), BoxesRunTime.boxToInteger(this.instances().length()), this.glDrawArraysInstancedARBptr());
        } else {
            throw new MatchError(option);
        }
        this.instances().clear();
    }

    private void write() {
        if (this.instances().length() > this.instanceBuffer().capacity()) {
            this.instanceBuffer().resize(this.instances().length() * 2);
            this.instanceBuffer().write(0, this.packInstances());
            return;
        }
        this.instanceBuffer().write(0, this.packInstances());
    }

    private ByteBuffer packInstances() {
        int instanceStride = this.instances().isEmpty() ? 0 : ((BufferPut)this.instances().apply(0)).stride();
        ByteBuffer data = BufferUtils.createByteBuffer(this.instances().length() * instanceStride);
        this.instances().foreach((Function1<Vertex, Object> & Serializable)element -> {
            element.put(data);
            return BoxedUnit.UNIT;
        });
        data.flip();
        return data;
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        this.vertexArray().freeResource();
        this.instanceBuffer().freeResource();
        this.indexBuffer().foreach((Function1<IndexBuffer, Object> & Serializable)x$2 -> {
            x$2.freeResource();
            return BoxedUnit.UNIT;
        });
        this.vertexBuffer().freeResource();
    }

    public static final /* synthetic */ void $anonfun$new$1(InstanceRenderer $this, IndexBuffer ib) {
        $this.vertexArray().addIndexBuffer(ib);
    }

    public InstanceRenderer(Mesh<V> mesh, VertexType instanceType, ShaderProgram shader) {
        this.mesh = mesh;
        this.shader = shader;
        Resource.$init$(this);
        Logging.$init$(this);
        this.InitialCapacity = 1;
        this.vertexBuffer = new VertexBuffer<V>(mesh.vertices());
        this.indexBuffer = mesh.indices().map((Function1<Seq, IndexBuffer> & Serializable)indices -> new IndexBuffer((Seq<Index>)indices));
        this.instanceBuffer = new VertexBuffer(instanceType, this.InitialCapacity());
        this.vertexArray = new VertexArray(shader);
        this.vertexArray().addVertexBuffer(this.vertexBuffer(), this.vertexArray().addVertexBuffer$default$2());
        this.indexBuffer().foreach((Function1<IndexBuffer, Object> & Serializable)ib -> {
            InstanceRenderer.$anonfun$new$1(this, ib);
            return BoxedUnit.UNIT;
        });
        this.vertexArray().addVertexBuffer(this.instanceBuffer(), true);
        this.instances = new ArrayBuffer();
        Statics.releaseFence();
    }
}

