/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.ui.widget.card;

import ocelot.desktop.ColorScheme$;
import ocelot.desktop.color.RGBAColorNorm;
import ocelot.desktop.geometry.Rect2D;
import ocelot.desktop.graphics.Graphics;
import ocelot.desktop.graphics.IconSource;
import ocelot.desktop.graphics.IconSource$Icons$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import totoro.ocelot.brain.entity.sound_card.ADSREnvelope;
import totoro.ocelot.brain.entity.sound_card.ADSREnvelope$Phase$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Sawtooth$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Sine$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Square$;
import totoro.ocelot.brain.entity.sound_card.SignalGenerator$Triangle$;

public final class SoundCardWindow$ {
    public static final SoundCardWindow$ MODULE$ = new SoundCardWindow$();
    private static final String[] notes = (String[])((Object[])new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"});
    private static final Tuple2<IconSource, Class<? extends SignalGenerator>>[] ocelot$desktop$ui$widget$card$SoundCardWindow$$waves = (Tuple2[])((Object[])new Tuple2[]{new Tuple2(IconSource$Icons$.MODULE$.WaveSine(), SignalGenerator$Sine$.MODULE$.getClass()), new Tuple2(IconSource$Icons$.MODULE$.WaveTriangle(), SignalGenerator$Triangle$.MODULE$.getClass()), new Tuple2(IconSource$Icons$.MODULE$.WaveSawtooth(), SignalGenerator$Sawtooth$.MODULE$.getClass()), new Tuple2(IconSource$Icons$.MODULE$.WaveSquare(), SignalGenerator$Square$.MODULE$.getClass()), new Tuple2<IconSource, Class<SignalGenerator.Noise>>(IconSource$Icons$.MODULE$.WaveNoise(), SignalGenerator.Noise.class), new Tuple2<IconSource, Class<SignalGenerator.LFSR>>(IconSource$Icons$.MODULE$.WaveLFSR(), SignalGenerator.LFSR.class)});

    private String[] notes() {
        return notes;
    }

    public Option<String> ocelot$desktop$ui$widget$card$SoundCardWindow$$freqToNote(float freq) {
        if (freq <= 0.0f) {
            return None$.MODULE$;
        }
        int idx = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)12 * package$.MODULE$.log(freq / (float)440) / package$.MODULE$.log(2.0) + (double)48));
        int octave = idx / 12;
        if (octave < 0) {
            return None$.MODULE$;
        }
        String note = this.notes()[package$.MODULE$.floorMod(idx + 9, 12)];
        return new Some<String>(new StringBuilder(0).append(note).append(Integer.toString(octave)).toString());
    }

    public float ocelot$desktop$ui$widget$card$SoundCardWindow$$magToDb(float mag) {
        return (float)20 * (float)package$.MODULE$.log10(mag);
    }

    public Tuple2<IconSource, Class<? extends SignalGenerator>>[] ocelot$desktop$ui$widget$card$SoundCardWindow$$waves() {
        return ocelot$desktop$ui$widget$card$SoundCardWindow$$waves;
    }

    public void ocelot$desktop$ui$widget$card$SoundCardWindow$$drawEnvelope(Graphics g2, ADSREnvelope env, Rect2D bounds, float elapsedMs) {
        float f2;
        int envDuration = env.attack() + env.decay() + env.release();
        int decayStart = env.attack();
        int releaseStart = decayStart + env.decay();
        Enumeration.Value value = env.phase();
        Enumeration.Value value2 = ADSREnvelope$Phase$.MODULE$.Closed();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !((Object)value2).equals(value3) : value3 != null)) {
            f2 = 0.0f;
        } else {
            Enumeration.Value value4 = ADSREnvelope$Phase$.MODULE$.Attack();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !((Object)value4).equals(value5) : value5 != null)) {
                f2 = elapsedMs;
            } else {
                Enumeration.Value value6 = ADSREnvelope$Phase$.MODULE$.Decay();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !((Object)value6).equals(value7) : value7 != null)) {
                    f2 = elapsedMs;
                } else {
                    Enumeration.Value value8 = ADSREnvelope$Phase$.MODULE$.Sustain();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !((Object)value8).equals(value9) : value9 != null)) {
                        f2 = releaseStart;
                    } else {
                        Enumeration.Value value10 = ADSREnvelope$Phase$.MODULE$.Release();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !((Object)value10).equals(value11) : value11 != null)) {
                            f2 = (float)releaseStart + elapsedMs;
                        } else {
                            throw new MatchError(value);
                        }
                    }
                }
            }
        }
        float elapsedTime = f2;
        ObjectRef<RGBAColorNorm> col = ObjectRef.create(ColorScheme$.MODULE$.apply("SoundCardWaveActive").withAlpha(0.6f));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)bounds.w()).foreach$mVc$sp(sx -> {
            float t = (float)sx / bounds.w() * (float)envDuration;
            if (t >= elapsedTime) {
                col$1.elem = ((RGBAColorNorm)col$1.elem).withAlpha(0.2f);
            }
            float v = t < (float)decayStart ? t / (float)env.attack() : (t < (float)releaseStart ? 1.0f - (t - (float)decayStart) / (float)env.decay() * (1.0f - env.sustain()) : (1.0f - (t - (float)releaseStart) / (float)env.release()) * env.sustain());
            float h2 = v * bounds.h();
            g2.rect(bounds.x() + (float)sx, bounds.y() + bounds.h() - h2, 1.0f, h2, (RGBAColorNorm)col$1.elem);
        });
        float unit = bounds.w() / (float)envDuration;
        float ay = bounds.y() + bounds.h();
        float by = bounds.y();
        float cy = bounds.y() + (1.0f - env.sustain()) * bounds.h();
        col.elem = ColorScheme$.MODULE$.apply("SoundCardWaveActive");
        float ax = bounds.x();
        float bx = bounds.x() + (float)env.attack() * unit;
        g2.line(ax, ay, bx, by, 1.0f, (RGBAColorNorm)col.elem);
        ax = bx;
        g2.line(ax, by, bx += (float)env.decay() * unit, cy, 1.0f, (RGBAColorNorm)col.elem);
        ax = bx;
        g2.line(ax, cy, bx += (float)env.release() * unit, ay, 1.0f, (RGBAColorNorm)col.elem);
    }

    private SoundCardWindow$() {
    }
}

