/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import ocelot.desktop.Settings;
import ocelot.desktop.util.Logging;
import org.apache.logging.log4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class FileUtils$
implements Logging {
    public static final FileUtils$ MODULE$ = new FileUtils$();
    private static Logger logger;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public ByteBuffer load(String filename) {
        ByteBuffer byteBuffer;
        RandomAccessFile file = new RandomAccessFile(filename, "r");
        FileChannel inChannel = file.getChannel();
        try {
            try {
                long fileSize = inChannel.size();
                ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
                inChannel.read(buffer);
                buffer.flip();
                byteBuffer = buffer;
            }
            catch (IOException e2) {
                this.logger().error(new StringBuilder(18).append("Cannot load file: ").append(filename).toString(), (Throwable)e2);
                byteBuffer = null;
            }
        }
        finally {
            if (file != null) {
                file.close();
            }
            if (inChannel != null) {
                inChannel.close();
            }
        }
        return byteBuffer;
    }

    public Try<File> unpackResource(String resource, File target) {
        return Try$.MODULE$.apply((Function0<File> & Serializable)() -> {
            URL configResource = Settings.class.getResource(resource);
            return (File)Using$.MODULE$.resources(Channels.newChannel(configResource.openStream()), (Function0<FileChannel> & Serializable)() -> new FileOutputStream(target).getChannel(), (Function2<ReadableByteChannel, FileChannel, File> & Serializable)(in, out) -> {
                out.transferFrom((ReadableByteChannel)in, 0L, Long.MAX_VALUE);
                target.setReadable(true, false);
                target.setWritable(true, false);
                target.setExecutable(false, false);
                return target;
            }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
        });
    }

    private FileUtils$() {
    }
}

