/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.time.ZonedDateTime;
import ocelot.desktop.util.OcelotOnlineAPI;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.matching.Regex;

public final class OcelotOnlineAPI$ {
    public static final OcelotOnlineAPI$ MODULE$ = new OcelotOnlineAPI$();
    private static final String UrlInfo = "https://ocelot.fomalhaut.me/desktop/info";
    private static final Regex RegexDevId = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"dev\":\\s?\\{.*?\"id\":\\s?\"(.*?)\""));
    private static final Regex RegexDevDate = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"dev\":\\s?\\{.*?\"date\":\\s?\"(.*?)\""));
    private static final Regex RegexReleaseVersion = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"release\":\\s?\\{.*?\"version\":\\s?\"(.*?)\""));
    private static final Regex RegexReleaseDate = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"release\":\\s?\\{.*?\"date\":\\s?\"(.*?)\""));

    private String UrlInfo() {
        return UrlInfo;
    }

    private Regex RegexDevId() {
        return RegexDevId;
    }

    private Regex RegexDevDate() {
        return RegexDevDate;
    }

    private Regex RegexReleaseVersion() {
        return RegexReleaseVersion;
    }

    private Regex RegexReleaseDate() {
        return RegexReleaseDate;
    }

    public void checkRemoteVersion(Function1<Try<OcelotOnlineAPI.Version>, BoxedUnit> callback) {
        new Thread(() -> callback.apply(MODULE$.getVersion())).start();
    }

    private Try<OcelotOnlineAPI.Version> getVersion() {
        return Try$.MODULE$.apply((Function0<OcelotOnlineAPI.Version> & Serializable)() -> {
            BufferedSource source = Source$.MODULE$.fromURL(MODULE$.UrlInfo(), Codec$.MODULE$.fallbackSystemCodec());
            String response = source.mkString();
            Option<String> devId = MODULE$.RegexDevId().findFirstMatchIn(response).map((Function1<Regex.Match, String> & Serializable)x$1 -> x$1.group(1));
            Option devDate = MODULE$.RegexDevDate().findFirstMatchIn(response).map((Function1<Regex.Match, String> & Serializable)x$2 -> x$2.group(1));
            Option<String> releaseVersion = MODULE$.RegexReleaseVersion().findFirstMatchIn(response).map((Function1<Regex.Match, String> & Serializable)x$3 -> x$3.group(1));
            Option releaseDate = MODULE$.RegexReleaseDate().findFirstMatchIn(response).map((Function1<Regex.Match, String> & Serializable)x$4 -> x$4.group(1));
            OcelotOnlineAPI.Version version = new OcelotOnlineAPI.Version(devId, devDate.map((Function1<String, ZonedDateTime> & Serializable)it -> ZonedDateTime.parse(it)), releaseVersion, releaseDate.map((Function1<String, ZonedDateTime> & Serializable)it -> ZonedDateTime.parse(it)));
            source.close();
            return version;
        });
    }

    public String get(String url, int connectTimeout, int readTimeout, String requestMethod) throws IOException, SocketTimeoutException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(connectTimeout);
        connection.setReadTimeout(readTimeout);
        connection.setRequestMethod(requestMethod);
        return (String)Using$.MODULE$.resource(connection.getInputStream(), (Function1<InputStream, String> & Serializable)inputStream -> {
            String content = Source$.MODULE$.fromInputStream((InputStream)inputStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
            return content;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public int get$default$2() {
        return 5000;
    }

    public int get$default$3() {
        return 5000;
    }

    public String get$default$4() {
        return "GET";
    }

    private OcelotOnlineAPI$() {
    }
}

